/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.credmanagement;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.credmanagement.jaxb.AutomaticRenewCredentialRequest;
import org.certificateservices.messages.credmanagement.jaxb.AutomaticRenewCredentialResponse;
import org.certificateservices.messages.credmanagement.jaxb.ChangeCredentialStatusRequest;
import org.certificateservices.messages.credmanagement.jaxb.ChangeCredentialStatusResponse;
import org.certificateservices.messages.credmanagement.jaxb.ChangeTokenStatusRequest;
import org.certificateservices.messages.credmanagement.jaxb.ChangeTokenStatusResponse;
import org.certificateservices.messages.credmanagement.jaxb.ChangeUserStatusRequest;
import org.certificateservices.messages.credmanagement.jaxb.ChangeUserStatusResponse;
import org.certificateservices.messages.credmanagement.jaxb.CredentialAvailableActionsOperation;
import org.certificateservices.messages.credmanagement.jaxb.CredentialFilter;
import org.certificateservices.messages.credmanagement.jaxb.FetchHardTokenDataRequest;
import org.certificateservices.messages.credmanagement.jaxb.FetchHardTokenDataResponse;
import org.certificateservices.messages.credmanagement.jaxb.FieldValue;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialAvailableActionsRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialAvailableActionsResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialStatusListRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetCredentialStatusListResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetEjbcaUserCredentialsRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetEjbcaUserCredentialsResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetIssuerCredentialsRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetIssuerCredentialsResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetTokensRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetTokensResponse;
import org.certificateservices.messages.credmanagement.jaxb.GetUsersRequest;
import org.certificateservices.messages.credmanagement.jaxb.GetUsersResponse;
import org.certificateservices.messages.credmanagement.jaxb.HardTokenData;
import org.certificateservices.messages.credmanagement.jaxb.IsIssuerRequest;
import org.certificateservices.messages.credmanagement.jaxb.IsIssuerResponse;
import org.certificateservices.messages.credmanagement.jaxb.IssueCredentialStatusListRequest;
import org.certificateservices.messages.credmanagement.jaxb.IssueCredentialStatusListResponse;
import org.certificateservices.messages.credmanagement.jaxb.IssueTokenCredentialsRequest;
import org.certificateservices.messages.credmanagement.jaxb.IssueTokenCredentialsResponse;
import org.certificateservices.messages.credmanagement.jaxb.Key;
import org.certificateservices.messages.credmanagement.jaxb.ObjectFactory;
import org.certificateservices.messages.credmanagement.jaxb.RecoverHardTokenResponse;
import org.certificateservices.messages.credmanagement.jaxb.RecoverKeyRequest;
import org.certificateservices.messages.credmanagement.jaxb.RecoverKeyResponse;
import org.certificateservices.messages.credmanagement.jaxb.RecoverableKey;
import org.certificateservices.messages.credmanagement.jaxb.RemoveCredentialRequest;
import org.certificateservices.messages.credmanagement.jaxb.RemoveCredentialResponse;
import org.certificateservices.messages.credmanagement.jaxb.StoreHardTokenDataRequest;
import org.certificateservices.messages.credmanagement.jaxb.StoreHardTokenDataResponse;
import org.certificateservices.messages.credmanagement.jaxb.StoreKeyRequest;
import org.certificateservices.messages.credmanagement.jaxb.StoreKeyResponse;
import org.certificateservices.messages.credmanagement.jaxb.TokenFilter;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.AutomationLevel;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.CredentialStatusList;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;
import org.certificateservices.messages.csmessages.jaxb.Token;
import org.certificateservices.messages.csmessages.jaxb.TokenRequest;
import org.certificateservices.messages.csmessages.jaxb.User;
import org.certificateservices.messages.utils.MessageGenerateUtils;

public class CredManagementPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/credmanagement2_0";
    public static final String CREDMANAGEMENT_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/credmanagement_schema2_0.xsd";
    public static final String CREDMANAGEMENT_XSD_SCHEMA_2_1_RESOURCE_LOCATION = "/credmanagement_schema2_1.xsd";
    public static final String CREDMANAGEMENT_XSD_SCHEMA_2_2_RESOURCE_LOCATION = "/credmanagement_schema2_2.xsd";
    public static final String CREDMANAGEMENT_XSD_SCHEMA_2_3_RESOURCE_LOCATION = "/credmanagement_schema2_3.xsd";
    public static final String CREDMANAGEMENT_XSD_SCHEMA_2_4_RESOURCE_LOCATION = "/credmanagement_schema2_4.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String CREDMANAGEMENT_VERSION_2_0 = "2.0";
    private static final String CREDMANAGEMENT_VERSION_2_1 = "2.1";
    private static final String CREDMANAGEMENT_VERSION_2_2 = "2.2";
    private static final String CREDMANAGEMENT_VERSION_2_3 = "2.3";
    private static final String CREDMANAGEMENT_VERSION_2_4 = "2.4";
    private static final String[] SUPPORTED_CREDMANAGEMENT_VERSIONS = new String[]{"2.0", "2.1", "2.2", "2.3", "2.4"};
    private static final String DEFAULT_CREDMANAGEMENT_VERSION = "2.4";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.credmanagement.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(CREDMANAGEMENT_VERSION_2_0)) {
            return this.getClass().getResourceAsStream(CREDMANAGEMENT_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals(CREDMANAGEMENT_VERSION_2_1)) {
            return this.getClass().getResourceAsStream(CREDMANAGEMENT_XSD_SCHEMA_2_1_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals(CREDMANAGEMENT_VERSION_2_2)) {
            return this.getClass().getResourceAsStream(CREDMANAGEMENT_XSD_SCHEMA_2_2_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals(CREDMANAGEMENT_VERSION_2_3)) {
            return this.getClass().getResourceAsStream(CREDMANAGEMENT_XSD_SCHEMA_2_3_RESOURCE_LOCATION);
        }
        if (payLoadVersion.equals("2.4")) {
            return this.getClass().getResourceAsStream(CREDMANAGEMENT_XSD_SCHEMA_2_4_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported Credential Management Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_CREDMANAGEMENT_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return "2.4";
    }

    public byte[] genIssueTokenCredentialsRequest(String requestId, String destinationId, String organisation, TokenRequest tokenRequest, List<FieldValue> fieldValues, HardTokenData hardTokenData, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genIssueTokenCredentialsRequest(requestId, destinationId, organisation, tokenRequest, fieldValues, hardTokenData, null, originator, assertions);
    }

    public byte[] genIssueTokenCredentialsRequest(String requestId, String destinationId, String organisation, TokenRequest tokenRequest, List<FieldValue> fieldValues, HardTokenData hardTokenData, List<RecoverableKey> recoverableKeys, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IssueTokenCredentialsRequest payload = this.of.createIssueTokenCredentialsRequest();
        payload.setTokenRequest(tokenRequest);
        if (fieldValues != null && fieldValues.size() > 0) {
            IssueTokenCredentialsRequest.FieldValues values = new IssueTokenCredentialsRequest.FieldValues();
            values.getFieldValue().addAll(fieldValues);
            payload.setFieldValues(values);
        }
        if (hardTokenData != null) {
            payload.setHardTokenData(hardTokenData);
        }
        if (recoverableKeys != null) {
            IssueTokenCredentialsRequest.RecoverableKeys rks = this.of.createIssueTokenCredentialsRequestRecoverableKeys();
            rks.getKey().addAll(recoverableKeys);
            payload.setRecoverableKeys(rks);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genIssueTokenCredentialsResponse(String relatedEndEntity, CSMessage request, List<Credential> credentials, List<Credential> revokedCredentials, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IssueTokenCredentialsResponse response = this.of.createIssueTokenCredentialsResponse();
        if (!(request.getPayload().getAny() instanceof IssueTokenCredentialsRequest)) {
            throw new MessageContentException("Error generating IssueTokenCredentialsResponse, related request not a IssueTokenCredentialsResponse");
        }
        IssueTokenCredentialsRequest requestPayLoad = (IssueTokenCredentialsRequest)request.getPayload().getAny();
        response.setTokenRequest(requestPayLoad.getTokenRequest());
        IssueTokenCredentialsResponse.Credentials credentialsElement = new IssueTokenCredentialsResponse.Credentials();
        credentialsElement.getCredential().addAll(credentials);
        response.setCredentials(credentialsElement);
        if (revokedCredentials != null && revokedCredentials.size() > 0) {
            IssueTokenCredentialsResponse.RevokedCredentials revokedCredElements = new IssueTokenCredentialsResponse.RevokedCredentials();
            revokedCredElements.getCredential().addAll(revokedCredentials);
            response.setRevokedCredentials(revokedCredElements);
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public byte[] genChangeCredentialStatusRequest(String requestId, String destinationId, String organisation, String issuerId, String serialNumber, int newCredentialStatus, String reasonInformation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeCredentialStatusRequest payload = this.of.createChangeCredentialStatusRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        payload.setNewCredentialStatus(newCredentialStatus);
        payload.setReasonInformation(reasonInformation);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genChangeCredentialStatusResponse(String relatedEndEntity, CSMessage request, String issuerId, String serialNumber, int credentialStatus, String reasonInformation, Date revocationDate, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeCredentialStatusResponse response = this.of.createChangeCredentialStatusResponse();
        response.setCredentialStatus(credentialStatus);
        response.setIssuerId(issuerId);
        response.setSerialNumber(serialNumber);
        response.setReasonInformation(reasonInformation);
        response.setRevocationDate(MessageGenerateUtils.dateToXMLGregorianCalendar(revocationDate));
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public byte[] genChangeUserStatusRequest(String requestId, String destinationId, String organisation, String userUniqueId, TokenFilter tokenFilter, CredentialFilter credentialFilter, int newCredentialStatus, String reasonInformation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeUserStatusRequest payload = this.of.createChangeUserStatusRequest();
        payload.setUserUniqueId(userUniqueId);
        payload.setTokenFilter(tokenFilter);
        payload.setCredentialFilter(credentialFilter);
        payload.setNewCredentialStatus(newCredentialStatus);
        payload.setReasonInformation(reasonInformation);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genChangeUserStatusResponse(String relatedEndEntity, CSMessage request, User user, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeUserStatusResponse response = this.of.createChangeUserStatusResponse();
        response.setUser(user);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public byte[] genChangeTokenStatusRequest(String requestId, String destinationId, String organisation, String tokenSerialNumber, CredentialFilter credentialFilter, int newCredentialStatus, String reasonInformation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeTokenStatusRequest payload = this.of.createChangeTokenStatusRequest();
        payload.setTokenSerialNumber(tokenSerialNumber);
        payload.setCredentialFilter(credentialFilter);
        payload.setNewCredentialStatus(newCredentialStatus);
        payload.setReasonInformation(reasonInformation);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genChangeTokenStatusResponse(String relatedEndEntity, CSMessage request, Token token, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ChangeTokenStatusResponse response = this.of.createChangeTokenStatusResponse();
        response.setToken(token);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public byte[] genGetCredentialRequest(String requestId, String destinationId, String organisation, String credentialSubType, String issuerId, String serialNumber, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialRequest payload = this.of.createGetCredentialRequest();
        payload.setIssuerId(issuerId);
        payload.setCredentialSubType(credentialSubType);
        payload.setSerialNumber(serialNumber);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetCredentialResponse(String relatedEndEntity, CSMessage request, Credential credential, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialResponse response = this.of.createGetCredentialResponse();
        response.setCredential(credential);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetCredentialStatusListRequest(String requestId, String destinationId, String organisation, String issuerId, Long serialNumber, String credentialStatusListType, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialStatusListRequest payload = this.of.createGetCredentialStatusListRequest();
        payload.setIssuerId(issuerId);
        payload.setCredentialStatusListType(credentialStatusListType);
        payload.setSerialNumber(serialNumber);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetCredentialStatusListResponse(String relatedEndEntity, CSMessage request, CredentialStatusList credentialStatusList, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialStatusListResponse response = this.of.createGetCredentialStatusListResponse();
        response.setCredentialStatusList(credentialStatusList);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetIssuerCredentialsRequest(String requestId, String destinationId, String organisation, String issuerId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetIssuerCredentialsRequest payload = this.of.createGetIssuerCredentialsRequest();
        payload.setIssuerId(issuerId);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetIssuerCredentialsResponse(String relatedEndEntity, CSMessage request, Credential issuerCredential, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetIssuerCredentialsResponse response = this.of.createGetIssuerCredentialsResponse();
        response.setCredential(issuerCredential);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genIsIssuerRequest(String requestId, String destinationId, String organisation, String issuerId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IsIssuerRequest payload = this.of.createIsIssuerRequest();
        payload.setIssuerId(issuerId);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genIsIssuerResponse(String relatedEndEntity, CSMessage request, boolean isIssuer, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IsIssuerResponse response = this.of.createIsIssuerResponse();
        response.setIsIssuer(isIssuer);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genIssueCredentialStatusListRequest(String requestId, String destinationId, String organisation, String issuerId, String credentialStatusListType, Boolean force, Date requestedValidFromDate, Date requestedNotAfterDate, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IssueCredentialStatusListRequest payload = this.of.createIssueCredentialStatusListRequest();
        payload.setIssuerId(issuerId);
        payload.setCredentialStatusListType(credentialStatusListType);
        payload.setForce(force);
        payload.setRequestedValidFromDate(MessageGenerateUtils.dateToXMLGregorianCalendar(requestedValidFromDate));
        payload.setRequestedNotAfterDate(MessageGenerateUtils.dateToXMLGregorianCalendar(requestedNotAfterDate));
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genIssueCredentialStatusListResponse(String relatedEndEntity, CSMessage request, CredentialStatusList credentialStatusList, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IssueCredentialStatusListResponse response = this.of.createIssueCredentialStatusListResponse();
        response.setCredentialStatusList(credentialStatusList);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public CSMessageResponseData genIssueCredentialStatusListResponseWithoutRequest(String csMessageVersion, String payLoadVersion, String relatedEndEntity, String destinationId, String requestName, String organisation, CredentialStatusList credentialStatusList, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        String responseId = MessageGenerateUtils.generateRandomUUID();
        IssueCredentialStatusListResponse response = this.of.createIssueCredentialStatusListResponse();
        response.setCredentialStatusList(credentialStatusList);
        response.setFailureMessage(null);
        response.setStatus(RequestStatus.SUCCESS);
        response.setInResponseTo(responseId);
        CSMessage csMessage = this.getCSMessageParser().genCSMessage(csMessageVersion, payLoadVersion, requestName, responseId, destinationId, organisation, originator, response, assertions);
        byte[] responseData = this.getCSMessageParser().marshallAndSignCSMessage(csMessage);
        return new CSMessageResponseData(csMessage, relatedEndEntity, responseData, true);
    }

    public byte[] genRemoveCredentialRequest(String requestId, String destinationId, String organisation, String issuerId, String serialNumber, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RemoveCredentialRequest payload = this.of.createRemoveCredentialRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genRemoveCredentialResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RemoveCredentialResponse response = this.of.createRemoveCredentialResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, true);
    }

    public byte[] genFetchHardTokenDataRequest(String requestId, String destinationId, String organisation, String tokenSerial, String relatedCredentialIssuerId, Credential adminCredential, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        FetchHardTokenDataRequest payload = this.of.createFetchHardTokenDataRequest();
        payload.setTokenSerial(tokenSerial);
        payload.setRelatedCredentialIssuerId(relatedCredentialIssuerId);
        payload.setAdminCredential(adminCredential);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), this.of.createFetchHardTokenDataRequest(payload), originator, assertions);
    }

    public CSMessageResponseData genFetchHardTokenDataResponse(String relatedEndEntity, CSMessage request, String tokenSerial, byte[] encryptedData, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        FetchHardTokenDataResponse response = this.of.createFetchHardTokenDataResponse();
        response.setTokenSerial(tokenSerial);
        response.setEncryptedData(encryptedData);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), this.of.createFetchHardTokenDataResponse(response));
    }

    public byte[] genRecoverHardTokenRequest(String requestId, String destinationId, String organisation, String tokenSerial, String relatedCredentialIssuerId, Credential adminCredential, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        FetchHardTokenDataRequest payload = this.of.createFetchHardTokenDataRequest();
        payload.setTokenSerial(tokenSerial);
        payload.setRelatedCredentialIssuerId(relatedCredentialIssuerId);
        payload.setAdminCredential(adminCredential);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), this.of.createRecoverHardTokenRequest(payload), originator, assertions);
    }

    public CSMessageResponseData genRecoverHardTokenResponse(String relatedEndEntity, CSMessage request, String tokenSerial, byte[] encryptedData, List<Key> keys, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RecoverHardTokenResponse response = this.of.createRecoverHardTokenResponse();
        response.setTokenSerial(tokenSerial);
        response.setEncryptedData(encryptedData);
        RecoverHardTokenResponse.RecoveredKeys rk = this.of.createRecoverHardTokenResponseRecoveredKeys();
        rk.getKey().addAll(keys);
        response.setRecoveredKeys(rk);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genStoreHardTokenDataRequest(String requestId, String destinationId, String organisation, String tokenSerial, String relatedCredentialIssuerId, byte[] encryptedData, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        StoreHardTokenDataRequest payload = this.of.createStoreHardTokenDataRequest();
        payload.setTokenSerial(tokenSerial);
        payload.setRelatedCredentialIssuerId(relatedCredentialIssuerId);
        payload.setEncryptedData(encryptedData);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genStoreHardTokenDataResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        StoreHardTokenDataResponse response = this.of.createStoreHardTokenDataResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetTokensRequest(String requestId, String destinationId, String organisation, String serialNumber, boolean exactMatch, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genGetTokensRequest(requestId, destinationId, organisation, serialNumber, exactMatch, null, null, originator, assertions);
    }

    public byte[] genGetTokensRequest(String requestId, String destinationId, String organisation, String serialNumber, boolean exactMatch, Integer startIndex, Integer resultSize, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetTokensRequest payload = this.of.createGetTokensRequest();
        payload.setSerialNumber(serialNumber);
        payload.setExactMatch(exactMatch);
        payload.setStartIndex(startIndex);
        payload.setResultSize(resultSize);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetTokensResponse(String relatedEndEntity, CSMessage request, List<Token> tokens, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genGetTokensResponse(relatedEndEntity, request, tokens, null, null, assertions);
    }

    public CSMessageResponseData genGetTokensResponse(String relatedEndEntity, CSMessage request, List<Token> tokens, Integer startIndex, Integer totalMatching, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetTokensResponse response = this.of.createGetTokensResponse();
        GetTokensResponse.Tokens tokensElement = new GetTokensResponse.Tokens();
        for (Token t : tokens) {
            tokensElement.getToken().add(t);
        }
        response.setTokens(tokensElement);
        if (!request.getPayLoadVersion().equals(CREDMANAGEMENT_VERSION_2_0)) {
            response.setStartIndex(startIndex);
            response.setTotalMatching(totalMatching);
        } else {
            for (Token token : tokens) {
                token.setDepartmentName(null);
            }
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetUsersRequest(String requestId, String destinationId, String organisation, String uniqueId, boolean exactMatch, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genGetUsersRequest(requestId, destinationId, organisation, uniqueId, exactMatch, null, null, originator, assertions);
    }

    public byte[] genGetUsersRequest(String requestId, String destinationId, String organisation, String uniqueId, boolean exactMatch, Integer startIndex, Integer resultSize, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetUsersRequest payload = this.of.createGetUsersRequest();
        payload.setUniqueId(uniqueId);
        payload.setExactMatch(exactMatch);
        payload.setStartIndex(startIndex);
        payload.setResultSize(resultSize);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetUsersResponse(String relatedEndEntity, CSMessage request, List<User> users, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.genGetUsersResponse(relatedEndEntity, request, users, null, null, assertions);
    }

    public CSMessageResponseData genGetUsersResponse(String relatedEndEntity, CSMessage request, List<User> users, Integer startIndex, Integer totalMatching, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetUsersResponse response = this.of.createGetUsersResponse();
        GetUsersResponse.Users usersElement = new GetUsersResponse.Users();
        for (User u : users) {
            usersElement.getUser().add(u);
        }
        response.setUsers(usersElement);
        if (!request.getPayLoadVersion().equals(CREDMANAGEMENT_VERSION_2_0)) {
            response.setStartIndex(startIndex);
            response.setTotalMatching(totalMatching);
        } else {
            for (User u : users) {
                if (u.getTokens() == null) continue;
                for (Token t : u.getTokens().getToken()) {
                    t.setDepartmentName(null);
                }
            }
        }
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetEjbcaUserCredentialsRequest(String requestId, String destinationId, String organisation, String ejbcaUsername, Integer startIndex, Integer resultSize, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetEjbcaUserCredentialsRequest payload = this.of.createGetEjbcaUserCredentialsRequest();
        payload.setEjbcaUsername(ejbcaUsername);
        payload.setStartIndex(startIndex);
        payload.setResultSize(resultSize);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetEjbcaUserCredentialsResponse(String relatedEndEntity, CSMessage request, List<Credential> credentials, Integer startIndex, Integer totalMatching, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetEjbcaUserCredentialsResponse response = this.of.createGetEjbcaUserCredentialsResponse();
        GetEjbcaUserCredentialsResponse.Credentials credentialsElement = this.of.createGetEjbcaUserCredentialsResponseCredentials();
        credentialsElement.getCredential().addAll(credentials);
        response.setCredentials(credentialsElement);
        response.setStartIndex(startIndex);
        response.setTotalMatching(totalMatching);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genRecoverKeyRequest(String requestId, String destinationId, String organisation, Credential adminCredential, List<Credential> relatedCredentials, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RecoverKeyRequest payload = this.of.createRecoverKeyRequest();
        payload.setAdminCredential(adminCredential);
        RecoverKeyRequest.RelatedCredentials rc = this.of.createRecoverKeyRequestRelatedCredentials();
        rc.getCredential().addAll(relatedCredentials);
        payload.setRelatedCredentials(rc);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genRecoverKeyResponse(String relatedEndEntity, CSMessage request, List<Key> keys, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        RecoverKeyResponse response = this.of.createRecoverKeyResponse();
        RecoverKeyResponse.RecoveredKeys rk = this.of.createRecoverKeyResponseRecoveredKeys();
        rk.getKey().addAll(keys);
        response.setRecoveredKeys(rk);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genStoreKeyRequest(String requestId, String destinationId, String organisation, List<Key> keys, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        StoreKeyRequest payload = this.of.createStoreKeyRequest();
        StoreKeyRequest.RecoverableKeys rk = this.of.createStoreKeyRequestRecoverableKeys();
        rk.getKey().addAll(keys);
        payload.setRecoverableKeys(rk);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genStoreKeyResponse(String relatedEndEntity, CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        StoreKeyResponse response = this.of.createStoreKeyResponse();
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genGetCredentialAvailableActionsRequest(String requestId, String destinationId, String organisation, String issuerId, String serialNumber, String locale, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialAvailableActionsRequest payload = this.of.createGetCredentialAvailableActionsRequest();
        payload.setIssuerId(issuerId);
        payload.setSerialNumber(serialNumber);
        payload.setLocale(locale);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetCredentialAvailableActionsResponse(String relatedEndEntity, CSMessage request, List<CredentialAvailableActionsOperation> operations, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCredentialAvailableActionsResponse response = this.of.createGetCredentialAvailableActionsResponse();
        GetCredentialAvailableActionsResponse.Operations ops = this.of.createGetCredentialAvailableActionsResponseOperations();
        ops.getOperation().addAll(operations);
        response.setOperations(ops);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public byte[] genAutomaticRenewCredentialRequest(String requestId, String destinationId, String organisation, AutomationLevel automationLevel, List<byte[]> renewalRequestData, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        AutomaticRenewCredentialRequest payload = this.of.createAutomaticRenewCredentialRequest();
        payload.setAutomationLevel(automationLevel);
        payload.getRenewalRequestData().addAll(renewalRequestData);
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genAutomaticRenewCredentialResponse(String relatedEndEntity, CSMessage request, List<AutomaticRenewCredentialResponse.RenewedCredential> renewedCredentials, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        AutomaticRenewCredentialResponse response = this.of.createAutomaticRenewCredentialResponse();
        response.getRenewedCredential().addAll(renewedCredentials);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response);
    }

    public Key genKey(Credential relatedCredential, byte[] encryptedKey) {
        Key retval = this.of.createKey();
        retval.setRelatedCredential(relatedCredential);
        retval.setEncryptedData(encryptedKey);
        return retval;
    }

    public RecoverableKey genRecoverableKey(int relatedCredentialRequestId, byte[] encryptedKey) {
        RecoverableKey retval = this.of.createRecoverableKey();
        retval.setRelatedCredentialRequestId(relatedCredentialRequestId);
        retval.setEncryptedData(encryptedKey);
        return retval;
    }
}

