/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.security.Init;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.CSMessageVersion;
import org.certificateservices.messages.csmessages.DefaultMessageNameCatalogue;
import org.certificateservices.messages.csmessages.MessageNameCatalogue;
import org.certificateservices.messages.csmessages.PayloadParser;
import org.certificateservices.messages.csmessages.PayloadParserRegistry;
import org.certificateservices.messages.csmessages.jaxb.ApprovalStatus;
import org.certificateservices.messages.csmessages.jaxb.Assertions;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.CSRequest;
import org.certificateservices.messages.csmessages.jaxb.CSResponse;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.GetApprovalRequest;
import org.certificateservices.messages.csmessages.jaxb.IsApprovedRequest;
import org.certificateservices.messages.csmessages.jaxb.IsApprovedResponseType;
import org.certificateservices.messages.csmessages.jaxb.ObjectFactory;
import org.certificateservices.messages.csmessages.jaxb.Originator;
import org.certificateservices.messages.csmessages.jaxb.Payload;
import org.certificateservices.messages.csmessages.jaxb.PingRequest;
import org.certificateservices.messages.csmessages.jaxb.PingResponse;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;
import org.certificateservices.messages.utils.CSMessageOrganisationLookup;
import org.certificateservices.messages.utils.CSMessageUtils;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SettingsUtils;
import org.certificateservices.messages.utils.SystemTime;
import org.certificateservices.messages.utils.XMLSigner;
import org.certificateservices.messages.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultCSMessageParser
implements CSMessageParser {
    public static final String SETTING_SOURCEID = "csmessage.sourceid";
    public static final String OLD_SETTING_SOURCEID = "pkimessage.sourceid";
    public static final String SETTING_SIGN = "csmessage.sign";
    public static final String OLD_SETTING_SIGN = "pkimessage.sign";
    public static final String SETTING_REQUIRESIGNATURE = "csmessage.requiresignature";
    public static final String OLD_SETTING_REQUIRESIGNATURE = "pkimessage.requiresignature";
    public static final String SETTING_MESSAGE_NAME_CATALOGUE_IMPL = "csmessage.messagenamecatalogue.impl";
    public static final String OLD_SETTING_MESSAGE_NAME_CATALOGUE_IMPL = "pkimessage.messagenamecatalogue.impl";
    public static final String DEFAULT_MESSAGE_NAME_CATALOGUE_IMPL = DefaultMessageNameCatalogue.class.getName();
    public static final String CSMESSAGE_NAMESPACE = "http://certificateservices.org/xsd/csmessages2_0";
    private static final String CSMESSAGE_VERSION_2_0 = "2.0";
    private static final String CSMESSAGE_VERSION_2_1 = "2.1";
    private static final String CSMESSAGE_VERSION_2_2 = "2.2";
    private static final String CSMESSAGE_VERSION_2_3 = "2.3";
    public static final String CSMESSAGE_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/csmessages_schema2_0.xsd";
    public static final String CSMESSAGE_XSD_SCHEMA_2_1_RESOURCE_LOCATION = "/csmessages_schema2_1.xsd";
    public static final String CSMESSAGE_XSD_SCHEMA_2_2_RESOURCE_LOCATION = "/csmessages_schema2_2.xsd";
    public static final String CSMESSAGE_XSD_SCHEMA_2_3_RESOURCE_LOCATION = "/csmessages_schema2_3.xsd";
    private static final String CSMESSAGE_XSD_SCHEMA_2_0_URI = "http://certificateservices.org/xsd/csmessages2_0 csmessages_schema2_0.xsd";
    private static final Map<String, String> csMessageSchemaMap = new HashMap<String, String>();
    private static final Map<String, String> csMessageSchemaUriMap;
    public static final String XMLDSIG_XSD_SCHEMA_RESOURCE_LOCATION = "/xmldsig-core-schema.xsd";
    public static final String XMLENC_XSD_SCHEMA_RESOURCE_LOCATION = "/xenc-schema.xsd";
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String[] SUPPORTED_CSMESSAGE_VERSIONS;
    private ObjectFactory objectFactory = new ObjectFactory();
    private Properties properties = null;
    private MessageSecurityProvider securityProvider = null;
    private MessageNameCatalogue messageNameCatalogue = null;
    private JAXBRelatedData jaxbData = new JAXBRelatedData();
    private SystemTime systemTime = new DefaultSystemTime();
    private String sourceId = null;
    private XMLSigner xmlSigner;
    public static final String DEFAULT_CSMESSAGE_PROTOCOL = "2.3";
    private static String csMessageVersion;
    private CSMessageSignatureLocationFinder cSMessageSignatureLocationFinder = new CSMessageSignatureLocationFinder();
    private AssertionPayloadParser assertionPayloadParser = null;
    private Boolean signMessages;
    private Boolean requireSignature;

    @Override
    public void init(final MessageSecurityProvider securityProvider, Properties config) throws MessageProcessingException {
        this.properties = config;
        this.securityProvider = securityProvider;
        this.messageNameCatalogue = this.getMessageNameCatalogue(config);
        Init.init();
        DefaultCSMessageParser thisParser = this;
        PayloadParserRegistry.configure(new PayloadParserRegistry.ConfigurationCallback(){

            @Override
            public void updateContext() throws MessageProcessingException {
                DefaultCSMessageParser.this.jaxbData.clearAllJAXBData();
            }

            @Override
            public boolean needReinitialization(String namespace) throws MessageProcessingException {
                return false;
            }

            @Override
            public void configurePayloadParser(String namespace, PayloadParser payloadParser) throws MessageProcessingException {
                payloadParser.init(DefaultCSMessageParser.this.properties, securityProvider);
            }
        }, true);
        try {
            this.jaxbData.getJAXBContext();
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error occurred initializing JAXBContext: " + e.getMessage(), e);
        }
        for (String version : SUPPORTED_CSMESSAGE_VERSIONS) {
            try {
                this.jaxbData.getCSMessageMarshaller(version);
                this.jaxbData.getCSMessageUnmarshaller(version);
            }
            catch (MessageContentException e) {
                throw new MessageProcessingException("Unsupported CS Message version: " + version + " detected");
            }
        }
        this.sourceId = SettingsUtils.getProperty(config, SETTING_SOURCEID, OLD_SETTING_SOURCEID);
        if (this.sourceId == null || this.sourceId.trim().equals("")) {
            throw new MessageProcessingException("Error setting csmessage.sourceid must be set.");
        }
        try {
            this.xmlSigner = new XMLSigner(securityProvider, this.signMessages(), this.cSMessageSignatureLocationFinder, new CSMessageOrganisationLookup());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initizalizing XML Signer " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized CSMessage parseMessage(byte[] messageData) throws MessageContentException, MessageProcessingException {
        return this.parseMessage(messageData, true, true);
    }

    @Override
    public synchronized CSMessage parseMessage(byte[] messageData, boolean performValidation) throws MessageContentException, MessageProcessingException {
        return this.parseMessage(messageData, performValidation, true);
    }

    @Override
    public synchronized CSMessage parseMessage(byte[] messageData, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(messageData));
            return this.parseMessage(doc, performValidation, requireSignature);
        }
        catch (SAXException e) {
            throw new MessageContentException("Error parsing CS Message: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Error parsing CS Message: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageContentException("Error parsing CS Message: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
    }

    @Override
    public synchronized CSMessage parseMessage(Document doc, boolean performValidation) throws MessageContentException, MessageProcessingException {
        return this.parseMessage(doc, performValidation, true);
    }

    @Override
    public synchronized CSMessage parseMessage(Document doc, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        try {
            CSMessageVersion version = this.getVersionFromMessage(doc);
            this.verifyCSMessageVersion(version.getMessageVersion());
            Object object = this.jaxbData.getCSMessageUnmarshaller(version.getMessageVersion()).unmarshal((Node)doc);
            this.validateCSMessage(version, object, doc, performValidation, requireSignature);
            return (CSMessage)object;
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing CS Message: " + CSMessageUtils.getMarshallingExceptionMessage((Exception)((Object)e)), e);
        }
    }

    @Override
    public synchronized CSMessage parseMessage(Document doc) throws MessageContentException, MessageProcessingException {
        return this.parseMessage(doc, true, true);
    }

    @Override
    public byte[] generateCSRequestMessage(String requestId, String destinationId, String organisation, String payLoadVersion, Object payload, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.generateCSRequestMessage(requestId, destinationId, organisation, payLoadVersion, payload, null, assertions);
    }

    @Override
    public byte[] generateCSRequestMessage(String requestId, String destinationId, String organisation, String payLoadVersion, Object payload, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        CSMessage message = this.genCSMessage(csMessageVersion, payLoadVersion, null, requestId, destinationId, organisation, originator, payload, assertions);
        return this.marshallAndSignCSMessage(message);
    }

    @Override
    public CSMessageResponseData generateCSResponseMessage(String relatedEndEntity, CSMessage request, String payLoadVersion, Object payload) throws MessageContentException, MessageProcessingException {
        return this.generateCSResponseMessage(relatedEndEntity, request, payLoadVersion, payload, false);
    }

    @Override
    public CSMessageResponseData generateCSResponseMessage(String relatedEndEntity, CSMessage request, String payLoadVersion, Object payload, boolean isForwardableResponse) throws MessageContentException, MessageProcessingException {
        this.populateSuccessfulResponse(payload, request);
        CSMessage message = this.genCSMessage(request.getVersion(), payLoadVersion, request.getName(), null, request.getSourceId(), request.getOrganisation(), this.getOriginatorFromRequest(request), payload, null);
        byte[] responseData = this.marshallAndSignCSMessage(message);
        return new CSMessageResponseData(message, relatedEndEntity, responseData, isForwardableResponse);
    }

    @Override
    public byte[] generateGetApprovalRequest(String requestId, String destinationId, String organisation, byte[] request, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        CSMessage csMessage = this.parseMessage(request);
        CSRequest requestPayload = null;
        try {
            requestPayload = (CSRequest)csMessage.getPayload().getAny();
        }
        catch (Exception e) {
            throw new MessageContentException("Error in request message, request didn't contain CSRequest in payload.");
        }
        GetApprovalRequest payload = this.objectFactory.createGetApprovalRequest();
        Payload requestedPayload = this.objectFactory.createPayload();
        requestedPayload.setAny(requestPayload);
        payload.setRequestPayload(requestedPayload);
        return this.generateCSRequestMessage(requestId, destinationId, organisation, csMessage.getPayLoadVersion(), payload, originator, assertions);
    }

    @Override
    public byte[] generateIsApprovedRequest(String requestId, String destinationId, String organisation, String approvalId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IsApprovedRequest payload = this.objectFactory.createIsApprovedRequest();
        payload.setApprovalId(approvalId);
        return this.generateCSRequestMessage(requestId, destinationId, organisation, csMessageVersion, payload, originator, assertions);
    }

    @Override
    public CSMessageResponseData generateIsApprovedResponse(String relatedEndEntity, CSMessage request, ApprovalStatus approvalStatus, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IsApprovedResponseType responseType = this.objectFactory.createIsApprovedResponseType();
        if (!(request.getPayload().getAny() instanceof IsApprovedRequest)) {
            throw new MessageContentException("Error generating IsApprovedResponse, no IsApprovedRequest found in request payload");
        }
        responseType.setApprovalId(((IsApprovedRequest)request.getPayload().getAny()).getApprovalId());
        responseType.setApprovalStatus(approvalStatus);
        if (assertions != null && assertions.size() > 0) {
            Assertions a = this.objectFactory.createAssertions();
            for (Object assertion : assertions) {
                a.getAny().add(assertion);
            }
            responseType.getAssertions().add(a);
        }
        return this.generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), this.objectFactory.createIsApprovedResponse(responseType));
    }

    @Override
    public CSMessageResponseData generateGetApprovalResponse(String relatedEndEntity, CSMessage request, String approvalId, ApprovalStatus approvalStatus, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        IsApprovedResponseType responseType = this.objectFactory.createIsApprovedResponseType();
        responseType.setApprovalId(approvalId);
        responseType.setApprovalStatus(approvalStatus);
        if (assertions != null && assertions.size() > 0) {
            Assertions a = this.objectFactory.createAssertions();
            for (Object assertion : assertions) {
                a.getAny().add(assertion);
            }
            responseType.getAssertions().add(a);
        }
        return this.generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), this.objectFactory.createGetApprovalResponse(responseType));
    }

    @Override
    public byte[] generatePingRequest(String requestId, String destinationId, String organisation, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.generateCSRequestMessage(requestId, destinationId, organisation, csMessageVersion, new PingRequest(), originator, assertions);
    }

    @Override
    public CSMessageResponseData generatePingResponse(CSMessage request, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        return this.generateCSResponseMessage(null, request, request.getPayLoadVersion(), new PingResponse());
    }

    @Override
    public CSMessageResponseData genCSFailureResponse(String relatedEndEntity, byte[] request, RequestStatus status, String failureMessage, String destinationID, Credential originator) throws MessageContentException, MessageProcessingException {
        try {
            XPathExpression expr;
            Object result;
            Node versionNode;
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(request));
            Node pkiMessageNode = doc.getFirstChild();
            String version = null;
            if (pkiMessageNode != null && (versionNode = pkiMessageNode.getAttributes().getNamedItem("version")) != null) {
                version = versionNode.getNodeValue();
            }
            if (version == null || version.trim().equals("")) {
                throw new MessageContentException("Error unsupported protocol version when generating CSResponse, version: " + version);
            }
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (destinationID == null && (result = (String)(expr = xpath.compile("//*[local-name()='sourceId']/text()")).evaluate(doc, XPathConstants.STRING)) != null) {
                destinationID = result;
            }
            expr = xpath.compile("//*[local-name()='CSMessage']/@ID");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String responseToRequestID = (String)result;
            expr = xpath.compile("//*[local-name()='organisation']/text()");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String organisation = (String)result;
            expr = xpath.compile("//*[local-name()='name']/text()");
            result = expr.evaluate(doc, XPathConstants.STRING);
            String requestName = (String)result;
            if (organisation == null || responseToRequestID == null || destinationID == null || requestName == null) {
                throw new MessageContentException("Error generating CS Message Response from request, due to missing fields organisation, sourceId, name or ID in request.");
            }
            CSResponse csResponse = this.objectFactory.createCSResponse();
            csResponse.setStatus(status);
            csResponse.setFailureMessage(failureMessage);
            csResponse.setInResponseTo(responseToRequestID);
            CSMessage csMessage = this.genCSMessage(version, version, requestName, null, (String)destinationID, organisation, originator, this.objectFactory.createFailureResponse(csResponse), null);
            byte[] responseData = this.marshallAndSignCSMessage(csMessage);
            return new CSMessageResponseData(csMessage, relatedEndEntity, responseData, false);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error configuring the XML SAX Parser : " + e.getMessage());
        }
        catch (SAXException e) {
            throw new MessageContentException("Error parsing request XML message: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MessageProcessingException("Error reading the XML request data : " + e.getMessage());
        }
        catch (XPathExpressionException e) {
            throw new MessageProcessingException("Error constructing XPath expression when generating PKI Message responses : " + e.getMessage());
        }
    }

    @Override
    public X509Certificate getSigningCertificate(byte[] request) throws MessageContentException, MessageProcessingException {
        X509Certificate retval = null;
        if (this.requireSignature()) {
            retval = this.xmlSigner.findSignerCertificate(request);
        }
        return retval;
    }

    @Override
    public CSMessage genCSMessage(String version, String payLoadVersion, String requestName, String messageId, String destinationID, String organisation, Credential originator, Object payload, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        CSMessage retval = this.objectFactory.createCSMessage();
        retval.setVersion(version);
        retval.setPayLoadVersion(payLoadVersion);
        if (messageId == null) {
            retval.setID(MessageGenerateUtils.generateRandomUUID());
        } else {
            retval.setID(messageId);
        }
        retval.setTimeStamp(MessageGenerateUtils.dateToXMLGregorianCalendar(this.systemTime.getSystemTime()));
        retval.setName(this.messageNameCatalogue.lookupName(requestName, payload));
        retval.setDestinationId(destinationID);
        retval.setSourceId(this.sourceId);
        retval.setOrganisation(organisation);
        if (originator != null) {
            Originator originatorElement = this.objectFactory.createOriginator();
            originatorElement.setCredential(originator);
            retval.setOriginator(originatorElement);
        }
        if (assertions != null && assertions.size() > 0) {
            Assertions assertionsElem = this.objectFactory.createAssertions();
            for (Object assertion : assertions) {
                assertionsElem.getAny().add(assertion);
            }
            retval.setAssertions(assertionsElem);
        }
        Payload payLoadElem = this.objectFactory.createPayload();
        payLoadElem.setAny(payload);
        retval.setPayload(payLoadElem);
        return retval;
    }

    @Override
    public byte[] populateOriginatorAssertionsAndSignCSMessage(CSMessage message, String destinationId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        if (destinationId != null) {
            message.setDestinationId(destinationId);
        }
        if (originator != null) {
            Originator o = this.objectFactory.createOriginator();
            o.setCredential(originator);
            message.setOriginator(o);
        }
        if (assertions != null) {
            message.setAssertions(this.objectFactory.createAssertions());
            message.getAssertions().getAny().addAll(assertions);
        }
        message.setSignature(null);
        return this.marshallAndSignCSMessage(message);
    }

    private void populateSuccessfulResponse(Object response, CSMessage request) throws MessageProcessingException {
        CSResponse csresp = null;
        if (response instanceof CSResponse) {
            csresp = (CSResponse)response;
        }
        if (response instanceof JAXBElement && ((JAXBElement)response).getValue() instanceof CSResponse) {
            csresp = (CSResponse)((JAXBElement)response).getValue();
        }
        if (csresp == null) {
            throw new MessageProcessingException("Error populating CS response, response object is not a CSResponse");
        }
        csresp.setFailureMessage(null);
        csresp.setStatus(RequestStatus.SUCCESS);
        csresp.setInResponseTo(request.getID());
    }

    @Override
    public synchronized byte[] marshallAndSignCSMessage(CSMessage csMessage) throws MessageProcessingException, MessageContentException {
        if (csMessage == null) {
            throw new MessageProcessingException("Error marshalling CS Message, message cannot be null.");
        }
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            String version = csMessage.getVersion();
            this.jaxbData.getCSMessageMarshaller(version).marshal((Object)csMessage, (Node)doc);
            return this.xmlSigner.marshallAndSign(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, this.cSMessageSignatureLocationFinder);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling CS Message, " + CSMessageUtils.getMarshallingExceptionMessage((Exception)((Object)e)), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error marshalling CS Message, " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
    }

    @Override
    public byte[] marshallCSMessage(CSMessage csMessage) throws MessageProcessingException, MessageContentException {
        if (csMessage == null) {
            throw new MessageProcessingException("Error marshalling CS Message, message cannot be null.");
        }
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            String version = csMessage.getVersion();
            this.jaxbData.getCSMessageMarshaller(version).marshal((Object)csMessage, (Node)doc);
            return this.xmlSigner.marshallDoc(doc);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling CS Message, " + CSMessageUtils.getMarshallingExceptionMessage((Exception)((Object)e)), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error marshalling CS Message, " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
    }

    @Override
    public CSMessageVersion getVersionFromMessage(byte[] messageData) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(messageData));
            return this.getVersionFromMessage(doc);
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error parsing XML data: " + e.getMessage(), e);
        }
    }

    private CSMessageVersion getVersionFromMessage(Document doc) throws MessageContentException, MessageProcessingException {
        String messageVersion = null;
        String payLoadVersion = null;
        try {
            Node csMessage = doc.getFirstChild();
            if (csMessage != null) {
                Node payLoadVersionNode;
                Node versionNode = csMessage.getAttributes().getNamedItem("version");
                if (versionNode != null) {
                    messageVersion = versionNode.getNodeValue();
                }
                if ((payLoadVersionNode = csMessage.getAttributes().getNamedItem("payLoadVersion")) != null) {
                    payLoadVersion = payLoadVersionNode.getNodeValue();
                }
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing XML data: " + e.getMessage(), e);
        }
        if (messageVersion == null || messageVersion.trim().equals("")) {
            throw new MessageContentException("Error no version attribute found in CS Message.");
        }
        if (payLoadVersion == null || payLoadVersion.trim().equals("")) {
            throw new MessageContentException("Error no payload version attribute found in CS Message.");
        }
        return new CSMessageVersion(messageVersion, payLoadVersion);
    }

    @Override
    public MessageSecurityProvider getMessageSecurityProvider() {
        return this.securityProvider;
    }

    @Override
    public Marshaller getMarshaller(CSMessage message) throws MessageContentException, MessageProcessingException {
        return this.jaxbData.getCSMessageMarshaller(message.getVersion());
    }

    private void verifyCSMessageVersion(String version) throws MessageContentException {
        boolean foundVersion = false;
        for (String supportedVersion : SUPPORTED_CSMESSAGE_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            foundVersion = true;
            break;
        }
        if (!foundVersion) {
            throw new MessageContentException("Error unsupported protocol version " + version);
        }
    }

    private void validateCSMessage(CSMessageVersion version, Object object, Document doc, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        if (!(object instanceof CSMessage)) {
            throw new MessageContentException("Error: parsed object not a CS Message.");
        }
        CSMessage csMessage = (CSMessage)object;
        this.validateCSMessageHeader(csMessage, doc, performValidation, requireSignature);
        if (csMessage.getAssertions() != null) {
            this.validateAssertions(csMessage.getAssertions().getAny());
        }
        this.validatePayloadObject(version, csMessage.getPayload().getAny());
    }

    private void validateCSMessageHeader(CSMessage csMessage, Document doc, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        this.validateSignature(doc, performValidation, requireSignature);
    }

    @Override
    public void validatePayloadObject(CSMessageVersion version, Object payLoadObject) throws MessageContentException {
        try {
            String payLoadNamespace = this.jaxbData.getNamespace(payLoadObject);
            if (!payLoadNamespace.equals(CSMESSAGE_NAMESPACE)) {
                Validator validator = this.jaxbData.getPayLoadValidatorFromCache(payLoadNamespace, version.getMessageVersion(), version.getPayLoadVersion());
                validator.validate((Source)new JAXBSource(this.jaxbData.getJAXBContext(), payLoadObject));
            } else if (payLoadObject instanceof GetApprovalRequest) {
                GetApprovalRequest getApprovalRequest = (GetApprovalRequest)payLoadObject;
                Object requestedPayload = getApprovalRequest.getRequestPayload().getAny();
                String requestedPayLoadNamespace = this.jaxbData.getNamespace(requestedPayload);
                Validator validator = this.jaxbData.getPayLoadValidatorFromCache(requestedPayLoadNamespace, version.getMessageVersion(), version.getPayLoadVersion());
                validator.validate((Source)new JAXBSource(this.jaxbData.getJAXBContext(), requestedPayload));
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing payload of CS Message: " + CSMessageUtils.getMarshallingExceptionMessage(e), e);
        }
    }

    private void validateAssertions(List<Object> assertions) throws MessageContentException, MessageProcessingException {
        if (assertions == null) {
            return;
        }
        for (Object assertion : assertions) {
            this.getAssertionPayloadParser().schemaValidateAssertion(assertion);
        }
    }

    private AssertionPayloadParser getAssertionPayloadParser() throws MessageProcessingException {
        if (this.assertionPayloadParser == null) {
            this.assertionPayloadParser = (AssertionPayloadParser)PayloadParserRegistry.getParser(AssertionPayloadParser.NAMESPACE);
        }
        return this.assertionPayloadParser;
    }

    private void validateSignature(Document doc, boolean performValidation, boolean requireSignature) throws MessageContentException, MessageProcessingException {
        if (this.requireSignature() && requireSignature) {
            this.xmlSigner.verifyEnvelopedSignature(doc, performValidation);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
    }

    private MessageNameCatalogue getMessageNameCatalogue(Properties config) throws MessageProcessingException {
        try {
            MessageNameCatalogue retval = (MessageNameCatalogue)this.getClass().getClassLoader().loadClass(config.getProperty(SETTING_MESSAGE_NAME_CATALOGUE_IMPL, DEFAULT_MESSAGE_NAME_CATALOGUE_IMPL)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            retval.init(config);
            return retval;
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error creating creating name catalogue " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private boolean signMessages() throws MessageProcessingException {
        if (this.signMessages == null) {
            this.signMessages = SettingsUtils.parseBooleanWithDefault(this.properties, SETTING_SIGN, OLD_SETTING_SIGN, true);
        }
        return this.signMessages;
    }

    private boolean requireSignature() throws MessageProcessingException {
        if (this.requireSignature == null) {
            this.requireSignature = SettingsUtils.parseBooleanWithDefault(this.properties, SETTING_REQUIRESIGNATURE, OLD_SETTING_REQUIRESIGNATURE, true);
        }
        return this.requireSignature;
    }

    @Override
    public Credential getOriginatorFromRequest(CSMessage request) {
        Credential retval = null;
        if (request != null && request.getOriginator() != null) {
            retval = request.getOriginator().getCredential();
        }
        return retval;
    }

    public String getCSMessageVersion() {
        return csMessageVersion;
    }

    public void setCSMessageVersion(String csMessageVersion) {
        DefaultCSMessageParser.csMessageVersion = csMessageVersion;
    }

    static {
        csMessageSchemaMap.put(CSMESSAGE_VERSION_2_0, CSMESSAGE_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        csMessageSchemaMap.put(CSMESSAGE_VERSION_2_1, CSMESSAGE_XSD_SCHEMA_2_1_RESOURCE_LOCATION);
        csMessageSchemaMap.put(CSMESSAGE_VERSION_2_2, CSMESSAGE_XSD_SCHEMA_2_2_RESOURCE_LOCATION);
        csMessageSchemaMap.put("2.3", CSMESSAGE_XSD_SCHEMA_2_3_RESOURCE_LOCATION);
        csMessageSchemaUriMap = new HashMap<String, String>();
        csMessageSchemaUriMap.put(CSMESSAGE_VERSION_2_0, CSMESSAGE_XSD_SCHEMA_2_0_URI);
        csMessageSchemaUriMap.put(CSMESSAGE_VERSION_2_1, CSMESSAGE_XSD_SCHEMA_2_0_URI);
        csMessageSchemaUriMap.put(CSMESSAGE_VERSION_2_2, CSMESSAGE_XSD_SCHEMA_2_0_URI);
        csMessageSchemaUriMap.put("2.3", CSMESSAGE_XSD_SCHEMA_2_0_URI);
        SUPPORTED_CSMESSAGE_VERSIONS = new String[]{CSMESSAGE_VERSION_2_0, CSMESSAGE_VERSION_2_1, CSMESSAGE_VERSION_2_2, "2.3"};
        csMessageVersion = "2.3";
    }

    public class CSMessageSignatureLocationFinder
    implements XMLSigner.SignatureLocationFinder {
        @Override
        public Element[] getSignatureLocations(Document doc) throws MessageContentException {
            try {
                if (doc.getDocumentElement().getLocalName().equals("CSMessage") && doc.getDocumentElement().getNamespaceURI().equals(DefaultCSMessageParser.CSMESSAGE_NAMESPACE)) {
                    return new Element[]{doc.getDocumentElement()};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageContentException("Invalid CS message type sent for signature.");
        }

        @Override
        public String getIDAttribute() {
            return "ID";
        }

        @Override
        public String getIDValue(Element signedElement) throws MessageContentException {
            return signedElement.getAttribute(this.getIDAttribute());
        }

        @Override
        public List<QName> getSiblingsBeforeSignature(Element element) throws MessageContentException {
            return null;
        }
    }

    private class JAXBRelatedData {
        private JAXBContext jaxbContext = null;
        private HashMap<String, Validator> payLoadValidatorCache = new HashMap();
        private JAXBIntrospector jaxbIntrospector = null;
        private Map<String, Schema> csMessageSchemaCache = new HashMap<String, Schema>();
        private String jaxbClassPath = "";

        private JAXBRelatedData() {
        }

        void clearAllJAXBData() {
            this.jaxbClassPath = "";
            this.jaxbContext = null;
            this.payLoadValidatorCache.clear();
            this.csMessageSchemaCache.clear();
            this.jaxbIntrospector = null;
        }

        JAXBContext getJAXBContext() throws JAXBException, MessageProcessingException {
            if (this.jaxbContext == null) {
                this.jaxbClassPath = "org.certificateservices.messages.csmessages.jaxb:org.certificateservices.messages.xmldsig.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.csexport.data.jaxb:org.certificateservices.messages.sensitivekeys.jaxb";
                for (String namespace : PayloadParserRegistry.getRegistredNamespaces()) {
                    String jaxbPackage = PayloadParserRegistry.getParser(namespace).getJAXBPackage();
                    if (jaxbPackage == null) continue;
                    this.jaxbClassPath = this.jaxbClassPath + ":" + jaxbPackage;
                }
                this.jaxbContext = JAXBContext.newInstance((String)this.jaxbClassPath);
            }
            return this.jaxbContext;
        }

        Validator getPayLoadValidatorFromCache(String payLoadNamespace, String version, String payLoadVersion) throws MessageProcessingException, MessageContentException {
            String key = payLoadNamespace + ";" + version + ";" + payLoadVersion;
            Validator retval = this.payLoadValidatorCache.get(key);
            if (retval == null) {
                PayloadParser pp = PayloadParserRegistry.getParser(payLoadNamespace);
                InputStream payLoadSchemaStream = pp.getSchemaAsInputStream(payLoadVersion);
                String csMessageSchemaLocation = (String)csMessageSchemaMap.get(version);
                String[] relatedSchemas = pp.getRelatedSchemas(payLoadVersion);
                Source[] sources = new Source[payLoadSchemaStream == null ? 3 + relatedSchemas.length : 4 + relatedSchemas.length];
                sources[0] = new StreamSource(this.getClass().getResourceAsStream(DefaultCSMessageParser.XMLDSIG_XSD_SCHEMA_RESOURCE_LOCATION));
                sources[1] = new StreamSource(this.getClass().getResourceAsStream("/sensitivekeys_schema2_0.xsd"));
                sources[2] = new StreamSource(this.getClass().getResourceAsStream(csMessageSchemaLocation));
                for (int i = 0; i < relatedSchemas.length; ++i) {
                    sources[3 + i] = new StreamSource(this.getClass().getResourceAsStream(relatedSchemas[i]));
                }
                if (payLoadSchemaStream != null) {
                    sources[3 + relatedSchemas.length] = new StreamSource(payLoadSchemaStream);
                }
                try {
                    Schema s = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(sources);
                    retval = s.newValidator();
                }
                catch (SAXException e) {
                    throw new MessageProcessingException("Problems occurred generating pay load schema for " + payLoadNamespace + ", version " + payLoadVersion + ", error: " + e.getMessage(), e);
                }
                this.payLoadValidatorCache.put(key, retval);
            }
            return retval;
        }

        JAXBIntrospector getJAXBIntrospector() throws JAXBException, MessageProcessingException {
            if (this.jaxbIntrospector == null) {
                this.jaxbIntrospector = this.getJAXBContext().createJAXBIntrospector();
            }
            return this.jaxbIntrospector;
        }

        Marshaller createMarshaller(String schemaLocation) throws JAXBException, MessageProcessingException {
            Marshaller retval = this.getJAXBContext().createMarshaller();
            retval.setProperty("jaxb.schemaLocation", (Object)schemaLocation);
            retval.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            return retval;
        }

        private String getNamespace(Object jaxbObject) throws MessageProcessingException {
            QName qname = null;
            try {
                qname = this.getJAXBIntrospector().getElementName(jaxbObject);
            }
            catch (JAXBException e) {
                throw new MessageProcessingException("Problems occured generating JAXB Context ( Introspector ) : " + e.getMessage(), e);
            }
            if (qname != null) {
                return qname.getNamespaceURI();
            }
            return null;
        }

        Marshaller getCSMessageMarshaller(String version) throws MessageProcessingException, MessageContentException {
            Marshaller retval;
            if (version == null) {
                throw new MessageContentException("Invalid CS Message, version is missing.");
            }
            String schemaURL = (String)csMessageSchemaUriMap.get(version);
            try {
                retval = this.createMarshaller(schemaURL);
                retval.setSchema(this.getCSMessageSchema(version));
            }
            catch (Exception e) {
                throw new MessageProcessingException("Error creating XML Marshaller for CS Message version: " + version);
            }
            return retval;
        }

        Unmarshaller getCSMessageUnmarshaller(String version) throws MessageProcessingException, MessageContentException {
            Unmarshaller retval;
            if (version == null) {
                throw new MessageContentException("Invalid CS Message, version is missing.");
            }
            try {
                retval = this.getJAXBContext().createUnmarshaller();
                retval.setSchema(this.getCSMessageSchema(version));
            }
            catch (Exception e) {
                throw new MessageProcessingException("Error creating XML Unmarshaller for CS Message version: " + version);
            }
            return retval;
        }

        Schema getCSMessageSchema(String version) throws MessageContentException, SAXException, MessageProcessingException {
            Schema retval = this.csMessageSchemaCache.get(version);
            if (retval == null) {
                String schemaLocation = (String)csMessageSchemaMap.get(version);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream(DefaultCSMessageParser.XMLDSIG_XSD_SCHEMA_RESOURCE_LOCATION)), new StreamSource(this.getClass().getResourceAsStream(schemaLocation))};
                retval = schemaFactory.newSchema(sources);
                this.csMessageSchemaCache.put(version, retval);
            }
            return retval;
        }
    }
}

