/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages;

import java.util.Properties;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.pkimessages.DefaultPKIMessageParser;
import org.certificateservices.messages.pkimessages.PKIMessageParser;

public class PKIMessageParserFactory {
    public static final String SETTING_PKIMESSAGEPARSER_IMPL = "pkimessage.parser.impl";
    private static final String DEFAULT_IMPLEMENTATION = DefaultPKIMessageParser.class.getName();

    public static PKIMessageParser genPKIMessageParser(MessageSecurityProvider securityProvider, Properties config) throws MessageException {
        String cp = config.getProperty(SETTING_PKIMESSAGEPARSER_IMPL, DEFAULT_IMPLEMENTATION);
        try {
            Class<?> c = PKIMessageParserFactory.class.getClassLoader().loadClass(cp);
            PKIMessageParser retval = (PKIMessageParser)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            retval.init(securityProvider, config);
            return retval;
        }
        catch (Exception e) {
            if (e instanceof MessageException) {
                throw (MessageException)e;
            }
            throw new MessageException("Error creating PKI Message Parser: " + e.getMessage(), e);
        }
    }
}

