/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.security.SecureRandom;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.certificateservices.messages.MessageProcessingException;

public class MessageGenerateUtils {
    private static SecureRandom secureRandom = new SecureRandom();
    private static String[] specialCharSet = new String[]{"8", "9", "a", "b"};
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static String generateRandomUUID() {
        byte[] randomData = new byte[15];
        secureRandom.nextBytes(randomData);
        String hexData = new String(MessageGenerateUtils.bytesToHex(randomData));
        String specialChar = specialCharSet[secureRandom.nextInt(4)];
        return hexData.substring(0, 8) + "-" + hexData.substring(8, 12) + "-4" + hexData.substring(12, 15) + "-" + specialChar + hexData.substring(15, 18) + "-" + hexData.substring(18);
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date) throws MessageProcessingException {
        return MessageGenerateUtils.dateToXMLGregorianCalendar(date, null);
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date, TimeZone timeZone) throws MessageProcessingException {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = timeZone != null ? new GregorianCalendar(timeZone) : new GregorianCalendar();
        c.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            throw new MessageProcessingException("Error generating XMLGregorianDate from Date : " + e.getMessage(), e);
        }
    }

    public static XMLGregorianCalendar dateToXMLGregorianCalendarNoTimeZone(Date date) throws MessageProcessingException {
        if (date == null) {
            return null;
        }
        XMLGregorianCalendar xmlGregorianCalendar = MessageGenerateUtils.dateToXMLGregorianCalendar(date, TimeZone.getTimeZone("UTC"));
        return xmlGregorianCalendar;
    }

    public static Date xMLGregorianCalendarToDate(XMLGregorianCalendar calendarDate) throws MessageProcessingException {
        if (calendarDate == null) {
            return null;
        }
        return calendarDate.toGregorianCalendar().getTime();
    }

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

