/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.autoenroll;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.autoenroll.jaxb.CheckStatusRequest;
import org.certificateservices.messages.autoenroll.jaxb.CheckStatusResponse;
import org.certificateservices.messages.autoenroll.jaxb.ClientActionRequest;
import org.certificateservices.messages.autoenroll.jaxb.ClientActionResponse;
import org.certificateservices.messages.autoenroll.jaxb.ObjectFactory;
import org.certificateservices.messages.autoenroll.jaxb.PerformFetchExistingTokensAction;
import org.certificateservices.messages.autoenroll.jaxb.PerformGenerateCredentialRequestAction;
import org.certificateservices.messages.autoenroll.jaxb.PerformRemoveCredentialsAction;
import org.certificateservices.messages.autoenroll.jaxb.PerformedFetchExistingTokensAction;
import org.certificateservices.messages.autoenroll.jaxb.PerformedGenerateCredentialRequestAction;
import org.certificateservices.messages.autoenroll.jaxb.PerformedRemoveCredentialsAction;
import org.certificateservices.messages.autoenroll.jaxb.TokenData;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.Attribute;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.CredentialRequest;
import org.certificateservices.messages.sensitivekeys.jaxb.KeyDataType;

public class AutoEnrollPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/autoenroll2_x";
    public static final String AUTOENROLL_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/autoenroll_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_AUTOENROLL_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_AUTOENROLL_VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.autoenroll.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_AUTOENROLL_VERSION)) {
            return this.getClass().getResourceAsStream(AUTOENROLL_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported Auto Enroll Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_AUTOENROLL_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_AUTOENROLL_VERSION;
    }

    public byte[] genCheckStatusRequest(String requestId, String destinationId, String organisation, List<CheckStatusRequest.Type> autoEnrollmentProfileTypes, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        CheckStatusRequest payload = this.of.createCheckStatusRequest();
        payload.getType().addAll(autoEnrollmentProfileTypes);
        CSMessageParser csMessageParser = this.getCSMessageParser();
        CSMessage message = csMessageParser.genCSMessage("2.3", DEFAULT_AUTOENROLL_VERSION, null, requestId, destinationId, organisation, originator, payload, assertions);
        return csMessageParser.marshallCSMessage(message);
    }

    public CSMessageResponseData genCheckStatusResponse(String relatedEndEntity, CSMessage request, List<CheckStatusResponse.Type> autoEnrollmentProfileTypes, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        CheckStatusResponse payload = this.of.createCheckStatusResponse();
        payload.getType().addAll(autoEnrollmentProfileTypes);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload, false);
    }

    public byte[] genClientActionRequest(String requestId, String destinationId, String organisation, List<ClientActionRequest.Type> autoEnrollmentProfileTypes, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ClientActionRequest payload = this.of.createClientActionRequest();
        payload.getType().addAll(autoEnrollmentProfileTypes);
        CSMessageParser csMessageParser = this.getCSMessageParser();
        CSMessage message = csMessageParser.genCSMessage("2.3", DEFAULT_AUTOENROLL_VERSION, null, requestId, destinationId, organisation, originator, payload, assertions);
        return csMessageParser.marshallCSMessage(message);
    }

    public CSMessageResponseData genClientActionResponse(String relatedEndEntity, CSMessage request, List<ClientActionResponse.Type> autoEnrollmentProfileTypes, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        ClientActionResponse payload = this.of.createClientActionResponse();
        payload.getType().addAll(autoEnrollmentProfileTypes);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), payload, false);
    }

    public CheckStatusRequest.Type genCheckStatusRequestType(String autoEnrollmentProfile, List<Credential> currentCredentials) {
        CheckStatusRequest.Type retval = this.of.createCheckStatusRequestType();
        retval.setAutoEnrollmentProfile(autoEnrollmentProfile);
        CheckStatusRequest.Type.CurrentCredentials cc = this.of.createCheckStatusRequestTypeCurrentCredentials();
        cc.getCredential().addAll(currentCredentials);
        retval.setCurrentCredentials(cc);
        return retval;
    }

    public CheckStatusResponse.Type genCheckStatusResponseType(String autoEnrollmentProfile, CheckStatusResponse.Type.PerformActions performActions) {
        CheckStatusResponse.Type retval = this.of.createCheckStatusResponseType();
        retval.setAutoEnrollmentProfile(autoEnrollmentProfile);
        retval.setPerformActions(performActions);
        return retval;
    }

    public ClientActionRequest.Type genClientActionRequestType(String autoEnrollmentProfile, List<Credential> currentCredentials, ClientActionRequest.Type.Actions actions) {
        ClientActionRequest.Type retval = this.of.createClientActionRequestType();
        retval.setAutoEnrollmentProfile(autoEnrollmentProfile);
        ClientActionRequest.Type.CurrentCredentials cc = this.of.createClientActionRequestTypeCurrentCredentials();
        cc.getCredential().addAll(currentCredentials);
        retval.setCurrentCredentials(cc);
        retval.setActions(actions);
        return retval;
    }

    public ClientActionResponse.Type genClientActionResponseType(String autoEnrollmentProfile, List<TokenData> tokenDatas) {
        ClientActionResponse.Type retval = this.of.createClientActionResponseType();
        retval.setAutoEnrollmentProfile(autoEnrollmentProfile);
        if (tokenDatas != null) {
            ClientActionResponse.Type.TokenDatas tds = this.of.createClientActionResponseTypeTokenDatas();
            tds.getTokenData().addAll(tokenDatas);
            retval.setTokenDatas(tds);
        }
        return retval;
    }

    public PerformFetchExistingTokensAction genPerformFetchExistingTokensAction() {
        return this.of.createPerformFetchExistingTokensAction();
    }

    public PerformGenerateCredentialRequestAction genPerformGenerateCredentialRequestAction(boolean keyRecoverable, Credential wrappingCredential, String credentialSubType, Map<String, String> tokenRequestAttributes) throws MessageContentException {
        if (keyRecoverable && wrappingCredential == null) {
            throw new MessageContentException("PerformGenerateCredentialRequestAction must have a wrapping credential when set as key recoverable");
        }
        if (credentialSubType == null) {
            throw new MessageContentException("PerformGenerateCredentialRequestAction must have credentialSubType set.");
        }
        if (tokenRequestAttributes == null || tokenRequestAttributes.size() < 1) {
            throw new MessageContentException("Error at least on token request attribute must be specified.");
        }
        PerformGenerateCredentialRequestAction retval = this.of.createPerformGenerateCredentialRequestAction();
        retval.setKeyRecoverable(keyRecoverable);
        retval.setWrappingCredential(wrappingCredential);
        retval.setCredentialSubType(credentialSubType);
        PerformGenerateCredentialRequestAction.TokenRequestAttributes tra = this.of.createPerformGenerateCredentialRequestActionTokenRequestAttributes();
        for (String key : tokenRequestAttributes.keySet()) {
            Attribute a = this.csMessageObjectFactory.createAttribute();
            a.setKey(key);
            a.setValue(tokenRequestAttributes.get(key));
            tra.getTokenRequestAttribute().add(a);
        }
        retval.setTokenRequestAttributes(tra);
        return retval;
    }

    public PerformRemoveCredentialsAction genPerformRemoveCredentialsAction(List<Credential> credentials) throws MessageContentException {
        if (credentials == null || credentials.size() == 0) {
            throw new MessageContentException("PerformRemoveCredentialsAction must have at least one credential.");
        }
        PerformRemoveCredentialsAction retval = this.of.createPerformRemoveCredentialsAction();
        retval.getCredential().addAll(credentials);
        return retval;
    }

    public PerformedFetchExistingTokensAction genPerformedFetchExistingTokensAction() {
        return this.of.createPerformedFetchExistingTokensAction();
    }

    public PerformedFetchExistingTokensAction genPerformedFetchExistingTokensAction(Credential wrappingCredential) {
        PerformedFetchExistingTokensAction retval = this.of.createPerformedFetchExistingTokensAction();
        retval.setWrappingCredential(wrappingCredential);
        return retval;
    }

    public PerformedGenerateCredentialRequestAction genPerformedGenerateCredentialRequestAction(CredentialRequest credentialRequest, byte[] encryptedKey) throws MessageContentException {
        if (credentialRequest == null) {
            throw new MessageContentException("PerformedGenerateCredentialRequestAction must have a credential request.");
        }
        PerformedGenerateCredentialRequestAction retval = this.of.createPerformedGenerateCredentialRequestAction();
        retval.setCredentialRequest(credentialRequest);
        retval.setEncryptedKey(encryptedKey);
        return retval;
    }

    public PerformedRemoveCredentialsAction genPerformedRemoveCredentialsAction(List<Credential> credentials) throws MessageContentException {
        if (credentials == null || credentials.size() == 0) {
            throw new MessageContentException("PerformedRemoveCredentialsAction must have at least one credential.");
        }
        PerformedRemoveCredentialsAction retval = this.of.createPerformedRemoveCredentialsAction();
        retval.getCredential().addAll(credentials);
        return retval;
    }

    public TokenData genTokenData(Credential credential) throws MessageContentException {
        return this.genTokenData(credential, (KeyDataType)null);
    }

    public TokenData genTokenData(Credential credential, KeyDataType keyData) throws MessageContentException {
        if (credential == null) {
            throw new MessageContentException("TokenData must have at least credential set.");
        }
        TokenData retval = this.of.createTokenData();
        retval.setCredential(credential);
        retval.setKey(keyData);
        return retval;
    }

    public TokenData genTokenData(Credential credential, byte[] encryptedKey) throws MessageContentException {
        if (credential == null) {
            throw new MessageContentException("TokenData must have at least credential set.");
        }
        TokenData retval = this.of.createTokenData();
        retval.setCredential(credential);
        retval.setEncryptedKey(encryptedKey);
        return retval;
    }
}

