/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csexport.protocol;

import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.csexport.data.jaxb.CSExport;
import org.certificateservices.messages.csexport.protocol.jaxb.GetCSExportRequest;
import org.certificateservices.messages.csexport.protocol.jaxb.GetCSExportResponse;
import org.certificateservices.messages.csexport.protocol.jaxb.ObjectFactory;
import org.certificateservices.messages.csexport.protocol.jaxb.QueryParameter;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.CSMessageResponseData;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.CSResponse;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;

public class CSExportProtocolPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/cs_export_protocol2_0";
    public static final String CS_EXPORT_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs_export_protocol_schema2_0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private static final String[] SUPPORTED_CSEXPORT_PROTOCOL_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_CSEXPORT_PROTOCOL__VERSION = "2.0";

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.csexport.protocol.jaxb";
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_CSEXPORT_PROTOCOL__VERSION)) {
            return this.getClass().getResourceAsStream(CS_EXPORT_PROTOCOL_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported CS Export Protocol Payload version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_CSEXPORT_PROTOCOL_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_CSEXPORT_PROTOCOL__VERSION;
    }

    public byte[] genGetCSExportRequest(String requestId, String destinationId, String organisation, String exportDataVersion, List<QueryParameter> queryParameters, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCSExportRequest payload = this.of.createGetCSExportRequest();
        payload.setExportDataVersion(exportDataVersion);
        if (queryParameters != null && queryParameters.size() > 0) {
            GetCSExportRequest.QueryParameters params = this.of.createGetCSExportRequestQueryParameters();
            params.getQueryParameter().addAll(queryParameters);
            payload.setQueryParameters(params);
        }
        return this.getCSMessageParser().generateCSRequestMessage(requestId, destinationId, organisation, this.getPayloadVersion(), payload, originator, assertions);
    }

    public CSMessageResponseData genGetCSExportResponse(String relatedEndEntity, CSMessage request, String exportDataVersion, Object csExportData, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        GetCSExportResponse response = this.of.createGetCSExportResponse();
        response.setExportDataVersion(exportDataVersion);
        response.setResult(this.of.createResult());
        response.getResult().setAny(csExportData);
        return this.getCSMessageParser().generateCSResponseMessage(relatedEndEntity, request, request.getPayLoadVersion(), response, false);
    }

    public CSExport getCSExportDataFromResponse(CSMessage resp) throws MessageContentException, MessageProcessingException {
        try {
            Object responsePayload = resp.getPayload().getAny();
            if (responsePayload instanceof JAXBElement && ((JAXBElement)responsePayload).getValue() instanceof CSResponse) {
                CSResponse csResponse = (CSResponse)((JAXBElement)responsePayload).getValue();
                RequestStatus requestStatus = csResponse.getStatus();
                if (requestStatus.equals((Object)RequestStatus.ILLEGALARGUMENT)) {
                    throw new MessageContentException("Failure CSExport response; status: " + requestStatus.toString() + ", message: " + csResponse.getFailureMessage());
                }
                if (requestStatus.equals((Object)RequestStatus.ERROR) || requestStatus.equals((Object)RequestStatus.APPROVALREQUIRED) || requestStatus.equals((Object)RequestStatus.NOTAUTHORIZED)) {
                    throw new MessageProcessingException("Failure CSExport response; status: " + requestStatus.toString() + ", message: " + csResponse.getFailureMessage());
                }
            }
            if (responsePayload instanceof GetCSExportResponse) {
                return (CSExport)((GetCSExportResponse)responsePayload).getResult().getAny();
            }
        }
        catch (MessageContentException e) {
            throw e;
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error parsing CSExport response from message: " + e.getMessage(), e);
        }
        throw new MessageProcessingException("Error parsing CSExport response from message, make sure it is a CSResponse object.");
    }
}

