/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.encryptedcsmessage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.csmessages.jaxb.Credential;
import org.certificateservices.messages.csmessages.jaxb.RequestStatus;
import org.certificateservices.messages.encryptedcsmessage.jaxb.EncryptedCSMessageType;
import org.certificateservices.messages.encryptedcsmessage.jaxb.ObjectFactory;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SystemTime;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLUtils;
import org.certificateservices.messages.xenc.jaxb.EncryptedDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class EncryptedCSMessagePayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "http://certificateservices.org/xsd/encrypted_csmessages2_0";
    private static final String XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/encrypted_csmessages_schema2_0.xsd";
    private static final String[] SUPPORTED_ASSERTION_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_ASSERTION_VERSION = "2.0";
    private XMLEncrypter xmlEncrypter;
    private SystemTime systemTime = new DefaultSystemTime();
    private EncryptedCSMessageXMLConverter xmlConverter = new EncryptedCSMessageXMLConverter();
    ObjectFactory of = new ObjectFactory();
    org.certificateservices.messages.csmessages.jaxb.ObjectFactory csMessageOf = new org.certificateservices.messages.csmessages.jaxb.ObjectFactory();
    private Transformer transformer;
    private JAXBContext jaxbContext = null;
    private Schema schema = null;

    @Override
    public void init(Properties config, MessageSecurityProvider secProv) throws MessageProcessingException {
        super.init(config, secProv);
        try {
            this.xmlEncrypter = new XMLEncrypter(secProv, this.getDocumentBuilder(), this.getMarshaller(), this.getUnmarshaller());
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing JAXB in AssertionPayloadParser: " + e.getMessage(), e);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            this.transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MessageProcessingException("Error instanciating Transformer for XMLSigner: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public String getJAXBPackage() {
        return null;
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        return null;
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_ASSERTION_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_ASSERTION_VERSION;
    }

    public byte[] genEncryptedCSMessage(byte[] message, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        return this.genEncryptedCSMessage(message, DEFAULT_ASSERTION_VERSION, receipients);
    }

    public byte[] genEncryptedCSMessage(byte[] message, String version, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(message));
            String id = MessageGenerateUtils.generateRandomUUID();
            EncryptedCSMessageType type = this.of.createEncryptedCSMessageType();
            type.setID(id);
            type.setVersion(version);
            type.setTimeStamp(MessageGenerateUtils.dateToXMLGregorianCalendar(this.systemTime.getSystemTime()));
            JAXBElement encryptedData = (JAXBElement)this.getUnmarshaller().unmarshal((Node)this.xmlEncrypter.encryptElement(doc, receipients, true));
            type.setEncryptedData((EncryptedDataType)encryptedData.getValue());
            return this.marshall(this.of.createEncryptedCSMessage(type));
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error encrypting CS Message: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new MessageContentException("Error encrypting CS Message: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error encrypting CS Message: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Error encrypting CS Message: " + e.getMessage(), e);
        }
    }

    @Override
    public CSMessage parseMessage(byte[] messageData) throws MessageContentException, MessageProcessingException {
        try {
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(messageData));
            Element rootElement = doc.getDocumentElement();
            if (rootElement.getLocalName().equals(ObjectFactory._EncryptedCSMessage_QNAME.getLocalPart()) && rootElement.getNamespaceURI().equals(NAMESPACE)) {
                doc = this.xmlEncrypter.decryptDoc(doc, this.xmlConverter);
            }
            return this.getCSMessageParser().parseMessage(doc);
        }
        catch (SAXException e) {
            throw new MessageContentException("Error parsing message: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Error parsing message: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error parsing configuration error when parsing message: " + e.getMessage(), e);
        }
        catch (NoDecryptionKeyFoundException e) {
            throw new MessageContentException("Error no related decryption key found for message: " + e.getMessage(), e);
        }
    }

    public Document isEncryptedCSMessage(byte[] messageData) throws MessageContentException, MessageProcessingException {
        try {
            Document retval = null;
            Document doc = this.getDocumentBuilder().parse(new ByteArrayInputStream(messageData));
            Element rootElement = doc.getDocumentElement();
            if (rootElement.getLocalName().equals(ObjectFactory._EncryptedCSMessage_QNAME.getLocalPart()) && rootElement.getNamespaceURI().equals(NAMESPACE)) {
                retval = doc;
            }
            return retval;
        }
        catch (SAXException e) {
            throw new MessageContentException("Error parsing message: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new MessageContentException("Error parsing message: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error parsing configuration error when parsing message: " + e.getMessage(), e);
        }
    }

    public byte[] decryptDoc(Document doc) throws MessageContentException, MessageProcessingException {
        try {
            doc = this.xmlEncrypter.decryptDoc(doc, this.xmlConverter);
            StringWriter writer = new StringWriter();
            this.transformer.transform(new DOMSource(doc), new StreamResult(writer));
            String output = writer.getBuffer().toString();
            return output.getBytes("UTF-8");
        }
        catch (IOException e) {
            throw new MessageContentException("Error parsing message: " + e.getMessage(), e);
        }
        catch (NoDecryptionKeyFoundException e) {
            throw new MessageContentException("Error no related decryption key found for message: " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new MessageContentException("Error converting Doc into XML String: " + e.getMessage(), e);
        }
    }

    private byte[] marshall(JAXBElement<?> message) throws MessageProcessingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getMarshaller().marshal(message, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error occurred marshalling assertion object: " + e.getMessage(), e);
        }
    }

    @Override
    public Object getPayload(CSMessage csMessage) throws MessageContentException {
        throw new IllegalStateException("Error EncryptedCSMessagePayloadParser doesn't support metod getPayload");
    }

    @Override
    public RequestStatus getResponseStatus(CSMessage csMessage) throws MessageContentException {
        throw new IllegalStateException("Error EncryptedCSMessagePayloadParser doesn't support metod getPayload");
    }

    @Override
    public byte[] generateGetApprovalRequest(String requestId, String destinationId, String organisation, byte[] requestMessage, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        throw new IllegalStateException("Error EncryptedCSMessagePayloadParser doesn't support metod getPayload");
    }

    @Override
    public byte[] generateIsApprovedRequest(String requestId, String destinationId, String organisation, String approvalId, Credential originator, List<Object> assertions) throws MessageContentException, MessageProcessingException {
        throw new IllegalStateException("Error EncryptedCSMessagePayloadParser doesn't support metod getPayload");
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
    }

    Marshaller getMarshaller() throws JAXBException {
        Marshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    Unmarshaller getUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setSchema(this.getSchema());
        return unmarshaller;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.encryptedcsmessage.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb";
            this.jaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.jaxbContext;
    }

    private Schema getSchema() throws SAXException {
        if (this.schema == null) {
            this.schema = this.generateSchema();
        }
        return this.schema;
    }

    private Schema generateSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new EncryptionParserLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(XSD_SCHEMA_2_0_RESOURCE_LOCATION))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    public class EncryptionParserLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xenc-schema.xsd"));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(EncryptedCSMessagePayloadParser.XSD_SCHEMA_2_0_RESOURCE_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }

    public class EncryptedCSMessageXMLConverter
    implements XMLEncrypter.DecryptedXMLConverter {
        @Override
        public Document convert(Document doc) throws MessageContentException {
            NodeList nodeList = doc.getElementsByTagNameNS("http://certificateservices.org/xsd/csmessages2_0", "CSMessage");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element attribute = (Element)nodeList.item(i);
                Element parent = (Element)attribute.getParentNode();
                if (!parent.getLocalName().equals(ObjectFactory._EncryptedCSMessage_QNAME.getLocalPart()) || !parent.getNamespaceURI().equals(NAMESPACE)) continue;
                parent.getParentNode().replaceChild(attribute, parent);
            }
            return doc;
        }
    }
}

