/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.X509Data;
import org.bouncycastle.util.encoders.Base64;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.EncryptionAlgorithmScheme;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.utils.XMLSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLEncrypter {
    private static String XMLENC_NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private MessageSecurityProvider securityProvider;
    private DocumentBuilder documentBuilder;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Map<ContextMessageSecurityProvider.Context, XMLCipher> encKeyXMLCipherMap = new HashMap<ContextMessageSecurityProvider.Context, XMLCipher>();
    private Map<ContextMessageSecurityProvider.Context, XMLCipher> encDataXMLCipherMap = new HashMap<ContextMessageSecurityProvider.Context, XMLCipher>();
    private XMLCipher decChiper;
    private CertificateFactory cf;
    private Map<ContextMessageSecurityProvider.Context, KeyGenerator> dataKeyGeneratorMap = new HashMap<ContextMessageSecurityProvider.Context, KeyGenerator>();
    private Set<String> supportedEncryptionChipers = new HashSet<String>();
    private static MessageDigest generateKeyDigest;

    public XMLEncrypter(MessageSecurityProvider securityProvider, DocumentBuilder documentBuilder, Marshaller marshaller, Unmarshaller unmarshaller) throws MessageProcessingException {
        this.securityProvider = securityProvider;
        this.documentBuilder = documentBuilder;
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
        try {
            this.decChiper = XMLCipher.getInstance();
            this.cf = CertificateFactory.getInstance("X.509");
            for (EncryptionAlgorithmScheme s : EncryptionAlgorithmScheme.values()) {
                this.supportedEncryptionChipers.add(s.getDataEncryptionAlgorithmURI());
                this.supportedEncryptionChipers.add(s.getKeyEncryptionAlgorithmURI());
            }
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error instanciating XML chipers: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public Document encryptElement(JAXBElement<?> element, List<X509Certificate> receipients, boolean useKeyId) throws MessageProcessingException {
        return this.encryptElement(ContextMessageSecurityProvider.DEFAULT_CONTEXT, element, receipients, useKeyId);
    }

    public Document encryptElement(ContextMessageSecurityProvider.Context context, JAXBElement<?> element, List<X509Certificate> receipients, boolean useKeyId) throws MessageProcessingException {
        return this.encryptElement(context, element, receipients, useKeyId ? KeyInfoType.KEYNAME : KeyInfoType.X509CERTIFICATE);
    }

    public Document encryptElement(ContextMessageSecurityProvider.Context context, JAXBElement<?> element, List<X509Certificate> receipients, KeyInfoType keyInfoType) throws MessageProcessingException {
        try {
            Document doc = this.documentBuilder.newDocument();
            this.marshaller.marshal(element, (Node)doc);
            return this.encryptElement(context, doc, receipients, keyInfoType);
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when encrypting XML: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public Document encryptElement(Document doc, List<X509Certificate> receipients, boolean useKeyId) throws MessageProcessingException {
        return this.encryptElement(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, receipients, useKeyId);
    }

    public Document encryptElement(ContextMessageSecurityProvider.Context context, Document doc, List<X509Certificate> receipients, boolean useKeyId) throws MessageProcessingException {
        return this.encryptElement(context, doc, receipients, useKeyId ? KeyInfoType.KEYNAME : KeyInfoType.X509CERTIFICATE);
    }

    public Document encryptElement(ContextMessageSecurityProvider.Context context, Document doc, List<X509Certificate> receipients, KeyInfoType keyInfoType) throws MessageProcessingException {
        try {
            SecretKey dataKey = this.getDataKeyGenerator(context).generateKey();
            XMLCipher encDataXMLCipher = this.getEncDataXMLCipher(context);
            encDataXMLCipher.init(1, (Key)dataKey);
            EncryptedData encData = encDataXMLCipher.getEncryptedData();
            KeyInfo keyInfo = new KeyInfo(doc);
            for (X509Certificate receipient : receipients) {
                keyInfo.add(this.addReceipient(context, doc, dataKey, receipient, keyInfoType));
            }
            encData.setKeyInfo(keyInfo);
            Element documentElement = doc.getDocumentElement();
            doc = encDataXMLCipher.doFinal(doc, documentElement, false);
            return doc;
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when encrypting XML: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public Object decryptDocument(Document doc) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        return this.decryptDocument(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, null);
    }

    public Object decryptDocument(ContextMessageSecurityProvider.Context context, Document doc) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        return this.decryptDocument(context, doc, null);
    }

    @Deprecated
    public Object decryptDocument(Document doc, DecryptedXMLConverter converter) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        return this.decryptDocument(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, converter);
    }

    public Object decryptDocument(ContextMessageSecurityProvider.Context context, Document doc, DecryptedXMLConverter converter) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        try {
            return this.unmarshaller.unmarshal((Node)this.decryptDoc(doc, converter));
        }
        catch (Exception e) {
            if (e instanceof NoDecryptionKeyFoundException) {
                throw (NoDecryptionKeyFoundException)e;
            }
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when decrypting XML: " + e.getMessage(), e);
        }
    }

    public Document decryptDoc(Document doc, DecryptedXMLConverter converter) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        return this.decryptDoc(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, converter);
    }

    public Document decryptDoc(ContextMessageSecurityProvider.Context context, Document doc, DecryptedXMLConverter converter) throws MessageProcessingException, MessageContentException, NoDecryptionKeyFoundException {
        try {
            this.verifyKeyInfo(doc);
            NodeList nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            while (nodeList.getLength() > 0) {
                Element encryptedElement = (Element)nodeList.item(0);
                this.verifyCiphers(encryptedElement);
                Key kekKey = this.findKEK(context, encryptedElement);
                String encProvider = this.securityProvider instanceof ContextMessageSecurityProvider ? ((ContextMessageSecurityProvider)this.securityProvider).getProvider(context) : this.securityProvider.getProvider();
                if (encProvider == null || encProvider.equals("BC")) {
                    this.decChiper.init(2, null);
                    this.decChiper.setKEK(kekKey);
                } else {
                    Key encKey = this.resolveKey(encryptedElement, kekKey, encProvider);
                    this.decChiper.init(2, encKey);
                }
                doc = this.decChiper.doFinal(doc, encryptedElement);
                nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
            }
            if (converter != null) {
                doc = converter.convert(doc);
            }
            return doc;
        }
        catch (Exception e) {
            if (e instanceof NoDecryptionKeyFoundException) {
                throw (NoDecryptionKeyFoundException)e;
            }
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when decrypting XML: " + e.getMessage(), e);
        }
    }

    Key resolveKey(Element element, Key kekKey, String provider) {
        try {
            Element keyInfoElement = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
            XMLCipher cipher = XMLCipher.getProviderInstance((String)provider);
            cipher.init(4, kekKey);
            EncryptedKey ek = cipher.loadEncryptedKey(keyInfoElement);
            return cipher.decryptKey(ek, "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Document encryptProperties(Properties properties, List<X509Certificate> receipients, boolean useKeyId) throws MessageProcessingException {
        Document encDocument = null;
        Document document = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            properties.storeToXML((OutputStream)os, null, "UTF-8");
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            this.documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null && systemId.equals("http://java.sun.com/dtd/properties.dtd")) {
                        return new InputSource(this.getClass().getResourceAsStream("/properties.dtd"));
                    }
                    return null;
                }
            });
            document = this.documentBuilder.parse(is);
            encDocument = this.encryptElement(document, receipients, useKeyId);
        }
        catch (Exception e) {
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when encrypting properties: " + e.getMessage(), e);
        }
        return encDocument;
    }

    public Properties decryptProperties(Document encDocument) throws NoDecryptionKeyFoundException, MessageProcessingException, MessageContentException {
        Properties properties = null;
        try {
            Document document = this.decryptDoc(encDocument, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DOMSource src = new DOMSource(document);
            StreamResult res = new StreamResult(baos);
            Transformer trf = TransformerFactory.newInstance().newTransformer();
            trf.setOutputProperty("doctype-system", "http://java.sun.com/dtd/properties.dtd");
            trf.transform(src, res);
            ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
            properties = new Properties();
            properties.loadFromXML(is);
        }
        catch (Exception e) {
            if (e instanceof NoDecryptionKeyFoundException) {
                throw (NoDecryptionKeyFoundException)e;
            }
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Internal error occurred when decrypting properties: " + e.getMessage(), e);
        }
        return properties;
    }

    private void verifyCiphers(Element encryptedElement) throws MessageContentException {
        NodeList nodeList = encryptedElement.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element encryptionMetod = (Element)nodeList.item(0);
            String alg = encryptionMetod.getAttribute("Algorithm");
            if (this.supportedEncryptionChipers.contains(alg)) continue;
            throw new MessageContentException("Error unsupported encryption algorithm " + alg + " for encrypted XML data");
        }
    }

    private void verifyKeyInfo(Document document) throws MessageContentException {
        NodeList keyInfoList = document.getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "KeyInfo");
        if (keyInfoList.getLength() == 0) {
            throw new MessageContentException("No KeyInfo found in encrypted element");
        }
        NodeList encryptedKeyList = document.getElementsByTagNameNS(XMLENC_NAMESPACE, "EncryptedKey");
        for (int i = 0; i < keyInfoList.getLength(); ++i) {
            Node keyInfo = keyInfoList.item(i);
            NodeList keyInfoChildren = keyInfo.getChildNodes();
            for (int j = 0; j < keyInfoChildren.getLength(); ++j) {
                if (keyInfoChildren.item(j).getLocalName() == null || !keyInfoChildren.item(j).getLocalName().equals("RetrievalMethod")) continue;
                Element retrievalMethodElement = (Element)keyInfoChildren.item(j);
                if (!retrievalMethodElement.getAttribute("Type").equals("http://www.w3.org/2001/04/xmlenc#EncryptedKey")) {
                    throw new MessageContentException("RetrievalMethod not supported: " + retrievalMethodElement.getAttribute("Type"));
                }
                String uri = retrievalMethodElement.getAttribute("URI").substring(1);
                for (int k = 0; k < encryptedKeyList.getLength(); ++k) {
                    if (!((Element)encryptedKeyList.item(k)).getAttribute("Id").equals(uri)) continue;
                    keyInfo.replaceChild(encryptedKeyList.item(k), keyInfoChildren.item(j));
                }
            }
        }
    }

    private Key findKEK(ContextMessageSecurityProvider.Context context, Element encryptedElement) throws NoDecryptionKeyFoundException {
        try {
            String keyId;
            Set<String> availableKeyIds = this.securityProvider instanceof ContextMessageSecurityProvider ? ((ContextMessageSecurityProvider)this.securityProvider).getDecryptionKeyIds(context) : this.securityProvider.getDecryptionKeyIds();
            NodeList keyNameList = encryptedElement.getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "KeyName");
            for (int i = 0; i < keyNameList.getLength(); ++i) {
                Node keyName = keyNameList.item(i);
                String keyId2 = keyName.getFirstChild().getNodeValue();
                if (keyId2 == null || !availableKeyIds.contains(keyId2 = keyId2.trim())) continue;
                return this.getDecryptionKey(context, keyId2);
            }
            NodeList certList = encryptedElement.getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "X509Certificate");
            for (int i = 0; i < certList.getLength(); ++i) {
                X509Certificate cert;
                String keyId3;
                Node certNode = certList.item(i);
                String certData = certNode.getFirstChild().getNodeValue();
                if (certData == null || !availableKeyIds.contains(keyId3 = XMLEncrypter.generateKeyId((cert = (X509Certificate)this.cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)certData)))).getPublicKey()))) continue;
                return this.getDecryptionKey(context, keyId3);
            }
            NodeList rsaKeyValueList = encryptedElement.getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "RSAKeyValue");
            for (int i = 0; i < rsaKeyValueList.getLength(); ++i) {
                NodeList expValueList;
                String modValue = null;
                String expValue = null;
                Node rsaKeyNode = rsaKeyValueList.item(i);
                NodeList modValueList = ((Element)rsaKeyNode).getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "Modulus");
                if (modValueList != null && modValueList.getLength() > 0) {
                    modValue = modValueList.item(0).getFirstChild().getNodeValue();
                }
                if ((expValueList = ((Element)rsaKeyNode).getElementsByTagNameNS(XMLSigner.XMLDSIG_NAMESPACE, "Exponent")) != null && expValueList.getLength() > 0) {
                    expValue = expValueList.item(0).getFirstChild().getNodeValue();
                }
                if (modValue == null || expValue == null) continue;
                BigInteger modulus = new BigInteger(1, Base64.decode((String)modValue));
                BigInteger exponent = new BigInteger(1, Base64.decode((String)expValue));
                RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                PublicKey publicKey = factory.generatePublic(spec);
                String keyId4 = XMLEncrypter.generateKeyId(publicKey);
                if (!availableKeyIds.contains(keyId4)) continue;
                return this.getDecryptionKey(context, keyId4);
            }
            KeyInfo keyInfo = new KeyInfo(encryptedElement, encryptedElement.getBaseURI());
            PublicKey publicKey = keyInfo.getPublicKey();
            if (publicKey != null && availableKeyIds.contains(keyId = XMLEncrypter.generateKeyId(publicKey))) {
                return this.getDecryptionKey(context, keyId);
            }
        }
        catch (Exception e) {
            throw new NoDecryptionKeyFoundException("Error finding encryption public key in XML message: " + e.getMessage(), e);
        }
        throw new NoDecryptionKeyFoundException("Error couldn't find any matching decryption key to decrypt XML message");
    }

    private PrivateKey getDecryptionKey(ContextMessageSecurityProvider.Context context, String keyId) throws MessageProcessingException {
        if (this.securityProvider instanceof ContextMessageSecurityProvider) {
            return ((ContextMessageSecurityProvider)this.securityProvider).getDecryptionKey(context, keyId);
        }
        return this.securityProvider.getDecryptionKey(keyId);
    }

    public static String generateKeyId(PublicKey publicKey) throws MessageProcessingException {
        try {
            if (generateKeyDigest == null) {
                generateKeyDigest = MessageDigest.getInstance("SHA-256");
            }
            generateKeyDigest.update(publicKey.getEncoded());
            return new String(Base64.encode((byte[])generateKeyDigest.digest()));
        }
        catch (Exception e) {
            throw new MessageProcessingException(e.getMessage(), e);
        }
    }

    private EncryptedKey addReceipient(ContextMessageSecurityProvider.Context context, Document doc, Key dataKey, X509Certificate receipient, KeyInfoType keyInfoType) throws XMLEncryptionException, CertificateEncodingException, MessageProcessingException {
        XMLCipher encKeyXMLCipher = this.getEncKeyXMLCipher(context);
        encKeyXMLCipher.init(3, (Key)receipient.getPublicKey());
        KeyInfo keyInfo = new KeyInfo(doc);
        EncryptedKey retval = encKeyXMLCipher.encryptKey(doc, dataKey);
        switch (keyInfoType) {
            case KEYNAME: {
                KeyName keyName = new KeyName(doc, XMLEncrypter.generateKeyId(receipient.getPublicKey()));
                keyInfo.add(keyName);
                break;
            }
            case KEYVALUE: {
                keyInfo.add(receipient.getPublicKey());
                break;
            }
            case X509CERTIFICATE: {
                X509Data x509Data = new X509Data(doc);
                x509Data.addCertificate(receipient.getEncoded());
                keyInfo.add(x509Data);
            }
        }
        retval.setKeyInfo(keyInfo);
        return retval;
    }

    private XMLCipher getEncKeyXMLCipher(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        XMLCipher retval = this.encKeyXMLCipherMap.get(context);
        if (retval == null) {
            try {
                retval = XMLCipher.getInstance((String)this.getScheme(context).getKeyEncryptionAlgorithmURI());
                this.encKeyXMLCipherMap.put(context, retval);
            }
            catch (XMLEncryptionException e) {
                throw new MessageProcessingException("Error creating Enc Key Alg Scheme: " + e.getMessage(), e);
            }
        }
        return retval;
    }

    private XMLCipher getEncDataXMLCipher(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        XMLCipher retval = this.encDataXMLCipherMap.get(context);
        if (retval == null) {
            try {
                retval = XMLCipher.getInstance((String)this.getScheme(context).getDataEncryptionAlgorithmURI());
                this.encDataXMLCipherMap.put(context, retval);
            }
            catch (XMLEncryptionException e) {
                throw new MessageProcessingException("Error creating Enc Data Alg Scheme: " + e.getMessage(), e);
            }
        }
        return retval;
    }

    private KeyGenerator getDataKeyGenerator(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        KeyGenerator retval = this.dataKeyGeneratorMap.get(context);
        if (retval == null) {
            try {
                EncryptionAlgorithmScheme scheme = this.getScheme(context);
                switch (scheme) {
                    case RSA_OAEP_WITH_AES256: 
                    case RSA_OAEP_WITH_AES256_GCM: 
                    case RSA_PKCS1_5_WITH_AES256: 
                    case RSA_PKCS1_5_WITH_AES256_GCM: {
                        retval = KeyGenerator.getInstance("AES");
                        retval.init(256);
                        break;
                    }
                    default: {
                        throw new MessageProcessingException("Unsupported Encryption scheme " + (Object)((Object)scheme));
                    }
                }
                this.dataKeyGeneratorMap.put(context, retval);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MessageProcessingException("Error creating Encryption key generator: " + e.getMessage(), e);
            }
        }
        return retval;
    }

    private EncryptionAlgorithmScheme getScheme(ContextMessageSecurityProvider.Context context) throws MessageProcessingException {
        if (this.securityProvider instanceof ContextMessageSecurityProvider) {
            return ((ContextMessageSecurityProvider)this.securityProvider).getEncryptionAlgorithmScheme(context);
        }
        return this.securityProvider.getEncryptionAlgorithmScheme();
    }

    public static interface DecryptedXMLConverter {
        public Document convert(Document var1) throws MessageContentException;
    }

    public static enum KeyInfoType {
        KEYNAME,
        KEYVALUE,
        X509CERTIFICATE;

    }
}

