/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.assertion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.certificateservices.messages.ContextMessageSecurityProvider;
import org.certificateservices.messages.MessageContentException;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.MessageSecurityProvider;
import org.certificateservices.messages.NoDecryptionKeyFoundException;
import org.certificateservices.messages.assertion.AssertionData;
import org.certificateservices.messages.assertion.AssertionTypeEnum;
import org.certificateservices.messages.assertion.AttributeQueryData;
import org.certificateservices.messages.assertion.ResponseStatusCodes;
import org.certificateservices.messages.credmanagement.jaxb.FieldValue;
import org.certificateservices.messages.csmessages.BasePayloadParser;
import org.certificateservices.messages.csmessages.DefaultCSMessageParser;
import org.certificateservices.messages.csmessages.XSDLSInput;
import org.certificateservices.messages.csmessages.jaxb.Approver;
import org.certificateservices.messages.csmessages.jaxb.CSMessage;
import org.certificateservices.messages.saml2.BaseSAMLMessageParser;
import org.certificateservices.messages.saml2.assertion.SAMLAssertionMessageParser;
import org.certificateservices.messages.saml2.assertion.jaxb.AssertionType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeStatementType;
import org.certificateservices.messages.saml2.assertion.jaxb.AttributeType;
import org.certificateservices.messages.saml2.assertion.jaxb.EncryptedElementType;
import org.certificateservices.messages.saml2.assertion.jaxb.NameIDType;
import org.certificateservices.messages.saml2.assertion.jaxb.ObjectFactory;
import org.certificateservices.messages.saml2.assertion.jaxb.StatementAbstractType;
import org.certificateservices.messages.saml2.assertion.jaxb.SubjectType;
import org.certificateservices.messages.saml2.protocol.jaxb.AttributeQueryType;
import org.certificateservices.messages.saml2.protocol.jaxb.ResponseType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusCodeType;
import org.certificateservices.messages.saml2.protocol.jaxb.StatusType;
import org.certificateservices.messages.utils.CSMessageOrganisationLookup;
import org.certificateservices.messages.utils.DefaultSystemTime;
import org.certificateservices.messages.utils.MessageGenerateUtils;
import org.certificateservices.messages.utils.SystemTime;
import org.certificateservices.messages.utils.XMLEncrypter;
import org.certificateservices.messages.utils.XMLSigner;
import org.certificateservices.messages.utils.XMLUtils;
import org.certificateservices.messages.xenc.jaxb.EncryptedDataType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class AssertionPayloadParser
extends BasePayloadParser {
    public static String NAMESPACE = "urn:oasis:names:tc:SAML:2.0:assertion";
    public static String SAMLP_NAMESPACE = "urn:oasis:names:tc:SAML:2.0:protocol";
    public static String ANY_DESTINATION = "ANY";
    private static final String ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs-message-saml-schema-assertion-2.0.xsd";
    private static final String SAMLP_XSD_SCHEMA_2_0_RESOURCE_LOCATION = "/cs-message-saml-schema-protocol-2.0.xsd";
    private ObjectFactory of = new ObjectFactory();
    private org.certificateservices.messages.saml2.protocol.jaxb.ObjectFactory samlpOf = new org.certificateservices.messages.saml2.protocol.jaxb.ObjectFactory();
    private static final String[] SUPPORTED_ASSERTION_VERSIONS = new String[]{"2.0"};
    private static final String DEFAULT_ASSERTION_VERSION = "2.0";
    public static final String ATTRIBUTE_NAME_TYPE = "Type";
    public static final String ATTRIBUTE_NAME_DISPLAYNAME = "DisplayName";
    public static final String ATTRIBUTE_NAME_ROLES = "Roles";
    public static final String ATTRIBUTE_NAME_DEPARTMENTS = "Departments";
    public static final String ATTRIBUTE_NAME_USERDATA = "UserData";
    public static final String ATTRIBUTE_NAME_TOKENTYPE = "TokenType";
    public static final String ATTRIBUTE_NAME_DESTINATIONID = "DestinationId";
    public static final String ATTRIBUTE_NAME_APPROVALID = "ApprovalId";
    public static final String ATTRIBUTE_NAME_APPROVEDREQUESTS = "ApprovedRequests";
    public static final String ATTRIBUTE_NAME_APPROVERS = "Approvers";
    public static final String ALL_DEPARTMENTS_ATTRIBUTE_VALUE = "ALL_DEPARTMENTS";
    private SystemTime systemTime = new DefaultSystemTime();
    private XMLEncrypter xmlEncrypter;
    private XMLEncrypter userDataXmlEncrypter;
    private BaseSAMLMessageParser.EncryptedAttributeXMLConverter encryptedAttributeXMLConverter = new BaseSAMLMessageParser.EncryptedAttributeXMLConverter();
    private XMLSigner xmlSigner;
    private CertificateFactory cf;
    private Validator assertionSchemaValidator;
    private SAMLAssertionMessageParser samlAssertionMessageParser = new SAMLAssertionMessageParser();
    private BaseSAMLMessageParser.AssertionSignatureLocationFinder assertionSignatureLocationFinder = new BaseSAMLMessageParser.AssertionSignatureLocationFinder();
    private BaseSAMLMessageParser.SimpleConditionLookup simpleConditionLookup = new BaseSAMLMessageParser.SimpleConditionLookup();
    private Schema assertionSchema = null;
    private Schema userDataSchema = null;
    private JAXBContext jaxbContext = null;
    private JAXBContext userDataJaxbContext = null;

    @Override
    public void init(Properties config, MessageSecurityProvider secProv) throws MessageProcessingException {
        super.init(config, secProv);
        try {
            this.xmlEncrypter = new XMLEncrypter(secProv, this.getDocumentBuilder(), this.getAssertionMarshaller(), this.getAssertionUnmarshaller());
            this.userDataXmlEncrypter = new XMLEncrypter(secProv, this.getDocumentBuilder(), this.getUserDataMarshaller(), this.getUserDataUnmarshaller());
            this.xmlSigner = new XMLSigner(secProv, true, this.assertionSignatureLocationFinder, new CSMessageOrganisationLookup());
            this.cf = CertificateFactory.getInstance("X.509");
            this.assertionSchemaValidator = this.generateUserDataSchema().newValidator();
            this.samlAssertionMessageParser.init(secProv, null);
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error initializing JAXB in AssertionPayloadParser: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNameSpace() {
        return NAMESPACE;
    }

    @Override
    public String getJAXBPackage() {
        return "org.certificateservices.messages.saml2.assertion.jaxb";
    }

    @Override
    public InputStream getSchemaAsInputStream(String payLoadVersion) throws MessageContentException, MessageProcessingException {
        if (payLoadVersion.equals(DEFAULT_ASSERTION_VERSION)) {
            return this.getClass().getResourceAsStream(ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION);
        }
        throw new MessageContentException("Error unsupported Assertion version: " + payLoadVersion);
    }

    @Override
    protected String[] getSupportedVersions() {
        return SUPPORTED_ASSERTION_VERSIONS;
    }

    @Override
    protected String getDefaultPayloadVersion() {
        return DEFAULT_ASSERTION_VERSION;
    }

    public void schemaValidateAssertion(Object assertion) throws MessageContentException {
        try {
            this.assertionSchemaValidator.validate((Source)new JAXBSource(this.getUserDataJAXBContext(), assertion));
        }
        catch (Exception e) {
            throw new MessageContentException("Error validating Assertion agains schema: " + e.getMessage(), e);
        }
    }

    public byte[] genDistributedAuthorizationRequest(String subjectId) throws MessageContentException, MessageProcessingException {
        return this.genAttributeQuery(subjectId, ATTRIBUTE_NAME_ROLES, null);
    }

    public byte[] genUserDataRequest(String subjectId, String tokenType) throws MessageContentException, MessageProcessingException {
        return this.genAttributeQuery(subjectId, ATTRIBUTE_NAME_USERDATA, tokenType);
    }

    public byte[] genDistributedAuthorizationTicket(String inResponseTo, String issuer, Date notBefore, Date notOnOrAfter, String subjectId, List<String> roles, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        return this.genDistributedAuthorizationTicket(inResponseTo, issuer, notBefore, notOnOrAfter, subjectId, roles, null, receipients);
    }

    public byte[] genDistributedAuthorizationTicket(String inResponseTo, String issuer, Date notBefore, Date notOnOrAfter, String subjectId, List<String> roles, List<String> departments, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        try {
            ArrayList<Object> attributes = new ArrayList<Object>();
            AttributeType typeAttributeType = this.of.createAttributeType();
            typeAttributeType.setName(ATTRIBUTE_NAME_TYPE);
            typeAttributeType.getAttributeValue().add(AssertionTypeEnum.AUTHORIZATION_TICKET.getAttributeValue());
            attributes.add(typeAttributeType);
            attributes.add(this.createEncryptedAttribute(ATTRIBUTE_NAME_ROLES, roles, receipients));
            if (departments != null) {
                attributes.add(this.createEncryptedAttribute(ATTRIBUTE_NAME_DEPARTMENTS, departments, receipients));
            }
            return this.marshallAndSignAssertion(this.genSuccessfulSAMLPResponse(inResponseTo, this.generateAssertion(issuer, notBefore, notOnOrAfter, subjectId, attributes)));
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation DistributedAuthorizationTicket: " + e.getMessage(), e);
        }
    }

    public byte[] genUserDataTicket(String inResponseTo, String issuer, Date notBefore, Date notOnOrAfter, String subjectId, String displayName, String tokenType, List<FieldValue> fieldValues, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        try {
            ArrayList<Object> attributes = new ArrayList<Object>();
            AttributeType typeAttributeType = this.of.createAttributeType();
            typeAttributeType.setName(ATTRIBUTE_NAME_TYPE);
            typeAttributeType.getAttributeValue().add(AssertionTypeEnum.USER_DATA.getAttributeValue());
            attributes.add(typeAttributeType);
            if (displayName != null) {
                AttributeType displayNameAttributeType = this.of.createAttributeType();
                displayNameAttributeType.setName(ATTRIBUTE_NAME_DISPLAYNAME);
                displayNameAttributeType.getAttributeValue().add(displayName);
                attributes.add(displayNameAttributeType);
            }
            if (tokenType != null) {
                AttributeType tokenTypeAttributeType = this.of.createAttributeType();
                tokenTypeAttributeType.setName(ATTRIBUTE_NAME_TOKENTYPE);
                tokenTypeAttributeType.getAttributeValue().add(tokenType);
                attributes.add(tokenTypeAttributeType);
            }
            AttributeType userDataAttributeType = this.of.createAttributeType();
            userDataAttributeType.setName(ATTRIBUTE_NAME_USERDATA);
            for (FieldValue fieldValue : fieldValues) {
                userDataAttributeType.getAttributeValue().add(fieldValue);
            }
            JAXBElement<AttributeType> userDataAttribute = this.of.createAttribute(userDataAttributeType);
            JAXBElement encryptedData = (JAXBElement)this.getAssertionUnmarshaller().unmarshal((Node)this.userDataXmlEncrypter.encryptElement(userDataAttribute, receipients, true));
            EncryptedElementType encryptedElementType1 = this.of.createEncryptedElementType();
            encryptedElementType1.setEncryptedData((EncryptedDataType)encryptedData.getValue());
            attributes.add(encryptedElementType1);
            return this.marshallAndSignAssertion(this.genSuccessfulSAMLPResponse(inResponseTo, this.generateAssertion(issuer, notBefore, notOnOrAfter, subjectId, attributes)));
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation DistributedAuthorizationTicket: " + e.getMessage(), e);
        }
    }

    public byte[] genApprovalTicket(String issuer, Date notBefore, Date notOnOrAfter, String subjectId, String approvalId, List<String> approvalRequests, String destinationId, List<Approver> approvers, List<X509Certificate> receipients) throws MessageContentException, MessageProcessingException {
        try {
            ArrayList<Object> attributes = new ArrayList<Object>();
            AttributeType typeAttributeType = this.of.createAttributeType();
            typeAttributeType.setName(ATTRIBUTE_NAME_TYPE);
            typeAttributeType.getAttributeValue().add(AssertionTypeEnum.APPROVAL_TICKET.getAttributeValue());
            attributes.add(typeAttributeType);
            AttributeType destAttributeType = this.of.createAttributeType();
            destAttributeType.setName(ATTRIBUTE_NAME_DESTINATIONID);
            destAttributeType.getAttributeValue().add(destinationId != null ? destinationId : ANY_DESTINATION);
            attributes.add(destAttributeType);
            AttributeType approvalIdAttributeType = this.of.createAttributeType();
            approvalIdAttributeType.setName(ATTRIBUTE_NAME_APPROVALID);
            approvalIdAttributeType.getAttributeValue().add(approvalId);
            attributes.add(approvalIdAttributeType);
            AttributeType approvalRequestAttributeType = this.of.createAttributeType();
            approvalRequestAttributeType.setName(ATTRIBUTE_NAME_APPROVEDREQUESTS);
            for (String string : approvalRequests) {
                approvalRequestAttributeType.getAttributeValue().add(string);
            }
            attributes.add(approvalRequestAttributeType);
            if (approvers != null) {
                AttributeType approversAttributeType = this.of.createAttributeType();
                approversAttributeType.setName(ATTRIBUTE_NAME_APPROVERS);
                for (Approver approver : approvers) {
                    approversAttributeType.getAttributeValue().add(approver);
                }
                JAXBElement<AttributeType> jAXBElement = this.of.createAttribute(approversAttributeType);
                JAXBElement encryptedData = (JAXBElement)this.getAssertionUnmarshaller().unmarshal((Node)this.userDataXmlEncrypter.encryptElement(jAXBElement, receipients, true));
                EncryptedElementType encryptedElementType1 = this.of.createEncryptedElementType();
                encryptedElementType1.setEncryptedData((EncryptedDataType)encryptedData.getValue());
                attributes.add(encryptedElementType1);
            }
            return this.marshallAndSignAssertion(this.generateAssertion(issuer, notBefore, notOnOrAfter, subjectId, attributes));
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation DistributedAuthorizationTicket: " + e.getMessage(), e);
        }
    }

    public byte[] genFailureMessage(String inResponseTo, ResponseStatusCodes statusCode, String failureMessage) throws MessageContentException, MessageProcessingException {
        try {
            StatusCodeType statusCodeType = this.samlpOf.createStatusCodeType();
            statusCodeType.setValue(statusCode.getURIValue());
            StatusType statusType = this.samlpOf.createStatusType();
            statusType.setStatusCode(statusCodeType);
            if (failureMessage != null) {
                statusType.setStatusMessage(failureMessage);
            }
            ResponseType responseType = this.samlpOf.createResponseType();
            responseType.setID("_" + MessageGenerateUtils.generateRandomUUID());
            responseType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
            responseType.setVersion(DEFAULT_ASSERTION_VERSION);
            responseType.setInResponseTo(inResponseTo);
            responseType.setStatus(statusType);
            return this.marshall(this.samlpOf.createResponse(responseType));
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageProcessingException("Error generation DistributedAuthorizationTicket: " + e.getMessage(), e);
        }
    }

    public ResponseType parseAttributeQueryResponse(byte[] response) throws MessageContentException, MessageProcessingException {
        try {
            JAXBElement resp = (JAXBElement)this.getUserDataUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response));
            return (ResponseType)resp.getValue();
        }
        catch (Exception e) {
            throw new MessageContentException("Error parsing Attribute Query Response Data: " + e.getMessage(), e);
        }
    }

    public JAXBElement<AssertionType> parseApprovalTicket(byte[] response) throws MessageContentException, MessageProcessingException {
        try {
            this.xmlSigner.verifyEnvelopedSignature(response);
            JAXBElement resp = (JAXBElement)this.getUserDataUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(response));
            AssertionType assertionType = (AssertionType)resp.getValue();
            this.verifyAssertionConditions(assertionType);
            return this.of.createAssertion(assertionType);
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error parsing Attribute Query Response Data: " + e.getMessage(), e);
        }
    }

    public X509Certificate getCertificateFromAssertion(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        return this.samlAssertionMessageParser.getCertificateFromAssertion(assertion);
    }

    public JAXBElement<AssertionType> getAssertionFromResponseType(ResponseType responseType) {
        if (responseType.getAssertionOrEncryptedAssertion().size() == 0) {
            return null;
        }
        return this.of.createAssertion((AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0));
    }

    public List<JAXBElement<AssertionType>> getAssertionsFromCSMessage(CSMessage csmessage) throws MessageProcessingException, MessageContentException {
        ArrayList<JAXBElement<AssertionType>> retval = new ArrayList<JAXBElement<AssertionType>>();
        if (csmessage.getAssertions() != null && csmessage.getAssertions().getAny() != null) {
            for (Object next : csmessage.getAssertions().getAny()) {
                JAXBElement assertion = (JAXBElement)next;
                try {
                    this.verifyAssertionSignature((JAXBElement<AssertionType>)assertion);
                    this.verifyAssertionConditions((AssertionType)assertion.getValue());
                    retval.add((JAXBElement<AssertionType>)assertion);
                }
                catch (MessageContentException messageContentException) {}
            }
        }
        return retval;
    }

    public AssertionTypeEnum getTypeOfAssertion(JAXBElement<AssertionType> assertion) throws MessageContentException {
        try {
            for (StatementAbstractType o : ((AssertionType)assertion.getValue()).getStatementOrAuthnStatementOrAuthzDecisionStatement()) {
                if (!(o instanceof AttributeStatementType)) continue;
                for (Object attr : ((AttributeStatementType)o).getAttributeOrEncryptedAttribute()) {
                    if (!(attr instanceof AttributeType) || !((AttributeType)attr).getName().equals(ATTRIBUTE_NAME_TYPE)) continue;
                    String attributeValue = (String)((AttributeType)attr).getAttributeValue().get(0);
                    for (AssertionTypeEnum next : AssertionTypeEnum.values()) {
                        if (!next.getAttributeValue().equals(attributeValue)) continue;
                        return next;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MessageContentException("Error determining type of assertion " + e.getMessage(), e);
        }
        throw new MessageContentException("Error no Attribute type could be determined from assertion");
    }

    public AttributeQueryData parseAttributeQuery(byte[] attributeQuery) throws MessageContentException, MessageProcessingException {
        try {
            JAXBElement attrQuery = (JAXBElement)this.getUserDataUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(attributeQuery));
            AttributeQueryData aqd = new AttributeQueryData();
            aqd.parse((JAXBElement<AttributeQueryType>)attrQuery);
            return aqd;
        }
        catch (Exception e) {
            if (e instanceof MessageContentException) {
                throw (MessageContentException)e;
            }
            if (e instanceof MessageProcessingException) {
                throw (MessageProcessingException)e;
            }
            throw new MessageContentException("Error parsing Attribute Query: " + e.getMessage(), e);
        }
    }

    public List<AssertionData> parseAssertions(List<JAXBElement<AssertionType>> assertions) throws MessageContentException, MessageProcessingException {
        try {
            ArrayList<AssertionData> retval = new ArrayList<AssertionData>();
            for (JAXBElement<AssertionType> assertion : assertions) {
                AssertionTypeEnum assertionType = this.getTypeOfAssertion(assertion);
                if (assertionType == AssertionTypeEnum.AUTHORIZATION_TICKET || assertionType == AssertionTypeEnum.USER_DATA) continue;
                this.schemaValidateAssertion(assertion);
                AssertionData ad = (AssertionData)assertionType.getAssertionDataClass().getConstructor(AssertionPayloadParser.class).newInstance(this);
                ad.parse(assertion);
                retval.add(ad);
            }
            return retval;
        }
        catch (InstantiationException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
    }

    public AssertionData parseAndDecryptAssertion(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException, NoDecryptionKeyFoundException {
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getUserDataMarshaller().marshal(assertion, (Node)doc);
            JAXBElement decryptedAssertion = (JAXBElement)this.userDataXmlEncrypter.decryptDocument(doc, this.encryptedAttributeXMLConverter);
            this.schemaValidateAssertion(decryptedAssertion);
            AssertionTypeEnum assertionType = this.getTypeOfAssertion((JAXBElement<AssertionType>)decryptedAssertion);
            AssertionData retval = (AssertionData)assertionType.getAssertionDataClass().getConstructor(AssertionPayloadParser.class).newInstance(this);
            retval.parse((JAXBElement<AssertionType>)decryptedAssertion);
            return retval;
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error parsing assertion : " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new MessageProcessingException("Internal error parsing assertion: " + e.getMessage(), e);
        }
    }

    private void verifyAssertionConditions(AssertionType assertionType) throws MessageContentException {
        this.samlAssertionMessageParser.verifyAssertionConditions(assertionType, this.simpleConditionLookup);
    }

    private void verifyAssertionSignature(JAXBElement<AssertionType> assertion) throws MessageContentException, MessageProcessingException {
        DOMResult res = new DOMResult();
        try {
            this.getAssertionMarshaller().marshal(assertion, (Result)res);
        }
        catch (JAXBException e) {
            throw new MessageContentException("Error marshalling assertion: " + e.getMessage(), e);
        }
        this.xmlSigner.verifyEnvelopedSignature((Document)res.getNode(), false);
    }

    private JAXBElement<AssertionType> generateAssertion(String issuer, Date notBefore, Date notOnOrAfter, String subjectId, List<Object> attributes) throws MessageProcessingException {
        return this.samlAssertionMessageParser.generateSimpleAssertion(issuer, notBefore, notOnOrAfter, subjectId, attributes);
    }

    private JAXBElement<ResponseType> genSuccessfulSAMLPResponse(String inResponseTo, JAXBElement<AssertionType> assertion) throws MessageProcessingException {
        return this.samlAssertionMessageParser.genSuccessfulSAMLPResponse(inResponseTo, assertion);
    }

    private byte[] genAttributeQuery(String subjectId, String attributeName, String tokenType) throws MessageContentException, MessageProcessingException {
        if (subjectId == null || subjectId.trim().equals("")) {
            throw new MessageContentException("Error subject id cannot be null in attribute query");
        }
        AttributeQueryType attributeQueryType = this.samlpOf.createAttributeQueryType();
        attributeQueryType.setID("_" + MessageGenerateUtils.generateRandomUUID());
        attributeQueryType.setIssueInstant(MessageGenerateUtils.dateToXMLGregorianCalendarNoTimeZone(this.systemTime.getSystemTime()));
        attributeQueryType.setVersion(DEFAULT_ASSERTION_VERSION);
        NameIDType nameIdType = this.of.createNameIDType();
        nameIdType.setValue(subjectId);
        SubjectType subjectType = this.of.createSubjectType();
        subjectType.getContent().add(this.of.createNameID(nameIdType));
        attributeQueryType.setSubject(subjectType);
        AttributeType attributeType = this.of.createAttributeType();
        attributeType.setName(attributeName);
        attributeQueryType.getAttribute().add(attributeType);
        if (tokenType != null) {
            AttributeType tokenTypeAttributeType = this.of.createAttributeType();
            tokenTypeAttributeType.setName(ATTRIBUTE_NAME_TOKENTYPE);
            tokenTypeAttributeType.getAttributeValue().add(tokenType);
            attributeQueryType.getAttribute().add(tokenTypeAttributeType);
        }
        return this.marshall(this.samlpOf.createAttributeQuery(attributeQueryType));
    }

    private byte[] marshall(JAXBElement<?> message) throws MessageProcessingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.getAssertionMarshaller().marshal(message, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new MessageProcessingException("Error occurred marshalling assertion object: " + e.getMessage(), e);
        }
    }

    private byte[] marshallAndSignAssertion(JAXBElement<?> message) throws MessageProcessingException, MessageContentException {
        if (message == null) {
            throw new MessageProcessingException("Error marshalling assertion, message cannot be null.");
        }
        try {
            Document doc = this.getDocumentBuilder().newDocument();
            this.getAssertionMarshaller().marshal(message, (Node)doc);
            return this.xmlSigner.marshallAndSign(ContextMessageSecurityProvider.DEFAULT_CONTEXT, doc, this.assertionSignatureLocationFinder);
        }
        catch (JAXBException e) {
            throw new MessageProcessingException("Error marshalling message " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new MessageProcessingException("Error generating document builder " + e.getMessage(), e);
        }
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLUtils.createSecureDocumentBuilderFactory().newDocumentBuilder();
    }

    Marshaller getAssertionMarshaller() throws JAXBException {
        Marshaller assertionMarshaller = this.getJAXBContext().createMarshaller();
        assertionMarshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return assertionMarshaller;
    }

    Unmarshaller getAssertionUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller assertionUnmarshaller = this.getJAXBContext().createUnmarshaller();
        assertionUnmarshaller.setSchema(this.getAssertionSchema());
        return assertionUnmarshaller;
    }

    Schema getAssertionSchema() throws SAXException {
        if (this.assertionSchema == null) {
            this.assertionSchema = this.generateAssertionSchema();
        }
        return this.assertionSchema;
    }

    Marshaller getUserDataMarshaller() throws JAXBException {
        Marshaller userDataMarshaller = this.getUserDataJAXBContext().createMarshaller();
        userDataMarshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return userDataMarshaller;
    }

    Unmarshaller getUserDataUnmarshaller() throws JAXBException, SAXException {
        Unmarshaller userDataUnmarshaller = this.getUserDataJAXBContext().createUnmarshaller();
        userDataUnmarshaller.setSchema(this.getUserDataSchema());
        return userDataUnmarshaller;
    }

    Schema getUserDataSchema() throws SAXException {
        if (this.userDataSchema == null) {
            this.userDataSchema = this.generateUserDataSchema();
        }
        return this.userDataSchema;
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        if (this.jaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.saml2.protocol.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb";
            this.jaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.jaxbContext;
    }

    private JAXBContext getUserDataJAXBContext() throws JAXBException {
        if (this.userDataJaxbContext == null) {
            String jaxbClassPath = "org.certificateservices.messages.saml2.assertion.jaxb:org.certificateservices.messages.saml2.protocol.jaxb:org.certificateservices.messages.xenc.jaxb:org.certificateservices.messages.xmldsig.jaxb:org.certificateservices.messages.credmanagement.jaxb";
            this.userDataJaxbContext = JAXBContext.newInstance((String)jaxbClassPath);
        }
        return this.userDataJaxbContext;
    }

    private Schema generateAssertionSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new AssertionLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION)), new StreamSource(this.getClass().getResourceAsStream(SAMLP_XSD_SCHEMA_2_0_RESOURCE_LOCATION))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    private Schema generateUserDataSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(new AssertionLSResourceResolver());
        Source[] sources = new Source[]{new StreamSource(this.getClass().getResourceAsStream("/xmldsig-core-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream("/xenc-schema.xsd")), new StreamSource(this.getClass().getResourceAsStream(ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION)), new StreamSource(this.getClass().getResourceAsStream(SAMLP_XSD_SCHEMA_2_0_RESOURCE_LOCATION)), new StreamSource(this.getClass().getResourceAsStream("/csmessages_schema2_0.xsd")), new StreamSource(this.getClass().getResourceAsStream("/credmanagement_schema2_0.xsd"))};
        Schema schema = schemaFactory.newSchema(sources);
        return schema;
    }

    private EncryptedElementType createEncryptedAttribute(String attributeName, List<String> attributeValues, List<X509Certificate> receipients) throws JAXBException, SAXException, MessageProcessingException {
        AttributeType roleAttributeType = this.of.createAttributeType();
        roleAttributeType.setName(attributeName);
        for (String value : attributeValues) {
            roleAttributeType.getAttributeValue().add(value);
        }
        JAXBElement<AttributeType> roleAttribute = this.of.createAttribute(roleAttributeType);
        JAXBElement encryptedData = (JAXBElement)this.getAssertionUnmarshaller().unmarshal((Node)this.xmlEncrypter.encryptElement(roleAttribute, receipients, true));
        EncryptedElementType encryptedElementType1 = this.of.createEncryptedElementType();
        encryptedElementType1.setEncryptedData((EncryptedDataType)encryptedData.getValue());
        return encryptedElementType1;
    }

    public static class AssertionLSResourceResolver
    implements LSResourceResolver {
        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId != null && systemId.equals("http://www.w3.org/2001/XMLSchema.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/XMLSchema.dtd"));
                }
                if (systemId != null && systemId.equals("datatypes.dtd")) {
                    return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/datatypes.dtd"));
                }
                if (namespaceURI != null) {
                    if (namespaceURI.equals("http://www.w3.org/2000/09/xmldsig#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xmldsig-core-schema.xsd"));
                    }
                    if (namespaceURI.equals("http://www.w3.org/2001/04/xmlenc#")) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream("/xenc-schema.xsd"));
                    }
                    if (namespaceURI.equals(SAMLP_NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(AssertionPayloadParser.SAMLP_XSD_SCHEMA_2_0_RESOURCE_LOCATION));
                    }
                    if (namespaceURI.equals(NAMESPACE)) {
                        return new XSDLSInput(publicId, systemId, DefaultCSMessageParser.class.getResourceAsStream(AssertionPayloadParser.ASSERTION_XSD_SCHEMA_2_0_RESOURCE_LOCATION));
                    }
                }
            }
            catch (MessageProcessingException e) {
                throw new IllegalStateException("Error couldn't read XSD from class path: " + e.getMessage(), e);
            }
            return null;
        }
    }
}

