/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.csmessages;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.certificateservices.messages.MessageProcessingException;
import org.certificateservices.messages.assertion.AssertionPayloadParser;
import org.certificateservices.messages.authorization.AuthorizationPayloadParser;
import org.certificateservices.messages.autoenroll.AutoEnrollPayloadParser;
import org.certificateservices.messages.credmanagement.CredManagementPayloadParser;
import org.certificateservices.messages.csagent.CSAgentProtocolPayloadParser;
import org.certificateservices.messages.csexport.protocol.CSExportProtocolPayloadParser;
import org.certificateservices.messages.csmessages.PayloadParser;
import org.certificateservices.messages.encryptedcsmessage.EncryptedCSMessagePayloadParser;
import org.certificateservices.messages.keystoremgmt.KeystoreMgmtPayloadParser;
import org.certificateservices.messages.signrequest.SignRequestPayloadParser;
import org.certificateservices.messages.sysconfig.SysConfigPayloadParser;
import org.certificateservices.messages.v2x.backend.V2XBackendPayloadParser;
import org.certificateservices.messages.v2x.registration.V2XPayloadParser;

public class PayloadParserRegistry {
    private static Map<String, Class<? extends PayloadParser>> payloadParserRegistry = new HashMap<String, Class<? extends PayloadParser>>();
    private static Map<String, PayloadParser> payloadParserCache = new HashMap<String, PayloadParser>();
    private static ConfigurationCallback configurationCallback = null;

    public static void configure(ConfigurationCallback callback, boolean registerBuiltInPayloads) {
        configurationCallback = callback;
        if (registerBuiltInPayloads) {
            payloadParserRegistry.put(SysConfigPayloadParser.NAMESPACE, SysConfigPayloadParser.class);
            payloadParserRegistry.put(KeystoreMgmtPayloadParser.NAMESPACE, KeystoreMgmtPayloadParser.class);
            payloadParserRegistry.put(CredManagementPayloadParser.NAMESPACE, CredManagementPayloadParser.class);
            payloadParserRegistry.put(AssertionPayloadParser.NAMESPACE, AssertionPayloadParser.class);
            payloadParserRegistry.put(EncryptedCSMessagePayloadParser.NAMESPACE, EncryptedCSMessagePayloadParser.class);
            payloadParserRegistry.put(AuthorizationPayloadParser.NAMESPACE, AuthorizationPayloadParser.class);
            payloadParserRegistry.put(CSExportProtocolPayloadParser.NAMESPACE, CSExportProtocolPayloadParser.class);
            payloadParserRegistry.put(AutoEnrollPayloadParser.NAMESPACE, AutoEnrollPayloadParser.class);
            payloadParserRegistry.put(CSAgentProtocolPayloadParser.NAMESPACE, CSAgentProtocolPayloadParser.class);
            payloadParserRegistry.put(SignRequestPayloadParser.NAMESPACE, SignRequestPayloadParser.class);
            payloadParserRegistry.put(V2XPayloadParser.NAMESPACE, V2XPayloadParser.class);
            payloadParserRegistry.put(V2XBackendPayloadParser.NAMESPACE, V2XBackendPayloadParser.class);
        }
    }

    public static PayloadParser getParser(String namespace) throws MessageProcessingException {
        PayloadParser retval = payloadParserCache.get(namespace);
        if (retval == null) {
            Class<? extends PayloadParser> registeredClass = payloadParserRegistry.get(namespace);
            if (registeredClass == null) {
                throw new MessageProcessingException("Error no parser registered for payload with namespace: " + namespace);
            }
            try {
                retval = registeredClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MessageProcessingException("Error occurred creating a payload parser implementation: " + registeredClass + " : " + e.getMessage(), e);
            }
            configurationCallback.configurePayloadParser(namespace, retval);
            payloadParserCache.put(namespace, retval);
        } else if (configurationCallback.needReinitialization(namespace)) {
            configurationCallback.configurePayloadParser(namespace, retval);
        }
        return retval;
    }

    public static Set<String> getRegistredNamespaces() {
        return payloadParserRegistry.keySet();
    }

    public static void register(String namespace, Class<? extends PayloadParser> payLoadParser) throws MessageProcessingException {
        payloadParserRegistry.put(namespace, payLoadParser);
        if (configurationCallback != null) {
            configurationCallback.updateContext();
        }
    }

    public static void deregister(String namespace) throws MessageProcessingException {
        payloadParserCache.remove(namespace);
        payloadParserRegistry.remove(namespace);
        if (configurationCallback != null) {
            configurationCallback.updateContext();
        }
    }

    public static interface ConfigurationCallback {
        public boolean needReinitialization(String var1) throws MessageProcessingException;

        public void configurePayloadParser(String var1, PayloadParser var2) throws MessageProcessingException;

        public void updateContext() throws MessageProcessingException;
    }
}

