/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.pkimessages.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.certificateservices.messages.MessageException;
import org.certificateservices.messages.pkimessages.PKIMessageGenerateUtils;
import org.certificateservices.messages.pkimessages.PKIMessageParser;
import org.certificateservices.messages.pkimessages.jaxb.ChangeCredentialStatusRequest;
import org.certificateservices.messages.pkimessages.jaxb.Credential;
import org.certificateservices.messages.pkimessages.jaxb.CredentialRequest;
import org.certificateservices.messages.pkimessages.jaxb.GetCredentialRequest;
import org.certificateservices.messages.pkimessages.jaxb.IssueTokenCredentialsRequest;
import org.certificateservices.messages.pkimessages.jaxb.ObjectFactory;
import org.certificateservices.messages.pkimessages.jaxb.PKIMessage;
import org.certificateservices.messages.pkimessages.manager.MessageHandler;
import org.certificateservices.messages.pkimessages.manager.MessageResponseCallback;

public class DummyMessageHandler
implements MessageHandler {
    private MessageResponseCallback callback;
    private PKIMessageParser parser;
    private ObjectFactory of = new ObjectFactory();
    private long waitTime;
    public boolean revokeMessageRecieved = false;
    public static final String SETTING_WAITTIME = "dummy.waittime";
    public static byte[] base64Cert = "MIIDLTCCAhWgAwIBAgIIYmVP6xQ/t3QwDQYJKoZIhvcNAQEFBQAwJDETMBEGA1UEAwwKVGVzdCBlSURDQTENMAsGA1UECgwEVGVzdDAeFw0xMTEwMjExNDM2MzlaFw0zMTEwMjExNDM2MzlaMCQxEzARBgNVBAMMClRlc3QgZUlEQ0ExDTALBgNVBAoMBFRlc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDecUf5if2UdWbV/HIjh6U3XIymmh28wo8VVxPIbV1A8Yxz7QaMkP8vqaDwHnB1B6mHEjn4VyVogxWxI70IwPudUL+Oxkc9ZL7H7zkbi6l2d/n85PjyZvdarCwcBzpEqIRsc+Wa3bGFKBpdZjwLXjuuI4YWx+uUrQ96X+WusvFcb8C4Ru3w/K8Saf7yLJNvqmTJrgAOeKY49Jnp9V5x9dGe+xpHR3t2xhJ5HXhm+SeUsrH5fHXky7/OVKvLPOXSve+1KHpyp+eOxxgYozTh5k+viL0pP9G3AbEPp1mXtxCNzRjUgNlG0BDSIbowD5JciLkz8uYbamLzoUiz1KzZuCfXAgMBAAGjYzBhMB0GA1UdDgQWBBT6HyWgz7ykq9BxTCaULtOIjen3bDAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFPofJaDPvKSr0HFMJpQu04iN6fdsMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAbG7Y+rm82Gz1yIWVFKBfXxDee7UwX2pyKdDfvRf9lFLxXv4LKBnuM5Zlb2RPdAAe7tTMtnYDwOWs4Uniy57hYrCKU3v80u4uZoH8FNCG22APWQ+xa5UQtuq0yRf2xp2e4wjGZLQZlYUbePAZEjle0E2YIa/kOrlvy5Z62sj24yczBL9uHfWpQUefA1+R9JpbOj0WEk+rAV0xJ2knmC/RNzHWz92kL6UKUFzyBXBiBbY7TSVjO+bV/uPaTEVP7QhJk4Cahg1a7h8iMdF78ths+xMeZX1KyiL4Dpo2rocZAvdL/C8qkt/uEgOjwOTdmoRVxkFWcm+DRNa26cclBQ4tVw==".getBytes();

    @Override
    public void init(Properties config, PKIMessageParser parser, MessageResponseCallback callback) throws MessageException {
        this.parser = parser;
        this.callback = callback;
        this.waitTime = Long.parseLong(config.getProperty(SETTING_WAITTIME));
    }

    @Override
    public void connect() throws MessageException, IOException {
    }

    @Override
    public void sendMessage(String messageId, byte[] messageData) throws MessageException, IOException {
        PKIMessage response = null;
        PKIMessage request = this.parser.parseMessage(messageData);
        if (request.getPayload().getGetCredentialRequest() != null) {
            GetCredentialRequest gcr = request.getPayload().getGetCredentialRequest();
            Credential c = this.of.createCredential();
            c.setCredentialData(this.base64Decode(base64Cert));
            c.setCredentialSubType(gcr.getCredentialSubType());
            c.setCredentialType("x509certificate");
            c.setDisplayName("SomeDisplayName");
            c.setExpireDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(1L)));
            c.setIssueDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(2L)));
            c.setIssuerId("CN=SomeIssuerId");
            c.setSerialNumber("abc123");
            c.setStatus(100);
            c.setUniqueId("SomeUniqueId");
            c.setValidFromDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(3L)));
            response = this.parser.parseMessage(this.parser.genGetCredentialResponse("UNKNOWN", request, c).getResponseData());
        }
        if (request.getPayload().getIssueTokenCredentialsRequest() != null) {
            IssueTokenCredentialsRequest itr = request.getPayload().getIssueTokenCredentialsRequest();
            CredentialRequest cr = itr.getTokenRequest().getCredentialRequests().getCredentialRequest().get(0);
            Credential c = this.of.createCredential();
            c.setCredentialData(this.base64Decode(base64Cert));
            c.setCredentialSubType(cr.getCredentialSubType());
            c.setCredentialType("x509certificate");
            c.setDisplayName("SomeDisplayName");
            c.setExpireDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(1L)));
            c.setIssueDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(2L)));
            c.setIssuerId("CN=SomeIssuerId");
            c.setSerialNumber("abc123");
            c.setStatus(100);
            c.setUniqueId("SomeUniqueId");
            c.setValidFromDate(PKIMessageGenerateUtils.dateToXMLGregorianCalendar(new Date(3L)));
            ArrayList<Credential> credentials = new ArrayList<Credential>();
            credentials.add(c);
            response = this.parser.parseMessage(this.parser.genIssueTokenCredentialsResponse("UNKNOWN", request, credentials, null).getResponseData());
        }
        if (request.getPayload().getChangeCredentialStatusRequest() != null) {
            ChangeCredentialStatusRequest r = request.getPayload().getChangeCredentialStatusRequest();
            if (r.getNewCredentialStatus() != 160) {
                throw new IllegalArgumentException("Bad revoke status");
            }
            if (!r.getIssuerId().equals("CN=SomeIssuerId")) {
                throw new IllegalArgumentException("Bad issuer id");
            }
            if (!r.getReasonInformation().equals("5")) {
                throw new IllegalArgumentException("Bad reason information");
            }
            if (!r.getSerialNumber().equals("abc123")) {
                throw new IllegalArgumentException("Bad serial number");
            }
            this.revokeMessageRecieved = true;
        }
        if (response != null) {
            Thread t = new Thread(new WaitAndSend(response));
            t.start();
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Object getConnectionFactory() throws MessageException, IOException {
        throw new MessageException("Not implemented");
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    private byte[] base64Decode(byte[] data) throws MessageException {
        try {
            return Base64.decode((byte[])base64Cert);
        }
        catch (Base64DecodingException e) {
            throw new MessageException("Base64 Decoding Exception: " + e.getMessage(), e);
        }
    }

    private class WaitAndSend
    implements Runnable {
        private PKIMessage responseMessage;

        public WaitAndSend(PKIMessage responseMessage) {
            this.responseMessage = responseMessage;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(DummyMessageHandler.this.waitTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            DummyMessageHandler.this.callback.responseReceived(this.responseMessage);
        }
    }
}

