/*
 * Decompiled with CFR 0.152.
 */
package org.certificateservices.messages.utils;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.certificateservices.messages.utils.CertUtils;

public class SubjectDNMatcher {
    private AvailableDNFields availableDNFields = new AvailableDNFields();

    public boolean subjectMatch(X509Certificate cert, String subjectDNField, String subjectDNValue) {
        String certFieldValue = CertUtils.getSubjectDNField(cert, this.getIdentifier(subjectDNField));
        return certFieldValue != null && certFieldValue.equals(subjectDNValue.trim());
    }

    public boolean subjectMatch(X509Certificate cert, ASN1ObjectIdentifier subjectDNField, String subjectDNValue) {
        String certFieldValue = CertUtils.getSubjectDNField(cert, subjectDNField);
        return certFieldValue.equals(subjectDNValue.trim());
    }

    public ASN1ObjectIdentifier getIdentifier(String dnSymbol) {
        try {
            return this.availableDNFields.getIdentifier(dnSymbol.trim().toLowerCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static class AvailableDNFields
    extends BCStyle {
        public ASN1ObjectIdentifier getIdentifier(String dnSymbol) {
            return this.attrNameToOID(dnSymbol);
        }
    }
}

