/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.Cell;
import ceylon.collection.Hashtable;
import ceylon.collection.StoreIterator;
import ceylon.collection.entryStore_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.Correspondence;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.identityHash_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="An identity map implemented as a hash map stored in an \n[[Array]] of singly linked lists of [[Entry]]s. The hash \ncode of a key is defined by [[identityHash]]. Note that an \n`IdentityMap` is not a [[Map]], since it does not obey the\nsemantics of a `Map`. In particular, it may contain \nmultiple keys which are equal, as determined by the `==` \noperator.")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@SatisfiedTypes(value={"{<Key->Item>*}", "ceylon.language::Collection<Key->Item>", "ceylon.language::Correspondence<Key,Item>"})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={}), @TypeParameter(value="Item", variance=Variance.NONE, satisfies={}, caseTypes={})})
public class IdentityMap<Key, Item>
implements ReifiedType,
Iterable<Entry<? extends Key, ? extends Item>, java.lang.Object>,
ceylon.language.Collection<Entry<? extends Key, ? extends Item>>,
Correspondence<Key, Item>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Key;
    @Ignore
    private final TypeDescriptor $reified$Item;
    @Ignore
    protected final Iterable.impl<Entry<? extends Key, ? extends Item>, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Collection.impl<Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$this$;
    @Ignore
    protected final Correspondence.impl<Key, Item> $ceylon$language$Correspondence$this$;
    @Ignore
    private final Hashtable hashtable;
    @Ignore
    private Array<Cell<Entry<? extends Key, ? extends Item>>> store;
    @Ignore
    private long length;

    @Ignore
    public IdentityMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        Hashtable $ceylontmp$hashtable$0 = IdentityMap.$default$hashtable($reified$Key, $reified$Item);
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$1 = IdentityMap.$default$entries($reified$Key, $reified$Item, $ceylontmp$hashtable$0);
        this($reified$Key, $reified$Item, $ceylontmp$hashtable$0, $ceylontmp$entries$1);
    }

    @Ignore
    public IdentityMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Hashtable hashtable) {
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$2 = IdentityMap.$default$entries($reified$Key, $reified$Item, hashtable);
        this($reified$Key, $reified$Item, hashtable, $ceylontmp$entries$2);
    }

    @Ignore
    public IdentityMap($Serialization$ ignored, TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (ceylon.language.Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl($reified$Key, $reified$Item, (Correspondence)this);
        this.hashtable = null;
        this.store = null;
        this.length = 0L;
    }

    public IdentityMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable, @Name(value="entries") @Defaulted @TypeInfo(value="{<Key->Item>*}") @DocAnnotation$annotation$(description="The initial entries in the map.") @NonNull Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries) {
        Iterator entry$iterator$$17;
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.hashtable = hashtable;
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (ceylon.language.Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl($reified$Key, $reified$Item, (Correspondence)this);
        this.store = entryStore_.entryStore($reified$Key, $reified$Item, this.getHashtable$priv$().getInitialCapacity());
        this.length = 0L;
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> iterable$12 = entries;
        boolean isArray$13 = iterable$12 instanceof Array;
        boolean isTuple$14 = iterable$12 instanceof Tuple && ((Tuple)iterable$12).$getArray$() != null;
        java.lang.Object elem$11 = null;
        int i$15 = 0;
        int length$16 = isArray$13 || isTuple$14 ? (int)iterable$12.getSize() : 0;
        Iterator iterator = entry$iterator$$17 = isTuple$14 || isArray$13 ? null : iterable$12.iterator();
        while (isTuple$14 || isArray$13 ? i$15 < length$16 : !((elem$11 = entry$iterator$$17.next()) instanceof Finished)) {
            if (isArray$13 || isTuple$14) {
                elem$11 = iterable$12.getFromFirst((long)i$15++);
            }
            Entry entry = (Entry)elem$11;
            if (!this.addToStore$priv$(this.getStore$priv$(), entry)) continue;
            long $ceylontmp$op$19 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$19 + 1L);
        }
        this.checkRehash$priv$();
    }

    @Ignore
    public static <Key, Item> Hashtable $default$hashtable(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        return new Hashtable();
    }

    @Ignore
    public static <Key, Item> Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $default$entries(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Hashtable hashtable) {
        return empty_.get_();
    }

    @Ignore
    public Iterable.impl<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$this$.getDistinct();
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Ignore
    public Entry<? extends Key, ? extends Item> find(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Ignore
    public Entry<? extends Key, ? extends Item> findLast(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public Entry getFirst() {
        return (Entry)this.$ceylon$language$Iterable$this$.getFirst();
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Ignore
    public final Map<? extends Entry<? extends Key, ? extends Item>, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Ignore
    public Entry<? extends Key, ? extends Item> getFromFirst(long index) {
        return (Entry)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Entry<? extends Key, ? extends Item>>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$3 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$3);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    public Entry getLast() {
        return (Entry)this.$ceylon$language$Iterable$this$.getLast();
    }

    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Ignore
    public Entry max(Callable<? extends Comparison> comparing) {
        return (Entry)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Ignore
    public Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Ignore
    public Sequential<? extends Entry<? extends Key, ? extends Item>> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Ignore
    public Sequential<? extends Entry<? extends Key, ? extends Item>> sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Ignore
    public final <Result> Map<? extends Entry<? extends Key, ? extends Item>, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Collection.impl<? extends Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Correspondence.impl<? super Key, ? extends Item> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Ignore
    public boolean definesAny(Iterable<? extends Key, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Ignore
    public boolean definesEvery(Iterable<? extends Key, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Ignore
    public <Absent> Iterable<? extends Item, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends Key, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @Ignore
    public Category<? super Key> getKeys() {
        return this.$ceylon$language$Correspondence$this$.getKeys();
    }

    @DocAnnotation$annotation$(description="Performance-related settings for the backing array.")
    @TypeInfo(value="ceylon.collection::Hashtable")
    @NonNull
    private final Hashtable getHashtable$priv$() {
        return this.hashtable;
    }

    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Key->Item>?>")
    @NonNull
    private final Array<Cell<Entry<? extends Key, ? extends Item>>> getStore$priv$() {
        return this.store;
    }

    private final void setStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Key->Item>?>") @NonNull Array<Cell<Entry<? extends Key, ? extends Item>>> store) {
        this.store = store;
    }

    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    private final long storeIndex$priv$(@Name(value="key") @TypeInfo(value="ceylon.language::Identifiable") @NonNull java.lang.Object key, @Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Key->Item>?>") @NonNull Array<Cell<Entry<? extends Key, ? extends Item>>> store) {
        return Integer.getMagnitude((long)(identityHash_.identityHash((java.lang.Object)key) % store.getSize()));
    }

    private final boolean addToStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Key->Item>?>") @NonNull Array<Cell<Entry<? extends Key, ? extends Item>>> store, @Name(value="entry") @TypeInfo(value="Key->Item") @NonNull Entry<? extends Key, ? extends Item> entry) {
        Cell<Entry<Key, Item>> cell$4;
        Cell<Entry<Key, Item>> headBucket;
        long index = this.storeIndex$priv$(entry.getKey(), store);
        Cell<Entry<Key, Item>> bucket = headBucket = (Cell<Entry<Key, Item>>)store.getFromFirst(index);
        while ((cell$4 = bucket) != null) {
            Cell<Entry<Key, Item>> cell$5 = cell$4;
            if (((Entry)cell$5.getElement()).getKey() == entry.getKey()) {
                cell$5.setElement(entry);
                return false;
            }
            bucket = cell$5.getRest();
        }
        store.set(index, new Cell<Entry<? extends Key, ? extends Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), entry, headBucket));
        return true;
    }

    private final void checkRehash$priv$() {
        if (this.getHashtable$priv$().rehash(this.getLength$priv$(), this.getStore$priv$().getSize())) {
            Array newStore = entryStore_.entryStore(this.$reified$Key, this.$reified$Item, this.getHashtable$priv$().capacity(this.getLength$priv$()));
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                Cell cell$8;
                Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
                while ((cell$8 = bucket) != null) {
                    Cell cell$9 = cell$8;
                    bucket = cell$9.getRest();
                    long newIndex = this.storeIndex$priv$(((Entry)cell$9.getElement()).getKey(), newStore);
                    Cell newBucket = (Cell)newStore.getFromFirst(newIndex);
                    cell$9.setRest(newBucket);
                    newStore.set(newIndex, cell$9);
                }
            }
            this.setStore$priv$(newStore);
        }
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item put(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item") Item item) {
        Cell<Entry> cell$20;
        Cell<Entry> headBucket;
        long index = this.storeIndex$priv$(key, this.getStore$priv$());
        Entry entry = new Entry(this.$reified$Key, this.$reified$Item, key, item);
        Cell<Entry> bucket = headBucket = (Cell<Entry>)this.getStore$priv$().getFromFirst(index);
        while ((cell$20 = bucket) != null) {
            Cell<Entry> cell$21 = cell$20;
            if (((Entry)cell$21.getElement()).getKey() == key) {
                java.lang.Object oldItem = ((Entry)cell$21.getElement()).getItem();
                cell$21.setElement(entry);
                return (Item)oldItem;
            }
            bucket = cell$21.getRest();
        }
        this.getStore$priv$().set(index, new Cell<Entry>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), entry, headBucket));
        long $ceylontmp$op$23 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$23 + 1L);
        this.checkRehash$priv$();
        return null;
    }

    @DocAnnotation$annotation$(description="Adds a collection of key/value mappings to this map, \nmay be used to change existing mappings")
    @SharedAnnotation$annotation$
    public final void putAll(@Name(value="entries") @TypeInfo(value="{<Key->Item>*}") @NonNull Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries) {
        Iterator entry$iterator$$31;
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> iterable$26 = entries;
        boolean isArray$27 = iterable$26 instanceof Array;
        boolean isTuple$28 = iterable$26 instanceof Tuple && ((Tuple)iterable$26).$getArray$() != null;
        java.lang.Object elem$25 = null;
        int i$29 = 0;
        int length$30 = isArray$27 || isTuple$28 ? (int)iterable$26.getSize() : 0;
        Iterator iterator = entry$iterator$$31 = isTuple$28 || isArray$27 ? null : iterable$26.iterator();
        while (isTuple$28 || isArray$27 ? i$29 < length$30 : !((elem$25 = entry$iterator$$31.next()) instanceof Finished)) {
            if (isArray$27 || isTuple$28) {
                elem$25 = iterable$26.getFromFirst((long)i$29++);
            }
            Entry entry = (Entry)elem$25;
            if (!this.addToStore$priv$(this.getStore$priv$(), entry)) continue;
            long $ceylontmp$op$33 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$33 + 1L);
        }
        this.checkRehash$priv$();
    }

    @SharedAnnotation$annotation$
    public final boolean replaceEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item, @Name(value="newItem") @TypeInfo(value="Item") Item newItem) {
        Cell<Entry> cell$34;
        long index = this.storeIndex$priv$(key, this.getStore$priv$());
        Cell<Entry> bucket = (Cell<Entry>)this.getStore$priv$().getFromFirst(index);
        while ((cell$34 = bucket) != null) {
            Cell<Entry> cell$35 = cell$34;
            if (((Entry)cell$35.getElement()).getKey() == key) {
                boolean $ceylontmp$if$37 = false;
                java.lang.Object oldItem$38 = ((Entry)cell$35.getElement()).getItem();
                if (oldItem$38 != null) {
                    java.lang.Object oldItem$39 = oldItem$38;
                    if (oldItem$39.equals(item)) {
                        $ceylontmp$if$37 = true;
                    }
                } else {
                    java.lang.Object oldItem$39 = null;
                }
                if ($ceylontmp$if$37) {
                    cell$35.setElement(new Entry(this.$reified$Key, this.$reified$Item, key, newItem));
                    return true;
                }
                return false;
            }
            bucket = cell$35.getRest();
        }
        return false;
    }

    @DocAnnotation$annotation$(description="Removes a key/value mapping if it exists")
    @SharedAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item remove(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Cell cell$44;
        Cell head$42;
        long index = this.storeIndex$priv$(key, this.getStore$priv$());
        Cell head$41 = (Cell)this.getStore$priv$().getFromFirst(index);
        if (head$41 != null && ((Entry)(head$42 = head$41).getElement()).getKey() == key) {
            this.getStore$priv$().set(index, head$42.getRest());
            long $ceylontmp$op$43 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$43 - 1L);
            return (Item)((Entry)head$42.getElement()).getItem();
        }
        Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
        while ((cell$44 = bucket) != null) {
            Cell rest$48;
            Cell cell$45 = cell$44;
            Cell rest = cell$45.getRest();
            boolean $ceylontmp$if$46 = false;
            Cell rest$47 = rest;
            if (rest$47 != null) {
                rest$48 = rest$47;
                if (((Entry)rest$48.getElement()).getKey() == key) {
                    $ceylontmp$if$46 = true;
                }
            } else {
                rest$48 = null;
            }
            if ($ceylontmp$if$46) {
                cell$45.setRest(rest$48.getRest());
                long $ceylontmp$op$49 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$49 - 1L);
                return (Item)((Entry)rest$48.getElement()).getItem();
            }
            bucket = rest;
        }
        return null;
    }

    @DocAnnotation$annotation$(description="Remove the entries associated with the given keys, \nif any, from this map")
    @SharedAnnotation$annotation$
    public final void removeAll(@Name(value="keys") @TypeInfo(value="{Key*}") @NonNull Iterable<? extends Key, ? extends java.lang.Object> keys) {
        Iterator key$iterator$$57;
        Iterable<? extends Key, ? extends java.lang.Object> iterable$52 = keys;
        boolean isArray$53 = iterable$52 instanceof Array;
        boolean isTuple$54 = iterable$52 instanceof Tuple && ((Tuple)iterable$52).$getArray$() != null;
        java.lang.Object elem$51 = null;
        int i$55 = 0;
        int length$56 = isArray$53 || isTuple$54 ? (int)iterable$52.getSize() : 0;
        Iterator iterator = key$iterator$$57 = isTuple$54 || isArray$53 ? null : iterable$52.iterator();
        while (isTuple$54 || isArray$53 ? i$55 < length$56 : !((elem$51 = key$iterator$$57.next()) instanceof Finished)) {
            if (isArray$53 || isTuple$54) {
                elem$51 = iterable$52.getFromFirst((long)i$55++);
            }
            java.lang.Object key = elem$51;
            this.remove(key);
        }
    }

    @SharedAnnotation$annotation$
    public final boolean removeEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item) {
        Cell cell$64;
        Cell head$59;
        long index = this.storeIndex$priv$(key, this.getStore$priv$());
        Cell head$58 = (Cell)this.getStore$priv$().getFromFirst(index);
        if (head$58 != null && ((Entry)(head$59 = head$58).getElement()).getKey() == key) {
            boolean $ceylontmp$if$60 = false;
            java.lang.Object it$61 = ((Entry)head$59.getElement()).getItem();
            if (it$61 != null) {
                java.lang.Object it$62 = it$61;
                if (it$62.equals(item)) {
                    $ceylontmp$if$60 = true;
                }
            } else {
                java.lang.Object it$62 = null;
            }
            if ($ceylontmp$if$60) {
                this.getStore$priv$().set(index, head$59.getRest());
                long $ceylontmp$op$63 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$63 - 1L);
                return true;
            }
            return false;
        }
        Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
        while ((cell$64 = bucket) != null) {
            Cell rest$68;
            Cell cell$65 = cell$64;
            Cell rest = cell$65.getRest();
            boolean $ceylontmp$if$66 = false;
            Cell rest$67 = rest;
            if (rest$67 != null) {
                rest$68 = rest$67;
                if (((Entry)rest$68.getElement()).getKey() == key) {
                    $ceylontmp$if$66 = true;
                }
            } else {
                rest$68 = null;
            }
            if ($ceylontmp$if$66) {
                boolean $ceylontmp$if$69 = false;
                java.lang.Object it$70 = ((Entry)rest$68.getElement()).getItem();
                if (it$70 != null) {
                    java.lang.Object it$71 = it$70;
                    if (it$71.equals(item)) {
                        $ceylontmp$if$69 = true;
                    }
                } else {
                    java.lang.Object it$71 = null;
                }
                if ($ceylontmp$if$69) {
                    cell$65.setRest(rest$68.getRest());
                    long $ceylontmp$op$72 = this.getLength$priv$();
                    this.setLength$priv$($ceylontmp$op$72 - 1L);
                    return true;
                }
                return false;
            }
            bucket = rest;
        }
        return false;
    }

    @DocAnnotation$annotation$(description="Removes every key/value mapping")
    @SharedAnnotation$annotation$
    public final void clear() {
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            this.getStore$priv$().set(index++, null);
        }
        this.setLength$priv$(0L);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item get(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Cell cell$74;
        if (this.getEmpty()) {
            return null;
        }
        long index = this.storeIndex$priv$(key, this.getStore$priv$());
        Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
        while ((cell$74 = bucket) != null) {
            Cell cell$75 = cell$74;
            if (((Entry)cell$75.getElement()).getKey() == key) {
                return (Item)((Entry)cell$75.getElement()).getItem();
            }
            bucket = cell$75.getRest();
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Key->Item>")
    @NonNull
    public final Iterator<? extends Entry<? extends Key, ? extends Item>> iterator() {
        return new StoreIterator<Entry<Key, Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), this.getStore$priv$());
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Key->Item)") @NonNull Callable<? extends Boolean> selecting) {
        long count = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$77;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$77 = bucket) != null) {
                Cell cell$78 = cell$77;
                if (((Boolean)selecting.$call$(cell$78.getElement())).booleanValue()) {
                    ++count;
                }
                bucket = cell$78.getRest();
            }
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(final @Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Key->Item)") @NonNull Callable<? extends java.lang.Object> step) {
        this.getStore$priv$().each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})})})}), "Anything(Cell<Key->Item>?)", -1){

            @Ignore
            public java.lang.Object $call$(java.lang.Object $param$0) {
                Cell cell$80;
                Cell bucket;
                Cell iter = bucket = (Cell)$param$0;
                while ((cell$80 = iter) != null) {
                    Cell cell$81 = cell$80;
                    step.$call$(cell$81.getElement());
                    iter = cell$81.getRest();
                }
                return null;
            }
        });
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long hash = 17L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$83;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$83 = bucket) != null) {
                Cell cell$84 = cell$83;
                hash = (hash * 31L + identityHash_.identityHash((java.lang.Object)((Entry)cell$84.getElement()).getKey())) * 31L;
                java.lang.Object item$86 = ((Entry)cell$84.getElement()).getItem();
                if (item$86 != null) {
                    java.lang.Object item$87 = item$86;
                    hash += (long)item$87.hashCode();
                }
                bucket = cell$84.getRest();
            }
        }
        long $ceylontmp$hash$88 = hash;
        return (int)($ceylontmp$hash$88 ^ $ceylontmp$hash$88 >>> 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        IdentityMap that$91;
        block13: {
            block12: {
                java.lang.Object that$90 = that;
                if (!(that$90 instanceof IdentityMap) || !Util.isReified((java.lang.Object)that$90, (TypeDescriptor)TypeDescriptor.klass(IdentityMap.class, (TypeDescriptor[])new TypeDescriptor[]{Object.$TypeDescriptor$, Object.$TypeDescriptor$}))) break block12;
                that$91 = (IdentityMap)that$90;
                if (this.getSize() == that$91.getSize()) break block13;
            }
            return false;
        }
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            Cell cell$92;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$92 = bucket) != null) {
                Cell cell$93 = cell$92;
                Item thatItem = that$91.get(((Entry)cell$93.getElement()).getKey());
                java.lang.Object thisItem$95 = ((Entry)cell$93.getElement()).getItem();
                if (thisItem$95 != null) {
                    java.lang.Object thisItem$97 = thisItem$95;
                    Item thatItem$99 = thatItem;
                    if (thatItem$99 == null) {
                        Item thatItem$100 = thatItem$99;
                        return false;
                    }
                    Item thatItem$101 = thatItem$99;
                    if (!thatItem$101.equals(thisItem$97)) {
                        return false;
                    }
                } else if (thatItem != null) {
                    return false;
                }
                bucket = cell$93.getRest();
            }
            ++index;
        }
        return true;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentityMap<Key,Item>")
    @NonNull
    public final IdentityMap<Key, Item> $clone() {
        IdentityMap<Key, Item> clone = new IdentityMap<Key, Item>(this.$reified$Key, this.$reified$Item);
        super.setLength$priv$(this.getLength$priv$());
        super.setStore$priv$(entryStore_.entryStore(this.$reified$Key, this.$reified$Item, this.getStore$priv$().getSize()));
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell bucket$104 = (Cell)this.getStore$priv$().getFromFirst(index);
            if (bucket$104 == null) continue;
            Cell bucket$105 = bucket$104;
            super.getStore$priv$().set(index, bucket$105.$clone());
        }
        return clone;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean defines(@Name(value="key") @TypeInfo(value="Key") Key key) {
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$106;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$106 = bucket) != null) {
                Cell cell$107 = cell$106;
                if (((Entry)cell$107.getElement()).getKey() == key) {
                    return true;
                }
                bucket = cell$107.getRest();
            }
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$109;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$109 = bucket) != null) {
                java.lang.Object it$113;
                Cell cell$110 = cell$109;
                java.lang.Object it$112 = ((Entry)cell$110.getElement()).getItem();
                if (it$112 != null && (it$113 = it$112).equals(element)) {
                    return true;
                }
                bucket = cell$110.getRest();
            }
        }
        return false;
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new IdentityMap(TypeDescriptor.NothingType, TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(IdentityMap.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentityMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "hashtable")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentityMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "store")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentityMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::IdentityMap.hashtable": {
                return this.hashtable;
            }
            case "ceylon.collection::IdentityMap.store": {
                return this.store;
            }
            case "ceylon.collection::IdentityMap.length": {
                return Integer.instance((long)this.length);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::IdentityMap.hashtable": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"hashtable").invokeExact(this, (Hashtable)instance);
                    break;
                }
                case "ceylon.collection::IdentityMap.store": {
                    this.store = (Array)instance;
                    break;
                }
                case "ceylon.collection::IdentityMap.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }
}

