/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.Cell;
import ceylon.collection.Hashtable;
import ceylon.collection.StoreIterator;
import ceylon.collection.elementStore_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.identityHash_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="An identity set implemented as a hash set stored in an \n[[Array]] of singly linked lists. The hash code of an \nelement is defined by [[identityHash]]. Note that an \n`IdentitySet` is not a [[Set]], since it does not obey the \nsemantics of a `Set`. In particular, it may contain \nmultiple elements which are equal, as determined by the\n`==` operator.")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@SatisfiedTypes(value={"{Element*}", "ceylon.language::Collection<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
public class IdentitySet<Element>
implements ReifiedType,
Iterable<Element, java.lang.Object>,
ceylon.language.Collection<Element>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final Iterable.impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Collection.impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    private final Hashtable hashtable;
    @Ignore
    private Array<Cell<Element>> store;
    @Ignore
    private long length;

    @Ignore
    public IdentitySet(TypeDescriptor $reified$Element) {
        Hashtable $ceylontmp$hashtable$0 = IdentitySet.$default$hashtable($reified$Element);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$1 = IdentitySet.$default$elements($reified$Element, $ceylontmp$hashtable$0);
        this($reified$Element, $ceylontmp$hashtable$0, $ceylontmp$elements$1);
    }

    @Ignore
    public IdentitySet(TypeDescriptor $reified$Element, Hashtable hashtable) {
        Iterable<Element, java.lang.Object> $ceylontmp$elements$2 = IdentitySet.$default$elements($reified$Element, hashtable);
        this($reified$Element, hashtable, $ceylontmp$elements$2);
    }

    @Ignore
    public IdentitySet($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.hashtable = null;
        this.store = null;
        this.length = 0L;
    }

    public IdentitySet(@Ignore TypeDescriptor $reified$Element, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable, @Name(value="elements") @Defaulted @TypeInfo(value="{Element*}") @DocAnnotation$annotation$(description="The initial elements of the set.") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterator element$iterator$$17;
        this.$reified$Element = $reified$Element;
        this.hashtable = hashtable;
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.store = elementStore_.elementStore($reified$Element, this.getHashtable$priv$().getInitialCapacity());
        this.length = 0L;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$12 = elements;
        boolean isArray$13 = iterable$12 instanceof Array;
        boolean isTuple$14 = iterable$12 instanceof Tuple && ((Tuple)iterable$12).$getArray$() != null;
        java.lang.Object elem$11 = null;
        int i$15 = 0;
        int length$16 = isArray$13 || isTuple$14 ? (int)iterable$12.getSize() : 0;
        Iterator iterator = element$iterator$$17 = isTuple$14 || isArray$13 ? null : iterable$12.iterator();
        while (isTuple$14 || isArray$13 ? i$15 < length$16 : !((elem$11 = element$iterator$$17.next()) instanceof Finished)) {
            if (isArray$13 || isTuple$14) {
                elem$11 = iterable$12.getFromFirst((long)i$15++);
            }
            java.lang.Object element = elem$11;
            if (!this.addToStore$priv$(this.getStore$priv$(), element)) continue;
            long $ceylontmp$op$19 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$19 + 1L);
        }
        this.checkRehash$priv$();
    }

    @Ignore
    public static <Element> Hashtable $default$hashtable(TypeDescriptor $reified$Element) {
        return new Hashtable();
    }

    @Ignore
    public static <Element> Iterable<? extends Element, ? extends java.lang.Object> $default$elements(TypeDescriptor $reified$Element, Hashtable hashtable) {
        return empty_.get_();
    }

    @Ignore
    public Iterable.impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$this$.getDistinct();
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Ignore
    public Element find(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Ignore
    public Element findLast(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public Element getFirst() {
        return (Element)this.$ceylon$language$Iterable$this$.getFirst();
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Ignore
    public Element getFromFirst(long index) {
        return (Element)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$3 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$3);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    public Element getLast() {
        return (Element)this.$ceylon$language$Iterable$this$.getLast();
    }

    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Ignore
    public Sequential<? extends Element> sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Collection.impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @DocAnnotation$annotation$(description="Performance-related settings for the backing array.")
    @TypeInfo(value="ceylon.collection::Hashtable")
    @NonNull
    private final Hashtable getHashtable$priv$() {
        return this.hashtable;
    }

    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Element>?>")
    @NonNull
    private final Array<Cell<Element>> getStore$priv$() {
        return this.store;
    }

    private final void setStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Element>?>") @NonNull Array<Cell<Element>> store) {
        this.store = store;
    }

    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    private final long storeIndex$priv$(@Name(value="elem") @TypeInfo(value="ceylon.language::Identifiable") @NonNull java.lang.Object elem, @Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Element>?>") @NonNull Array<Cell<Element>> store) {
        return Integer.getMagnitude((long)(identityHash_.identityHash((java.lang.Object)elem) % store.getSize()));
    }

    private final boolean addToStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::Cell<Element>?>") @NonNull Array<Cell<Element>> store, @Name(value="element") @TypeInfo(value="Element") Element element) {
        Cell<Element> cell$4;
        Cell<Element> headBucket;
        long index = this.storeIndex$priv$(element, store);
        Cell<Element> bucket = headBucket = (Cell<Element>)store.getFromFirst(index);
        while ((cell$4 = bucket) != null) {
            Cell<Element> cell$5 = cell$4;
            if (cell$5.getElement() == element) {
                cell$5.setElement(element);
                return false;
            }
            bucket = cell$5.getRest();
        }
        store.set(index, new Cell<Element>(this.$reified$Element, element, headBucket));
        return true;
    }

    private final void checkRehash$priv$() {
        if (this.getHashtable$priv$().rehash(this.getLength$priv$(), this.getStore$priv$().getSize())) {
            Array newStore = elementStore_.elementStore(this.$reified$Element, this.getHashtable$priv$().capacity(this.getLength$priv$()));
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                Cell cell$8;
                Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
                while ((cell$8 = bucket) != null) {
                    Cell cell$9 = cell$8;
                    bucket = cell$9.getRest();
                    long newIndex = this.storeIndex$priv$(cell$9.getElement(), newStore);
                    Cell newBucket = (Cell)newStore.getFromFirst(newIndex);
                    cell$9.setRest(newBucket);
                    newStore.set(newIndex, cell$9);
                }
            }
            this.setStore$priv$(newStore);
        }
    }

    @SharedAnnotation$annotation$
    public final boolean add(@Name(value="element") @TypeInfo(value="Element") Element element) {
        if (this.addToStore$priv$(this.getStore$priv$(), element)) {
            long $ceylontmp$op$21 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$21 + 1L);
            this.checkRehash$priv$();
            return true;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    public final boolean addAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterator elem$iterator$$29;
        boolean ret = false;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$24 = elements;
        boolean isArray$25 = iterable$24 instanceof Array;
        boolean isTuple$26 = iterable$24 instanceof Tuple && ((Tuple)iterable$24).$getArray$() != null;
        java.lang.Object elem$23 = null;
        int i$27 = 0;
        int length$28 = isArray$25 || isTuple$26 ? (int)iterable$24.getSize() : 0;
        Iterator iterator = elem$iterator$$29 = isTuple$26 || isArray$25 ? null : iterable$24.iterator();
        while (isTuple$26 || isArray$25 ? i$27 < length$28 : !((elem$23 = elem$iterator$$29.next()) instanceof Finished)) {
            if (isArray$25 || isTuple$26) {
                elem$23 = iterable$24.getFromFirst((long)i$27++);
            }
            java.lang.Object elem = elem$23;
            ret |= this.add(elem);
        }
        if (ret) {
            this.checkRehash$priv$();
        }
        return ret;
    }

    @SharedAnnotation$annotation$
    public final boolean remove(@Name(value="element") @TypeInfo(value="Element") Element element) {
        Cell cell$35;
        Cell head$33;
        long index = this.storeIndex$priv$(element, this.getStore$priv$());
        Cell head$32 = (Cell)this.getStore$priv$().getFromFirst(index);
        if (head$32 != null && (head$33 = head$32).getElement() == element) {
            this.getStore$priv$().set(index, head$33.getRest());
            long $ceylontmp$op$34 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$34 - 1L);
            return true;
        }
        Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
        while ((cell$35 = bucket) != null) {
            Cell rest$39;
            Cell cell$36 = cell$35;
            Cell rest = cell$36.getRest();
            boolean $ceylontmp$if$37 = false;
            Cell rest$38 = rest;
            if (rest$38 != null) {
                rest$39 = rest$38;
                if (rest$39.getElement() == element) {
                    $ceylontmp$if$37 = true;
                }
            } else {
                rest$39 = null;
            }
            if ($ceylontmp$if$37) {
                cell$36.setRest(rest$39.getRest());
                long $ceylontmp$op$40 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$40 - 1L);
                return true;
            }
            bucket = rest;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    public final boolean removeAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterator element$iterator$$48;
        boolean result = false;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$43 = elements;
        boolean isArray$44 = iterable$43 instanceof Array;
        boolean isTuple$45 = iterable$43 instanceof Tuple && ((Tuple)iterable$43).$getArray$() != null;
        java.lang.Object elem$42 = null;
        int i$46 = 0;
        int length$47 = isArray$44 || isTuple$45 ? (int)iterable$43.getSize() : 0;
        Iterator iterator = element$iterator$$48 = isTuple$45 || isArray$44 ? null : iterable$43.iterator();
        while (isTuple$45 || isArray$44 ? i$46 < length$47 : !((elem$42 = element$iterator$$48.next()) instanceof Finished)) {
            java.lang.Object element;
            if (isArray$44 || isTuple$45) {
                elem$42 = iterable$43.getFromFirst((long)i$46++);
            }
            if (!this.remove(element = elem$42)) continue;
            result = true;
        }
        return result;
    }

    @DocAnnotation$annotation$(description="Removes every element")
    @SharedAnnotation$annotation$
    public final void clear() {
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            this.getStore$priv$().set(index++, null);
        }
        this.setLength$priv$(0L);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    @NonNull
    public final Iterator<? extends Element> iterator() {
        return new StoreIterator<Element>(this.$reified$Element, this.getStore$priv$());
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        long count = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$50;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$50 = bucket) != null) {
                Cell cell$51 = cell$50;
                if (((Boolean)selecting.$call$(cell$51.getElement())).booleanValue()) {
                    ++count;
                }
                bucket = cell$51.getRest();
            }
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(final @Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") @NonNull Callable<? extends java.lang.Object> step) {
        this.getStore$priv$().each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})})}), "Anything(Cell<Element>?)", -1){

            @Ignore
            public java.lang.Object $call$(java.lang.Object $param$0) {
                Cell cell$53;
                Cell bucket;
                Cell iter = bucket = (Cell)$param$0;
                while ((cell$53 = iter) != null) {
                    Cell cell$54 = cell$53;
                    step.$call$(cell$54.getElement());
                    iter = cell$54.getRest();
                }
                return null;
            }
        });
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long hash = 17L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell cell$56;
            Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
            while ((cell$56 = bucket) != null) {
                Cell cell$57 = cell$56;
                hash = hash * 31L + identityHash_.identityHash((java.lang.Object)cell$57);
                bucket = cell$57.getRest();
            }
        }
        long $ceylontmp$hash$58 = hash;
        return (int)($ceylontmp$hash$58 ^ $ceylontmp$hash$58 >>> 32);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        java.lang.Object that$60 = that;
        if (that$60 instanceof IdentitySet && Util.isReified((java.lang.Object)that$60, (TypeDescriptor)TypeDescriptor.klass(IdentitySet.class, (TypeDescriptor[])new TypeDescriptor[]{Object.$TypeDescriptor$}))) {
            IdentitySet that$61 = (IdentitySet)that$60;
            if (this.getSize() == that$61.getSize()) {
                for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                    Cell cell$62;
                    Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
                    while ((cell$62 = bucket) != null) {
                        Cell cell$63 = cell$62;
                        java.lang.Object $ceylontmp$65 = cell$63.getElement();
                        if (!that$61.contains($ceylontmp$65)) {
                            return false;
                        }
                        bucket = cell$63.getRest();
                    }
                }
                return true;
            }
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentitySet<Element>")
    @NonNull
    public final IdentitySet<Element> $clone() {
        IdentitySet<Element> clone = new IdentitySet<Element>(this.$reified$Element);
        super.setLength$priv$(this.getLength$priv$());
        super.setStore$priv$(elementStore_.elementStore(this.$reified$Element, this.getStore$priv$().getSize()));
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            Cell bucket$67 = (Cell)this.getStore$priv$().getFromFirst(index);
            if (bucket$67 == null) continue;
            Cell bucket$68 = bucket$67;
            super.getStore$priv$().set(index, bucket$68.$clone());
        }
        return clone;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        if (Util.isIdentifiable((java.lang.Object)element)) {
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                Cell cell$71;
                Cell bucket = (Cell)this.getStore$priv$().getFromFirst(index);
                while ((cell$71 = bucket) != null) {
                    Cell cell$72 = cell$71;
                    if (cell$72.getElement() == element) {
                        return true;
                    }
                    bucket = cell$72.getRest();
                }
            }
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    public <Other> boolean superset(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        java.lang.Object elem$75;
        Iterator<Other> element$iterator$$76 = set.iterator();
        while (!((elem$75 = element$iterator$$76.next()) instanceof Finished)) {
            java.lang.Object element = elem$75;
            java.lang.Object $ceylontmp$78 = element;
            if (this.contains($ceylontmp$78)) continue;
            return false;
        }
        return true;
    }

    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    public <Other> boolean subset(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        java.lang.Object elem$80;
        Iterator<Element> element$iterator$$81 = this.iterator();
        while (!((elem$80 = element$iterator$$81.next()) instanceof Finished)) {
            java.lang.Object element = elem$80;
            java.lang.Object $ceylontmp$83 = element;
            if (set.contains($ceylontmp$83)) continue;
            return false;
        }
        return true;
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentitySet<Element>")
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    @NonNull
    public final <Other> IdentitySet<Element> complement(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        java.lang.Object elem$85;
        IdentitySet<java.lang.Object> ret = new IdentitySet<java.lang.Object>(this.$reified$Element);
        Iterator<Element> elem$iterator$$86 = this.iterator();
        while (!((elem$85 = elem$iterator$$86.next()) instanceof Finished)) {
            java.lang.Object elem = elem$85;
            java.lang.Object $ceylontmp$88 = elem;
            if (set.contains($ceylontmp$88)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentitySet<Element|Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    @NonNull
    public final <Other> IdentitySet exclusiveUnion(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        java.lang.Object elem$95;
        java.lang.Object elem$90;
        IdentitySet<java.lang.Object> ret = new IdentitySet<java.lang.Object>(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        Iterator<Element> elem$iterator$$91 = this.iterator();
        while (!((elem$90 = elem$iterator$$91.next()) instanceof Finished)) {
            java.lang.Object elem = elem$90;
            java.lang.Object $ceylontmp$93 = elem;
            if (set.contains($ceylontmp$93)) continue;
            ret.add(elem);
        }
        Iterator<Other> elem$iterator$$96 = set.iterator();
        while (!((elem$95 = elem$iterator$$96.next()) instanceof Finished)) {
            java.lang.Object elem = elem$95;
            if (this.contains(elem)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentitySet<Element&Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    @NonNull
    public final <Other> IdentitySet intersection(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        java.lang.Object elem$99;
        IdentitySet<java.lang.Object> ret = new IdentitySet<java.lang.Object>(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        Iterator<Element> elem$iterator$$100 = this.iterator();
        while (!((elem$99 = elem$iterator$$100.next()) instanceof Finished)) {
            java.lang.Object elem = elem$99;
            java.lang.Object $ceylontmp$102 = elem;
            if (!set.contains($ceylontmp$102) || !Util.isReified((java.lang.Object)elem, (TypeDescriptor)$reified$Other)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::IdentitySet<Element|Other>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Identifiable"}, caseTypes={})})
    @NonNull
    public final <Other> IdentitySet union(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.collection::IdentitySet<Other>") @NonNull IdentitySet<Other> set) {
        IdentitySet<Element> ret = new IdentitySet<Element>(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        ret.addAll(this);
        ret.addAll(set);
        return ret;
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new IdentitySet(TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(IdentitySet.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentitySet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "hashtable")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentitySet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "store")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(IdentitySet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::IdentitySet.hashtable": {
                return this.hashtable;
            }
            case "ceylon.collection::IdentitySet.store": {
                return this.store;
            }
            case "ceylon.collection::IdentitySet.length": {
                return Integer.instance((long)this.length);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::IdentitySet.hashtable": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"hashtable").invokeExact(this, (Hashtable)instance);
                    break;
                }
                case "ceylon.collection::IdentitySet.store": {
                    this.store = (Array)instance;
                    break;
                }
                case "ceylon.collection::IdentitySet.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }
}

