/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.ListMutator$impl;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.IndexedCorrespondenceMutator;
import ceylon.language.Iterable;
import ceylon.language.List;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.VariableAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Protocol for mutation of a [[MutableList]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.collection::IMutableList"})})
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::List<ceylon.language::Anything>", "ceylon.language::IndexedCorrespondenceMutator<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.IN, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface ListMutator<Element>
extends List<Object>,
IndexedCorrespondenceMutator<Element> {
    @Ignore
    public ListMutator$impl<? super Element> $ceylon$collection$ListMutator$impl();

    @DocAnnotation$annotation$(description="Add the given [[element]] to the end of this list,\nincrementing the [[length|List.size]] of the list.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object add(@Name(value="element") @TypeInfo(value="Element") Element var1);

    @DocAnnotation$annotation$(description="Add the given [[elements]] to the end of this list,\nincreasing the [[length|List.size]] of the list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object addAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends Object> var1);

    @DocAnnotation$annotation$(description="Replace the existing element at the specified [[index]]\nwith the given [[element]].")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if the given index is out of bounds, that\nis, if `index<0` or if `index>lastIndex`")})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object set(@Name(value="index") long var1, @Name(value="element") @TypeInfo(value="Element") Element var3);

    @DocAnnotation$annotation$(description="Insert the given [[element]] at the specified [[index]],\nincrementing the [[length|List.size]] of the list.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if the given index is out of bounds, that\nis, if `index<0` or if `index>lastIndex+1`")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object insert(@Name(value="index") long var1, @Name(value="element") @TypeInfo(value="Element") Element var3);

    @DocAnnotation$annotation$(description="Insert the given [[elements]] at the specified \n[[index]], growing the [[length|List.size]] of the \nlist by the number of given elements.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if the given index is out of bounds, that\nis, if `index<0` or if `index>lastIndex+1`")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object insertAll(@Name(value="index") long var1, @Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends Object> var3);

    @DocAnnotation$annotation$(description="Remove the element at the specified [[index]],\nreturning the removed element, if any, or `null` if\nthere was no such element.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object delete(@Name(value="index") long var1);

    @DocAnnotation$annotation$(description="Remove all occurrences of the given [[value|element]]\nfrom this list, returning the number of elements \nremoved.\n\nTo remove just one occurrence of the given value, use\n[[removeFirst]] or [[removeLast]].")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long remove(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to remove") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Remove all occurrences of every one of the given\n[[values|elements]] from this list, returning the\nnumber of elements removed.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long removeAll(@Name(value="elements") @TypeInfo(value="{Element&ceylon.language::Object*}") @DocAnnotation$annotation$(description="The non-null values to remove") @NonNull Iterable<? extends Element, ? extends Object> var1);

    @DocAnnotation$annotation$(description="Remove the first occurrence of the given\n[[value|element]] from this list, if any, returning\n`true` if the value occurs in the list, or `false`\notherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public boolean removeFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to remove") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Remove the last occurrence of the given\n[[value|element]] from this list, if any, returning\n`true` if the value occurs in the list, or `false`\notherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public boolean removeLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to remove") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Remove all null elements from this list, leaving a list\nwith no null elements, returning the number of elements\nremoved.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long prune();

    @DocAnnotation$annotation$(description="Replace all occurrences of the given [[value|element]]\nin this list with the given [[replacement\nvalue|replacement]].\n\nTo replace just one occurrence of the given value, use\n[[replaceFirst]] or [[replaceLast]].")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public long replace(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to replace") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @DocAnnotation$annotation$(description="Replace the first occurrence of the given\n[[value|element]] in this list, if any, with the given\n[[replacement value|replacement]], returning `true` if\nthe value occurs in the list, or `false` otherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public boolean replaceFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to replace") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @DocAnnotation$annotation$(description="Replace the last occurrence of the given\n[[value|element]] in this list, if any, with the given\n[[replacement value|replacement]], returning `true` if\nthe value occurs in the list, or `false` otherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    public boolean replaceLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @DocAnnotation$annotation$(description="The non-null value to replace") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @DocAnnotation$annotation$(description="Replace all null values in this list with the given\n[[replacement value|replacement]].")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object infill(@Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var1);

    @DocAnnotation$annotation$(description="Given two indices within this list, swap the positions \nof the elements at these indices. If the two given \nindices are identical, no change is made to the list.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if either of the given indices is out of bounds")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object swap(@Name(value="i") @DocAnnotation$annotation$(description="The index of the first element.") long var1, @Name(value="j") @DocAnnotation$annotation$(description="The index of the second element.") long var3);

    @DocAnnotation$annotation$(description="Efficiently move the element of this list at the given \n[[source index|i]] to the given [[destination index|j]],\nshifting every element falling between the two given \nindices by one position to accommodate the change of\nposition. If the source index is larger than the \ndestination index, elements are shifted toward the end\nof the list. If the source index is smaller than the\ndestination index, elements are shifted toward the \nstart of the list. If the given indices are identical,\nno change is made to the list.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if either of the given indices is out of bounds")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object move(@Name(value="i") @DocAnnotation$annotation$(description="The source index of the element to move.") long var1, @Name(value="j") @DocAnnotation$annotation$(description="The destination index to which the element is\nmoved.") long var3);

    @DocAnnotation$annotation$(description="Remove every element from this list, leaving an empty\nlist with no elements.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object clear();

    @DocAnnotation$annotation$(description="Remove the element with index `0` from this list,\nreturning the removed element, or `null` if there was\nno such element.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object deleteFirst();

    @DocAnnotation$annotation$(description="Remove the element with index `size-1` from this list,\nreturning the removed element, or `null` if there was\nno such element.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object deleteLast();

    @DocAnnotation$annotation$(description="Remove every element with an index in the spanned range\n`from..to`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object deleteSpan(@Name(value="from") long var1, @Name(value="to") long var3);

    @DocAnnotation$annotation$(description="Remove every element with an index in the measured\nrange `from:length`. If `length<=0`, no elements are\nremoved.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object deleteMeasure(@Name(value="from") @VariableAnnotation$annotation$ long var1, @Name(value="length") @VariableAnnotation$annotation$ long var3);

    @DocAnnotation$annotation$(description="Truncate this list to the given [[size]] by removing\nelements from the end of the list, if necessary, \nleaving a list with at most the given size.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if `size<0`")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object truncate(@Name(value="size") long var1);

    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::ListMutator<Element>")
    @NonNull
    public ListMutator<? super Element> $clone();
}

