/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.Queue;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.OverflowException;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.emptyIterator_;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.runtime_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.smaller_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclaration;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[Queue]] implemented using a backing [[Array]] where\nthe front of the queue is the smallest element according\nto the order relation defined by [[compare]] function.\nNote that this implementation doesn't guarantee the back/last\nelement to be the largest element of the queue.\n\nThe size of the backing `Array` is called the _capacity_\nof the `PriorityQueue`. The capacity of a new instance is\nspecified by the given [[initialCapacity]]. The capacity is\nincreased when [[size]] exceeds the capacity. The new\ncapacity is the product of the needed capacity and the\ngiven [[growthFactor]].")
@AuthorsAnnotation$annotation$(authors={"Loic Rouchon"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@LocalDeclarations(value={"1it_"})
@SatisfiedTypes(value={"ceylon.language::Collection<Element>", "ceylon.collection::Queue<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
public class PriorityQueue<Element>
implements ReifiedType,
ceylon.language.Collection<Element>,
Queue<Element>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    private final Callable<? extends Comparison> compare;
    @Ignore
    protected final Collection.impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    private final double growthFactor;
    @Ignore
    private final Iterable<? extends Element, ? extends java.lang.Object> elements;
    @Ignore
    private Array<Element> array;
    @Ignore
    private long length;

    @Ignore
    public PriorityQueue(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare) {
        long $ceylontmp$initialCapacity$0 = PriorityQueue.$default$initialCapacity($reified$Element, compare);
        double $ceylontmp$growthFactor$1 = PriorityQueue.$default$growthFactor($reified$Element, compare, $ceylontmp$initialCapacity$0);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$2 = PriorityQueue.$default$elements($reified$Element, compare, $ceylontmp$initialCapacity$0, $ceylontmp$growthFactor$1);
        this($reified$Element, compare, $ceylontmp$initialCapacity$0, $ceylontmp$growthFactor$1, $ceylontmp$elements$2);
    }

    @Ignore
    public PriorityQueue(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare, long initialCapacity) {
        double $ceylontmp$growthFactor$3 = PriorityQueue.$default$growthFactor($reified$Element, compare, initialCapacity);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$4 = PriorityQueue.$default$elements($reified$Element, compare, initialCapacity, $ceylontmp$growthFactor$3);
        this($reified$Element, compare, initialCapacity, $ceylontmp$growthFactor$3, $ceylontmp$elements$4);
    }

    @Ignore
    public PriorityQueue(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare, long initialCapacity, double growthFactor) {
        Iterable<Element, java.lang.Object> $ceylontmp$elements$5 = PriorityQueue.$default$elements($reified$Element, compare, initialCapacity, growthFactor);
        this($reified$Element, compare, initialCapacity, growthFactor, $ceylontmp$elements$5);
    }

    @Jpa
    @Ignore
    protected PriorityQueue(@Ignore TypeDescriptor $reified$Element) {
        this(($Serialization$)null, $reified$Element);
    }

    @Ignore
    public PriorityQueue($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.compare = null;
        this.growthFactor = 0.0;
        this.elements = null;
        this.array = null;
        this.length = 0L;
    }

    public PriorityQueue(@Ignore TypeDescriptor $reified$Element, @Name(value="compare") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element, Element)") @NonNull Callable<? extends Comparison> compare, @Name(value="initialCapacity") @Defaulted @DocAnnotation$annotation$(description="The initial size of the backing array.") long initialCapacity, @Name(value="growthFactor") @Defaulted @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.") double growthFactor, @Name(value="elements") @Defaulted @TypeInfo(value="{Element*}") @DocAnnotation$annotation$(description="The initial elements of the queue.") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        this.$reified$Element = $reified$Element;
        this.compare = compare;
        this.growthFactor = growthFactor;
        this.elements = elements;
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        if (this.haveKnownSize$priv$(this.getElements$priv$())) {
            this.setLength$priv$(this.getElements$priv$().getSize());
            this.setArray$priv$(this.store$priv$(this.getLength$priv$() > initialCapacity ? this.getLength$priv$() : initialCapacity));
        } else {
            this.setLength$priv$(0L);
            this.setArray$priv$(this.store$priv$(initialCapacity));
        }
        this.addInitialElements$priv$();
    }

    @DocAnnotation$annotation$(description="A comparator function used to order elements.")
    @TypeInfo(value="ceylon.language::Comparison")
    @NonNull
    private final Comparison compare$priv$(@Name(value="x") @TypeInfo(value="Element") Element x, @Name(value="y") @TypeInfo(value="Element") Element y) {
        return (Comparison)this.compare.$call$(x, y);
    }

    @Ignore
    public static <Element> long $default$initialCapacity(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare) {
        return 0L;
    }

    @Ignore
    public static <Element> double $default$growthFactor(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare, long initialCapacity) {
        return 1.5;
    }

    @Ignore
    public static <Element> Iterable<? extends Element, ? extends java.lang.Object> $default$elements(TypeDescriptor $reified$Element, Callable<? extends Comparison> compare, long initialCapacity, double growthFactor) {
        return empty_.get_();
    }

    @Ignore
    public Collection.impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean contains(java.lang.Object element) {
        return this.$ceylon$language$Collection$this$.contains(element);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Iterable.impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Ignore
    public long count(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.count(selecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$this$.getDistinct();
    }

    @Ignore
    public java.lang.Object each(Callable<? extends java.lang.Object> step) {
        return this.$ceylon$language$Iterable$this$.each(step);
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Ignore
    public Element find(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Ignore
    public Element findLast(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public Element getFirst() {
        return (Element)this.$ceylon$language$Iterable$this$.getFirst();
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Ignore
    public Element getFromFirst(long index) {
        return (Element)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$6 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$6);
    }

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Ignore
    public Sequential<? extends Element> sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.")
    private final double getGrowthFactor$priv$() {
        return this.growthFactor;
    }

    @DocAnnotation$annotation$(description="The initial elements of the queue.")
    @TypeInfo(value="{Element*}")
    @NonNull
    private final Iterable<? extends Element, ? extends java.lang.Object> getElements$priv$() {
        return this.elements;
    }

    @TypeInfo(value="ceylon.language::Array<Element?>")
    @NonNull
    private final Array<Element> store$priv$(@Name(value="capacity") long capacity) {
        return new Array(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element}), Array.ofSize_, capacity, null);
    }

    private final boolean haveKnownSize$priv$(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterable<? extends Element, ? extends java.lang.Object> $ceylontmp$7 = elements;
        return $ceylontmp$7 instanceof ceylon.language.Collection && Util.isReified($ceylontmp$7, (TypeDescriptor)TypeDescriptor.klass(ceylon.language.Collection.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}));
    }

    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<Element?>")
    @NonNull
    private final Array<Element> getArray$priv$() {
        return this.array;
    }

    private final void setArray$priv$(@Name(value="array") @TypeInfo(value="ceylon.language::Array<Element?>") @NonNull Array<Element> array) {
        this.array = array;
    }

    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    private final void grow$priv$(@Name(value="increment") long increment) {
        long maxArraySize;
        long neededCapacity = this.getLength$priv$() + increment;
        if (neededCapacity > (maxArraySize = runtime_.get_().getMaxArraySize())) {
            throw new OverflowException();
        }
        if (neededCapacity > this.getArray$priv$().getSize()) {
            long grownCapacity = Float.getInteger((double)((double)neededCapacity * this.getGrowthFactor$priv$()));
            long newCapacity = grownCapacity < neededCapacity || grownCapacity > maxArraySize ? maxArraySize : grownCapacity;
            Array<Element> grown = this.store$priv$(newCapacity);
            this.getArray$priv$().copyTo(grown);
            this.setArray$priv$(grown);
        }
    }

    private final void add$priv$(@Name(value="element") @TypeInfo(value="Element") Element element) {
        this.grow$priv$(1L);
        this.getArray$priv$().set(this.getLength$priv$(), element);
        long $ceylontmp$op$11 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$11 + 1L);
    }

    @DocAnnotation$annotation$(description="Consider i1 as index in an array whose first element index is 1\nConsider i0 as index in an array whose first element index is 0\ni1 = i0 + 1\nparent index is defined by parent1 = i1 / 2\nparent0 =  (i0 + 1) / 2 - 1")
    private final long parent$priv$(@Name(value="index") long index) {
        return (index + 1L) / 2L - 1L;
    }

    @DocAnnotation$annotation$(description="Consider i1 as index in an array whose first element index is 1\nConsider i0 as index in an array whose first element index is 0\ni1 = i0 + 1\nleft child index is defined by left1 = i1 * 2\nleft0 =  i0 * 2 + 1")
    private final long leftChild$priv$(@Name(value="index") long index) {
        return index * 2L + 1L;
    }

    @DocAnnotation$annotation$(description="Consider i1 as index in an array whose first element index is 1\nConsider i0 as index in an array whose first element index is 0\ni1 = i0 + 1\nright child index is defined by right1 = i1 * 2 + 1\nright0 =  i0 * 2 + 2")
    private final long rightChild$priv$(@Name(value="index") long index) {
        return index * 2L + 2L;
    }

    @TypeInfo(value="Element")
    private final Element elt$priv$(@Name(value="index") long index) {
        java.lang.Object element$12 = null;
        element$12 = this.getArray$priv$().getFromFirst(index);
        if (element$12 == null) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists element = array[index]");
        }
        java.lang.Object element$13 = element$12;
        return (Element)element$13;
    }

    @TypeInfo(value="ceylon.language::Comparison")
    @NonNull
    private final Comparison compareIndexes$priv$(@Name(value="first") long first, @Name(value="second") long second) {
        return this.compare$priv$(this.elt$priv$(first), this.elt$priv$(second));
    }

    private final void swap$priv$(@Name(value="first") long first, @Name(value="second") long second) {
        java.lang.Object element = this.getArray$priv$().getFromFirst(first);
        this.getArray$priv$().set(first, this.getArray$priv$().getFromFirst(second));
        this.getArray$priv$().set(second, element);
    }

    private final void bubbleUp$priv$(@Name(value="index") long index) {
        if (index == 0L) {
            return;
        }
        long parentIndex = this.parent$priv$(index);
        if (this.compareIndexes$priv$(index, parentIndex).equals(smaller_.get_())) {
            this.swap$priv$(index, parentIndex);
            this.bubbleUp$priv$(parentIndex);
        }
    }

    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    private final Integer minChildrenIndex$priv$(@Name(value="index") long index) {
        long leftChildIndex = this.leftChild$priv$(index);
        if (leftChildIndex >= this.getLength$priv$()) {
            return null;
        }
        long rightChildIndex = this.rightChild$priv$(index);
        if (rightChildIndex >= this.getLength$priv$()) {
            return Integer.instance((long)leftChildIndex);
        }
        Comparison comparison = this.compareIndexes$priv$(leftChildIndex, rightChildIndex);
        if (comparison.equals(smaller_.get_())) {
            return Integer.instance((long)leftChildIndex);
        }
        return Integer.instance((long)rightChildIndex);
    }

    private final void bubbleDown$priv$(@Name(value="index") long index) {
        long childIndex$21;
        Integer childIndex$20 = this.minChildrenIndex$priv$(index);
        if (childIndex$20 != null && this.compareIndexes$priv$(childIndex$21 = childIndex$20.longValue(), index).equals(smaller_.get_())) {
            this.swap$priv$(index, childIndex$21);
            this.bubbleDown$priv$(childIndex$21);
        }
    }

    private final void addInitialElements$priv$() {
        block8: {
            if (this.haveKnownSize$priv$(this.getElements$priv$())) {
                Iterator element$iterator$$38;
                long index = 0L;
                Iterable<Element, java.lang.Object> iterable$33 = this.getElements$priv$();
                boolean isArray$34 = iterable$33 instanceof Array;
                boolean isTuple$35 = iterable$33 instanceof Tuple && ((Tuple)iterable$33).$getArray$() != null;
                java.lang.Object elem$32 = null;
                int i$36 = 0;
                int length$37 = isArray$34 || isTuple$35 ? (int)iterable$33.getSize() : 0;
                Iterator iterator = element$iterator$$38 = isTuple$35 || isArray$34 ? null : iterable$33.iterator();
                while (isTuple$35 || isArray$34 ? i$36 < length$37 : !((elem$32 = element$iterator$$38.next()) instanceof Finished)) {
                    if (isArray$34 || isTuple$35) {
                        elem$32 = iterable$33.getFromFirst((long)i$36++);
                    }
                    java.lang.Object element = elem$32;
                    this.getArray$priv$().set(index++, element);
                }
            } else {
                Iterator element$iterator$$30;
                Iterable<Element, java.lang.Object> iterable$25 = this.getElements$priv$();
                boolean isArray$26 = iterable$25 instanceof Array;
                boolean isTuple$27 = iterable$25 instanceof Tuple && ((Tuple)iterable$25).$getArray$() != null;
                java.lang.Object elem$24 = null;
                int i$28 = 0;
                int length$29 = isArray$26 || isTuple$27 ? (int)iterable$25.getSize() : 0;
                Iterator iterator = element$iterator$$30 = isTuple$27 || isArray$26 ? null : iterable$25.iterator();
                while (isTuple$27 || isArray$26 ? i$28 < length$29 : !((elem$24 = element$iterator$$30.next()) instanceof Finished)) {
                    if (isArray$26 || isTuple$27) {
                        elem$24 = iterable$25.getFromFirst((long)i$28++);
                    }
                    java.lang.Object element = elem$24;
                    this.add$priv$(element);
                }
            }
            if (this.getLength$priv$() <= 0L) break block8;
            long $ceylontmp$first$42 = this.parent$priv$(this.getLength$priv$() - 1L);
            long $ceylontmp$last$43 = 0L;
            boolean $ceylontmp$increasing$44 = Integer.offset((long)0L, (long)$ceylontmp$first$42) >= 0L;
            long $ceylontmp$incr$45 = $ceylontmp$increasing$44 ? 1L : -1L;
            long index$48 = $ceylontmp$first$42;
            long $ceylontmp$element$47 = $ceylontmp$first$42;
            boolean $ceylontmp$f$46 = false;
            do {
                if ($ceylontmp$f$46) {
                    $ceylontmp$element$47 += $ceylontmp$incr$45;
                }
                $ceylontmp$f$46 = true;
                long index = index$48 = $ceylontmp$element$47;
                this.bubbleDown$priv$(index);
            } while (!$ceylontmp$increasing$44 ? index$48 - 0L != 0L : index$48 - 0L != 0L);
        }
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @Override
    @DocAnnotation$annotation$(description="The smallest element (regarding the order\nrelation defined by [[compare]]) of the\nqueue, or `null` if the queue is empty.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getFront() {
        return (Element)this.getArray$priv$().getFromFirst(0L);
    }

    @DocAnnotation$annotation$(description="The element currently at the end of the\nqueue, or `null` if the queue is empty.\nThis is not necessarily the largest element\n(regarding the order relation defined by\n[[compare]]) of the queue.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getLast() {
        return (Element)this.getArray$priv$().getFromFirst(this.getLength$priv$() - 1L);
    }

    @Override
    @DocAnnotation$annotation$(description="The element currently at the end of the\nqueue, or `null` if the queue is empty.\nThis is not necessarily the largest element\n(regarding the order relation defined by\n[[compare]]) of the queue.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getBack() {
        return this.getLast();
    }

    @Override
    @DocAnnotation$annotation$(description="Add a new element to the queue.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object offer(@Name(value="element") @TypeInfo(value="Element") Element element) {
        this.add$priv$(element);
        this.bubbleUp$priv$(this.getLength$priv$() - 1L);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DocAnnotation$annotation$(description="Remove and return the smallest element\n([[front]] element) from this queue")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element accept() {
        Element element = this.getFront();
        if (this.getLength$priv$() > 0L) {
            void var2_2;
            this.getArray$priv$().set(0L, this.getLast());
            Array<Element> array = this.getArray$priv$();
            long $ceylontmp$op$50 = this.getLength$priv$() - 1L;
            this.setLength$priv$($ceylontmp$op$50);
            array.set((long)var2_2, null);
            this.bubbleDown$priv$(0L);
        }
        return element;
    }

    @DocAnnotation$annotation$(description="An iterator for the elements belonging to this queue.\nElements returned by this iterator are not ordered")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    @NonNull
    public final Iterator<? extends Element> iterator() {
        if (this.getLength$priv$() > 0L) {
            @Ceylon(major=8, minor=1)
            @Name(value="it")
            @LocalDeclaration(qualifier="1")
            @com.redhat.ceylon.compiler.java.metadata.Object
            @SatisfiedTypes(value={"ceylon.language::Iterator<Element>"})
            final class It_
            implements java.io.Serializable,
            ReifiedType,
            Iterator<Element> {
                @Ignore
                private long index = 0L;

                It_() {
                }

                @VariableAnnotation$annotation$
                private final long getIndex$priv$() {
                    return this.index;
                }

                private final void setIndex$priv$(@Name(value="index") long index) {
                    this.index = index;
                }

                @SharedAnnotation$annotation$
                @ActualAnnotation$annotation$
                @TypeInfo(value="Element|ceylon.language::Finished", erased=true)
                @NonNull
                public final java.lang.Object next() {
                    long rhs$58;
                    java.lang.Object element = PriorityQueue.this.getArray$priv$().getFromFirst(this.getIndex$priv$());
                    java.lang.Object element$53 = element;
                    if (element$53 != null) {
                        java.lang.Object element$54 = element$53;
                        long $ceylontmp$op$55 = this.getIndex$priv$();
                        this.setIndex$priv$($ceylontmp$op$55 + 1L);
                        return element$54;
                    }
                    java.lang.Object element$56 = element;
                    long lhs$57 = this.getIndex$priv$();
                    if (lhs$57 != (rhs$58 = PriorityQueue.this.getLength$priv$())) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "index == length" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$57), (java.lang.Object)Integer.instance((long)rhs$58)));
                    }
                    return finished_.get_();
                }

                @Ignore
                public TypeDescriptor $getType$() {
                    return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(PriorityQueue.class, (TypeDescriptor[])new TypeDescriptor[]{PriorityQueue.this.$reified$Element}), (TypeDescriptor)TypeDescriptor.functionOrValue((String)"iterator", (TypeDescriptor[])new TypeDescriptor[0])), (TypeDescriptor)TypeDescriptor.klass(It_.class, (TypeDescriptor[])new TypeDescriptor[0]));
                }
            }
            It_ it = new It_();
            return it;
        }
        return emptyIterator_.get_();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::PriorityQueue<Element>")
    @NonNull
    public final PriorityQueue<Element> $clone() {
        Callable<? extends Comparison> arg$59$0 = this.compare;
        long arg$59$1 = this.getLength$priv$();
        double arg$59$2 = this.getGrowthFactor$priv$();
        TypeDescriptor arg$59$reified$0 = this.$reified$Element;
        Iterable<Element, java.lang.Object> arg$59$3 = PriorityQueue.$default$elements(arg$59$reified$0, arg$59$0, arg$59$1, arg$59$2);
        PriorityQueue<Element> clone = new PriorityQueue<Element>(arg$59$reified$0, arg$59$0, arg$59$1, arg$59$2, arg$59$3);
        super.setLength$priv$(this.getLength$priv$());
        super.setArray$priv$(this.getArray$priv$().$clone());
        return clone;
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(PriorityQueue.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(PriorityQueue.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "growthFactor")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(PriorityQueue.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "elements")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(PriorityQueue.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "array")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(PriorityQueue.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::PriorityQueue.growthFactor": {
                return Float.instance((double)this.growthFactor);
            }
            case "ceylon.collection::PriorityQueue.elements": {
                return this.elements;
            }
            case "ceylon.collection::PriorityQueue.array": {
                return this.array;
            }
            case "ceylon.collection::PriorityQueue.length": {
                return Integer.instance((long)this.length);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::PriorityQueue.growthFactor": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"growthFactor").invokeExact(this, ((Float)instance).doubleValue());
                    break;
                }
                case "ceylon.collection::PriorityQueue.elements": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"elements").invokeExact(this, (Iterable)instance);
                    break;
                }
                case "ceylon.collection::PriorityQueue.array": {
                    this.array = (Array)instance;
                    break;
                }
                case "ceylon.collection::PriorityQueue.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }
}

