/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.Map;
import ceylon.language.Ranged;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[Map]] that maintains its entries in sorted order.")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::Map<Key,Item>", "ceylon.language::Ranged<Key,Key->Item,ceylon.collection::SortedMap<Key,Item>>"})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="Item", variance=Variance.OUT, satisfies={}, caseTypes={})})
public interface SortedMap<Key, Item>
extends Map<Key, Item>,
Ranged<Key, Entry<? extends Key, ? extends Item>, SortedMap<Key, ? extends Item>> {
    @DocAnnotation$annotation$(description="The entries with keys larger than or equal to the given \n[[key]], sorted by key in ascending order. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted map.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends Object> higherEntries(@Name(value="key") @TypeInfo(value="Key") Key var1);

    @DocAnnotation$annotation$(description="The entries with keys smaller than or equal to the \ngiven [[key]], sorted by key _in descending order_. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted map.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends Object> lowerEntries(@Name(value="key") @TypeInfo(value="Key") Key var1);

    @DocAnnotation$annotation$(description="The entries with keys larger than or equal to the first \ngiven [[value|from]], and smaller than or equal to the \nsecond given [[value|to]], sorted in ascending order. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted map.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends Object> ascendingEntries(@Name(value="from") @TypeInfo(value="Key") Key var1, @Name(value="to") @TypeInfo(value="Key") Key var2);

    @DocAnnotation$annotation$(description="The entries with keys smaller than or equal to the \nfirst given [[value|from]], and larger than or equal to \nthe second given [[value|to]], sorted _in descending \norder_. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted map.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends Object> descendingEntries(@Name(value="from") @TypeInfo(value="Key") Key var1, @Name(value="to") @TypeInfo(value="Key") Key var2);
}

