/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.Ranged;
import ceylon.language.Set;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[Set]] that maintains its entries in sorted order.")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::Set<Element>", "ceylon.language::Ranged<Element,Element,ceylon.collection::SortedSet<Element>>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
public interface SortedSet<Element>
extends Set<Element>,
Ranged<Element, Element, SortedSet<Element>> {
    @DocAnnotation$annotation$(description="The elements larger than or equal to the given \n[[value|element]], sorted in ascending order. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted set.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{Element*}")
    @NonNull
    public Iterable<? extends Element, ? extends Object> higherElements(@Name(value="element") @TypeInfo(value="Element") Element var1);

    @DocAnnotation$annotation$(description="The elements smaller than or equal to the given \n[[value|element]], sorted _in descending order_. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted set.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{Element*}")
    @NonNull
    public Iterable<? extends Element, ? extends Object> lowerElements(@Name(value="element") @TypeInfo(value="Element") Element var1);

    @DocAnnotation$annotation$(description="The elements larger than or equal to the first given \n[[value|from]], and smaller than or equal to the second\ngiven [[value|to]], sorted in ascending order. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted set.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{Element*}")
    @NonNull
    public Iterable<? extends Element, ? extends Object> ascendingElements(@Name(value="from") @TypeInfo(value="Element") Element var1, @Name(value="to") @TypeInfo(value="Element") Element var2);

    @DocAnnotation$annotation$(description="The elements smaller than or equal to the first given \n[[value|from]], and larger than or equal to the second\ngiven [[value|to]], sorted _in descending order_. \n\nThis is a lazy operation, returning a view of the \nunderlying sorted set.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="{Element*}")
    @NonNull
    public Iterable<? extends Element, ? extends Object> descendingElements(@Name(value="from") @TypeInfo(value="Element") Element var1, @Name(value="to") @TypeInfo(value="Element") Element var2);
}

