/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.MapMutator$impl;
import ceylon.collection.MutableMap;
import ceylon.collection.SortedMap;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.Correspondence;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Ranged;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.StringBuilder;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.equal_;
import ceylon.language.finished_;
import ceylon.language.forKey_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.larger_;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.smaller_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.language.EnumeratedTypeError;
import com.redhat.ceylon.compiler.java.language.SerializationProxy;
import com.redhat.ceylon.compiler.java.language.UninitializedMethodError;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Container;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclaration;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Member;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Object;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[MutableMap]] implemented using a red/black tree.\nEntries in the map are maintained in a sorted order, from\nsmallest to largest key, as determined by the given\n[[comparator function|compare]].")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.collection::FnaturalOrderTreeMap"})})
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@Members(value={@Member(klass=ReverseNodeIterator.class), @Member(klass=NodeIterator.class), @Member(klass=removeCases_.class), @Member(klass=Node.class)})
@LocalDeclarations(value={"1anonymous_0_", "1anonymous_1_"})
@SatisfiedTypes(value={"ceylon.collection::MutableMap<Key,Item>", "ceylon.collection::SortedMap<Key,Item>", "ceylon.language::Ranged<Key,Key->Item,ceylon.collection::TreeMap<Key,Item>>"})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="Item", variance=Variance.NONE, satisfies={}, caseTypes={})})
@Class(constructors=true)
public class TreeMap<Key, Item>
implements ReifiedType,
MutableMap<Key, Item>,
SortedMap<Key, Item>,
Ranged<Key, Entry<? extends Key, ? extends Item>, TreeMap<Key, Item>>,
Serializable,
com.redhat.ceylon.compiler.java.runtime.serialization.Serializable {
    @Ignore
    private final TypeDescriptor $reified$Key;
    @Ignore
    private final TypeDescriptor $reified$Item;
    @Ignore
    protected final Map.impl<Key, Item> $ceylon$language$Map$this$;
    @Ignore
    protected final Collection.impl<Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Entry<? extends Key, ? extends Item>, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Correspondence.impl<java.lang.Object, Item> $ceylon$language$Correspondence$this$;
    @Ignore
    protected final MapMutator$impl<Key, Item> $ceylon$collection$MapMutator$this$;
    private Callable<? extends Comparison> compare$priv$;
    @Ignore
    private Node root;
    private transient removeCases_ removeCases;
    @Ignore
    public static final copy_ copy_ = null;

    @Ignore
    public TreeMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Callable<? extends Comparison> compare$param$) {
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$313 = TreeMap.TreeMap$entries($reified$Key, $reified$Item, compare$param$);
        this($reified$Key, $reified$Item, compare$param$, $ceylontmp$entries$313);
    }

    @Jpa
    @Ignore
    protected TreeMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item) {
        this(($Serialization$)null, $reified$Key, $reified$Item);
    }

    @Ignore
    public TreeMap($Serialization$ ignored, TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(ceylon.language.Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.compare$priv$ = null;
        this.root = null;
        this.removeCases = null;
    }

    @Ignore
    public Map.impl<? extends Key, ? extends Item> $ceylon$language$Map$impl() {
        return this.$ceylon$language$Map$this$;
    }

    @Override
    @Ignore
    public Map<? extends Key, ? extends Item> getCoalescedMap() {
        return this.$ceylon$language$Map$this$.getCoalescedMap();
    }

    @Override
    @Ignore
    public final <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Map$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public <Default> Map defaultNullItems(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Map$this$.defaultNullItems($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Map$this$.getDistinct();
    }

    @Override
    @Ignore
    public Map<? extends Key, ? extends Item> filterKeys(Callable<? extends Boolean> filtering) {
        return this.$ceylon$language$Map$this$.filterKeys(filtering);
    }

    @Override
    @Ignore
    public Map<? extends Item, ? extends Sequence<? extends Key>> inverse() {
        return this.$ceylon$language$Map$this$.inverse();
    }

    @Override
    @Ignore
    public Collection<? extends Item> getItems() {
        return this.$ceylon$language$Map$this$.getItems();
    }

    @Override
    @Ignore
    public Collection<? extends Key> getKeys() {
        return this.$ceylon$language$Map$this$.getKeys();
    }

    @Override
    @Ignore
    public <Result> Map<? extends Key, ? extends Result> mapItems(TypeDescriptor $reified$Result, Callable<? extends Result> mapping) {
        return this.$ceylon$language$Map$this$.mapItems($reified$Result, mapping);
    }

    @Override
    @Ignore
    public <OtherKey, OtherItem> Map patch(TypeDescriptor $reified$OtherKey, TypeDescriptor $reified$OtherItem, Map<? extends OtherKey, ? extends OtherItem> other) {
        return this.$ceylon$language$Map$this$.patch($reified$OtherKey, $reified$OtherItem, other);
    }

    @Ignore
    public Collection.impl<? extends Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public Iterable.impl<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Ignore
    public long count(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.count(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public java.lang.Object each(Callable<? extends java.lang.Object> step) {
        return this.$ceylon$language$Iterable$this$.each(step);
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> find(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> findLast(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Entry<? extends Key, ? extends Item>, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> getFromFirst(long index) {
        return (Entry)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Entry<? extends Key, ? extends Item>>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$0 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$0);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Entry max(Callable<? extends Comparison> comparing) {
        return (Entry)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Entry<? extends Key, ? extends Item>> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public Sequential<? extends Entry<? extends Key, ? extends Item>> sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Entry<? extends Key, ? extends Item>, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Correspondence.impl<? super java.lang.Object, ? extends Item> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Ignore
    public boolean definesAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Ignore
    public boolean definesEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Item, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends java.lang.Object, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @Override
    @Ignore
    public MapMutator$impl<? super Key, ? super Item> $ceylon$collection$MapMutator$impl() {
        return this.$ceylon$collection$MapMutator$this$;
    }

    @Override
    @Ignore
    public java.lang.Object putAll(Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries) {
        return this.$ceylon$collection$MapMutator$this$.putAll(entries);
    }

    @Override
    @Ignore
    public java.lang.Object removeAll(Iterable<? extends Key, ? extends java.lang.Object> keys) {
        return this.$ceylon$collection$MapMutator$this$.removeAll(keys);
    }

    @DocAnnotation$annotation$(description="A comparator function used to sort the entries.")
    @TypeInfo(value="ceylon.language::Comparison")
    @NonNull
    private final Comparison compare$priv$(@Name(value="x") @TypeInfo(value="Key") Key x, @Name(value="y") @TypeInfo(value="Key") Key y) {
        if (this.compare$priv$ == null) {
            throw new UninitializedMethodError();
        }
        return (Comparison)this.compare$priv$.$call$(x, y);
    }

    @DocAnnotation$annotation$(description="The root node of the tree.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
    @Nullable
    private final Node getRoot$priv$() {
        return this.root;
    }

    private final void setRoot$priv$(@Name(value="root") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node root) {
        this.root = root;
    }

    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node")
    @NonNull
    private final Node copyNode$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node) {
        Node right$41;
        java.lang.Object arg$36$0 = node.getKey();
        java.lang.Object arg$36$1 = node.getItem();
        boolean arg$36$2 = node.getRed();
        Node copy = new Node(arg$36$0, arg$36$1, arg$36$2);
        Node left$38 = node.getLeft();
        if (left$38 != null) {
            Node left$39 = left$38;
            Node leftCopy = this.copyNode$priv$(left$39);
            leftCopy.setParent(copy);
            copy.setLeft(leftCopy);
        }
        if ((right$41 = node.getRight()) != null) {
            Node right$42 = right$41;
            Node rightCopy = this.copyNode$priv$(right$42);
            rightCopy.setParent(copy);
            copy.setRight(rightCopy);
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRed$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node node) {
        void var2_5;
        boolean $ceylontmp$ifResult$43;
        Node node$45 = node;
        if (node$45 != null) {
            Node node$47 = node$45;
            $ceylontmp$ifResult$43 = node$47.getRed();
        } else {
            Node node$46 = node$45;
            $ceylontmp$ifResult$43 = false;
        }
        return (boolean)var2_5;
    }

    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
    @Nullable
    private final Node lookup$priv$(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Node n$48;
        Node node = this.getRoot$priv$();
        while ((n$48 = node) != null) {
            Node n$49 = n$48;
            Comparison sel$50 = this.compare$priv$(key, n$49.getKey());
            if (sel$50 == equal_.get_()) {
                return n$49;
            }
            if (sel$50 == smaller_.get_()) {
                node = n$49.getLeft();
                continue;
            }
            if (sel$50 == larger_.get_()) {
                node = n$49.getRight();
                continue;
            }
            throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
        }
        return node;
    }

    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
    @Nullable
    private final Node ceiling$priv$(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Node n$51;
        Node node = this.getRoot$priv$();
        while ((n$51 = node) != null) {
            Node n$52 = n$51;
            Comparison sel$53 = this.compare$priv$(key, n$52.getKey());
            if (sel$53 == equal_.get_()) {
                return n$52;
            }
            if (sel$53 == smaller_.get_()) {
                if (n$52.getLeft() == null) {
                    Node parent$56;
                    Node child = n$52;
                    while ((parent$56 = child.getParent()) != null) {
                        Node parent$57 = parent$56;
                        if (!child.getOnLeft()) break;
                        child = parent$57;
                    }
                    return child.getParent();
                }
                node = n$52.getLeft();
                continue;
            }
            if (sel$53 == larger_.get_()) {
                if (n$52.getRight() == null) {
                    return n$52;
                }
                node = n$52.getRight();
                continue;
            }
            throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
        }
        return node;
    }

    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
    @Nullable
    private final Node floor$priv$(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Node n$58;
        Node node = this.getRoot$priv$();
        while ((n$58 = node) != null) {
            Node n$59 = n$58;
            Comparison sel$60 = this.compare$priv$(key, n$59.getKey());
            if (sel$60 == equal_.get_()) {
                return n$59;
            }
            if (sel$60 == smaller_.get_()) {
                if (n$59.getLeft() == null) {
                    return n$59;
                }
                node = n$59.getLeft();
                continue;
            }
            if (sel$60 == larger_.get_()) {
                if (n$59.getRight() == null) {
                    Node parent$62;
                    Node child = n$59;
                    while ((parent$62 = child.getParent()) != null) {
                        Node parent$63 = parent$62;
                        if (!child.getOnRight()) break;
                        child = parent$63;
                    }
                    return child.getParent();
                }
                node = n$59.getRight();
                continue;
            }
            throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void replaceNode$priv$(@Name(value="old") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node old, @Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node node) {
        Node parent$66 = old.getParent();
        if (parent$66 != null) {
            Node parent$67 = parent$66;
            if (old.getOnLeft()) {
                parent$67.setLeft(node);
            } else {
                if (!old.getOnRight()) throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
                parent$67.setRight(node);
            }
        } else {
            this.setRoot$priv$(node);
        }
        Node node$71 = node;
        if (node$71 == null) return;
        Node node$72 = node$71;
        node$72.setParent(old.getParent());
    }

    private final void setLeftChild$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="left") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node left) {
        node.setLeft(left);
        Node left$74 = left;
        if (left$74 != null) {
            Node left$75 = left$74;
            left$75.setParent(node);
        }
    }

    private final void setRightChild$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="right") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node right) {
        node.setRight(right);
        Node right$77 = right;
        if (right$77 != null) {
            Node right$78 = right$77;
            right$78.setParent(node);
        }
    }

    private final void rotateLeft$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node) {
        Node right$79 = null;
        right$79 = node.getRight();
        if (right$79 == null) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists right = node.right");
        }
        Node right$80 = right$79;
        this.replaceNode$priv$(node, right$80);
        Node rightLeft = right$80.getLeft();
        this.setRightChild$priv$(node, rightLeft);
        this.setLeftChild$priv$(right$80, node);
    }

    private final void rotateRight$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node) {
        Node left$81 = null;
        left$81 = node.getLeft();
        if (left$81 == null) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists left = node.left");
        }
        Node left$82 = left$81;
        Node leftRight = left$82.getRight();
        this.replaceNode$priv$(node, left$82);
        this.setLeftChild$priv$(node, leftRight);
        this.setRightChild$priv$(left$82, node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void balanceAfterInsert$priv$(@Name(value="newNode") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node newNode) {
        Node parent$84 = newNode.getParent();
        if (parent$84 != null) {
            Node uncle$89;
            Node parent$85 = parent$84;
            if (!this.isRed$priv$(parent$85)) return;
            boolean $ceylontmp$if$87 = false;
            Node uncle$88 = newNode.getUncle();
            if (uncle$88 != null) {
                uncle$89 = uncle$88;
                if (this.isRed$priv$(uncle$89)) {
                    $ceylontmp$if$87 = true;
                }
            } else {
                uncle$89 = null;
            }
            if ($ceylontmp$if$87) {
                parent$85.setRed(false);
                uncle$89.setRed(false);
                Node grandparent$90 = null;
                grandparent$90 = newNode.getGrandparent();
                if (grandparent$90 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists grandparent=newNode.grandparent");
                }
                Node grandparent$91 = grandparent$90;
                grandparent$91.setRed(true);
                this.balanceAfterInsert$priv$(grandparent$91);
                return;
            } else {
                Node adjustedNode;
                if (newNode.getOnRight() && parent$85.getOnLeft()) {
                    this.rotateLeft$priv$(parent$85);
                    Node nl$96 = null;
                    nl$96 = newNode.getLeft();
                    if (nl$96 == null) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists nl=newNode.left");
                    }
                    Node nl$97 = nl$96;
                    adjustedNode = nl$97;
                } else if (newNode.getOnLeft() && parent$85.getOnRight()) {
                    this.rotateRight$priv$(parent$85);
                    Node nr$94 = null;
                    nr$94 = newNode.getRight();
                    if (nr$94 == null) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists nr=newNode.right");
                    }
                    Node nr$95 = nr$94;
                    adjustedNode = nr$95;
                } else {
                    adjustedNode = newNode;
                }
                Node adjustedParent$98 = null;
                adjustedParent$98 = adjustedNode.getParent();
                if (adjustedParent$98 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists adjustedParent=adjustedNode.parent");
                }
                Node adjustedParent$99 = adjustedParent$98;
                adjustedParent$99.setRed(false);
                Node grandparent$100 = null;
                grandparent$100 = adjustedNode.getGrandparent();
                if (grandparent$100 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists grandparent=adjustedNode.grandparent");
                }
                Node grandparent$101 = grandparent$100;
                grandparent$101.setRed(true);
                if (adjustedNode.getOnLeft() && adjustedParent$99.getOnLeft()) {
                    this.rotateRight$priv$(grandparent$101);
                    return;
                } else {
                    if (!adjustedNode.getOnRight() || !adjustedParent$99.getOnRight()) throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
                    this.rotateLeft$priv$(grandparent$101);
                }
            }
            return;
        } else {
            newNode.setRed(false);
        }
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item put(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item") Item item) {
        Node newNode;
        block7: {
            block6: {
                Node node;
                block4: {
                    Comparison sel$107;
                    block5: {
                        Node root$106;
                        newNode = new Node(key, item, true);
                        Node root$105 = this.getRoot$priv$();
                        if (root$105 == null) break block6;
                        node = root$106 = root$105;
                        while (true) {
                            Node nl$110;
                            if ((sel$107 = this.compare$priv$(key, node.getKey())) == larger_.get_()) {
                                Node nr$112 = node.getRight();
                                if (nr$112 != null) {
                                    Node nr$113;
                                    node = nr$113 = nr$112;
                                    continue;
                                }
                                node.setRight(newNode);
                                break block4;
                            }
                            if (sel$107 != smaller_.get_()) break block5;
                            Node nl$109 = node.getLeft();
                            if (nl$109 == null) break;
                            node = nl$110 = nl$109;
                        }
                        node.setLeft(newNode);
                        break block4;
                    }
                    if (sel$107 == equal_.get_()) {
                        java.lang.Object oldItem = node.getItem();
                        node.setItem(item);
                        return oldItem;
                    }
                    throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
                }
                newNode.setParent(node);
                break block7;
            }
            this.setRoot$priv$(newNode);
        }
        this.balanceAfterInsert$priv$(newNode);
        return null;
    }

    @DocAnnotation$annotation$(description="Possible cases when removing nodes with at most one child")
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.removeCases")
    @NonNull
    private final removeCases_ getRemoveCases$priv$() {
        if (this.removeCases == null) {
            this.removeCases = new removeCases_();
        }
        return this.removeCases;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item remove(@Name(value="key") @TypeInfo(value="Key") Key key) {
        Node result$168 = this.lookup$priv$(key);
        if (result$168 != null) {
            Node node;
            Node left$172;
            Node result$169 = result$168;
            boolean $ceylontmp$if$170 = false;
            Node left$171 = result$169.getLeft();
            if (left$171 != null) {
                left$172 = left$171;
                Node right$173 = result$169.getRight();
                if (right$173 != null) {
                    Node right$174 = right$173;
                    $ceylontmp$if$170 = true;
                } else {
                    java.lang.Object right$174 = null;
                }
            } else {
                left$172 = null;
                java.lang.Object right$174 = null;
            }
            if ($ceylontmp$if$170) {
                node = left$172.getRightmostChild();
                result$169.setKey(node.getKey());
                result$169.setItem(node.getItem());
            } else {
                node = result$169;
            }
            this.getRemoveCases$priv$().removeNodeWithAtMostOneChild(node);
            return result$169.getItem();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item) {
        Node result$177;
        boolean $ceylontmp$if$175 = false;
        Node result$176 = this.lookup$priv$(key);
        if (result$176 != null) {
            result$177 = result$176;
            java.lang.Object it$178 = result$177.getItem();
            if (it$178 != null) {
                java.lang.Object it$179 = it$178;
                if (it$179.equals(item)) {
                    $ceylontmp$if$175 = true;
                }
            } else {
                java.lang.Object it$179 = null;
            }
        } else {
            result$177 = null;
            java.lang.Object it$179 = null;
        }
        if ($ceylontmp$if$175) {
            Node node;
            Node left$182;
            boolean $ceylontmp$if$180 = false;
            Node left$181 = result$177.getLeft();
            if (left$181 != null) {
                left$182 = left$181;
                Node right$183 = result$177.getRight();
                if (right$183 != null) {
                    Node right$184 = right$183;
                    $ceylontmp$if$180 = true;
                } else {
                    java.lang.Object right$184 = null;
                }
            } else {
                left$182 = null;
                java.lang.Object right$184 = null;
            }
            if ($ceylontmp$if$180) {
                node = left$182.getRightmostChild();
                result$177.setKey(node.getKey());
                result$177.setItem(node.getItem());
            } else {
                node = result$177;
            }
            this.getRemoveCases$priv$().removeNodeWithAtMostOneChild(node);
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item, @Name(value="newItem") @TypeInfo(value="Item") Item newItem) {
        block11: {
            Node root$186 = this.getRoot$priv$();
            if (root$186 != null) {
                Comparison sel$188;
                Node root$187;
                Node node = root$187 = root$186;
                while (true) {
                    if ((sel$188 = this.compare$priv$(key, node.getKey())) == larger_.get_()) {
                        Node nr$196 = node.getRight();
                        if (nr$196 != null) {
                            Node nr$197;
                            node = nr$197 = nr$196;
                            continue;
                        }
                    } else {
                        if (sel$188 != smaller_.get_()) break;
                        Node nl$193 = node.getLeft();
                        if (nl$193 != null) {
                            Node nl$194;
                            node = nl$194 = nl$193;
                            continue;
                        }
                    }
                    break block11;
                    break;
                }
                if (sel$188 == equal_.get_()) {
                    boolean $ceylontmp$if$189 = false;
                    java.lang.Object oldItem$190 = node.getItem();
                    if (oldItem$190 != null) {
                        java.lang.Object oldItem$191 = oldItem$190;
                        if (oldItem$191.equals(item)) {
                            $ceylontmp$if$189 = true;
                        }
                    } else {
                        java.lang.Object oldItem$191 = null;
                    }
                    if ($ceylontmp$if$189) {
                        node.setItem(newItem);
                        return true;
                    }
                    return false;
                }
                throw new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive");
            }
        }
        return false;
    }

    @Ignore
    private final Node $default$NodeIterator$current() {
        Node safe$198 = this.getRoot$priv$();
        return safe$198 != null ? safe$198.getLeftmostChild() : null;
    }

    @Ignore
    private final Node $default$ReverseNodeIterator$current() {
        Node safe$217 = this.getRoot$priv$();
        return safe$217 != null ? safe$217.getRightmostChild() : null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Key->Item>")
    @NonNull
    public final Iterator<? extends Entry<? extends Key, ? extends Item>> iterator() {
        return new NodeIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item get(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        void var2_7;
        java.lang.Object $ceylontmp$ifResult$236;
        java.lang.Object key$238 = key;
        if (Util.isReified((java.lang.Object)key$238, (TypeDescriptor)this.$reified$Key)) {
            java.lang.Object key$240 = key$238;
            Node safe$241 = this.lookup$priv$(key$240);
            $ceylontmp$ifResult$236 = safe$241 != null ? (java.lang.Object)safe$241.getItem() : null;
        } else {
            final java.lang.Object $instance$ = key;
            Entry safe$239 = (Entry)this.find(forKey_.forKey((TypeDescriptor)ceylon.language.Object.$TypeDescriptor$, (TypeDescriptor)Boolean.$TypeDescriptor$, (Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{ceylon.language.Object.$TypeDescriptor$}), "Boolean(Object)", -1){

                @Ignore
                public Boolean $call$(java.lang.Object $param$0) {
                    java.lang.Object $ceylontmp$that = $param$0;
                    return Boolean.instance((boolean)$instance$.equals($ceylontmp$that));
                }
            }));
            $ceylontmp$ifResult$236 = safe$239 != null ? safe$239.getItem() : null;
        }
        return var2_7;
    }

    /*
     * WARNING - void declaration
     */
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean defines(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        void var2_5;
        boolean $ceylontmp$ifResult$242;
        java.lang.Object key$244 = key;
        if (Util.isReified((java.lang.Object)key$244, (TypeDescriptor)this.$reified$Key)) {
            java.lang.Object key$245 = key$244;
            $ceylontmp$ifResult$242 = this.lookup$priv$(key$245) != null;
        } else {
            final java.lang.Object $instance$ = key;
            $ceylontmp$ifResult$242 = this.getKeys().any((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{ceylon.language.Object.$TypeDescriptor$}), "Boolean(Object)", -1){

                @Ignore
                public Boolean $call$(java.lang.Object $param$0) {
                    java.lang.Object $ceylontmp$that = $param$0;
                    return Boolean.instance((boolean)$instance$.equals($ceylontmp$that));
                }
            });
        }
        return (boolean)var2_5;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item|Default", erased=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @Nullable
    public final <Default> java.lang.Object getOrDefault(@Ignore TypeDescriptor $reified$Default, @Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key, @Name(value="default") @TypeInfo(value="Default") Default $default) {
        java.lang.Object $ceylontmp$ifResult$248;
        java.lang.Object key$247 = key;
        if (Util.isReified((java.lang.Object)key$247, (TypeDescriptor)this.$reified$Key)) {
            java.lang.Object $ceylontmp$ifResult$253;
            java.lang.Object key$252 = key$247;
            Node node$255 = this.lookup$priv$(key$252);
            if (node$255 != null) {
                Node node$256 = node$255;
                $ceylontmp$ifResult$253 = node$256.getItem();
            } else {
                $ceylontmp$ifResult$253 = $default;
            }
            return $ceylontmp$ifResult$253;
        }
        final java.lang.Object $instance$ = key;
        Entry node$250 = (Entry)this.find(forKey_.forKey((TypeDescriptor)ceylon.language.Object.$TypeDescriptor$, (TypeDescriptor)Boolean.$TypeDescriptor$, (Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{ceylon.language.Object.$TypeDescriptor$}), "Boolean(Object)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                java.lang.Object $ceylontmp$that = $param$0;
                return Boolean.instance((boolean)$instance$.equals($ceylontmp$that));
            }
        }));
        if (node$250 != null) {
            Entry node$251 = node$250;
            $ceylontmp$ifResult$248 = node$251.getItem();
        } else {
            $ceylontmp$ifResult$248 = $default;
        }
        return $ceylontmp$ifResult$248;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> higherEntries(final @Name(value="key") @TypeInfo(value="Key") Key key) {
        @Ceylon(major=8, minor=1)
        @Name(value="anonymous#0")
        @LocalDeclaration(qualifier="1")
        @Object
        @SatisfiedTypes(value={"{<Key->Item>*}"})
        class Anonymous_0_
        implements Serializable,
        ReifiedType,
        Iterable<Entry<? extends Key, ? extends Item>, java.lang.Object> {
            @Ignore
            protected final Iterable.impl<Entry<? extends Key, ? extends Item>, java.lang.Object> $ceylon$language$Iterable$this$;
            @Ignore
            protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;

            Anonymous_0_() {
                this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
                this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
            }

            @SharedAnnotation$annotation$
            @ActualAnnotation$annotation$
            @TypeInfo(value="ceylon.language::Iterator<Key->Item>")
            @NonNull
            public final Iterator<? extends Entry<? extends Key, ? extends Item>> iterator() {
                return new NodeIterator(TreeMap.this, TreeMap.this.floor$priv$(key));
            }

            @Ignore
            public Iterable.impl<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
                return this.$ceylon$language$Iterable$this$;
            }

            @Ignore
            public boolean any(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.any(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> by(long step) {
                return this.$ceylon$language$Iterable$this$.by(step);
            }

            @Ignore
            public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
                return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCoalesced() {
                return this.$ceylon$language$Iterable$this$.getCoalesced();
            }

            @Ignore
            public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
            }

            @Ignore
            public boolean contains(java.lang.Object element) {
                return this.$ceylon$language$Iterable$this$.contains(element);
            }

            @Ignore
            public long count(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.count(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCycled() {
                return this.$ceylon$language$Iterable$this$.getCycled();
            }

            @Ignore
            public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
                return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getDistinct() {
                return this.$ceylon$language$Iterable$this$.getDistinct();
            }

            @Ignore
            public java.lang.Object each(Callable<? extends java.lang.Object> step) {
                return this.$ceylon$language$Iterable$this$.each(step);
            }

            @Ignore
            public boolean getEmpty() {
                return this.$ceylon$language$Iterable$this$.getEmpty();
            }

            @Ignore
            public boolean every(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.every(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getExceptLast() {
                return this.$ceylon$language$Iterable$this$.getExceptLast();
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.filter(selecting);
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> find(Callable<? extends Boolean> selecting) {
                return (Entry)this.$ceylon$language$Iterable$this$.find(selecting);
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> findLast(Callable<? extends Boolean> selecting) {
                return (Entry)this.$ceylon$language$Iterable$this$.findLast(selecting);
            }

            @Ignore
            public Entry getFirst() {
                return (Entry)this.$ceylon$language$Iterable$this$.getFirst();
            }

            @Ignore
            public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
                return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
            }

            @Ignore
            public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
                return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
            }

            @Ignore
            public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
                return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
            }

            @Ignore
            public final Map<? extends Entry<? extends Key, ? extends Item>, ? extends Integer> frequencies() {
                return this.$ceylon$language$Iterable$this$.frequencies();
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> getFromFirst(long index) {
                return (Entry)this.$ceylon$language$Iterable$this$.getFromFirst(index);
            }

            @Ignore
            public final <Group> Map<? extends Group, ? extends Sequence<? extends Entry<? extends Key, ? extends Item>>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
                return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getIndexed() {
                return this.$ceylon$language$Iterable$this$.getIndexed();
            }

            @Ignore
            public java.lang.Object indexes() {
                return this.$ceylon$language$Iterable$this$.indexes();
            }

            @Ignore
            public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
                return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
            }

            @Ignore
            public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
                long $ceylontmp$step$257 = this.interpose$step($reified$Other, element);
                return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$257);
            }

            @Ignore
            public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
                return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
            }

            @Ignore
            private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
                return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
            }

            @Ignore
            public Entry getLast() {
                return (Entry)this.$ceylon$language$Iterable$this$.getLast();
            }

            @Ignore
            public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locate(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locate(selecting);
            }

            @Ignore
            public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locateLast(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locateLast(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locations(selecting);
            }

            @Ignore
            public boolean longerThan(long length) {
                return this.$ceylon$language$Iterable$this$.longerThan(length);
            }

            @Ignore
            public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
            }

            @Ignore
            public Entry max(Callable<? extends Comparison> comparing) {
                return (Entry)this.$ceylon$language$Iterable$this$.max(comparing);
            }

            @Ignore
            public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
                return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
            }

            @Ignore
            public Iterable getPaired() {
                return this.$ceylon$language$Iterable$this$.getPaired();
            }

            @Ignore
            public Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> partition(long length) {
                return this.$ceylon$language$Iterable$this$.partition(length);
            }

            @Ignore
            public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
                return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
            }

            @Ignore
            public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
                return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> repeat(long times) {
                return this.$ceylon$language$Iterable$this$.repeat(times);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getRest() {
                return this.$ceylon$language$Iterable$this$.getRest();
            }

            @Ignore
            public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
                return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
            }

            @Ignore
            public Sequential<? extends Entry<? extends Key, ? extends Item>> select(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.select(selecting);
            }

            @Ignore
            public Sequential sequence() {
                return this.$ceylon$language$Iterable$this$.sequence();
            }

            @Ignore
            public boolean shorterThan(long length) {
                return this.$ceylon$language$Iterable$this$.shorterThan(length);
            }

            @Ignore
            public long getSize() {
                return this.$ceylon$language$Iterable$this$.getSize();
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skip(long skipping) {
                return this.$ceylon$language$Iterable$this$.skip(skipping);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
                return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
            }

            @Ignore
            public Sequential<? extends Entry<? extends Key, ? extends Item>> sort(Callable<? extends Comparison> comparing) {
                return this.$ceylon$language$Iterable$this$.sort(comparing);
            }

            @Ignore
            public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
                return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
            }

            @Ignore
            public String toString() {
                return this.$ceylon$language$Iterable$this$.toString();
            }

            @Ignore
            public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
                return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
            }

            @Ignore
            public final <Result> Map<? extends Entry<? extends Key, ? extends Item>, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> take(long taking) {
                return this.$ceylon$language$Iterable$this$.take(taking);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
                return this.$ceylon$language$Iterable$this$.takeWhile(taking);
            }

            @Ignore
            public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
                return this.$ceylon$language$Category$this$;
            }

            @Ignore
            public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
                return this.$ceylon$language$Category$this$.containsAny(elements);
            }

            @Ignore
            public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
                return this.$ceylon$language$Category$this$.containsEvery(elements);
            }

            @Ignore
            public TypeDescriptor $getType$() {
                return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), (TypeDescriptor)TypeDescriptor.functionOrValue((String)"higherEntries", (TypeDescriptor[])new TypeDescriptor[0])), (TypeDescriptor)TypeDescriptor.klass(Anonymous_0_.class, (TypeDescriptor[])new TypeDescriptor[0]));
            }
        }
        return new Anonymous_0_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> lowerEntries(final @Name(value="key") @TypeInfo(value="Key") Key key) {
        @Ceylon(major=8, minor=1)
        @Name(value="anonymous#1")
        @LocalDeclaration(qualifier="1")
        @Object
        @SatisfiedTypes(value={"{<Key->Item>*}"})
        class Anonymous_1_
        implements Serializable,
        ReifiedType,
        Iterable<Entry<? extends Key, ? extends Item>, java.lang.Object> {
            @Ignore
            protected final Iterable.impl<Entry<? extends Key, ? extends Item>, java.lang.Object> $ceylon$language$Iterable$this$;
            @Ignore
            protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;

            Anonymous_1_() {
                this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
                this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
            }

            @SharedAnnotation$annotation$
            @ActualAnnotation$annotation$
            @TypeInfo(value="ceylon.language::Iterator<Key->Item>")
            @NonNull
            public final Iterator<? extends Entry<? extends Key, ? extends Item>> iterator() {
                return new ReverseNodeIterator(TreeMap.this, TreeMap.this.ceiling$priv$(key));
            }

            @Ignore
            public Iterable.impl<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
                return this.$ceylon$language$Iterable$this$;
            }

            @Ignore
            public boolean any(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.any(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> by(long step) {
                return this.$ceylon$language$Iterable$this$.by(step);
            }

            @Ignore
            public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
                return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCoalesced() {
                return this.$ceylon$language$Iterable$this$.getCoalesced();
            }

            @Ignore
            public <Result> Sequential<? extends Result> collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
            }

            @Ignore
            public boolean contains(java.lang.Object element) {
                return this.$ceylon$language$Iterable$this$.contains(element);
            }

            @Ignore
            public long count(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.count(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCycled() {
                return this.$ceylon$language$Iterable$this$.getCycled();
            }

            @Ignore
            public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
                return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getDistinct() {
                return this.$ceylon$language$Iterable$this$.getDistinct();
            }

            @Ignore
            public java.lang.Object each(Callable<? extends java.lang.Object> step) {
                return this.$ceylon$language$Iterable$this$.each(step);
            }

            @Ignore
            public boolean getEmpty() {
                return this.$ceylon$language$Iterable$this$.getEmpty();
            }

            @Ignore
            public boolean every(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.every(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getExceptLast() {
                return this.$ceylon$language$Iterable$this$.getExceptLast();
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.filter(selecting);
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> find(Callable<? extends Boolean> selecting) {
                return (Entry)this.$ceylon$language$Iterable$this$.find(selecting);
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> findLast(Callable<? extends Boolean> selecting) {
                return (Entry)this.$ceylon$language$Iterable$this$.findLast(selecting);
            }

            @Ignore
            public Entry getFirst() {
                return (Entry)this.$ceylon$language$Iterable$this$.getFirst();
            }

            @Ignore
            public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
                return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
            }

            @Ignore
            public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
                return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
            }

            @Ignore
            public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
                return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
            }

            @Ignore
            public final Map<? extends Entry<? extends Key, ? extends Item>, ? extends Integer> frequencies() {
                return this.$ceylon$language$Iterable$this$.frequencies();
            }

            @Ignore
            public Entry<? extends Key, ? extends Item> getFromFirst(long index) {
                return (Entry)this.$ceylon$language$Iterable$this$.getFromFirst(index);
            }

            @Ignore
            public final <Group> Map<? extends Group, ? extends Sequence<? extends Entry<? extends Key, ? extends Item>>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
                return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getIndexed() {
                return this.$ceylon$language$Iterable$this$.getIndexed();
            }

            @Ignore
            public java.lang.Object indexes() {
                return this.$ceylon$language$Iterable$this$.indexes();
            }

            @Ignore
            public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
                return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
            }

            @Ignore
            public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
                long $ceylontmp$step$258 = this.interpose$step($reified$Other, element);
                return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$258);
            }

            @Ignore
            public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
                return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
            }

            @Ignore
            private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
                return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
            }

            @Ignore
            public Entry getLast() {
                return (Entry)this.$ceylon$language$Iterable$this$.getLast();
            }

            @Ignore
            public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locate(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locate(selecting);
            }

            @Ignore
            public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locateLast(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locateLast(selecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.locations(selecting);
            }

            @Ignore
            public boolean longerThan(long length) {
                return this.$ceylon$language$Iterable$this$.longerThan(length);
            }

            @Ignore
            public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
            }

            @Ignore
            public Entry max(Callable<? extends Comparison> comparing) {
                return (Entry)this.$ceylon$language$Iterable$this$.max(comparing);
            }

            @Ignore
            public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
                return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
            }

            @Ignore
            public Iterable getPaired() {
                return this.$ceylon$language$Iterable$this$.getPaired();
            }

            @Ignore
            public Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> partition(long length) {
                return this.$ceylon$language$Iterable$this$.partition(length);
            }

            @Ignore
            public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
                return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
            }

            @Ignore
            public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
                return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> repeat(long times) {
                return this.$ceylon$language$Iterable$this$.repeat(times);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getRest() {
                return this.$ceylon$language$Iterable$this$.getRest();
            }

            @Ignore
            public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
                return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
            }

            @Ignore
            public Sequential<? extends Entry<? extends Key, ? extends Item>> select(Callable<? extends Boolean> selecting) {
                return this.$ceylon$language$Iterable$this$.select(selecting);
            }

            @Ignore
            public Sequential sequence() {
                return this.$ceylon$language$Iterable$this$.sequence();
            }

            @Ignore
            public boolean shorterThan(long length) {
                return this.$ceylon$language$Iterable$this$.shorterThan(length);
            }

            @Ignore
            public long getSize() {
                return this.$ceylon$language$Iterable$this$.getSize();
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skip(long skipping) {
                return this.$ceylon$language$Iterable$this$.skip(skipping);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
                return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
            }

            @Ignore
            public Sequential<? extends Entry<? extends Key, ? extends Item>> sort(Callable<? extends Comparison> comparing) {
                return this.$ceylon$language$Iterable$this$.sort(comparing);
            }

            @Ignore
            public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
                return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
            }

            @Ignore
            public String toString() {
                return this.$ceylon$language$Iterable$this$.toString();
            }

            @Ignore
            public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
                return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
            }

            @Ignore
            public final <Result> Map<? extends Entry<? extends Key, ? extends Item>, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
                return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> take(long taking) {
                return this.$ceylon$language$Iterable$this$.take(taking);
            }

            @Ignore
            public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
                return this.$ceylon$language$Iterable$this$.takeWhile(taking);
            }

            @Ignore
            public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
                return this.$ceylon$language$Category$this$;
            }

            @Ignore
            public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
                return this.$ceylon$language$Category$this$.containsAny(elements);
            }

            @Ignore
            public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
                return this.$ceylon$language$Category$this$.containsEvery(elements);
            }

            @Ignore
            public TypeDescriptor $getType$() {
                return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), (TypeDescriptor)TypeDescriptor.functionOrValue((String)"lowerEntries", (TypeDescriptor[])new TypeDescriptor[0])), (TypeDescriptor)TypeDescriptor.klass(Anonymous_1_.class, (TypeDescriptor[])new TypeDescriptor[0]));
            }
        }
        return new Anonymous_1_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> ascendingEntries(@Name(value="from") @TypeInfo(value="Key") Key from, final @Name(value="to") @TypeInfo(value="Key") Key to) {
        return this.higherEntries(from).takeWhile((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})}), "Boolean(Key->Item)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                Entry entry = (Entry)$param$0;
                return Boolean.instance((!TreeMap.this.compare$priv$(entry.getKey(), to).equals(larger_.get_()) ? 1 : 0) != 0);
            }
        });
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="{<Key->Item>*}")
    @NonNull
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> descendingEntries(@Name(value="from") @TypeInfo(value="Key") Key from, final @Name(value="to") @TypeInfo(value="Key") Key to) {
        return this.lowerEntries(from).takeWhile((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})}), "Boolean(Key->Item)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                Entry entry = (Entry)$param$0;
                return Boolean.instance((!TreeMap.this.compare$priv$(entry.getKey(), to).equals(smaller_.get_()) ? 1 : 0) != 0);
            }
        });
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="entry") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object entry) {
        Node node$263;
        Entry entry$261;
        boolean $ceylontmp$if$259 = false;
        java.lang.Object entry$260 = entry;
        if (entry$260 instanceof Entry && Util.isReified((java.lang.Object)entry$260, (TypeDescriptor)TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}))) {
            entry$261 = (Entry)entry$260;
            Node node$262 = this.lookup$priv$(entry$261.getKey());
            if (node$262 != null) {
                node$263 = node$262;
                $ceylontmp$if$259 = true;
            } else {
                node$263 = null;
            }
        } else {
            entry$261 = null;
            node$263 = null;
        }
        if ($ceylontmp$if$259) {
            java.lang.Object item$265 = node$263.getItem();
            if (item$265 != null) {
                java.lang.Object item$266 = item$265;
                java.lang.Object entryItem$268 = entry$261.getItem();
                if (entryItem$268 != null) {
                    java.lang.Object entryItem$269 = entryItem$268;
                    return entryItem$269.equals(item$266);
                }
                return false;
            }
            return entry$261.getItem() == null;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object clear() {
        void var1_1;
        Node $ceylontmp$op$270 = null;
        this.setRoot$priv$($ceylontmp$op$270);
        return var1_1;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        Node safe$271 = this.getRoot$priv$();
        Integer $ceylontmp$272 = safe$271 != null ? Integer.instance((long)safe$271.getSize()) : null;
        return ($ceylontmp$272 != null ? $ceylontmp$272 : Integer.instance((long)0L)).longValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="<Key->Item>?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Entry getFirst() {
        void var1_3;
        Entry $ceylontmp$ifResult$273;
        Node safe$276 = this.getRoot$priv$();
        Node node$275 = safe$276 != null ? safe$276.getLeftmostChild() : null;
        if (node$275 != null) {
            Node node$277 = node$275;
            $ceylontmp$ifResult$273 = new Entry(this.$reified$Key, this.$reified$Item, node$277.getKey(), node$277.getItem());
        } else {
            $ceylontmp$ifResult$273 = null;
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="<Key->Item>?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Entry getLast() {
        void var1_3;
        Entry $ceylontmp$ifResult$278;
        Node safe$281 = this.getRoot$priv$();
        Node node$280 = safe$281 != null ? safe$281.getRightmostChild() : null;
        if (node$280 != null) {
            Node node$282 = node$280;
            $ceylontmp$ifResult$278 = new Entry(this.$reified$Key, this.$reified$Item, node$282.getKey(), node$282.getItem());
        } else {
            $ceylontmp$ifResult$278 = null;
        }
        return var1_3;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>", erased=true, untrusted=true)
    @NonNull
    public final TreeMap measure(@Name(value="from") @TypeInfo(value="Key") Key from, @Name(value="length") long length) {
        return new TreeMap<Key, Item>(this.$reified$Key, this.$reified$Item, (Callable<? extends Comparison>)new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Key}), "Comparison(Key, Key)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object $ceylontmp$x = $param$0;
                java.lang.Object $ceylontmp$y = $param$1;
                return TreeMap.this.compare$priv$($ceylontmp$x, $ceylontmp$y);
            }
        }, this.higherEntries(from).take(length));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>", erased=true, untrusted=true)
    @NonNull
    public final TreeMap span(@Name(value="from") @TypeInfo(value="Key") Key from, @Name(value="to") @TypeInfo(value="Key") Key to) {
        final boolean reverse = this.compare$priv$(from, to).equals(larger_.get_());
        AbstractCallable<Comparison> arg$283$0 = new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Key}), "Comparison(Key, Key)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object x = $param$0;
                java.lang.Object y = $param$1;
                return reverse ? TreeMap.this.compare$priv$(y, x) : TreeMap.this.compare$priv$(x, y);
            }
        };
        Iterable<Entry<Key, Item>, java.lang.Object> arg$283$1 = reverse ? this.descendingEntries(from, to) : this.ascendingEntries(from, to);
        TypeDescriptor arg$283$reified$0 = this.$reified$Key;
        TypeDescriptor arg$283$reified$1 = this.$reified$Item;
        return new TreeMap<Key, Item>(arg$283$reified$0, arg$283$reified$1, (Callable<? extends Comparison>)arg$283$0, arg$283$1);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>", erased=true, untrusted=true)
    @NonNull
    public final TreeMap spanFrom(@Name(value="from") @TypeInfo(value="Key") Key from) {
        return new TreeMap<Key, Item>(this.$reified$Key, this.$reified$Item, (Callable<? extends Comparison>)new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Key}), "Comparison(Key, Key)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object $ceylontmp$x = $param$0;
                java.lang.Object $ceylontmp$y = $param$1;
                return TreeMap.this.compare$priv$($ceylontmp$x, $ceylontmp$y);
            }
        }, this.higherEntries(from));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>", erased=true, untrusted=true)
    @NonNull
    public final TreeMap spanTo(final @Name(value="to") @TypeInfo(value="Key") Key to) {
        return new TreeMap<Key, Item>(this.$reified$Key, this.$reified$Item, (Callable<? extends Comparison>)new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Key}), "Comparison(Key, Key)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object $ceylontmp$x = $param$0;
                java.lang.Object $ceylontmp$y = $param$1;
                return TreeMap.this.compare$priv$($ceylontmp$x, $ceylontmp$y);
            }
        }, this.takeWhile((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})}), "Boolean(Key->Item)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                Entry entry = (Entry)$param$0;
                return Boolean.instance((!TreeMap.this.compare$priv$(entry.getKey(), to).equals(larger_.get_()) ? 1 : 0) != 0);
            }
        }));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>")
    @NonNull
    public final TreeMap<Key, Item> $clone() {
        return new TreeMap<Key, Item>(this.$reified$Key, this.$reified$Item, copy_, this);
    }

    /*
     * WARNING - void declaration
     */
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    @NonNull
    public final String toString() {
        void var1_3;
        String $ceylontmp$ifResult$284;
        Node r$286 = this.getRoot$priv$();
        if (r$286 != null) {
            Node r$287 = r$286;
            $ceylontmp$ifResult$284 = "{ " + r$287.toString() + " }";
        } else {
            $ceylontmp$ifResult$284 = "{}";
        }
        return var1_3;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        return this.$ceylon$language$Map$this$.equals(that);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long $ceylontmp$hash$289 = this.$ceylon$language$Map$this$.hashCode();
        return (int)($ceylontmp$hash$289 ^ $ceylontmp$hash$289 >>> 32);
    }

    @SharedAnnotation$annotation$
    public final void assertInvariants() {
        this.assertBlackRoot$priv$();
        this.assertColors$priv$();
        this.assertBlackNodesInPaths$priv$();
    }

    private final void assertBlackRoot$priv$() {
        if (this.isRed$priv$(this.getRoot$priv$())) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!isRed(root)");
        }
    }

    @Ignore
    private final void assertColors$priv$() {
        Node $ceylontmp$node$294 = this.assertColors$node();
        this.assertColors$priv$$canonical$($ceylontmp$node$294);
    }

    @Ignore
    private final Node assertColors$node() {
        return this.getRoot$priv$();
    }

    @Ignore
    private void assertColors$priv$$canonical$(Node node) {
        Node node$291 = node;
        if (node$291 != null) {
            Node node$292 = node$291;
            if (this.isRed$priv$(node$292)) {
                if (this.isRed$priv$(node$292.getLeft())) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!isRed(node.left)");
                }
                if (this.isRed$priv$(node$292.getRight())) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!isRed(node.right)");
                }
                if (this.isRed$priv$(node$292.getParent())) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!isRed(node.parent)");
                }
            }
            this.assertColors$priv$(node$292.getLeft());
            this.assertColors$priv$(node$292.getRight());
        }
    }

    private final void assertColors$priv$(@Name(value="node") @Defaulted @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node node) {
        this.assertColors$priv$$canonical$(node);
    }

    @Ignore
    private final Integer assertBlackNodesInPaths$priv$() {
        Node $ceylontmp$node$306 = this.assertBlackNodesInPaths$node();
        long $ceylontmp$blackCount$307 = this.assertBlackNodesInPaths$blackCount($ceylontmp$node$306);
        Integer $ceylontmp$pathBlackCount$308 = this.assertBlackNodesInPaths$pathBlackCount($ceylontmp$node$306, $ceylontmp$blackCount$307);
        return this.assertBlackNodesInPaths$priv$$canonical$($ceylontmp$node$306, $ceylontmp$blackCount$307, $ceylontmp$pathBlackCount$308);
    }

    @Ignore
    private final Node assertBlackNodesInPaths$node() {
        return this.getRoot$priv$();
    }

    @Ignore
    private final Integer assertBlackNodesInPaths$priv$(Node node) {
        long $ceylontmp$blackCount$309 = this.assertBlackNodesInPaths$blackCount(node);
        Integer $ceylontmp$pathBlackCount$310 = this.assertBlackNodesInPaths$pathBlackCount(node, $ceylontmp$blackCount$309);
        return this.assertBlackNodesInPaths$priv$$canonical$(node, $ceylontmp$blackCount$309, $ceylontmp$pathBlackCount$310);
    }

    @Ignore
    private final long assertBlackNodesInPaths$blackCount(Node node) {
        return 0L;
    }

    @Ignore
    private final Integer assertBlackNodesInPaths$priv$(Node node, long blackCount) {
        Integer $ceylontmp$pathBlackCount$311 = this.assertBlackNodesInPaths$pathBlackCount(node, blackCount);
        return this.assertBlackNodesInPaths$priv$$canonical$(node, blackCount, $ceylontmp$pathBlackCount$311);
    }

    @Ignore
    private final Integer assertBlackNodesInPaths$pathBlackCount(Node node, long blackCount) {
        return null;
    }

    @Ignore
    private Integer assertBlackNodesInPaths$priv$$canonical$(Node node, long blackCount, Integer pathBlackCount) {
        Node node$298;
        if (!this.isRed$priv$(node)) {
            long $ceylontmp$op$296 = blackCount;
            blackCount = $ceylontmp$op$296 + 1L;
        }
        if ((node$298 = node) != null) {
            Node node$305 = node$298;
            pathBlackCount = this.assertBlackNodesInPaths$priv$(node$305.getLeft(), blackCount, pathBlackCount);
            pathBlackCount = this.assertBlackNodesInPaths$priv$(node$305.getRight(), blackCount, pathBlackCount);
            return pathBlackCount;
        }
        Node node$299 = node$298;
        Integer count$301 = pathBlackCount;
        if (count$301 != null) {
            long lhs$303 = blackCount;
            long count$302 = count$301.longValue();
            long rhs$304 = count$302;
            if (lhs$303 != rhs$304) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "blackCount == count" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$303), (java.lang.Object)Integer.instance((long)rhs$304)));
            }
        } else {
            pathBlackCount = Integer.instance((long)blackCount);
        }
        return pathBlackCount;
    }

    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    private final Integer assertBlackNodesInPaths$priv$(@Name(value="node") @Defaulted @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node node, @Name(value="blackCount") @Defaulted @VariableAnnotation$annotation$ long blackCount, @Name(value="pathBlackCount") @Defaulted @TypeInfo(value="ceylon.language::Integer?") @VariableAnnotation$annotation$ @Nullable Integer pathBlackCount) {
        return this.assertBlackNodesInPaths$priv$$canonical$(node, blackCount, pathBlackCount);
    }

    @Ignore
    public static final <Key, Item> Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> TreeMap$entries(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Callable<? extends Comparison> compare$param$) {
        return empty_.get_();
    }

    @DocAnnotation$annotation$(description="Create a new `TreeMap` with the given \n[[comparator function|compare]] and [[entries]].")
    @SharedAnnotation$annotation$
    public TreeMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Name(value="compare") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Key, Key)") @NonNull Callable<? extends Comparison> compare$param$, @Name(value="entries") @Defaulted @TypeInfo(value="{<Key->Item>*}") @DocAnnotation$annotation$(description="The initial entries in the map.") @NonNull Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries$param$) {
        Iterator elem$120$iterator$;
        Node $ceylontmp$ifResult$114;
        Node nodeToClone;
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(ceylon.language.Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.compare$priv$ = null;
        this.root = null;
        this.compare$priv$ = compare$param$;
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries = entries$param$;
        Node nodeToClone$116 = nodeToClone = null;
        if (nodeToClone$116 != null) {
            Node nodeToClone$118 = nodeToClone$116;
            $ceylontmp$ifResult$114 = this.copyNode$priv$(nodeToClone$118);
        } else {
            Node nodeToClone$117 = nodeToClone$116;
            $ceylontmp$ifResult$114 = null;
        }
        this.setRoot$priv$($ceylontmp$ifResult$114);
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> iterable$121 = entries;
        boolean isArray$122 = iterable$121 instanceof Array;
        boolean isTuple$123 = iterable$121 instanceof Tuple && ((Tuple)iterable$121).$getArray$() != null;
        java.lang.Object elem$120 = null;
        int i$124 = 0;
        int length$125 = isArray$122 || isTuple$123 ? (int)iterable$121.getSize() : 0;
        Iterator iterator = elem$120$iterator$ = isTuple$123 || isArray$122 ? null : iterable$121.iterator();
        while (isTuple$123 || isArray$122 ? i$124 < length$125 : !((elem$120 = elem$120$iterator$.next()) instanceof Finished)) {
            if (isArray$122 || isTuple$123) {
                elem$120 = iterable$121.getFromFirst((long)i$124++);
            }
            java.lang.Object key = ((Entry)elem$120).getKey();
            java.lang.Object item = ((Entry)elem$120).getItem();
            this.put(key, item);
        }
        this.removeCases = null;
    }

    @DocAnnotation$annotation$(description="Create a new `TreeMap` with the same comparator \nfunction and entries as the given [[treeMap]].")
    @SharedAnnotation$annotation$
    @Name(value="copy")
    public TreeMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Ignore copy_ $name$, @Name(value="treeMap") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>") @NonNull TreeMap<Key, Item> treeMap$param$) {
        Iterator elem$120$iterator$;
        Node $ceylontmp$ifResult$114;
        Node nodeToClone;
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(ceylon.language.Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.compare$priv$ = null;
        this.root = null;
        final TreeMap<Key, Item> $instance$ = treeMap$param$;
        this.compare$priv$ = new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Key}), "Comparison(Key, Key)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object $ceylontmp$x = $param$0;
                java.lang.Object $ceylontmp$y = $param$1;
                return $instance$.compare$priv$($ceylontmp$x, $ceylontmp$y);
            }
        };
        empty_ entries = empty_.get_();
        Node nodeToClone$116 = nodeToClone = super.getRoot$priv$();
        if (nodeToClone$116 != null) {
            Node nodeToClone$118 = nodeToClone$116;
            $ceylontmp$ifResult$114 = this.copyNode$priv$(nodeToClone$118);
        } else {
            Node nodeToClone$117 = nodeToClone$116;
            $ceylontmp$ifResult$114 = null;
        }
        this.setRoot$priv$($ceylontmp$ifResult$114);
        empty_ iterable$121 = entries;
        boolean isArray$122 = iterable$121 instanceof Array;
        boolean isTuple$123 = iterable$121 instanceof Tuple && ((Tuple)iterable$121).$getArray$() != null;
        java.lang.Object elem$120 = null;
        int i$124 = 0;
        int length$125 = isArray$122 || isTuple$123 ? (int)iterable$121.getSize() : 0;
        Iterator iterator = elem$120$iterator$ = isTuple$123 || isArray$122 ? null : iterable$121.iterator();
        while (isTuple$123 || isArray$122 ? i$124 < length$125 : !((elem$120 = elem$120$iterator$.next()) instanceof Finished)) {
            if (isArray$122 || isTuple$123) {
                elem$120 = iterable$121.getFromFirst((long)i$124++);
            }
            java.lang.Object key = ((Entry)elem$120).getKey();
            java.lang.Object item = ((Entry)elem$120).getItem();
            this.put(key, item);
        }
        this.removeCases = null;
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item});
    }

    @Ignore
    public java.util.Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(TreeMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "root")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(TreeMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "removeCases")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((ceylon.language.serialization.Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::TreeMap.root": {
                return this.root;
            }
            case "ceylon.collection::TreeMap.removeCases": {
                return this.removeCases;
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof ceylon.language.serialization.Member) {
            switch (((ceylon.language.serialization.Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::TreeMap.root": {
                    this.root = (Node)instance;
                    break;
                }
                case "ceylon.collection::TreeMap.removeCases": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"removeCases").invokeExact(this, (removeCases_)instance);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8, minor=1)
    @Name(value="Node")
    @Container(klass=TreeMap.class, isStatic=false)
    @Class(constructors=true)
    class Node
    implements ReifiedType,
    Serializable {
        @Ignore
        private Key key;
        @Ignore
        private Item item;
        @Ignore
        private Node left = null;
        @Ignore
        private Node right = null;
        @Ignore
        private Node parent = null;
        @Ignore
        private boolean red;

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        @TypeInfo(value="Key")
        public final Key getKey() {
            return this.key;
        }

        public final void setKey(@Name(value="key") @TypeInfo(value="Key") Key key) {
            this.key = key;
        }

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        @TypeInfo(value="Item")
        public final Item getItem() {
            return this.item;
        }

        public final void setItem(@Name(value="item") @TypeInfo(value="Item") Item item) {
            this.item = item;
        }

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        public final Node getLeft() {
            return this.left;
        }

        public final void setLeft(@Name(value="left") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node left) {
            this.left = left;
        }

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        public final Node getRight() {
            return this.right;
        }

        public final void setRight(@Name(value="right") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node right) {
            this.right = right;
        }

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        public final Node getParent() {
            return this.parent;
        }

        public final void setParent(@Name(value="parent") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node parent) {
            this.parent = parent;
        }

        @SharedAnnotation$annotation$
        @VariableAnnotation$annotation$
        public final boolean getRed() {
            return this.red;
        }

        public final void setRed(@Name(value="red") boolean red) {
            this.red = red;
        }

        /*
         * WARNING - void declaration
         */
        @SharedAnnotation$annotation$
        @Transient
        public final boolean getOnLeft() {
            void var1_3;
            boolean $ceylontmp$ifResult$1;
            Node safe$4 = this.getParent();
            Node parentLeft$3 = safe$4 != null ? safe$4.getLeft() : null;
            if (parentLeft$3 != null) {
                Node parentLeft$5 = parentLeft$3;
                $ceylontmp$ifResult$1 = this.equals(parentLeft$5);
            } else {
                $ceylontmp$ifResult$1 = false;
            }
            return (boolean)var1_3;
        }

        /*
         * WARNING - void declaration
         */
        @SharedAnnotation$annotation$
        @Transient
        public final boolean getOnRight() {
            void var1_3;
            boolean $ceylontmp$ifResult$6;
            Node safe$9 = this.getParent();
            Node parentRight$8 = safe$9 != null ? safe$9.getRight() : null;
            if (parentRight$8 != null) {
                Node parentRight$10 = parentRight$8;
                $ceylontmp$ifResult$6 = this.equals(parentRight$10);
            } else {
                $ceylontmp$ifResult$6 = false;
            }
            return (boolean)var1_3;
        }

        @SharedAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Transient
        @Nullable
        public final Node getGrandparent() {
            Node safe$11 = this.getParent();
            return safe$11 != null ? safe$11.getParent() : null;
        }

        @SharedAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Transient
        @Nullable
        public final Node getSibling() {
            Node p$13 = this.getParent();
            if (p$13 != null) {
                Node p$14 = p$13;
                if (this.getOnLeft()) {
                    return p$14.getRight();
                }
                if (this.getOnRight()) {
                    return p$14.getLeft();
                }
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
            }
            return null;
        }

        @SharedAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Transient
        @Nullable
        public final Node getUncle() {
            Node safe$17 = this.getParent();
            return safe$17 != null ? safe$17.getSibling() : null;
        }

        @SharedAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node")
        @Transient
        @NonNull
        public final Node getRightmostChild() {
            Node right$18;
            Node rightmost = this;
            while ((right$18 = rightmost.getRight()) != null) {
                Node right$19;
                rightmost = right$19 = right$18;
            }
            return rightmost;
        }

        @SharedAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node")
        @Transient
        @NonNull
        public final Node getLeftmostChild() {
            Node left$20;
            Node leftmost = this;
            while ((left$20 = leftmost.getLeft()) != null) {
                Node left$21;
                leftmost = left$21 = left$20;
            }
            return leftmost;
        }

        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @Transient
        @NonNull
        public final String toString() {
            java.lang.Object safe$25;
            StringBuilder stringBuilder = new StringBuilder();
            Node l$23 = this.getLeft();
            if (l$23 != null) {
                Node l$24 = l$23;
                stringBuilder.append(l$24.toString()).append(", ");
            }
            ceylon.language.String $ceylontmp$26 = (safe$25 = this.getItem()) != null ? ceylon.language.String.instance((String)safe$25.toString()) : null;
            stringBuilder.append(this.getKey().toString()).append("->").append(($ceylontmp$26 != null ? $ceylontmp$26 : ceylon.language.String.instance((String)"<null>")).toString());
            Node r$28 = this.getRight();
            if (r$28 != null) {
                Node r$29 = r$28;
                stringBuilder.append(", ").append(r$29.toString());
            }
            return stringBuilder.toString();
        }

        @SharedAnnotation$annotation$
        @Transient
        public final long getSize() {
            Node right$34;
            long size = 1L;
            Node left$31 = this.getLeft();
            if (left$31 != null) {
                Node left$32 = left$31;
                size += left$32.getSize();
            }
            if ((right$34 = this.getRight()) != null) {
                Node right$35 = right$34;
                size += right$35.getSize();
            }
            return size;
        }

        @SharedAnnotation$annotation$
        public Node(@Name(value="item") @TypeInfo(value="Item") Key key$param$, @Name(value="red") Item item$param$, boolean red$param$) {
            this.setKey(key$param$);
            this.setItem(item$param$);
            this.setRed(red$param$);
        }

        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), (TypeDescriptor)TypeDescriptor.klass(Node.class, (TypeDescriptor[])new TypeDescriptor[0]));
        }
    }

    @Ceylon(major=8, minor=1)
    @Name(value="NodeIterator")
    @Container(klass=TreeMap.class, isStatic=false)
    @SatisfiedTypes(value={"ceylon.language::Iterator<Key->Item>"})
    class NodeIterator
    implements ReifiedType,
    Iterator<Entry<? extends Key, ? extends Item>>,
    Serializable {
        @Ignore
        private Node current;
        final /* synthetic */ TreeMap this$0;

        @Ignore
        NodeIterator(TreeMap this$0) {
            Node $ceylontmp$current$199 = this$0.$default$NodeIterator$current();
            this(this$0, $ceylontmp$current$199);
        }

        NodeIterator(@Name(value="current") @Defaulted @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @VariableAnnotation$annotation$ @Nullable TreeMap this$0, Node current$param$) {
            this.this$0 = this$0;
            this.current = current$param$;
        }

        @VariableAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        private final Node getCurrent$priv$() {
            return this.current;
        }

        private final void setCurrent$priv$(@Name(value="current") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node current) {
            this.current = current;
        }

        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @TypeInfo(value="<Key->Item>|ceylon.language::Finished", erased=true)
        @NonNull
        public final java.lang.Object next() {
            Node right$208;
            Node node$206;
            finished_ $ceylontmp$ifResult$200;
            Node node$202 = this.getCurrent$priv$();
            if (node$202 != null) {
                Node node$203 = node$202;
                $ceylontmp$ifResult$200 = new Entry(this.this$0.$reified$Key, this.this$0.$reified$Item, node$203.getKey(), node$203.getItem());
            } else {
                $ceylontmp$ifResult$200 = finished_.get_();
            }
            finished_ entry = $ceylontmp$ifResult$200;
            boolean $ceylontmp$if$204 = false;
            Node node$205 = this.getCurrent$priv$();
            if (node$205 != null) {
                node$206 = node$205;
                Node right$207 = node$206.getRight();
                if (right$207 != null) {
                    right$208 = right$207;
                    $ceylontmp$if$204 = true;
                } else {
                    right$208 = null;
                }
            } else {
                node$206 = null;
                right$208 = null;
            }
            if ($ceylontmp$if$204) {
                Node safe$210;
                Node left$209;
                this.setCurrent$priv$(right$208);
                while ((left$209 = (safe$210 = this.getCurrent$priv$()) != null ? safe$210.getLeft() : null) != null) {
                    Node left$211 = left$209;
                    this.setCurrent$priv$(left$211);
                }
            } else {
                Node node$213 = this.getCurrent$priv$();
                if (node$213 != null) {
                    Node parent$215;
                    Node node$214;
                    Node child = node$214 = node$213;
                    while ((parent$215 = child.getParent()) != null) {
                        Node parent$216 = parent$215;
                        if (!child.getOnRight()) break;
                        child = parent$216;
                    }
                    this.setCurrent$priv$(child.getParent());
                } else {
                    this.setCurrent$priv$(null);
                }
            }
            return entry;
        }

        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{this.this$0.$reified$Key, this.this$0.$reified$Item}), (TypeDescriptor)TypeDescriptor.klass(NodeIterator.class, (TypeDescriptor[])new TypeDescriptor[0]));
        }
    }

    @Ceylon(major=8, minor=1)
    @Name(value="ReverseNodeIterator")
    @Container(klass=TreeMap.class, isStatic=false)
    @SatisfiedTypes(value={"ceylon.language::Iterator<Key->Item>"})
    class ReverseNodeIterator
    implements ReifiedType,
    Iterator<Entry<? extends Key, ? extends Item>>,
    Serializable {
        @Ignore
        private Node current;
        final /* synthetic */ TreeMap this$0;

        @Ignore
        ReverseNodeIterator(TreeMap this$0) {
            Node $ceylontmp$current$218 = this$0.$default$ReverseNodeIterator$current();
            this(this$0, $ceylontmp$current$218);
        }

        ReverseNodeIterator(@Name(value="current") @Defaulted @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @VariableAnnotation$annotation$ @Nullable TreeMap this$0, Node current$param$) {
            this.this$0 = this$0;
            this.current = current$param$;
        }

        @VariableAnnotation$annotation$
        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        private final Node getCurrent$priv$() {
            return this.current;
        }

        private final void setCurrent$priv$(@Name(value="current") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node current) {
            this.current = current;
        }

        @SharedAnnotation$annotation$
        @ActualAnnotation$annotation$
        @TypeInfo(value="<Key->Item>|ceylon.language::Finished", erased=true)
        @NonNull
        public final java.lang.Object next() {
            Node left$227;
            Node node$225;
            finished_ $ceylontmp$ifResult$219;
            Node node$221 = this.getCurrent$priv$();
            if (node$221 != null) {
                Node node$222 = node$221;
                $ceylontmp$ifResult$219 = new Entry(this.this$0.$reified$Key, this.this$0.$reified$Item, node$222.getKey(), node$222.getItem());
            } else {
                $ceylontmp$ifResult$219 = finished_.get_();
            }
            finished_ entry = $ceylontmp$ifResult$219;
            boolean $ceylontmp$if$223 = false;
            Node node$224 = this.getCurrent$priv$();
            if (node$224 != null) {
                node$225 = node$224;
                Node left$226 = node$225.getLeft();
                if (left$226 != null) {
                    left$227 = left$226;
                    $ceylontmp$if$223 = true;
                } else {
                    left$227 = null;
                }
            } else {
                node$225 = null;
                left$227 = null;
            }
            if ($ceylontmp$if$223) {
                Node safe$229;
                Node right$228;
                this.setCurrent$priv$(left$227);
                while ((right$228 = (safe$229 = this.getCurrent$priv$()) != null ? safe$229.getRight() : null) != null) {
                    Node right$230 = right$228;
                    this.setCurrent$priv$(right$230);
                }
            } else {
                Node node$232 = this.getCurrent$priv$();
                if (node$232 != null) {
                    Node parent$234;
                    Node node$233 = node$232;
                    this.setCurrent$priv$(node$233.getParent());
                    Node child = node$233;
                    while ((parent$234 = this.getCurrent$priv$()) != null) {
                        Node parent$235 = parent$234;
                        if (child.getOnLeft()) {
                            child = parent$235;
                            this.setCurrent$priv$(parent$235.getParent());
                            continue;
                        }
                        break;
                    }
                } else {
                    this.setCurrent$priv$(null);
                }
            }
            return entry;
        }

        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{this.this$0.$reified$Key, this.this$0.$reified$Item}), (TypeDescriptor)TypeDescriptor.klass(ReverseNodeIterator.class, (TypeDescriptor[])new TypeDescriptor[0]));
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="copy")
    public static final class copy_ {
        copy_() {
        }
    }

    @Ceylon(major=8, minor=1)
    @Name(value="removeCases")
    @Container(klass=TreeMap.class, isStatic=false)
    @Object
    final class removeCases_
    implements Serializable,
    ReifiedType {
        private removeCases_() {
        }

        @Ignore
        private final java.lang.Object writeReplace() {
            String $name$ = "getRemoveCases$priv$";
            return new SerializationProxy((java.lang.Object)TreeMap.this, TreeMap.class, $name$);
        }

        @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?")
        @Nullable
        private final Node getAndEnsureAtMostOneChild$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node) {
            Node left$127 = node.getLeft();
            if (left$127 != null) {
                Node left$131 = left$127;
                if (node.getRight() != null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!node.right exists");
                }
                return left$131;
            }
            Node right$129 = node.getRight();
            if (right$129 != null) {
                Node right$130 = right$129;
                if (node.getLeft() != null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "!node.left exists");
                }
                return right$130;
            }
            return null;
        }

        @SharedAnnotation$annotation$
        public final void removeNodeWithAtMostOneChild(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node) {
            Node child = this.getAndEnsureAtMostOneChild$priv$(node);
            boolean $ceylontmp$if$132 = false;
            if (!node.getRed() && TreeMap.this.isRed$priv$(child)) {
                $ceylontmp$if$132 = true;
            }
            if ($ceylontmp$if$132) {
                Node child$133 = null;
                child$133 = child;
                if (child$133 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists child");
                }
                Node child$134 = child$133;
                child$134.setRed(false);
            } else if (!node.getRed()) {
                this.case1$priv$(node, node.getSibling());
            }
            TreeMap.this.replaceNode$priv$(node, child);
        }

        private final void case1$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="sibling") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node sibling) {
            Node r$138;
            Node r$137 = TreeMap.this.getRoot$priv$();
            if (r$137 != null && (r$138 = r$137) != node) {
                this.case2$priv$(node, sibling);
            }
        }

        private final void case2$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="sibling") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node sibling) {
            Node s$143;
            Node p$139 = null;
            p$139 = node.getParent();
            if (p$139 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists p = node.parent");
            }
            Node p$140 = p$139;
            Node s$142 = sibling;
            if (s$142 != null && (s$143 = s$142).getRed()) {
                p$140.setRed(true);
                s$143.setRed(false);
                if (node.getOnLeft()) {
                    TreeMap.this.rotateLeft$priv$(p$140);
                } else {
                    TreeMap.this.rotateRight$priv$(p$140);
                }
            }
            Node newParent$145 = null;
            newParent$145 = node.getParent();
            if (newParent$145 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists newParent = node.parent");
            }
            Node newParent$146 = newParent$145;
            this.case3$priv$(node, newParent$146, node.getSibling());
        }

        private final void case3$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="p") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node p, @Name(value="s") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node?") @Nullable Node s) {
            Node s$147 = null;
            s$147 = s;
            if (s$147 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists s");
            }
            Node s$148 = s$147;
            boolean sLeftRed = TreeMap.this.isRed$priv$(s$148.getLeft());
            boolean sRightRed = TreeMap.this.isRed$priv$(s$148.getRight());
            boolean $ceylontmp$if$149 = false;
            if (!(s$148.getRed() || p.getRed() || sLeftRed || sRightRed)) {
                $ceylontmp$if$149 = true;
            }
            if ($ceylontmp$if$149) {
                s$148.setRed(true);
                this.case1$priv$(p, p.getSibling());
            } else {
                this.case4$priv$(node, p, s$148, sLeftRed, sRightRed);
            }
        }

        private final void case4$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="p") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node p, @Name(value="s") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node s, @Name(value="sLeftRed") boolean sLeftRed, @Name(value="sRightRed") boolean sRightRed) {
            boolean $ceylontmp$if$150 = false;
            if (!s.getRed() && p.getRed() && !sLeftRed && !sRightRed) {
                $ceylontmp$if$150 = true;
            }
            if ($ceylontmp$if$150) {
                s.setRed(true);
                p.setRed(false);
            } else {
                this.case5$priv$(node, p, s, sLeftRed, sRightRed);
            }
        }

        private final void case5$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="p") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node p, @Name(value="s") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node s, @Name(value="sLeftRed") boolean sLeftRed, @Name(value="sRightRed") boolean sRightRed) {
            Node newS$159;
            Node newParent$158;
            boolean $ceylontmp$if$151 = false;
            if (!s.getRed() && sLeftRed && !sRightRed && node.getOnLeft()) {
                $ceylontmp$if$151 = true;
            }
            if ($ceylontmp$if$151) {
                s.setRed(true);
                Node sl$152 = null;
                sl$152 = s.getLeft();
                if (sl$152 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists sl = s.left");
                }
                Node sl$153 = sl$152;
                sl$153.setRed(false);
                TreeMap.this.rotateRight$priv$(s);
            } else if (!s.getRed() && !sLeftRed && sRightRed && node.getOnRight()) {
                s.setRed(true);
                Node sr$155 = null;
                sr$155 = s.getRight();
                if (sr$155 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists sr = s.right");
                }
                Node sr$156 = sr$155;
                sr$156.setRed(false);
                TreeMap.this.rotateLeft$priv$(s);
            }
            Node newParent$157 = null;
            newParent$157 = node.getParent();
            if (newParent$157 != null) {
                newParent$158 = newParent$157;
                newS$159 = null;
                newS$159 = node.getSibling();
                if (newS$159 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tunviolated " + "exists newParent = node.parent" + System.lineSeparator() + "\tviolated " + "exists newS = node.sibling");
                }
            } else {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists newParent = node.parent" + System.lineSeparator() + "\tuntested " + "exists newS = node.sibling");
            }
            Node newS$160 = newS$159;
            this.case6$priv$(node, newParent$158, newS$160);
        }

        private final void case6$priv$(@Name(value="node") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node node, @Name(value="p") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node p, @Name(value="s") @TypeInfo(value="ceylon.collection::TreeMap<Key,Item>.Node") @NonNull Node s) {
            Node sr$163;
            s.setRed(p.getRed());
            p.setRed(false);
            boolean $ceylontmp$if$161 = false;
            if (node.getOnLeft()) {
                Node sr$162 = s.getRight();
                if (sr$162 != null) {
                    sr$163 = sr$162;
                    $ceylontmp$if$161 = true;
                } else {
                    sr$163 = null;
                }
            } else {
                sr$163 = null;
            }
            if ($ceylontmp$if$161) {
                sr$163.setRed(false);
                TreeMap.this.rotateLeft$priv$(p);
            } else {
                Node sl$165 = s.getLeft();
                if (sl$165 != null) {
                    Node sl$166 = sl$165;
                    sl$166.setRed(false);
                    TreeMap.this.rotateRight$priv$(p);
                }
            }
        }

        @Ignore
        public TypeDescriptor $getType$() {
            return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(TreeMap.class, (TypeDescriptor[])new TypeDescriptor[]{TreeMap.this.$reified$Key, TreeMap.this.$reified$Item}), (TypeDescriptor)TypeDescriptor.klass(removeCases_.class, (TypeDescriptor[])new TypeDescriptor[0]));
        }
    }
}

