/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.largest_;
import ceylon.collection.smallest_;
import ceylon.language.Boolean;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Sequence;
import ceylon.language.Tuple;
import ceylon.language.false_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@Method
final class spanToMeasure_ {
    private spanToMeasure_() {
    }

    @DocAnnotation$annotation$(description="Converts the indexes of a span to those of an equivalent \nmeasure which may be reversed (the span might have \n`from > to` to express that the elements of the segment \nshould be reversed). The returned tuple is of this form:\n\n    [start, length, reversed]")
    @TypeInfo(value="[ceylon.language::Integer, ceylon.language::Integer, ceylon.language::Boolean]", erased=true)
    @NonNull
    static Sequence spanToMeasure(@Name(value="from") long from, @Name(value="to") long to, @Name(value="size") long size) {
        if (size == 0L || from < 0L && to < 0L) {
            return Tuple.instance((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Integer.$TypeDescriptor$, false_.$TypeDescriptor$}), (Object[])new Object[]{Integer.instance((long)0L), Integer.instance((long)0L), Boolean.instance((boolean)false)});
        }
        boolean reversed = from > to;
        long start = largest_.largest(0L, reversed ? to : from);
        long end = smallest_.smallest(size - 1L, reversed ? from : to);
        return Tuple.instance((TypeDescriptor)TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Integer.$TypeDescriptor$, Boolean.$TypeDescriptor$}), (Object[])new Object[]{Integer.instance((long)start), Integer.instance((long)(1L + end - start)), Boolean.instance((boolean)reversed)});
    }
}

