/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.HashSet;
import ceylon.collection.Hashtable;
import ceylon.collection.ListMutator$impl;
import ceylon.collection.MutableList;
import ceylon.collection.MutableList$impl;
import ceylon.collection.Queue;
import ceylon.collection.Stability;
import ceylon.collection.Stack;
import ceylon.collection.largest_;
import ceylon.collection.measureToSpan_;
import ceylon.collection.smallest_;
import ceylon.collection.spanToMeasure_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.Correspondence;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.OverflowException;
import ceylon.language.SearchableList;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.equal_;
import ceylon.language.finished_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.larger_;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.runtime_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import ceylon.language.smaller_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.language.ConstantIterable;
import com.redhat.ceylon.compiler.java.language.EnumeratedTypeError;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclaration;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Object;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[MutableList]] implemented using a backing [[Array]].\nAlso:\n\n- a [[Stack]], where the top of the stack is the _last_\n  element of the list, and\n- a [[Queue]], where the front of the queue is the first\n  element of the list and the back of the queue is the\n  last element of the list.\n\nThe size of the backing `Array` is called the _capacity_\nof the `ArrayList`. The capacity of a new instance is\nspecified by the given [[initialCapacity]]. The capacity is\nincreased when [[size]] exceeds the capacity. The new\ncapacity is the product of the current capacity and the\ngiven [[growthFactor]].")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@LocalDeclarations(value={"1anonymous_0_"})
@SatisfiedTypes(value={"ceylon.collection::MutableList<Element>", "ceylon.language::SearchableList<Element>", "ceylon.collection::Stack<Element>", "ceylon.collection::Queue<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={}, caseTypes={})})
@Class(constructors=true)
public class ArrayList<Element>
implements ReifiedType,
MutableList<Element>,
SearchableList<Element>,
Stack<Element>,
Queue<Element>,
Serializable,
com.redhat.ceylon.compiler.java.runtime.serialization.Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final MutableList$impl<Element> $ceylon$collection$MutableList$this$;
    @Ignore
    protected final List.impl<Element> $ceylon$language$List$this$;
    @Ignore
    protected final Collection.impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Correspondence.impl<Integer, Element> $ceylon$language$Correspondence$this$;
    @Ignore
    protected final ListMutator$impl<Element> $ceylon$collection$ListMutator$this$;
    @Ignore
    protected final SearchableList.impl<Element> $ceylon$language$SearchableList$this$;
    @Ignore
    private final long initialCapacity;
    @Ignore
    private final double growthFactor;
    @Ignore
    private Array<Element> array;
    @Ignore
    private long length;
    @Ignore
    public static final copy_ copy_ = null;
    @Ignore
    public static final ofSize_ ofSize_ = null;

    @Ignore
    public ArrayList(TypeDescriptor $reified$Element) {
        long $ceylontmp$initialCapacity$248 = ArrayList.ArrayList$initialCapacity($reified$Element);
        double $ceylontmp$growthFactor$249 = ArrayList.ArrayList$growthFactor($reified$Element, $ceylontmp$initialCapacity$248);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$250 = ArrayList.ArrayList$elements($reified$Element, $ceylontmp$initialCapacity$248, $ceylontmp$growthFactor$249);
        this($reified$Element, $ceylontmp$initialCapacity$248, $ceylontmp$growthFactor$249, $ceylontmp$elements$250);
    }

    @Ignore
    public ArrayList(TypeDescriptor $reified$Element, long initialCapacity$param$) {
        double $ceylontmp$growthFactor$251 = ArrayList.ArrayList$growthFactor($reified$Element, initialCapacity$param$);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$252 = ArrayList.ArrayList$elements($reified$Element, initialCapacity$param$, $ceylontmp$growthFactor$251);
        this($reified$Element, initialCapacity$param$, $ceylontmp$growthFactor$251, $ceylontmp$elements$252);
    }

    @Ignore
    public ArrayList(TypeDescriptor $reified$Element, long initialCapacity$param$, double growthFactor$param$) {
        Iterable<Element, java.lang.Object> $ceylontmp$elements$253 = ArrayList.ArrayList$elements($reified$Element, initialCapacity$param$, growthFactor$param$);
        this($reified$Element, initialCapacity$param$, growthFactor$param$, $ceylontmp$elements$253);
    }

    @Ignore
    public ArrayList(TypeDescriptor $reified$Element, @Ignore copy_ $name$, ArrayList<Element> arrayList$param$) {
        double $ceylontmp$growthFactor$255 = ArrayList.ArrayList$copy$growthFactor($reified$Element, arrayList$param$);
        this($reified$Element, $name$, arrayList$param$, $ceylontmp$growthFactor$255);
    }

    @Ignore
    public ArrayList(TypeDescriptor $reified$Element, @Ignore ofSize_ $name$, long size$param$, Element element$param$) {
        double $ceylontmp$growthFactor$257 = ArrayList.ArrayList$ofSize$growthFactor($reified$Element, size$param$, element$param$);
        this($reified$Element, $name$, size$param$, element$param$, $ceylontmp$growthFactor$257);
    }

    @Ignore
    public ArrayList($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$SearchableList$this$ = new SearchableList.impl($reified$Element, (SearchableList)this);
        this.initialCapacity = 0L;
        this.growthFactor = 0.0;
        this.array = null;
        this.length = 0L;
    }

    @Override
    @Ignore
    public MutableList$impl<Element> $ceylon$collection$MutableList$impl() {
        return this.$ceylon$collection$MutableList$this$;
    }

    @Override
    @Ignore
    public Element deleteFirst() {
        return this.$ceylon$collection$MutableList$this$.deleteFirst();
    }

    @Override
    @Ignore
    public Element deleteLast() {
        return this.$ceylon$collection$MutableList$this$.deleteLast();
    }

    @Ignore
    public List.impl<? extends Element> $ceylon$language$List$impl() {
        return this.$ceylon$language$List$this$;
    }

    @Ignore
    public <Result> Sequential collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$List$this$.collect($reified$Result, collecting);
    }

    @Ignore
    public boolean defines(Integer index) {
        return this.$ceylon$language$List$this$.defines(index);
    }

    @Ignore
    public boolean endsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.endsWith(sublist);
    }

    @Ignore
    public Integer firstIndexWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.firstIndexWhere(selecting);
    }

    @Override
    @Ignore
    public final Element get(Integer index) {
        return (Element)this.$ceylon$language$List$this$.get(index);
    }

    @Override
    @Ignore
    public Element getFromLast(long index) {
        return (Element)this.$ceylon$language$List$this$.getFromLast(index);
    }

    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> indexesWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.indexesWhere(selecting);
    }

    @Override
    @Ignore
    public List<? extends Element> initial(long length) {
        return this.$ceylon$language$List$this$.initial(length);
    }

    @Ignore
    public List<? extends Integer> getKeys() {
        return this.$ceylon$language$List$this$.getKeys();
    }

    @Override
    @Ignore
    public Element getLast() {
        return (Element)this.$ceylon$language$List$this$.getLast();
    }

    @Ignore
    public Integer lastIndexWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.lastIndexWhere(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$List$this$.longerThan(length);
    }

    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor $reified$Result, Callable<? extends Result> mapping) {
        return this.$ceylon$language$List$this$.mapElements($reified$Result, mapping);
    }

    @Ignore
    public final <Other> long patch$from(TypeDescriptor $reified$Other, List<? extends Other> list) {
        return this.$ceylon$language$List$this$.patch$from($reified$Other, list);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list) {
        long $ceylontmp$from$0 = this.patch$from($reified$Other, list);
        long $ceylontmp$length$1 = this.patch$length($reified$Other, list, $ceylontmp$from$0);
        return this.patch$canonical$($reified$Other, list, $ceylontmp$from$0, $ceylontmp$length$1);
    }

    @Ignore
    public final <Other> long patch$length(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        return this.$ceylon$language$List$this$.patch$length($reified$Other, list, from);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        long $ceylontmp$length$2 = this.patch$length($reified$Other, list, from);
        return this.patch$canonical$($reified$Other, list, from, $ceylontmp$length$2);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Ignore
    private <Other> List patch$canonical$(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Override
    @Ignore
    public List<? extends Element> repeat(long times) {
        return this.$ceylon$language$List$this$.repeat(times);
    }

    @Override
    @Ignore
    public List<? extends Element> getRest() {
        return this.$ceylon$language$List$this$.getRest();
    }

    @Override
    @Ignore
    public List<? extends Element> getReversed() {
        return this.$ceylon$language$List$this$.getReversed();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$List$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Sequence slice(long index) {
        return this.$ceylon$language$List$this$.slice(index);
    }

    @Ignore
    public boolean startsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.startsWith(sublist);
    }

    @Override
    @Ignore
    public List<? extends Element> sublist(long from, long to) {
        return this.$ceylon$language$List$this$.sublist(from, to);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistFrom(long from) {
        return this.$ceylon$language$List$this$.sublistFrom(from);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistTo(long to) {
        return this.$ceylon$language$List$this$.sublistTo(to);
    }

    @Override
    @Ignore
    public List<? extends Element> terminal(long length) {
        return this.$ceylon$language$List$this$.terminal(length);
    }

    @Override
    @Ignore
    public List<? extends Element> trim(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trim(trimming);
    }

    @Override
    @Ignore
    public List<? extends Element> trimLeading(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trimLeading(trimming);
    }

    @Override
    @Ignore
    public List<? extends Element> trimTrailing(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trimTrailing(trimming);
    }

    @Ignore
    public Collection.impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Iterable.impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$this$.getDistinct();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$3 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$3);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public Sequential sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Correspondence.impl<? super Integer, ? extends Element> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends Integer, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @Override
    @Ignore
    public ListMutator$impl<? super Element> $ceylon$collection$ListMutator$impl() {
        return this.$ceylon$collection$ListMutator$this$;
    }

    @Ignore
    public SearchableList.impl<Element> $ceylon$language$SearchableList$impl() {
        return this.$ceylon$language$SearchableList$this$;
    }

    @Ignore
    public final long firstInclusion$from(List<? extends Element> sublist) {
        return this.$ceylon$language$SearchableList$this$.firstInclusion$from(sublist);
    }

    @Ignore
    public Integer firstInclusion(List<? extends Element> sublist) {
        long $ceylontmp$from$4 = this.firstInclusion$from(sublist);
        return this.firstInclusion$canonical$(sublist, $ceylontmp$from$4);
    }

    @Ignore
    public Integer firstInclusion(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.firstInclusion(sublist, from);
    }

    @Ignore
    private Integer firstInclusion$canonical$(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.firstInclusion(sublist, from);
    }

    @Ignore
    public final long firstOccurrence$from(Element element) {
        return this.$ceylon$language$SearchableList$this$.firstOccurrence$from(element);
    }

    @Ignore
    public final long firstOccurrence$length(Element element, long from) {
        return this.$ceylon$language$SearchableList$this$.firstOccurrence$length(element, from);
    }

    @Ignore
    public final long includes$from(List<? extends Element> sublist) {
        return this.$ceylon$language$SearchableList$this$.includes$from(sublist);
    }

    @Ignore
    public boolean includes(List<? extends Element> sublist) {
        long $ceylontmp$from$5 = this.includes$from(sublist);
        return this.includes$canonical$(sublist, $ceylontmp$from$5);
    }

    @Ignore
    public boolean includes(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.includes(sublist, from);
    }

    @Ignore
    private boolean includes$canonical$(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.includes(sublist, from);
    }

    @Ignore
    public boolean includesAt(long index, List<? extends Element> sublist) {
        return this.$ceylon$language$SearchableList$this$.includesAt(index, sublist);
    }

    @Ignore
    public final long inclusions$from(List<? extends Element> sublist) {
        return this.$ceylon$language$SearchableList$this$.inclusions$from(sublist);
    }

    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(List<? extends Element> sublist) {
        long $ceylontmp$from$6 = this.inclusions$from(sublist);
        return this.inclusions$canonical$(sublist, $ceylontmp$from$6);
    }

    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.inclusions(sublist, from);
    }

    @Ignore
    private Iterable<? extends Integer, ? extends java.lang.Object> inclusions$canonical$(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.inclusions(sublist, from);
    }

    @Ignore
    public final long lastInclusion$from(List<? extends Element> sublist) {
        return this.$ceylon$language$SearchableList$this$.lastInclusion$from(sublist);
    }

    @Ignore
    public Integer lastInclusion(List<? extends Element> sublist) {
        long $ceylontmp$from$7 = this.lastInclusion$from(sublist);
        return this.lastInclusion$canonical$(sublist, $ceylontmp$from$7);
    }

    @Ignore
    public Integer lastInclusion(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.lastInclusion(sublist, from);
    }

    @Ignore
    private Integer lastInclusion$canonical$(List<? extends Element> sublist, long from) {
        return this.$ceylon$language$SearchableList$this$.lastInclusion(sublist, from);
    }

    @Ignore
    public final long lastOccurrence$from(Element element) {
        return this.$ceylon$language$SearchableList$this$.lastOccurrence$from(element);
    }

    @Ignore
    public final long lastOccurrence$length(Element element, long from) {
        return this.$ceylon$language$SearchableList$this$.lastOccurrence$length(element, from);
    }

    @Ignore
    public final long occurrences$from(Element element) {
        return this.$ceylon$language$SearchableList$this$.occurrences$from(element);
    }

    @Ignore
    public final long occurrences$length(Element element, long from) {
        return this.$ceylon$language$SearchableList$this$.occurrences$length(element, from);
    }

    @Ignore
    public final long occurs$from(Element element) {
        return this.$ceylon$language$SearchableList$this$.occurs$from(element);
    }

    @Ignore
    public final long occurs$length(Element element, long from) {
        return this.$ceylon$language$SearchableList$this$.occurs$length(element, from);
    }

    @DocAnnotation$annotation$(description="The initial size of the backing array.")
    private final long getInitialCapacity$priv$() {
        return this.initialCapacity;
    }

    @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.")
    private final double getGrowthFactor$priv$() {
        return this.growthFactor;
    }

    @DocAnnotation$annotation$(description="The underlying array.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<Element?>")
    @NonNull
    private final Array<Element> getArray$priv$() {
        return this.array;
    }

    private final void setArray$priv$(@Name(value="array") @TypeInfo(value="ceylon.language::Array<Element?>") @NonNull Array<Element> array) {
        this.array = array;
    }

    @DocAnnotation$annotation$(description="The number of slots of the backing array that actually\nhold elements of this list.")
    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    @TypeInfo(value="ceylon.language::Array<Element?>")
    @NonNull
    private final Array<Element> store$priv$(@Name(value="capacity") long capacity) {
        return new Array(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element}), Array.ofSize_, capacity, null);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    private final void grow$priv$(@Name(value="increment") long increment) {
        long maxArraySize;
        long neededCapacity = this.getLength$priv$() + increment;
        if (neededCapacity > (maxArraySize = runtime_.get_().getMaxArraySize())) {
            throw new OverflowException();
        }
        if (neededCapacity > this.getArray$priv$().getSize()) {
            long grownCapacity = Float.getInteger((double)((double)neededCapacity * this.getGrowthFactor$priv$()));
            long newCapacity = grownCapacity < neededCapacity || grownCapacity > maxArraySize ? neededCapacity : grownCapacity;
            Array<Element> grown = this.store$priv$(newCapacity);
            this.getArray$priv$().copyTo(grown);
            this.setArray$priv$(grown);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object add(@Name(value="element") @TypeInfo(value="Element") Element element) {
        void var2_2;
        this.grow$priv$(1L);
        Array<Element> array = this.getArray$priv$();
        long $ceylontmp$op$17 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$17 + 1L);
        array.set((long)var2_2, element);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object addAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        java.lang.Object elem$19;
        Sequential sequence = elements.sequence();
        this.grow$priv$(sequence.getSize());
        Iterator element$iterator$$20 = ((Iterable)sequence).iterator();
        while (!((elem$19 = element$iterator$$20.next()) instanceof Finished)) {
            java.lang.Object element = elem$19;
            Array<Element> array = this.getArray$priv$();
            long $ceylontmp$op$21 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$21 + 1L);
            array.set($ceylontmp$op$21, element);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public java.lang.Object swap(@Name(value="i") long i, @Name(value="j") long j) {
        long lhs$22 = 0L;
        long middle$23 = i;
        long rhs$24 = this.getLength$priv$();
        if (lhs$22 <= middle$23 && middle$23 < rhs$24) {
            long lhs$25 = 0L;
            long middle$26 = j;
            long rhs$27 = this.getLength$priv$();
            if (lhs$25 > middle$26 || middle$26 >= rhs$27) {
                throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tunviolated " + "0<=i<length" + System.lineSeparator() + "\tviolated " + "0<=j<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$25), (java.lang.Object)Integer.instance((long)middle$26), (java.lang.Object)Integer.instance((long)rhs$27)));
            }
        } else {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tviolated " + "0<=i<length" + System.lineSeparator() + "\tuntested " + "0<=j<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$22), (java.lang.Object)Integer.instance((long)middle$23), (java.lang.Object)Integer.instance((long)rhs$24)));
        }
        this.getArray$priv$().swap(i, j);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public java.lang.Object move(@Name(value="i") long i, @Name(value="j") long j) {
        long lhs$28 = 0L;
        long middle$29 = i;
        long rhs$30 = this.getLength$priv$();
        if (lhs$28 <= middle$29 && middle$29 < rhs$30) {
            long lhs$31 = 0L;
            long middle$32 = j;
            long rhs$33 = this.getLength$priv$();
            if (lhs$31 > middle$32 || middle$32 >= rhs$33) {
                throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tunviolated " + "0<=i<length" + System.lineSeparator() + "\tviolated " + "0<=j<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$31), (java.lang.Object)Integer.instance((long)middle$32), (java.lang.Object)Integer.instance((long)rhs$33)));
            }
        } else {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tviolated " + "0<=i<length" + System.lineSeparator() + "\tuntested " + "0<=j<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$28), (java.lang.Object)Integer.instance((long)middle$29), (java.lang.Object)Integer.instance((long)rhs$30)));
        }
        this.getArray$priv$().move(i, j);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object clear() {
        this.setLength$priv$(0L);
        this.setArray$priv$(this.store$priv$(this.getInitialCapacity$priv$()));
        return null;
    }

    @DocAnnotation$annotation$(description="The size of the backing array, which must be at least\nas large as the [[size]] of the list.")
    @SharedAnnotation$annotation$
    @Transient
    public final long getCapacity() {
        return this.getArray$priv$().getSize();
    }

    public final void setCapacity(@Name(value="capacity") long capacity) {
        long lhs$34 = capacity;
        long rhs$35 = this.getSize();
        if (lhs$34 < rhs$35) {
            throw new AssertionError("Assertion failed: capacity must be at least as large as list size" + System.lineSeparator() + "\tviolated " + "capacity >= size" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$34), (java.lang.Object)Integer.instance((long)rhs$35)));
        }
        long lhs$36 = capacity;
        long rhs$37 = runtime_.get_().getMaxArraySize();
        if (lhs$36 > rhs$37) {
            throw new AssertionError("Assertion failed: capacity too large" + System.lineSeparator() + "\tviolated " + "capacity <= runtime.maxArraySize" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$36), (java.lang.Object)Integer.instance((long)rhs$37)));
        }
        Array<Element> resized = this.store$priv$(capacity);
        this.getArray$priv$().copyTo(resized, 0L, 0L, this.getLength$priv$());
        this.setArray$priv$(resized);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element getFromFirst(@Name(value="index") long index) {
        void var3_3;
        long middle$40 = index;
        java.lang.Object $ceylontmp$ifResult$38 = 0L <= middle$40 && middle$40 < this.getLength$priv$() ? this.getArray$priv$().getFromFirst(index) : null;
        return var3_3;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        boolean start$42 = false;
        long length$43 = this.getSize();
        for (long i$44 = 0L; i$44 < length$43; ++i$44) {
            java.lang.Object elem$47;
            long index = i$44 + 0L;
            java.lang.Object elem$46 = this.getArray$priv$().getFromFirst(index);
            if (elem$46 == null || !(elem$47 = elem$46).equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    @NonNull
    public final Iterator<? extends Element> iterator() {
        @Ceylon(major=8, minor=1)
        @Name(value="anonymous#0")
        @LocalDeclaration(qualifier="1")
        @Object
        @SatisfiedTypes(value={"ceylon.language::Iterator<Element>"})
        class Anonymous_0_
        implements Serializable,
        ReifiedType,
        Iterator<Element> {
            @Ignore
            private long index = 0L;

            Anonymous_0_() {
            }

            @VariableAnnotation$annotation$
            private final long getIndex$priv$() {
                return this.index;
            }

            private final void setIndex$priv$(@Name(value="index") long index) {
                this.index = index;
            }

            @SharedAnnotation$annotation$
            @ActualAnnotation$annotation$
            @TypeInfo(value="ceylon.language::Finished|Element", erased=true)
            @Nullable
            public final java.lang.Object next() {
                if (this.getIndex$priv$() < ArrayList.this.getLength$priv$()) {
                    Array array = ArrayList.this.getArray$priv$();
                    long $ceylontmp$op$52 = this.getIndex$priv$();
                    this.setIndex$priv$($ceylontmp$op$52 + 1L);
                    java.lang.Object next$51 = array.getFromFirst($ceylontmp$op$52);
                    if (next$51 != null) {
                        java.lang.Object next$54 = next$51;
                        return next$54;
                    }
                    if (!Util.isReified(null, (TypeDescriptor)ArrayList.this.$reified$Element)) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Element null" + Util.assertIsFailed((boolean)false, (TypeDescriptor)ArrayList.this.$reified$Element, null));
                    }
                    return null;
                }
                return finished_.get_();
            }

            @Ignore
            public TypeDescriptor $getType$() {
                return TypeDescriptor.member((TypeDescriptor)TypeDescriptor.member((TypeDescriptor)TypeDescriptor.klass(ArrayList.class, (TypeDescriptor[])new TypeDescriptor[]{ArrayList.this.$reified$Element}), (TypeDescriptor)TypeDescriptor.functionOrValue((String)"iterator", (TypeDescriptor[])new TypeDescriptor[0])), (TypeDescriptor)TypeDescriptor.klass(Anonymous_0_.class, (TypeDescriptor[])new TypeDescriptor[0]));
            }
        }
        return new Anonymous_0_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object insert(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        long lhs$55 = 0L;
        long middle$56 = index;
        long rhs$57 = this.getLength$priv$();
        if (lhs$55 > middle$56 || middle$56 > rhs$57) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlength of the list" + System.lineSeparator() + "\tviolated " + "0 <= index <= length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$55), (java.lang.Object)Integer.instance((long)middle$56), (java.lang.Object)Integer.instance((long)rhs$57)));
        }
        this.grow$priv$(1L);
        if (index < this.getLength$priv$()) {
            this.getArray$priv$().copyTo(this.getArray$priv$(), index, index + 1L, this.getLength$priv$() - index);
        }
        long $ceylontmp$op$59 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$59 + 1L);
        this.getArray$priv$().set(index, element);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object insertAll(@Name(value="index") long index, @Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        long lhs$60 = 0L;
        long middle$61 = index;
        long rhs$62 = this.getLength$priv$();
        if (lhs$60 > middle$61 || middle$61 > rhs$62) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlength of the list" + System.lineSeparator() + "\tviolated " + "0 <= index <= length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$60), (java.lang.Object)Integer.instance((long)middle$61), (java.lang.Object)Integer.instance((long)rhs$62)));
        }
        Sequential sequence = elements.sequence();
        long size = sequence.getSize();
        if (size > 0L) {
            java.lang.Object elem$66;
            this.grow$priv$(size);
            if (index < this.getLength$priv$()) {
                this.getArray$priv$().copyTo(this.getArray$priv$(), index, index + size, this.getLength$priv$() - index);
            }
            long i = index;
            Iterator element$iterator$$67 = ((Iterable)sequence).iterator();
            while (!((elem$66 = element$iterator$$67.next()) instanceof Finished)) {
                java.lang.Object element = elem$66;
                this.getArray$priv$().set(i++, element);
            }
            long $ceylontmp$op$68 = this.getLength$priv$() + size;
            this.setLength$priv$($ceylontmp$op$68);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element delete(@Name(value="index") long index) {
        long middle$70 = index;
        if (0L <= middle$70 && middle$70 < this.getLength$priv$()) {
            java.lang.Object result = this.getArray$priv$().getFromFirst(index);
            this.getArray$priv$().copyTo(this.getArray$priv$(), index + 1L, index, this.getLength$priv$() - index - 1L);
            long $ceylontmp$op$71 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$71 - 1L);
            this.getArray$priv$().set(this.getLength$priv$(), null);
            return (Element)result;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long remove(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element) {
        long i = 0L;
        long j = 0L;
        while (i < this.getLength$priv$()) {
            java.lang.Object elem$73 = this.getArray$priv$().getFromFirst(i++);
            if (elem$73 != null) {
                java.lang.Object elem$74 = elem$73;
                if (elem$74.equals(element)) continue;
                this.getArray$priv$().set(j++, elem$74);
                continue;
            }
            this.getArray$priv$().set(j++, null);
        }
        this.setLength$priv$(j);
        while (j < i) {
            this.getArray$priv$().set(j++, null);
        }
        return i - this.getLength$priv$();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long removeAll(@Name(value="elements") @TypeInfo(value="{Element&ceylon.language::Object*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        TypeDescriptor arg$76$reified$0 = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, ceylon.language.Object.$TypeDescriptor$});
        ConstantIterable arg$76$2 = new ConstantIterable(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, ceylon.language.Object.$TypeDescriptor$}), Null.$TypeDescriptor$, elements, new java.lang.Object[0]);
        Stability arg$76$0 = HashSet.HashSet$stability(arg$76$reified$0);
        Hashtable arg$76$1 = HashSet.HashSet$hashtable(arg$76$reified$0, arg$76$0);
        HashSet set = new HashSet(arg$76$reified$0, arg$76$0, arg$76$1, arg$76$2);
        long i = 0L;
        long j = 0L;
        while (i < this.getLength$priv$()) {
            java.lang.Object elem$78 = this.getArray$priv$().getFromFirst(i++);
            if (elem$78 != null) {
                java.lang.Object elem$79 = elem$78;
                java.lang.Object $ceylontmp$81 = elem$79;
                if (set.contains($ceylontmp$81)) continue;
                this.getArray$priv$().set(j++, elem$79);
                continue;
            }
            this.getArray$priv$().set(j++, null);
        }
        this.setLength$priv$(j);
        while (j < i) {
            this.getArray$priv$().set(j++, null);
        }
        return i - this.getLength$priv$();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element) {
        Integer index$83 = this.firstOccurrence(element);
        if (index$83 != null) {
            long index$84 = index$83.longValue();
            this.delete(index$84);
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element) {
        Integer index$86 = this.lastOccurrence(element);
        if (index$86 != null) {
            long index$87 = index$86.longValue();
            this.delete(index$87);
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Integer index$89 = this.firstIndexWhere(selecting);
        if (index$89 != null) {
            long index$90 = index$89.longValue();
            return this.delete(index$90);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Integer index$92 = this.lastIndexWhere(selecting);
        if (index$92 != null) {
            long index$93 = index$92.longValue();
            return this.delete(index$93);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long removeWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        long i = 0L;
        long j = 0L;
        while (i < this.getLength$priv$()) {
            java.lang.Object elem$95 = this.getArray$priv$().getFromFirst(i++);
            if (elem$95 != null) {
                java.lang.Object elem$96 = elem$95;
                if (((Boolean)selecting.$call$(elem$96)).booleanValue()) continue;
                this.getArray$priv$().set(j++, elem$96);
                continue;
            }
            this.getArray$priv$().set(j++, null);
        }
        this.setLength$priv$(j);
        while (j < i) {
            this.getArray$priv$().set(j++, null);
        }
        return i - this.getLength$priv$();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long prune() {
        long i = 0L;
        long j = 0L;
        while (i < this.getLength$priv$()) {
            java.lang.Object element$99 = this.getArray$priv$().getFromFirst(i++);
            if (element$99 == null) continue;
            java.lang.Object element$100 = element$99;
            this.getArray$priv$().set(j++, element$100);
        }
        long removed = i - j;
        this.setLength$priv$(j);
        while (j < i) {
            this.getArray$priv$().set(j++, null);
        }
        return removed;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long replace(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        long count = 0L;
        for (long i = 0L; i < this.getLength$priv$(); ++i) {
            java.lang.Object elem$103;
            java.lang.Object elem$102 = this.getArray$priv$().getFromFirst(i);
            if (elem$102 == null || !(elem$103 = elem$102).equals(element)) continue;
            this.getArray$priv$().set(i, replacement);
            ++count;
        }
        return count;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Integer index$105 = this.firstOccurrence(element);
        if (index$105 != null) {
            long index$106 = index$105.longValue();
            this.getArray$priv$().set(index$106, replacement);
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Integer index$108 = this.lastOccurrence(element);
        if (index$108 != null) {
            long index$109 = index$108.longValue();
            this.getArray$priv$().set(index$109, replacement);
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Integer index$111 = this.firstIndexWhere(selecting);
        if (index$111 != null) {
            long index$112 = index$111.longValue();
            Element old = this.getFromFirst(index$112);
            this.getArray$priv$().set(index$112, replacement);
            return old;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Integer index$114 = this.lastIndexWhere(selecting);
        if (index$114 != null) {
            long index$115 = index$114.longValue();
            Element old = this.getFromFirst(index$115);
            this.getArray$priv$().set(index$115, replacement);
            return old;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long replaceWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        long count = 0L;
        for (long i = 0L; i < this.getLength$priv$(); ++i) {
            java.lang.Object elem$118;
            java.lang.Object elem$117 = this.getArray$priv$().getFromFirst(i);
            if (elem$117 == null || !((Boolean)selecting.$call$(elem$118 = elem$117)).booleanValue()) continue;
            this.getArray$priv$().set(i, replacement);
            ++count;
        }
        return count;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object infill(@Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        for (long i = 0L; i < this.getLength$priv$(); ++i) {
            if (this.getArray$priv$().getFromFirst(i) != null) continue;
            this.getArray$priv$().set(i, replacement);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object set(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        long lhs$120 = 0L;
        long middle$121 = index;
        long rhs$122 = this.getLength$priv$();
        if (lhs$120 > middle$121 || middle$121 >= rhs$122) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tviolated " + "0<=index<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$120), (java.lang.Object)Integer.instance((long)middle$121), (java.lang.Object)Integer.instance((long)rhs$122)));
        }
        this.getArray$priv$().set(index, element);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List span(@Name(value="from") @NonNull Integer from, @Name(value="to") @NonNull Integer to) {
        Sequence $pattern$tuple$123 = spanToMeasure_.spanToMeasure(from.longValue(), to.longValue(), this.getLength$priv$());
        long start = ((Integer)$pattern$tuple$123.getFromFirst(0L)).longValue();
        long len = ((Integer)$pattern$tuple$123.getFromFirst(1L)).longValue();
        boolean reversed = ((Boolean)$pattern$tuple$123.getFromFirst(2L)).booleanValue();
        long arg$124$0 = len;
        double arg$124$1 = this.getGrowthFactor$priv$();
        Iterable arg$124$2 = this.skip(start).take(len);
        TypeDescriptor arg$124$reified$0 = this.$reified$Element;
        List result = new ArrayList(arg$124$reified$0, arg$124$0, arg$124$1, arg$124$2);
        return reversed ? result.getReversed() : result;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object deleteSpan(@Name(value="from") long from, @Name(value="to") long to) {
        Sequence $pattern$tuple$125 = spanToMeasure_.spanToMeasure(from, to, this.getLength$priv$());
        long start = ((Integer)$pattern$tuple$125.getFromFirst(0L)).longValue();
        long len = ((Integer)$pattern$tuple$125.getFromFirst(1L)).longValue();
        boolean _ = ((Boolean)$pattern$tuple$125.getFromFirst(2L)).booleanValue();
        if (start < this.getLength$priv$() && len > 0L) {
            long fstTrailing = start + len;
            this.getArray$priv$().copyTo(this.getArray$priv$(), fstTrailing, start, this.getLength$priv$() - fstTrailing);
            long i = this.getLength$priv$() - len;
            while (i < this.getLength$priv$()) {
                this.getArray$priv$().set(i++, null);
            }
            long $ceylontmp$op$127 = this.getLength$priv$() - len;
            this.setLength$priv$($ceylontmp$op$127);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List measure(@Name(value="from") @NonNull Integer from, @Name(value="length") long length) {
        Sequence<? extends Integer> tuple$128 = measureToSpan_.measureToSpan(from.longValue(), length);
        return this.span((Integer)tuple$128.get(Integer.instance((long)0L)), (Integer)tuple$128.get(Integer.instance((long)1L)));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object deleteMeasure(@Name(value="from") long from, @Name(value="length") long length) {
        Sequence<? extends Integer> tuple$130 = measureToSpan_.measureToSpan(from, length);
        this.deleteSpan(((Integer)tuple$130.get(Integer.instance((long)0L))).longValue(), ((Integer)tuple$130.get(Integer.instance((long)1L))).longValue());
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object truncate(@Name(value="size") long size) {
        long lhs$132 = size;
        long rhs$133 = 0L;
        if (lhs$132 < rhs$133) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "size >= 0" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$132), (java.lang.Object)Integer.instance((long)rhs$133)));
        }
        if (size < this.getLength$priv$()) {
            long i = size;
            while (i < this.getLength$priv$()) {
                this.getArray$priv$().set(i++, null);
            }
            this.setLength$priv$(size);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List spanFrom(@Name(value="from") @NonNull Integer from) {
        return from.longValue() >= this.getLength$priv$() ? new ArrayList(TypeDescriptor.NothingType) : this.span(from, Integer.instance((long)(this.getLength$priv$() - 1L)));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List spanTo(@Name(value="to") @NonNull Integer to) {
        return to.longValue() < 0L ? new ArrayList(TypeDescriptor.NothingType) : this.span(Integer.instance((long)0L), to);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getFirst() {
        void var1_1;
        java.lang.Object $ceylontmp$ifResult$135 = this.getLength$priv$() > 0L ? this.getArray$priv$().getFromFirst(0L) : null;
        return var1_1;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Transient
    @Nullable
    public final Integer getLastIndex() {
        return this.getLength$priv$() >= 1L ? Integer.instance((long)(this.getLength$priv$() - 1L)) : null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        java.lang.Object that$138 = that;
        if (that$138 instanceof ArrayList && Util.isReified((java.lang.Object)that$138, (TypeDescriptor)TypeDescriptor.klass(ArrayList.class, (TypeDescriptor[])new TypeDescriptor[]{Anything.$TypeDescriptor$}))) {
            ArrayList that$139 = (ArrayList)that$138;
            if (this == that$139) {
                return true;
            }
            if (this.getLength$priv$() != that$139.getLength$priv$()) {
                return false;
            }
            boolean start$143 = false;
            long length$144 = this.getLength$priv$();
            for (long i$145 = 0L; i$145 < length$144; ++i$145) {
                long index = i$145 + 0L;
                java.lang.Object thisElement = this.getArray$priv$().getFromFirst(index);
                java.lang.Object thatElement = that$139.getArray$priv$().getFromFirst(index);
                java.lang.Object thisElement$147 = thisElement;
                if (thisElement$147 != null) {
                    java.lang.Object thisElement$150 = thisElement$147;
                    java.lang.Object thatElement$152 = thatElement;
                    if (thatElement$152 == null) {
                        java.lang.Object thatElement$155 = thatElement$152;
                        return false;
                    }
                    java.lang.Object thatElement$153 = thatElement$152;
                    if (thisElement$150.equals(thatElement$153)) continue;
                    return false;
                }
                java.lang.Object thisElement$148 = thisElement$147;
                if (thatElement == null) continue;
                return false;
            }
            return true;
        }
        return this.$ceylon$language$List$this$.equals(that);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long hash = 1L;
        boolean start$158 = false;
        long length$159 = this.getLength$priv$();
        for (long i$160 = 0L; i$160 < length$159; ++i$160) {
            long index = i$160 + 0L;
            hash *= 31L;
            java.lang.Object elem$162 = this.getArray$priv$().getFromFirst(index);
            if (elem$162 == null) continue;
            java.lang.Object elem$163 = elem$162;
            hash += (long)elem$163.hashCode();
        }
        long $ceylontmp$hash$164 = hash;
        return (int)($ceylontmp$hash$164 ^ $ceylontmp$hash$164 >>> 32);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object push(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return this.add(element);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element pop() {
        return this.deleteLast();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getTop() {
        return (Element)this.getLast();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object offer(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return this.add(element);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element accept() {
        return this.deleteFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getBack() {
        return (Element)this.getLast();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getFront() {
        return this.getFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::ArrayList<Element>")
    @NonNull
    public final ArrayList<Element> $clone() {
        return new ArrayList<Element>(this.$reified$Element, copy_, this);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element find(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        return (Element)this.getArray$priv$().find(selecting);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        return (Element)this.getArray$priv$().findLast(selecting);
    }

    @DocAnnotation$annotation$(description="Sorts the elements in this list according to the\norder induced by the given \n[[comparison function|comparing]]. Null elements are \nsorted to the end of the list. This operation modifies \nthe list.")
    @SharedAnnotation$annotation$
    public final void sortInPlace(final @Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element&ceylon.language::Object, Element&ceylon.language::Object)") @NonNull Callable<? extends Comparison> comparing) {
        this.getArray$priv$().sortInPlace((Callable)new AbstractCallable<Comparison>(Comparison.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element}), TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Comparison(Element?, Element?)", -1){

            @Ignore
            public Comparison $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                Comparison $ceylontmp$ifResult$165;
                java.lang.Object y$170;
                java.lang.Object x$168;
                java.lang.Object x = $param$0;
                java.lang.Object y = $param$1;
                boolean $ceylontmp$if$166 = false;
                java.lang.Object x$167 = x;
                if (x$167 != null) {
                    x$168 = x$167;
                    java.lang.Object y$169 = y;
                    if (y$169 != null) {
                        y$170 = y$169;
                        $ceylontmp$if$166 = true;
                    } else {
                        y$170 = null;
                    }
                } else {
                    x$168 = null;
                    y$170 = null;
                }
                if ($ceylontmp$if$166) {
                    $ceylontmp$ifResult$165 = (Comparison)comparing.$call$(x$168, y$170);
                } else {
                    smaller_ $ceylontmp$ifResult$171;
                    boolean $ceylontmp$if$172 = false;
                    if (x != null && y == null) {
                        $ceylontmp$if$172 = true;
                    }
                    if ($ceylontmp$if$172) {
                        $ceylontmp$ifResult$171 = smaller_.get_();
                    } else {
                        boolean $ceylontmp$if$174 = false;
                        if (y != null && x == null) {
                            $ceylontmp$if$174 = true;
                        }
                        java.lang.Object $ceylontmp$ifResult$173 = $ceylontmp$if$174 ? larger_.get_() : equal_.get_();
                        $ceylontmp$ifResult$171 = $ceylontmp$ifResult$173;
                    }
                    $ceylontmp$ifResult$165 = $ceylontmp$ifResult$171;
                }
                return $ceylontmp$ifResult$165;
            }
        });
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(final @Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") @NonNull Callable<? extends java.lang.Object> step) {
        if (Util.isReified(null, (TypeDescriptor)this.$reified$Element)) {
            this.getArray$priv$().take(this.getLength$priv$()).each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Anything(Element?)", -1){

                @Ignore
                public java.lang.Object $call$(java.lang.Object $param$0) {
                    java.lang.Object e = $param$0;
                    java.lang.Object $ceylontmp$179 = e;
                    step.$call$($ceylontmp$179 != null ? $ceylontmp$179 : null);
                    return null;
                }
            });
        } else {
            this.getArray$priv$().take(this.getLength$priv$()).each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Anything(Element?)", -1){

                @Ignore
                public java.lang.Object $call$(java.lang.Object $param$0) {
                    java.lang.Object e = $param$0;
                    java.lang.Object e$177 = null;
                    e$177 = e;
                    if (e$177 == null) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists e");
                    }
                    java.lang.Object e$178 = e$177;
                    step.$call$(e$178);
                    return null;
                }
            });
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        if (Util.isReified(null, (TypeDescriptor)this.$reified$Element)) {
            return this.getArray$priv$().take(this.getLength$priv$()).count((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

                @Ignore
                public Boolean $call$(java.lang.Object $param$0) {
                    java.lang.Object e = $param$0;
                    java.lang.Object $ceylontmp$184 = e;
                    return (Boolean)selecting.$call$($ceylontmp$184 != null ? $ceylontmp$184 : null);
                }
            });
        }
        return this.getArray$priv$().take(this.getLength$priv$()).count((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                java.lang.Object e = $param$0;
                java.lang.Object e$182 = null;
                e$182 = e;
                if (e$182 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists e");
                }
                java.lang.Object e$183 = e$182;
                return (Boolean)selecting.$call$(e$183);
            }
        });
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean every(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        if (Util.isReified(null, (TypeDescriptor)this.$reified$Element)) {
            return this.getArray$priv$().take(this.getLength$priv$()).every((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

                @Ignore
                public Boolean $call$(java.lang.Object $param$0) {
                    java.lang.Object e = $param$0;
                    java.lang.Object $ceylontmp$189 = e;
                    return (Boolean)selecting.$call$($ceylontmp$189 != null ? $ceylontmp$189 : null);
                }
            });
        }
        return this.getArray$priv$().take(this.getLength$priv$()).every((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                java.lang.Object e = $param$0;
                java.lang.Object e$187 = null;
                e$187 = e;
                if (e$187 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists e");
                }
                java.lang.Object e$188 = e$187;
                return (Boolean)selecting.$call$(e$188);
            }
        });
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean any(final @Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        if (Util.isReified(null, (TypeDescriptor)this.$reified$Element)) {
            return this.getArray$priv$().take(this.getLength$priv$()).any((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

                @Ignore
                public Boolean $call$(java.lang.Object $param$0) {
                    java.lang.Object e = $param$0;
                    java.lang.Object $ceylontmp$194 = e;
                    return (Boolean)selecting.$call$($ceylontmp$194 != null ? $ceylontmp$194 : null);
                }
            });
        }
        return this.getArray$priv$().take(this.getLength$priv$()).any((Callable)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Boolean(Element?)", -1){

            @Ignore
            public Boolean $call$(java.lang.Object $param$0) {
                java.lang.Object e = $param$0;
                java.lang.Object e$192 = null;
                e$192 = e;
                if (e$192 == null) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists e");
                }
                java.lang.Object e$193 = e$192;
                return (Boolean)selecting.$call$(e$193);
            }
        });
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Result|Element|ceylon.language::Null", erased=true)
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @Nullable
    public final <Result> java.lang.Object reduce(@Ignore TypeDescriptor $reified$Result, final @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="Result(Result|Element, Element)") @NonNull Callable<? extends Result> accumulating) {
        if (Util.isReified(null, (TypeDescriptor)this.$reified$Element)) {
            return this.getArray$priv$().take(this.getLength$priv$()).reduce($reified$Result, (Callable)new AbstractCallable<Result>($reified$Result, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{$reified$Result, Null.$TypeDescriptor$, this.$reified$Element}), TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Result(Result|Null|Element, Element?)", -1){

                @Ignore
                public Result $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                    java.lang.Object partial = $param$0;
                    java.lang.Object element = $param$1;
                    java.lang.Object $ceylontmp$201 = partial;
                    java.lang.Object object = $ceylontmp$201 != null ? $ceylontmp$201 : null;
                    java.lang.Object $ceylontmp$202 = element;
                    return accumulating.$call$(object, $ceylontmp$202 != null ? $ceylontmp$202 : null);
                }
            });
        }
        return this.getArray$priv$().take(this.getLength$priv$()).reduce($reified$Result, (Callable)new AbstractCallable<Result>($reified$Result, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{$reified$Result, Null.$TypeDescriptor$, this.$reified$Element}), TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}), "Result(Result|Null|Element, Element?)", -1){

            @Ignore
            public Result $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                java.lang.Object element$199;
                java.lang.Object partial$198;
                java.lang.Object partial = $param$0;
                java.lang.Object element = $param$1;
                java.lang.Object partial$197 = null;
                partial$197 = partial;
                if (partial$197 != null) {
                    partial$198 = partial$197;
                    element$199 = null;
                    element$199 = element;
                    if (element$199 == null) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tunviolated " + "exists partial" + System.lineSeparator() + "\tviolated " + "exists element");
                    }
                } else {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists partial" + System.lineSeparator() + "\tuntested " + "exists element");
                }
                java.lang.Object element$200 = element$199;
                return accumulating.$call$(partial$198, element$200);
            }
        });
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean occursAt(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        boolean $ceylontmp$ifResult$203 = index < this.getLength$priv$() ? this.getArray$priv$().occursAt(index, element) : false;
        return $ceylontmp$ifResult$203;
    }

    @Ignore
    public final Integer firstOccurrence(Element element) {
        long $ceylontmp$from$210 = this.firstOccurrence$from(element);
        long $ceylontmp$length$211 = this.firstOccurrence$length(element, $ceylontmp$from$210);
        return this.firstOccurrence$canonical$(element, $ceylontmp$from$210, $ceylontmp$length$211);
    }

    @Ignore
    public final Integer firstOccurrence(Element element, long from) {
        long $ceylontmp$length$212 = this.firstOccurrence$length(element, from);
        return this.firstOccurrence$canonical$(element, from, $ceylontmp$length$212);
    }

    @Ignore
    private Integer firstOccurrence$canonical$(Element element, long from, long length) {
        Integer $ceylontmp$ifResult$205;
        long arg$208$2;
        long arg$208$1;
        Element arg$208$0;
        Array<Element> arg$208$callable$ = this.getArray$priv$();
        Integer result$207 = arg$208$callable$.firstOccurrence(arg$208$0 = element, arg$208$1 = from, arg$208$2 = smallest_.smallest(from + length, this.getSize()) - from);
        if (result$207 != null) {
            long result$209 = result$207.longValue();
            $ceylontmp$ifResult$205 = Integer.instance((long)result$209);
        } else {
            $ceylontmp$ifResult$205 = null;
        }
        return $ceylontmp$ifResult$205;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public final Integer firstOccurrence(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="from") @Defaulted long from, @Name(value="length") @Defaulted long length) {
        return this.firstOccurrence$canonical$(element, from, length);
    }

    @Ignore
    public final Integer lastOccurrence(Element element) {
        long $ceylontmp$from$218 = this.lastOccurrence$from(element);
        long $ceylontmp$length$219 = this.lastOccurrence$length(element, $ceylontmp$from$218);
        return this.lastOccurrence$canonical$(element, $ceylontmp$from$218, $ceylontmp$length$219);
    }

    @Ignore
    public final Integer lastOccurrence(Element element, long from) {
        long $ceylontmp$length$220 = this.lastOccurrence$length(element, from);
        return this.lastOccurrence$canonical$(element, from, $ceylontmp$length$220);
    }

    @Ignore
    private Integer lastOccurrence$canonical$(Element element, long from, long length) {
        Integer $ceylontmp$ifResult$213;
        long arg$216$2;
        long arg$216$1;
        Element arg$216$0;
        Array<Element> arg$216$callable$ = this.getArray$priv$();
        Integer result$215 = arg$216$callable$.lastOccurrence(arg$216$0 = element, arg$216$1 = largest_.largest(from, this.getArray$priv$().getSize() - this.getSize()), arg$216$2 = length);
        if (result$215 != null) {
            long result$217 = result$215.longValue();
            $ceylontmp$ifResult$213 = Integer.instance((long)result$217);
        } else {
            $ceylontmp$ifResult$213 = null;
        }
        return $ceylontmp$ifResult$213;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public final Integer lastOccurrence(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="from") @Defaulted long from, @Name(value="length") @Defaulted long length) {
        return this.lastOccurrence$canonical$(element, from, length);
    }

    @Ignore
    public final boolean occurs(Element element) {
        long $ceylontmp$from$222 = this.occurs$from(element);
        long $ceylontmp$length$223 = this.occurs$length(element, $ceylontmp$from$222);
        return this.occurs$canonical$(element, $ceylontmp$from$222, $ceylontmp$length$223);
    }

    @Ignore
    public final boolean occurs(Element element, long from) {
        long $ceylontmp$length$224 = this.occurs$length(element, from);
        return this.occurs$canonical$(element, from, $ceylontmp$length$224);
    }

    @Ignore
    private boolean occurs$canonical$(Element element, long from, long length) {
        Array<Element> arg$221$callable$ = this.getArray$priv$();
        Element arg$221$0 = element;
        long arg$221$1 = from;
        long arg$221$2 = smallest_.smallest(from + length, this.getSize()) - from;
        return arg$221$callable$.occurs(arg$221$0, arg$221$1, arg$221$2);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean occurs(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="from") @Defaulted long from, @Name(value="length") @Defaulted long length) {
        return this.occurs$canonical$(element, from, length);
    }

    @Ignore
    public final Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Element element) {
        long $ceylontmp$from$226 = this.occurrences$from(element);
        long $ceylontmp$length$227 = this.occurrences$length(element, $ceylontmp$from$226);
        return this.occurrences$canonical$(element, $ceylontmp$from$226, $ceylontmp$length$227);
    }

    @Ignore
    public final Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Element element, long from) {
        long $ceylontmp$length$228 = this.occurrences$length(element, from);
        return this.occurrences$canonical$(element, from, $ceylontmp$length$228);
    }

    @Ignore
    private Iterable<? extends Integer, ? extends java.lang.Object> occurrences$canonical$(Element element, long from, long length) {
        Array<Element> arg$225$callable$ = this.getArray$priv$();
        Element arg$225$0 = element;
        long arg$225$1 = from;
        long arg$225$2 = smallest_.smallest(from + length, this.getSize()) - from;
        return arg$225$callable$.occurrences(arg$225$0, arg$225$1, arg$225$2);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="{ceylon.language::Integer*}")
    @NonNull
    public final Iterable<? extends Integer, ? extends java.lang.Object> occurrences(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="from") @Defaulted long from, @Name(value="length") @Defaulted long length) {
        return this.occurrences$canonical$(element, from, length);
    }

    @Ignore
    public final void copyTo(java.lang.Object destination) {
        long $ceylontmp$sourcePosition$240 = this.copyTo$sourcePosition(destination);
        long $ceylontmp$destinationPosition$241 = this.copyTo$destinationPosition(destination, $ceylontmp$sourcePosition$240);
        long $ceylontmp$length$242 = this.copyTo$length(destination, $ceylontmp$sourcePosition$240, $ceylontmp$destinationPosition$241);
        this.copyTo$canonical$(destination, $ceylontmp$sourcePosition$240, $ceylontmp$destinationPosition$241, $ceylontmp$length$242);
    }

    @Ignore
    public final long copyTo$sourcePosition(java.lang.Object destination) {
        return 0L;
    }

    @Ignore
    public final void copyTo(java.lang.Object destination, long sourcePosition) {
        long $ceylontmp$destinationPosition$243 = this.copyTo$destinationPosition(destination, sourcePosition);
        long $ceylontmp$length$244 = this.copyTo$length(destination, sourcePosition, $ceylontmp$destinationPosition$243);
        this.copyTo$canonical$(destination, sourcePosition, $ceylontmp$destinationPosition$243, $ceylontmp$length$244);
    }

    @Ignore
    public final long copyTo$destinationPosition(java.lang.Object destination, long sourcePosition) {
        return 0L;
    }

    @Ignore
    public final void copyTo(java.lang.Object destination, long sourcePosition, long destinationPosition) {
        long $ceylontmp$length$245 = this.copyTo$length(destination, sourcePosition, destinationPosition);
        this.copyTo$canonical$(destination, sourcePosition, destinationPosition, $ceylontmp$length$245);
    }

    @Ignore
    public final long copyTo$length(java.lang.Object destination, long sourcePosition, long destinationPosition) {
        return smallest_.smallest(this.getSize() - sourcePosition, ((List)destination).getSize() - destinationPosition);
    }

    @Ignore
    private void copyTo$canonical$(java.lang.Object destination, long sourcePosition, long destinationPosition, long length) {
        Array $ceylontmp$ifResult$236;
        long lhs$229 = 0L;
        long middle$230 = sourcePosition;
        long rhs$231 = this.getSize() - length;
        if (lhs$229 > middle$230 || middle$230 > rhs$231) {
            throw new AssertionError("Assertion failed: illegal starting position in source list" + System.lineSeparator() + "\tviolated " + "0<=sourcePosition<=size-length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$229), (java.lang.Object)Integer.instance((long)middle$230), (java.lang.Object)Integer.instance((long)rhs$231)));
        }
        long lhs$232 = 0L;
        long middle$233 = destinationPosition;
        long rhs$234 = ((List)destination).getSize() - length;
        if (lhs$232 > middle$233 || middle$233 > rhs$234) {
            throw new AssertionError("Assertion failed: illegal starting position in destination list" + System.lineSeparator() + "\tviolated " + "0<=destinationPosition<=destination.size-length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$232), (java.lang.Object)Integer.instance((long)middle$233), (java.lang.Object)Integer.instance((long)rhs$234)));
        }
        Array<Element> arg$235$callable$ = this.getArray$priv$();
        long arg$235$3 = length;
        long arg$235$1 = sourcePosition;
        long arg$235$2 = destinationPosition;
        java.lang.Object sel$237 = destination;
        if (sel$237 instanceof Array && Util.isReified((java.lang.Object)sel$237, (TypeDescriptor)TypeDescriptor.klass(Array.class, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, this.$reified$Element})}))) {
            Array destination$239;
            $ceylontmp$ifResult$236 = destination$239 = (Array)sel$237;
        } else if (sel$237 instanceof ArrayList && Util.isReified((java.lang.Object)sel$237, (TypeDescriptor)TypeDescriptor.klass(ArrayList.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}))) {
            ArrayList destination$238 = (ArrayList)sel$237;
            $ceylontmp$ifResult$236 = destination$238.getArray$priv$();
        } else {
            Util.rethrow((Throwable)new EnumeratedTypeError("Supposedly exhaustive switch was not exhaustive"));
            $ceylontmp$ifResult$236 = null;
        }
        Array arg$235$0 = $ceylontmp$ifResult$236;
        arg$235$callable$.copyTo(arg$235$0, arg$235$1, arg$235$2, arg$235$3);
    }

    @DocAnnotation$annotation$(description="Efficiently copy the elements in the measure\n`sourcePosition:length` of this list to the measure \n`destinationPosition:length` of the given \n[[destination]] `ArrayList` or `Array`.\n\nThe given [[sourcePosition]] and [[destinationPosition]] \nmust be non-negative and, together with the given \n[[length]], must identify meaningful ranges within the \ntwo lists, satisfying:\n\n- `size >= sourcePosition+length`, and \n- `destination.size >= destinationPosition+length`.\n\nIf the given `length` is not strictly positive, no\nelements are copied.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CAssertionError", when="if the arguments do not identify meaningful ranges \nwithin the two lists:\n\n- if the given [[sourcePosition]] or \n  [[destinationPosition]] is negative, \n- if `size < sourcePosition+length`, or \n- if `destination.size < destinationPosition+length`.")})
    @SharedAnnotation$annotation$
    public final void copyTo(@Name(value="destination") @TypeInfo(value="ceylon.collection::ArrayList<Element>|ceylon.language::Array<Element?>", erased=true) @DocAnnotation$annotation$(description="The list into which to copy the elements.") @NonNull java.lang.Object destination, @Name(value="sourcePosition") @Defaulted @DocAnnotation$annotation$(description="The index of the first element in this array to \ncopy.") long sourcePosition, @Name(value="destinationPosition") @Defaulted @DocAnnotation$annotation$(description="The index in the given array into which to copy the \nfirst element.") long destinationPosition, @Name(value="length") @Defaulted @DocAnnotation$annotation$(description="The number of elements to copy.") long length) {
        this.copyTo$canonical$(destination, sourcePosition, destinationPosition, length);
    }

    @DocAnnotation$annotation$(description="Reduce the capacity of the list to its current [[size]],\nby allocating a new backing array.")
    @SharedAnnotation$annotation$
    public final void shrink() {
        if (this.getArray$priv$().getSize() > this.getLength$priv$()) {
            Array<Element> newArray = this.store$priv$(this.getLength$priv$());
            this.getArray$priv$().copyTo(newArray, 0L, 0L, this.getLength$priv$());
            this.setArray$priv$(newArray);
        }
    }

    @Ignore
    public static final <Element> long ArrayList$initialCapacity(TypeDescriptor $reified$Element) {
        return 0L;
    }

    @Ignore
    public static final <Element> double ArrayList$growthFactor(TypeDescriptor $reified$Element, long initialCapacity$param$) {
        return 1.5;
    }

    @Ignore
    public static final <Element> Iterable<? extends Element, ? extends java.lang.Object> ArrayList$elements(TypeDescriptor $reified$Element, long initialCapacity$param$, double growthFactor$param$) {
        return empty_.get_();
    }

    @DocAnnotation$annotation$(description="Create a new `ArrayList` with the given initial\n[[elements]].")
    @SharedAnnotation$annotation$
    public ArrayList(@Ignore TypeDescriptor $reified$Element, @Name(value="initialCapacity") @Defaulted @DocAnnotation$annotation$(description="The initial size of the backing array.") long initialCapacity$param$, @Name(value="growthFactor") @Defaulted @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.") double growthFactor$param$, @Name(value="elements") @Defaulted @TypeInfo(value="{Element*}") @DocAnnotation$annotation$(description="The initial elements of the list.") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements$param$) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.$ceylon$language$SearchableList$this$ = new SearchableList.impl($reified$Element, (SearchableList)this);
        this.initialCapacity = initialCapacity$param$;
        this.growthFactor = growthFactor$param$;
        this.setArray$priv$(new Array(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, $reified$Element}), elements$param$));
        this.setLength$priv$(this.getArray$priv$().getSize());
        long lhs$8 = this.getInitialCapacity$priv$();
        long rhs$9 = 0L;
        if (lhs$8 < rhs$9) {
            throw new AssertionError("Assertion failed: initial capacity cannot be negative" + System.lineSeparator() + "\tviolated " + "initialCapacity >= 0" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$8), (java.lang.Object)Integer.instance((long)rhs$9)));
        }
        long lhs$10 = this.getInitialCapacity$priv$();
        long rhs$11 = runtime_.get_().getMaxArraySize();
        if (lhs$10 > rhs$11) {
            throw new AssertionError("Assertion failed: initial capacity too large" + System.lineSeparator() + "\tviolated " + "initialCapacity <= runtime.maxArraySize" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$10), (java.lang.Object)Integer.instance((long)rhs$11)));
        }
        double lhs$12 = this.getGrowthFactor$priv$();
        double rhs$13 = 1.0;
        if (!(lhs$12 >= rhs$13)) {
            throw new AssertionError("Assertion failed: growth factor must be at least 1.0" + System.lineSeparator() + "\tviolated " + "growthFactor >= 1.0" + Util.assertBinOpFailed((java.lang.Object)Float.instance((double)lhs$12), (java.lang.Object)Float.instance((double)rhs$13)));
        }
        if (this.getLength$priv$() < this.getInitialCapacity$priv$()) {
            Array<Element> newArray = this.store$priv$(this.getInitialCapacity$priv$());
            this.getArray$priv$().copyTo(newArray, 0L, 0L, this.getLength$priv$());
            this.setArray$priv$(newArray);
        }
    }

    @Ignore
    public static final <Element> double ArrayList$copy$growthFactor(TypeDescriptor $reified$Element, ArrayList<Element> arrayList$param$) {
        return 1.5;
    }

    @DocAnnotation$annotation$(description="Create a new `ArrayList` with the same initial elements \nas the given [[arrayList]].")
    @SharedAnnotation$annotation$
    @Name(value="copy")
    public ArrayList(@Ignore TypeDescriptor $reified$Element, @Ignore copy_ $name$, @Name(value="arrayList") @TypeInfo(value="ceylon.collection::ArrayList<Element>") @DocAnnotation$annotation$(description="The `ArrayList` to copy.") @NonNull ArrayList<Element> arrayList$param$, @Name(value="growthFactor") @Defaulted @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.") double growthFactor$param$) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.$ceylon$language$SearchableList$this$ = new SearchableList.impl($reified$Element, (SearchableList)this);
        this.initialCapacity = arrayList$param$.getSize();
        this.growthFactor = growthFactor$param$;
        this.setArray$priv$(super.getArray$priv$().$clone());
        this.setLength$priv$(arrayList$param$.getSize());
        long lhs$8 = this.getInitialCapacity$priv$();
        long rhs$9 = 0L;
        if (lhs$8 < rhs$9) {
            throw new AssertionError("Assertion failed: initial capacity cannot be negative" + System.lineSeparator() + "\tviolated " + "initialCapacity >= 0" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$8), (java.lang.Object)Integer.instance((long)rhs$9)));
        }
        long lhs$10 = this.getInitialCapacity$priv$();
        long rhs$11 = runtime_.get_().getMaxArraySize();
        if (lhs$10 > rhs$11) {
            throw new AssertionError("Assertion failed: initial capacity too large" + System.lineSeparator() + "\tviolated " + "initialCapacity <= runtime.maxArraySize" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$10), (java.lang.Object)Integer.instance((long)rhs$11)));
        }
        double lhs$12 = this.getGrowthFactor$priv$();
        double rhs$13 = 1.0;
        if (!(lhs$12 >= rhs$13)) {
            throw new AssertionError("Assertion failed: growth factor must be at least 1.0" + System.lineSeparator() + "\tviolated " + "growthFactor >= 1.0" + Util.assertBinOpFailed((java.lang.Object)Float.instance((double)lhs$12), (java.lang.Object)Float.instance((double)rhs$13)));
        }
        if (this.getLength$priv$() < this.getInitialCapacity$priv$()) {
            Array<Element> newArray = this.store$priv$(this.getInitialCapacity$priv$());
            this.getArray$priv$().copyTo(newArray, 0L, 0L, this.getLength$priv$());
            this.setArray$priv$(newArray);
        }
    }

    @Ignore
    public static final <Element> double ArrayList$ofSize$growthFactor(TypeDescriptor $reified$Element, long size$param$, Element element$param$) {
        return 1.5;
    }

    @DocAnnotation$annotation$(description="Create a new `ArrayList` of the given [[size]], \npopulating every index with the given [[element]]. If \n`size<=0`, the new list will have no elements.")
    @SharedAnnotation$annotation$
    @Name(value="ofSize")
    public ArrayList(@Ignore TypeDescriptor $reified$Element, @Ignore ofSize_ $name$, @Name(value="size") @DocAnnotation$annotation$(description="The size of the resulting list. If the size is \nnon-positive, an empty list will be created.") long size$param$, @Name(value="element") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The element value with which to populate the list. \nAll elements of the resulting list will have the \nsame value.") Element element$param$, @Name(value="growthFactor") @Defaulted @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.") double growthFactor$param$) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(ceylon.language.Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.$ceylon$language$SearchableList$this$ = new SearchableList.impl($reified$Element, (SearchableList)this);
        this.initialCapacity = size$param$ < 0L ? 0L : size$param$;
        this.growthFactor = growthFactor$param$;
        this.setArray$priv$(new Array(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, $reified$Element}), Array.ofSize_, size$param$, element$param$));
        this.setLength$priv$(size$param$);
        long lhs$8 = this.getInitialCapacity$priv$();
        long rhs$9 = 0L;
        if (lhs$8 < rhs$9) {
            throw new AssertionError("Assertion failed: initial capacity cannot be negative" + System.lineSeparator() + "\tviolated " + "initialCapacity >= 0" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$8), (java.lang.Object)Integer.instance((long)rhs$9)));
        }
        long lhs$10 = this.getInitialCapacity$priv$();
        long rhs$11 = runtime_.get_().getMaxArraySize();
        if (lhs$10 > rhs$11) {
            throw new AssertionError("Assertion failed: initial capacity too large" + System.lineSeparator() + "\tviolated " + "initialCapacity <= runtime.maxArraySize" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$10), (java.lang.Object)Integer.instance((long)rhs$11)));
        }
        double lhs$12 = this.getGrowthFactor$priv$();
        double rhs$13 = 1.0;
        if (!(lhs$12 >= rhs$13)) {
            throw new AssertionError("Assertion failed: growth factor must be at least 1.0" + System.lineSeparator() + "\tviolated " + "growthFactor >= 1.0" + Util.assertBinOpFailed((java.lang.Object)Float.instance((double)lhs$12), (java.lang.Object)Float.instance((double)rhs$13)));
        }
        if (this.getLength$priv$() < this.getInitialCapacity$priv$()) {
            Array<Element> newArray = this.store$priv$(this.getInitialCapacity$priv$());
            this.getArray$priv$().copyTo(newArray, 0L, 0L, this.getLength$priv$());
            this.setArray$priv$(newArray);
        }
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new ArrayList(TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(ArrayList.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }

    @Ignore
    public java.util.Collection<ReachableReference> $references$() {
        java.util.ArrayList<ReachableReference> reference = new java.util.ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(ArrayList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "initialCapacity")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(ArrayList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "growthFactor")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(ArrayList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "array")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(ArrayList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::ArrayList.initialCapacity": {
                return Integer.instance((long)this.initialCapacity);
            }
            case "ceylon.collection::ArrayList.growthFactor": {
                return Float.instance((double)this.growthFactor);
            }
            case "ceylon.collection::ArrayList.array": {
                return this.array;
            }
            case "ceylon.collection::ArrayList.length": {
                return Integer.instance((long)this.length);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::ArrayList.initialCapacity": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"initialCapacity").invokeExact(this, ((Integer)instance).longValue());
                    break;
                }
                case "ceylon.collection::ArrayList.growthFactor": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"growthFactor").invokeExact(this, ((Float)instance).doubleValue());
                    break;
                }
                case "ceylon.collection::ArrayList.array": {
                    this.array = (Array)instance;
                    break;
                }
                case "ceylon.collection::ArrayList.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="copy")
    public static final class copy_ {
        copy_() {
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="ofSize")
    public static final class ofSize_ {
        ofSize_() {
        }
    }
}

