/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.CachingCell;
import ceylon.collection.CachingStoreIterator;
import ceylon.collection.Hashtable;
import ceylon.collection.LinkedCell;
import ceylon.collection.LinkedCellIterator;
import ceylon.collection.MapMutator$impl;
import ceylon.collection.MutableMap;
import ceylon.collection.Stability;
import ceylon.collection.cachingEntryStore_;
import ceylon.collection.linked_;
import ceylon.collection.unlinked_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.Correspondence;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[MutableMap]] implemented as a hash map stored in an \n[[Array]] of singly linked lists of \n[[ceylon.language::Entry]]s. Each entry is assigned an \nindex in the array according to the hash code of its key. \nThe hash code of a key is defined by [[Object.hash]].\n\nThe [[stability]] of a `HashMap` controls its iteration\norder:\n\n- A [[linked]] map has a stable and meaningful order of \n  iteration. The entries of the map form a linked list, \n  where new entries are added to the end of the linked \n  list. Iteration of the map follows this linked list, from \n  least recently added elements to most recently added \n  elements.\n- An [[unlinked]] map has an unstable iteration order that \n  may change when the map is modified. The order itself is \n  not meaningful to a client.\n\nThe stability is `linked` by default.\n\nThe management of the backing array is controlled by the\ngiven [[hashtable]].")
@AuthorsAnnotation$annotation$(authors={"St\u00e9phane \u00c9pardaud"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.collection::MutableMap<Key,Item>"})
@TypeParameters(value={@TypeParameter(value="Key", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={}), @TypeParameter(value="Item", variance=Variance.NONE, satisfies={}, caseTypes={})})
@Class(constructors=true)
public class HashMap<Key, Item>
implements ReifiedType,
MutableMap<Key, Item>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Key;
    @Ignore
    private final TypeDescriptor $reified$Item;
    @Ignore
    protected final Map.impl<Key, Item> $ceylon$language$Map$this$;
    @Ignore
    protected final Collection.impl<Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Entry<? extends Key, ? extends Item>, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Correspondence.impl<java.lang.Object, Item> $ceylon$language$Correspondence$this$;
    @Ignore
    protected final MapMutator$impl<Key, Item> $ceylon$collection$MapMutator$this$;
    @Ignore
    private final Stability stability;
    @Ignore
    private final Hashtable hashtable;
    @Ignore
    private Array<CachingCell<Entry<? extends Key, ? extends Item>>> store;
    @Ignore
    private long length;
    @Ignore
    private LinkedCell<Entry<? extends Key, ? extends Item>> head;
    @Ignore
    private LinkedCell<Entry<? extends Key, ? extends Item>> tip;
    @Ignore
    public static final copy_ copy_ = null;

    @Ignore
    public HashMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        Stability $ceylontmp$stability$140 = HashMap.HashMap$stability($reified$Key, $reified$Item);
        Hashtable $ceylontmp$hashtable$141 = HashMap.HashMap$hashtable($reified$Key, $reified$Item, $ceylontmp$stability$140);
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$142 = HashMap.HashMap$entries($reified$Key, $reified$Item, $ceylontmp$stability$140, $ceylontmp$hashtable$141);
        this($reified$Key, $reified$Item, $ceylontmp$stability$140, $ceylontmp$hashtable$141, $ceylontmp$entries$142);
    }

    @Ignore
    public HashMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Stability stability$param$) {
        Hashtable $ceylontmp$hashtable$143 = HashMap.HashMap$hashtable($reified$Key, $reified$Item, stability$param$);
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$144 = HashMap.HashMap$entries($reified$Key, $reified$Item, stability$param$, $ceylontmp$hashtable$143);
        this($reified$Key, $reified$Item, stability$param$, $ceylontmp$hashtable$143, $ceylontmp$entries$144);
    }

    @Ignore
    public HashMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Stability stability$param$, Hashtable hashtable$param$) {
        Iterable<Entry<Key, Item>, java.lang.Object> $ceylontmp$entries$145 = HashMap.HashMap$entries($reified$Key, $reified$Item, stability$param$, hashtable$param$);
        this($reified$Key, $reified$Item, stability$param$, hashtable$param$, $ceylontmp$entries$145);
    }

    @Ignore
    public HashMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, @Ignore copy_ $name$, HashMap<Key, Item> hashMap$param$) {
        Stability $ceylontmp$stability$151 = HashMap.HashMap$copy$stability($reified$Key, $reified$Item, hashMap$param$);
        Hashtable $ceylontmp$hashtable$152 = HashMap.HashMap$copy$hashtable($reified$Key, $reified$Item, hashMap$param$, $ceylontmp$stability$151);
        this($reified$Key, $reified$Item, $name$, hashMap$param$, $ceylontmp$stability$151, $ceylontmp$hashtable$152);
    }

    @Ignore
    public HashMap(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, @Ignore copy_ $name$, HashMap<Key, Item> hashMap$param$, Stability stability$param$) {
        Hashtable $ceylontmp$hashtable$153 = HashMap.HashMap$copy$hashtable($reified$Key, $reified$Item, hashMap$param$, stability$param$);
        this($reified$Key, $reified$Item, $name$, hashMap$param$, stability$param$, $ceylontmp$hashtable$153);
    }

    @Ignore
    public HashMap($Serialization$ ignored, TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (ceylon.language.Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.stability = null;
        this.hashtable = null;
        this.store = null;
        this.length = 0L;
        this.head = null;
        this.tip = null;
    }

    @Ignore
    public Map.impl<? extends Key, ? extends Item> $ceylon$language$Map$impl() {
        return this.$ceylon$language$Map$this$;
    }

    @Override
    @Ignore
    public Map<? extends Key, ? extends Item> getCoalescedMap() {
        return this.$ceylon$language$Map$this$.getCoalescedMap();
    }

    @Override
    @Ignore
    public final <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Map$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public <Default> Map defaultNullItems(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Map$this$.defaultNullItems($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public final Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Map$this$.getDistinct();
    }

    @Override
    @Ignore
    public Map<? extends Key, ? extends Item> filterKeys(Callable<? extends Boolean> filtering) {
        return this.$ceylon$language$Map$this$.filterKeys(filtering);
    }

    @Override
    @Ignore
    public Map<? extends Item, ? extends Sequence<? extends Key>> inverse() {
        return this.$ceylon$language$Map$this$.inverse();
    }

    @Override
    @Ignore
    public ceylon.language.Collection<? extends Item> getItems() {
        return this.$ceylon$language$Map$this$.getItems();
    }

    @Override
    @Ignore
    public ceylon.language.Collection<? extends Key> getKeys() {
        return this.$ceylon$language$Map$this$.getKeys();
    }

    @Override
    @Ignore
    public <Result> Map<? extends Key, ? extends Result> mapItems(TypeDescriptor $reified$Result, Callable<? extends Result> mapping) {
        return this.$ceylon$language$Map$this$.mapItems($reified$Result, mapping);
    }

    @Override
    @Ignore
    public <OtherKey, OtherItem> Map patch(TypeDescriptor $reified$OtherKey, TypeDescriptor $reified$OtherItem, Map<? extends OtherKey, ? extends OtherItem> other) {
        return this.$ceylon$language$Map$this$.patch($reified$OtherKey, $reified$OtherItem, other);
    }

    @Ignore
    public Collection.impl<? extends Entry<? extends Key, ? extends Item>> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Iterable.impl<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> find(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> findLast(Callable<? extends Boolean> selecting) {
        return (Entry)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Entry<? extends Key, ? extends Item>, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public Entry<? extends Key, ? extends Item> getFromFirst(long index) {
        return (Entry)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Entry<? extends Key, ? extends Item>>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$0 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$0);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Entry max(Callable<? extends Comparison> comparing) {
        return (Entry)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Entry<? extends Key, ? extends Item>>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Entry<? extends Key, ? extends Item>> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public Sequential sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Entry<? extends Key, ? extends Item>, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Correspondence.impl<? super java.lang.Object, ? extends Item> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Ignore
    public boolean definesAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Ignore
    public boolean definesEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Item, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends java.lang.Object, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @Override
    @Ignore
    public MapMutator$impl<? super Key, ? super Item> $ceylon$collection$MapMutator$impl() {
        return this.$ceylon$collection$MapMutator$this$;
    }

    @Override
    @Ignore
    public java.lang.Object removeAll(Iterable<? extends Key, ? extends java.lang.Object> keys) {
        return this.$ceylon$collection$MapMutator$this$.removeAll(keys);
    }

    @DocAnnotation$annotation$(description="Determines whether this is a linked hash map with a\nstable iteration order.")
    @TypeInfo(value="ceylon.collection::Stability")
    @NonNull
    private final Stability getStability$priv$() {
        return this.stability;
    }

    @DocAnnotation$annotation$(description="Performance-related settings for the backing array.")
    @TypeInfo(value="ceylon.collection::Hashtable")
    @NonNull
    private final Hashtable getHashtable$priv$() {
        return this.hashtable;
    }

    @DocAnnotation$annotation$(description="Array of linked lists where we store the elements.\n\nEach element is stored in a linked list from this array\nat the index of the hash code of the element, modulo \nthe array size.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Key->Item>?>")
    @NonNull
    private final Array<CachingCell<Entry<? extends Key, ? extends Item>>> getStore$priv$() {
        return this.store;
    }

    private final void setStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Key->Item>?>") @NonNull Array<CachingCell<Entry<? extends Key, ? extends Item>>> store) {
        this.store = store;
    }

    @DocAnnotation$annotation$(description="Number of elements in this map.")
    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    @DocAnnotation$annotation$(description="Head of the traversal linked list if in `linked` mode. \nStorage is done in [[store]], but traversal is done \nusing an alternative linked list maintained to have a \nstable iteration order. Note that the cells used are \nthe same as in the [[store]], except for storage we use \n[[CachingCell.rest]] for traversal, while for the stable \niteration we use the \n[[LinkedCell.next]]/[[LinkedCell.previous]] attributes \nof the same cell.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::LinkedCell<Key->Item>?")
    @Nullable
    private final LinkedCell<Entry<? extends Key, ? extends Item>> getHead$priv$() {
        return this.head;
    }

    private final void setHead$priv$(@Name(value="head") @TypeInfo(value="ceylon.collection::LinkedCell<Key->Item>?") @Nullable LinkedCell<Entry<? extends Key, ? extends Item>> head) {
        this.head = head;
    }

    @DocAnnotation$annotation$(description="Tip of the traversal linked list if in `linked` mode.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::LinkedCell<Key->Item>?")
    @Nullable
    private final LinkedCell<Entry<? extends Key, ? extends Item>> getTip$priv$() {
        return this.tip;
    }

    private final void setTip$priv$(@Name(value="tip") @TypeInfo(value="ceylon.collection::LinkedCell<Key->Item>?") @Nullable LinkedCell<Entry<? extends Key, ? extends Item>> tip) {
        this.tip = tip;
    }

    private final long hashCode$priv$(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        long h = key.hashCode();
        return h ^ h >>> 16;
    }

    private final long storeIndex$priv$(@Name(value="keyHash") long keyHash, @Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Key->Item>?>") @NonNull Array<CachingCell<Entry<? extends Key, ? extends Item>>> store) {
        return keyHash & store.getSize() - 1L;
    }

    @TypeInfo(value="ceylon.collection::CachingCell<Key->Item>")
    @NonNull
    private final CachingCell<Entry<? extends Key, ? extends Item>> createCell$priv$(@Name(value="entry") @TypeInfo(value="Key->Item") @NonNull Entry<? extends Key, ? extends Item> entry, @Name(value="keyHash") long keyHash, @Name(value="rest") @TypeInfo(value="ceylon.collection::CachingCell<Key->Item>?") @Nullable CachingCell<Entry<? extends Key, ? extends Item>> rest) {
        if (this.getStability$priv$().equals(linked_.get_())) {
            LinkedCell<Entry<? extends Key, ? extends Item>> cell = new LinkedCell<Entry<? extends Key, ? extends Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), entry, keyHash, rest, this.getTip$priv$());
            LinkedCell<Entry<Key, Item>> last$3 = this.getTip$priv$();
            if (last$3 != null) {
                LinkedCell<Entry<Key, Item>> last$4 = last$3;
                last$4.setNext(cell);
            }
            this.setTip$priv$(cell);
            if (this.getHead$priv$() == null) {
                this.setHead$priv$(cell);
            }
            return cell;
        }
        return new CachingCell<Entry<? extends Key, ? extends Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), entry, keyHash, rest);
    }

    private final void deleteCell$priv$(@Name(value="cell") @TypeInfo(value="ceylon.collection::CachingCell<Key->Item>") @NonNull CachingCell<Entry<? extends Key, ? extends Item>> cell) {
        if (this.getStability$priv$().equals(linked_.get_())) {
            CachingCell<Entry<? extends Key, ? extends Item>> cell$7 = null;
            cell$7 = cell;
            if (!(cell$7 instanceof LinkedCell) || !Util.isReified(cell$7, (TypeDescriptor)TypeDescriptor.klass(LinkedCell.class, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})}))) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is LinkedCell<Key->Item> cell" + Util.assertIsFailed((boolean)false, (TypeDescriptor)TypeDescriptor.klass(LinkedCell.class, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})}), cell$7));
            }
            LinkedCell cell$8 = (LinkedCell)cell$7;
            LinkedCell last$10 = cell$8.getPrevious();
            if (last$10 != null) {
                LinkedCell last$11 = last$10;
                last$11.setNext(cell$8.getNext());
            } else {
                this.setHead$priv$(cell$8.getNext());
            }
            LinkedCell next$13 = cell$8.getNext();
            if (next$13 != null) {
                LinkedCell next$14 = next$13;
                next$14.setPrevious(cell$8.getPrevious());
            } else {
                this.setTip$priv$(cell$8.getPrevious());
            }
        }
    }

    private final boolean addToStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Key->Item>?>") @NonNull Array<CachingCell<Entry<? extends Key, ? extends Item>>> store, @Name(value="entry") @TypeInfo(value="Key->Item") @NonNull Entry<? extends Key, ? extends Item> entry) {
        CachingCell<Entry<Key, Item>> cell$15;
        CachingCell<Entry<Key, Item>> headBucket;
        long keyHash = this.hashCode$priv$(entry.getKey());
        long index = this.storeIndex$priv$(keyHash, store);
        CachingCell<Entry<Key, Item>> bucket = headBucket = (CachingCell<Entry<Key, Item>>)store.getFromFirst(index);
        while ((cell$15 = bucket) != null) {
            CachingCell<Entry<Key, Item>> cell$16 = cell$15;
            if (cell$16.getKeyHash() == keyHash && ((Entry)cell$16.getElement()).getKey().equals(entry.getKey())) {
                cell$16.setElement(entry);
                return false;
            }
            bucket = cell$16.getRest();
        }
        store.set(index, this.createCell$priv$(entry, keyHash, headBucket));
        return true;
    }

    private final void checkRehash$priv$() {
        if (this.getHashtable$priv$().rehash(this.getLength$priv$(), this.getStore$priv$().getSize())) {
            Array newStore = cachingEntryStore_.cachingEntryStore(this.$reified$Key, this.$reified$Item, this.getHashtable$priv$().capacity(this.getLength$priv$()));
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                CachingCell cell$19;
                CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
                while ((cell$19 = bucket) != null) {
                    CachingCell cell$20 = cell$19;
                    bucket = cell$20.getRest();
                    long newIndex = this.storeIndex$priv$(cell$20.getKeyHash(), newStore);
                    CachingCell newBucket = (CachingCell)newStore.getFromFirst(newIndex);
                    cell$20.setRest(newBucket);
                    newStore.set(newIndex, cell$20);
                }
            }
            this.setStore$priv$(newStore);
        }
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item put(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item") Item item) {
        CachingCell<Entry> cell$32;
        CachingCell<Entry> headBucket;
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        Entry entry = new Entry(this.$reified$Key, this.$reified$Item, key, item);
        CachingCell<Entry> bucket = headBucket = (CachingCell<Entry>)this.getStore$priv$().getFromFirst(index);
        while ((cell$32 = bucket) != null) {
            CachingCell<Entry> cell$33 = cell$32;
            if (cell$33.getKeyHash() == keyHash && ((Entry)cell$33.getElement()).getKey().equals(key)) {
                java.lang.Object oldItem = ((Entry)cell$33.getElement()).getItem();
                cell$33.setElement(entry);
                return (Item)oldItem;
            }
            bucket = cell$33.getRest();
        }
        this.getStore$priv$().set(index, this.createCell$priv$(entry, keyHash, headBucket));
        long $ceylontmp$op$35 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$35 + 1L);
        this.checkRehash$priv$();
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item, @Name(value="newItem") @TypeInfo(value="Item") Item newItem) {
        CachingCell<Entry> cell$36;
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell<Entry> bucket = (CachingCell<Entry>)this.getStore$priv$().getFromFirst(index);
        while ((cell$36 = bucket) != null) {
            CachingCell<Entry> cell$37 = cell$36;
            if (cell$37.getKeyHash() == keyHash && ((Entry)cell$37.getElement()).getKey().equals(key)) {
                boolean $ceylontmp$if$39 = false;
                java.lang.Object oldItem$40 = ((Entry)cell$37.getElement()).getItem();
                if (oldItem$40 != null) {
                    java.lang.Object oldItem$41 = oldItem$40;
                    if (oldItem$41.equals(item)) {
                        $ceylontmp$if$39 = true;
                    }
                } else {
                    java.lang.Object oldItem$41 = null;
                }
                if ($ceylontmp$if$39) {
                    cell$37.setElement(new Entry(this.$reified$Key, this.$reified$Item, key, newItem));
                    return true;
                }
                return false;
            }
            bucket = cell$37.getRest();
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object putAll(@Name(value="entries") @TypeInfo(value="{<Key->Item>*}") @NonNull Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries) {
        Iterator entry$iterator$$49;
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> iterable$44 = entries;
        boolean isArray$45 = iterable$44 instanceof Array;
        boolean isTuple$46 = iterable$44 instanceof Tuple && ((Tuple)iterable$44).$getArray$() != null;
        java.lang.Object elem$43 = null;
        int i$47 = 0;
        int length$48 = isArray$45 || isTuple$46 ? (int)iterable$44.getSize() : 0;
        Iterator iterator = entry$iterator$$49 = isTuple$46 || isArray$45 ? null : iterable$44.iterator();
        while (isTuple$46 || isArray$45 ? i$47 < length$48 : !((elem$43 = entry$iterator$$49.next()) instanceof Finished)) {
            if (isArray$45 || isTuple$46) {
                elem$43 = iterable$44.getFromFirst((long)i$47++);
            }
            Entry entry = (Entry)elem$43;
            if (!this.addToStore$priv$(this.getStore$priv$(), entry)) continue;
            long $ceylontmp$op$51 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$51 + 1L);
        }
        this.checkRehash$priv$();
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item remove(@Name(value="key") @TypeInfo(value="Key") Key key) {
        CachingCell<Entry<Key, Item>> cell$56;
        CachingCell head$54;
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell head$53 = (CachingCell)this.getStore$priv$().getFromFirst(index);
        if (head$53 != null && (head$54 = head$53).getKeyHash() == keyHash && ((Entry)head$54.getElement()).getKey().equals(key)) {
            this.getStore$priv$().set(index, head$54.getRest());
            this.deleteCell$priv$(head$54);
            long $ceylontmp$op$55 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$55 - 1L);
            return (Item)((Entry)head$54.getElement()).getItem();
        }
        CachingCell<Entry<Key, Item>> bucket = (CachingCell<Entry<Key, Item>>)this.getStore$priv$().getFromFirst(index);
        while ((cell$56 = bucket) != null) {
            CachingCell<Entry<Key, Item>> rest$60;
            CachingCell<Entry<Key, Item>> cell$57 = cell$56;
            CachingCell<Entry<Key, Item>> rest = cell$57.getRest();
            boolean $ceylontmp$if$58 = false;
            CachingCell<Entry<Key, Item>> rest$59 = rest;
            if (rest$59 != null) {
                rest$60 = rest$59;
                if (((Entry)rest$60.getElement()).getKey().equals(key)) {
                    $ceylontmp$if$58 = true;
                }
            } else {
                rest$60 = null;
            }
            if ($ceylontmp$if$58) {
                cell$57.setRest(rest$60.getRest());
                this.deleteCell$priv$(rest$60);
                long $ceylontmp$op$61 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$61 - 1L);
                return (Item)rest$60.getElement().getItem();
            }
            bucket = rest;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeEntry(@Name(value="key") @TypeInfo(value="Key") Key key, @Name(value="item") @TypeInfo(value="Item&ceylon.language::Object") @NonNull Item item) {
        CachingCell<Entry<Key, Item>> cell$68;
        CachingCell head$63;
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell head$62 = (CachingCell)this.getStore$priv$().getFromFirst(index);
        if (head$62 != null && (head$63 = head$62).getKeyHash() == keyHash && ((Entry)head$63.getElement()).getKey().equals(key)) {
            boolean $ceylontmp$if$64 = false;
            java.lang.Object it$65 = ((Entry)head$63.getElement()).getItem();
            if (it$65 != null) {
                java.lang.Object it$66 = it$65;
                if (it$66.equals(item)) {
                    $ceylontmp$if$64 = true;
                }
            } else {
                java.lang.Object it$66 = null;
            }
            if ($ceylontmp$if$64) {
                this.getStore$priv$().set(index, head$63.getRest());
                long $ceylontmp$op$67 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$67 - 1L);
                return true;
            }
            return false;
        }
        CachingCell<Entry<Key, Item>> bucket = (CachingCell<Entry<Key, Item>>)this.getStore$priv$().getFromFirst(index);
        while ((cell$68 = bucket) != null) {
            CachingCell<Entry<Key, Item>> rest$72;
            CachingCell<Entry<Key, Item>> cell$69 = cell$68;
            CachingCell<Entry<Key, Item>> rest = cell$69.getRest();
            boolean $ceylontmp$if$70 = false;
            CachingCell<Entry<Key, Item>> rest$71 = rest;
            if (rest$71 != null) {
                rest$72 = rest$71;
                if (((Entry)rest$72.getElement()).getKey().equals(key)) {
                    $ceylontmp$if$70 = true;
                }
            } else {
                rest$72 = null;
            }
            if ($ceylontmp$if$70) {
                boolean $ceylontmp$if$73 = false;
                java.lang.Object it$74 = ((Entry)rest$72.getElement()).getItem();
                if (it$74 != null) {
                    java.lang.Object it$75 = it$74;
                    if (it$75.equals(item)) {
                        $ceylontmp$if$73 = true;
                    }
                } else {
                    java.lang.Object it$75 = null;
                }
                if ($ceylontmp$if$73) {
                    cell$69.setRest(rest$72.getRest());
                    this.deleteCell$priv$(rest$72);
                    long $ceylontmp$op$76 = this.getLength$priv$();
                    this.setLength$priv$($ceylontmp$op$76 - 1L);
                    return true;
                }
                return false;
            }
            bucket = rest;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object clear() {
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            this.getStore$priv$().set(index++, null);
        }
        this.setLength$priv$(0L);
        this.setHead$priv$(null);
        this.setTip$priv$(null);
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final boolean getEmpty() {
        return this.getLength$priv$() == 0L;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item?")
    @Nullable
    public final Item get(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        CachingCell cell$78;
        if (this.getEmpty()) {
            return null;
        }
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
        while ((cell$78 = bucket) != null) {
            CachingCell cell$79 = cell$78;
            if (cell$79.getKeyHash() == keyHash && ((Entry)cell$79.getElement()).getKey().equals(key)) {
                return (Item)((Entry)cell$79.getElement()).getItem();
            }
            bucket = cell$79.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Item|Default", erased=true)
    @TypeParameters(value={@TypeParameter(value="Default", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @Nullable
    public final <Default> java.lang.Object getOrDefault(@Ignore TypeDescriptor $reified$Default, @Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key, @Name(value="default") @TypeInfo(value="Default") Default $default) {
        CachingCell cell$82;
        if (this.getEmpty()) {
            return $default;
        }
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
        while ((cell$82 = bucket) != null) {
            CachingCell cell$83 = cell$82;
            if (cell$83.getKeyHash() == keyHash && ((Entry)cell$83.getElement()).getKey().equals(key)) {
                return ((Entry)cell$83.getElement()).getItem();
            }
            bucket = cell$83.getRest();
        }
        return $default;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="<Key->Item>?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Entry getFirst() {
        void var1_3;
        CachingCell safe$87;
        LinkedCell<Entry<Key, Item>> safe$88;
        Entry $ceylontmp$ifResult$85 = this.getStability$priv$().equals(linked_.get_()) ? ((safe$88 = this.getHead$priv$()) != null ? (Entry)safe$88.getElement() : null) : ((safe$87 = (CachingCell)this.getStore$priv$().getCoalesced().getFirst()) != null ? (Entry)safe$87.getElement() : null);
        return var1_3;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="<Key->Item>?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Entry getLast() {
        CachingCell safe$91;
        CachingCell cell$90;
        if (this.getStability$priv$().equals(linked_.get_())) {
            LinkedCell<Entry<Key, Item>> safe$94 = this.getTip$priv$();
            return safe$94 != null ? (Entry)safe$94.getElement() : null;
        }
        CachingCell bucket = (CachingCell)this.getStore$priv$().getReversed().getCoalesced().getFirst();
        while ((cell$90 = (safe$91 = bucket) != null ? safe$91.getRest() : null) != null) {
            CachingCell cell$92;
            bucket = cell$92 = cell$90;
        }
        CachingCell safe$93 = bucket;
        return safe$93 != null ? (Entry)safe$93.getElement() : null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Key->Item>")
    @NonNull
    public final Iterator<? extends Entry<? extends Key, ? extends Item>> iterator() {
        return (Iterator)(this.getStability$priv$().equals(linked_.get_()) ? new LinkedCellIterator<Entry<Key, Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), this.getHead$priv$()) : new CachingStoreIterator<Entry<Key, Item>>(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item}), this.getStore$priv$()));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Key->Item)") @NonNull Callable<? extends Boolean> selecting) {
        long count = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            CachingCell cell$95;
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$95 = bucket) != null) {
                CachingCell cell$96 = cell$95;
                if (((Boolean)selecting.$call$(cell$96.getElement())).booleanValue()) {
                    ++count;
                }
                bucket = cell$96.getRest();
            }
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(final @Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Key->Item)") @NonNull Callable<? extends java.lang.Object> step) {
        this.getStore$priv$().each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(CachingCell.class, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item})})})}), "Anything(CachingCell<Key->Item>?)", -1){

            @Ignore
            public java.lang.Object $call$(java.lang.Object $param$0) {
                CachingCell cell$98;
                CachingCell bucket;
                CachingCell iter = bucket = (CachingCell)$param$0;
                while ((cell$98 = iter) != null) {
                    CachingCell cell$99 = cell$98;
                    step.$call$(cell$99.getElement());
                    iter = cell$99.getRest();
                }
                return null;
            }
        });
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long hash = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            CachingCell cell$101;
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$101 = bucket) != null) {
                CachingCell cell$102 = cell$101;
                hash += (long)((Entry)cell$102.getElement()).hashCode();
                bucket = cell$102.getRest();
            }
        }
        long $ceylontmp$hash$103 = hash;
        return (int)($ceylontmp$hash$103 ^ $ceylontmp$hash$103 >>> 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        Map that$109;
        HashMap that$106;
        boolean $ceylontmp$if$104 = false;
        java.lang.Object that$105 = that;
        if (that$105 instanceof HashMap && Util.isReified((java.lang.Object)that$105, (TypeDescriptor)TypeDescriptor.klass(HashMap.class, (TypeDescriptor[])new TypeDescriptor[]{Anything.$TypeDescriptor$, Anything.$TypeDescriptor$}))) {
            that$106 = (HashMap)that$105;
            if (this == that$106) {
                return true;
            }
        } else {
            that$106 = null;
        }
        if ($ceylontmp$if$104) {
            return true;
        }
        boolean $ceylontmp$if$107 = false;
        java.lang.Object that$108 = that;
        if (that$108 instanceof Map) {
            that$109 = (Map)that$108;
            if (that$109.getSize() == this.getLength$priv$()) {
                $ceylontmp$if$107 = true;
            }
        } else {
            that$109 = null;
        }
        if (!$ceylontmp$if$107) {
            return false;
        }
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            CachingCell cell$110;
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$110 = bucket) != null) {
                CachingCell cell$111 = cell$110;
                java.lang.Object thatItem = that$109.get(((Entry)cell$111.getElement()).getKey());
                java.lang.Object thisItem$113 = ((Entry)cell$111.getElement()).getItem();
                if (thisItem$113 != null) {
                    java.lang.Object thisItem$115 = thisItem$113;
                    java.lang.Object thatItem$117 = thatItem;
                    if (thatItem$117 == null) {
                        java.lang.Object thatItem$118 = thatItem$117;
                        return false;
                    }
                    java.lang.Object thatItem$119 = thatItem$117;
                    if (!thatItem$119.equals(thisItem$115)) {
                        return false;
                    }
                } else if (thatItem != null) {
                    return false;
                }
                bucket = cell$111.getRest();
            }
            ++index;
        }
        return true;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashMap<Key,Item>")
    @NonNull
    public final HashMap<Key, Item> $clone() {
        return new HashMap<Key, Item>(this.$reified$Key, this.$reified$Item, copy_, this);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean defines(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        CachingCell cell$122;
        if (this.getEmpty()) {
            return false;
        }
        long keyHash = this.hashCode$priv$(key);
        long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
        CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
        while ((cell$122 = bucket) != null) {
            CachingCell cell$123 = cell$122;
            if (cell$123.getKeyHash() == keyHash && ((Entry)cell$123.getElement()).getKey().equals(key)) {
                return true;
            }
            bucket = cell$123.getRest();
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="entry") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object entry) {
        if (this.getEmpty()) {
            return false;
        }
        java.lang.Object entry$127 = entry;
        if (entry$127 instanceof Entry) {
            CachingCell cell$129;
            Entry entry$128 = (Entry)entry$127;
            java.lang.Object key = entry$128.getKey();
            long keyHash = this.hashCode$priv$(key);
            long index = this.storeIndex$priv$(keyHash, this.getStore$priv$());
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$129 = bucket) != null) {
                CachingCell cell$130 = cell$129;
                if (cell$130.getKeyHash() == keyHash && ((Entry)cell$130.getElement()).getKey().equals(key)) {
                    java.lang.Object item$133 = ((Entry)cell$130.getElement()).getItem();
                    if (item$133 != null) {
                        java.lang.Object item$134 = item$133;
                        java.lang.Object elementItem$136 = entry$128.getItem();
                        if (elementItem$136 != null) {
                            java.lang.Object elementItem$137 = elementItem$136;
                            return item$134.equals(elementItem$137);
                        }
                        return false;
                    }
                    return entry$128.getItem() == null;
                }
                bucket = cell$130.getRest();
            }
            return false;
        }
        return false;
    }

    @Ignore
    public static final <Key, Item> Stability HashMap$stability(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item) {
        return linked_.get_();
    }

    @Ignore
    public static final <Key, Item> Hashtable HashMap$hashtable(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Stability stability$param$) {
        return new Hashtable();
    }

    @Ignore
    public static final <Key, Item> Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> HashMap$entries(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, Stability stability$param$, Hashtable hashtable$param$) {
        return empty_.get_();
    }

    @DocAnnotation$annotation$(description="Create a new `HashMap` with the given initial entries.")
    @SharedAnnotation$annotation$
    public HashMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Name(value="stability") @Defaulted @TypeInfo(value="ceylon.collection::Stability") @DocAnnotation$annotation$(description="Determines whether this is a linked hash map with a\nstable iteration order, defaulting to [[linked]]\n(stable).") @NonNull Stability stability$param$, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable$param$, @Name(value="entries") @Defaulted @TypeInfo(value="{<Key->Item>*}") @DocAnnotation$annotation$(description="The initial entries in the map, defaulting to no\ninitial entries.") @NonNull Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries$param$) {
        Iterator entry$iterator$$28;
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.head = null;
        this.tip = null;
        this.stability = stability$param$;
        this.hashtable = hashtable$param$;
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> entries = entries$param$;
        this.setLength$priv$(0L);
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> $ceylontmp$139 = entries$param$;
        boolean accurateInitialCapacity = $ceylontmp$139 instanceof ceylon.language.Collection;
        long initialCapacity = accurateInitialCapacity ? hashtable$param$.initialCapacityForSize(entries$param$.getSize()) : hashtable$param$.initialCapacityForUnknownSize();
        this.setStore$priv$(cachingEntryStore_.cachingEntryStore($reified$Key, $reified$Item, initialCapacity));
        Iterable<? extends Entry<? extends Key, ? extends Item>, ? extends java.lang.Object> iterable$23 = entries;
        boolean isArray$24 = iterable$23 instanceof Array;
        boolean isTuple$25 = iterable$23 instanceof Tuple && ((Tuple)iterable$23).$getArray$() != null;
        java.lang.Object elem$22 = null;
        int i$26 = 0;
        int length$27 = isArray$24 || isTuple$25 ? (int)iterable$23.getSize() : 0;
        Iterator iterator = entry$iterator$$28 = isTuple$25 || isArray$24 ? null : iterable$23.iterator();
        while (isTuple$25 || isArray$24 ? i$26 < length$27 : !((elem$22 = entry$iterator$$28.next()) instanceof Finished)) {
            if (isArray$24 || isTuple$25) {
                elem$22 = iterable$23.getFromFirst((long)i$26++);
            }
            Entry entry = (Entry)elem$22;
            if (!this.addToStore$priv$(this.getStore$priv$(), entry)) continue;
            long $ceylontmp$op$30 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$30 + 1L);
        }
        if (!accurateInitialCapacity) {
            this.checkRehash$priv$();
        }
    }

    @Ignore
    public static final <Key, Item> Stability HashMap$copy$stability(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, HashMap<Key, Item> hashMap$param$) {
        return super.getStability$priv$();
    }

    @Ignore
    public static final <Key, Item> Hashtable HashMap$copy$hashtable(TypeDescriptor $reified$Key, TypeDescriptor $reified$Item, HashMap<Key, Item> hashMap$param$, Stability stability$param$) {
        return new Hashtable();
    }

    @DocAnnotation$annotation$(description="Create a new `HashMap` with the same initial entries as \nthe given [[hashMap]].")
    @SharedAnnotation$annotation$
    @Name(value="copy")
    public HashMap(@Ignore TypeDescriptor $reified$Key, @Ignore TypeDescriptor $reified$Item, @Ignore copy_ $name$, @Name(value="hashMap") @TypeInfo(value="ceylon.collection::HashMap<Key,Item>") @DocAnnotation$annotation$(description="The `HashMap` to copy.") @NonNull HashMap<Key, Item> hashMap$param$, @Name(value="stability") @Defaulted @TypeInfo(value="ceylon.collection::Stability") @DocAnnotation$annotation$(description="Determines whether this is a linked hash map with a\nstable iteration order, defaulting to the stability\nof the copied `HashMap`.") @NonNull Stability stability$param$, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable$param$) {
        Iterator entry$iterator$$28;
        java.lang.Object entries;
        this.$reified$Key = $reified$Key;
        this.$reified$Item = $reified$Item;
        this.$ceylon$language$Map$this$ = new Map.impl($reified$Key, $reified$Item, (Map)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl(TypeDescriptor.klass(Entry.class, (TypeDescriptor[])new TypeDescriptor[]{$reified$Key, $reified$Item}), Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Object.$TypeDescriptor$, $reified$Item, (Correspondence)this);
        this.$ceylon$collection$MapMutator$this$ = new MapMutator$impl($reified$Key, $reified$Item, this);
        this.head = null;
        this.tip = null;
        this.stability = stability$param$;
        this.hashtable = hashtable$param$;
        boolean accurateInitialCapacity = true;
        this.setStore$priv$(cachingEntryStore_.cachingEntryStore($reified$Key, $reified$Item, super.getStore$priv$().getSize()));
        if (stability$param$.equals(unlinked_.get_())) {
            entries = empty_.get_();
            this.setLength$priv$(super.getLength$priv$());
            for (long index = 0L; index < super.getStore$priv$().getSize(); ++index) {
                CachingCell bucket$149 = (CachingCell)super.getStore$priv$().getFromFirst(index);
                if (bucket$149 == null) continue;
                CachingCell bucket$150 = bucket$149;
                this.getStore$priv$().set(index, bucket$150.$clone());
            }
        } else {
            this.setLength$priv$(0L);
            entries = hashMap$param$;
        }
        java.lang.Object iterable$23 = entries;
        boolean isArray$24 = iterable$23 instanceof Array;
        boolean isTuple$25 = iterable$23 instanceof Tuple && ((Tuple)iterable$23).$getArray$() != null;
        java.lang.Object elem$22 = null;
        int i$26 = 0;
        int length$27 = isArray$24 || isTuple$25 ? (int)iterable$23.getSize() : 0;
        Iterator iterator = entry$iterator$$28 = isTuple$25 || isArray$24 ? null : iterable$23.iterator();
        while (isTuple$25 || isArray$24 ? i$26 < length$27 : !((elem$22 = entry$iterator$$28.next()) instanceof Finished)) {
            if (isArray$24 || isTuple$25) {
                elem$22 = iterable$23.getFromFirst((long)i$26++);
            }
            Entry entry = (Entry)elem$22;
            if (!this.addToStore$priv$(this.getStore$priv$(), entry)) continue;
            long $ceylontmp$op$30 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$30 + 1L);
        }
        if (!accurateInitialCapacity) {
            this.checkRehash$priv$();
        }
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new HashMap(TypeDescriptor.NothingType, TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(HashMap.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Key, this.$reified$Item});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "stability")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "hashtable")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "store")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "head")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashMap.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "tip")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::HashMap.stability": {
                return this.stability;
            }
            case "ceylon.collection::HashMap.hashtable": {
                return this.hashtable;
            }
            case "ceylon.collection::HashMap.store": {
                return this.store;
            }
            case "ceylon.collection::HashMap.length": {
                return Integer.instance((long)this.length);
            }
            case "ceylon.collection::HashMap.head": {
                return this.head;
            }
            case "ceylon.collection::HashMap.tip": {
                return this.tip;
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::HashMap.stability": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"stability").invokeExact(this, (Stability)instance);
                    break;
                }
                case "ceylon.collection::HashMap.hashtable": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"hashtable").invokeExact(this, (Hashtable)instance);
                    break;
                }
                case "ceylon.collection::HashMap.store": {
                    this.store = (Array)instance;
                    break;
                }
                case "ceylon.collection::HashMap.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                case "ceylon.collection::HashMap.head": {
                    this.head = (LinkedCell)instance;
                    break;
                }
                case "ceylon.collection::HashMap.tip": {
                    this.tip = (LinkedCell)instance;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="copy")
    public static final class copy_ {
        copy_() {
        }
    }
}

