/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.CachingCell;
import ceylon.collection.CachingStoreIterator;
import ceylon.collection.Hashtable;
import ceylon.collection.LinkedCell;
import ceylon.collection.LinkedCellIterator;
import ceylon.collection.MutableSet;
import ceylon.collection.SetMutator$impl;
import ceylon.collection.Stability;
import ceylon.collection.cachingElementStore_;
import ceylon.collection.linked_;
import ceylon.collection.unlinked_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.Set;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[MutableSet]] implemented as a hash set stored in an \n[[Array]] of singly linked lists. Each element is assigned \nan index of the array according to its hash code. The hash \ncode of an element is defined by [[Object.hash]].\n\nThe [[stability]] of a `HashSet` controls its iteration\norder:\n\n- A [[linked]] set has a stable and meaningful order of \n  iteration. The elements of the set form a linked list, \n  where new elements are added to the end of the linked \n  list. Iteration of the set follows this linked list, from \n  least recently added elements to most recently added \n  elements.\n- An [[unlinked]] set has an unstable iteration order that \n  may change when the set is modified. The order itself is \n  not meaningful to a client.\n\nThe stability is `linked` by default.\n\nThe management of the backing array is controlled by the\ngiven [[hashtable]].")
@AuthorsAnnotation$annotation$(authors={"St\u00e9phane \u00c9pardaud", "Gavin King"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.collection::MutableSet<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
@Class(constructors=true)
public class HashSet<Element>
implements ReifiedType,
MutableSet<Element>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final Set.impl<Element> $ceylon$language$Set$this$;
    @Ignore
    protected final Collection.impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final SetMutator$impl<Element> $ceylon$collection$SetMutator$this$;
    @Ignore
    private final Stability stability;
    @Ignore
    private final Hashtable hashtable;
    @Ignore
    private Array<CachingCell<Element>> store;
    @Ignore
    private long length;
    @Ignore
    private LinkedCell<Element> head;
    @Ignore
    private LinkedCell<Element> tip;
    @Ignore
    public static final copy_ copy_ = null;

    @Ignore
    public HashSet(TypeDescriptor $reified$Element) {
        Stability $ceylontmp$stability$111 = HashSet.HashSet$stability($reified$Element);
        Hashtable $ceylontmp$hashtable$112 = HashSet.HashSet$hashtable($reified$Element, $ceylontmp$stability$111);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$113 = HashSet.HashSet$elements($reified$Element, $ceylontmp$stability$111, $ceylontmp$hashtable$112);
        this($reified$Element, $ceylontmp$stability$111, $ceylontmp$hashtable$112, $ceylontmp$elements$113);
    }

    @Ignore
    public HashSet(TypeDescriptor $reified$Element, Stability stability$param$) {
        Hashtable $ceylontmp$hashtable$114 = HashSet.HashSet$hashtable($reified$Element, stability$param$);
        Iterable<Element, java.lang.Object> $ceylontmp$elements$115 = HashSet.HashSet$elements($reified$Element, stability$param$, $ceylontmp$hashtable$114);
        this($reified$Element, stability$param$, $ceylontmp$hashtable$114, $ceylontmp$elements$115);
    }

    @Ignore
    public HashSet(TypeDescriptor $reified$Element, Stability stability$param$, Hashtable hashtable$param$) {
        Iterable<Element, java.lang.Object> $ceylontmp$elements$116 = HashSet.HashSet$elements($reified$Element, stability$param$, hashtable$param$);
        this($reified$Element, stability$param$, hashtable$param$, $ceylontmp$elements$116);
    }

    @Ignore
    public HashSet(TypeDescriptor $reified$Element, @Ignore copy_ $name$, HashSet<Element> hashSet$param$) {
        Stability $ceylontmp$stability$122 = HashSet.HashSet$copy$stability($reified$Element, hashSet$param$);
        Hashtable $ceylontmp$hashtable$123 = HashSet.HashSet$copy$hashtable($reified$Element, hashSet$param$, $ceylontmp$stability$122);
        this($reified$Element, $name$, hashSet$param$, $ceylontmp$stability$122, $ceylontmp$hashtable$123);
    }

    @Ignore
    public HashSet(TypeDescriptor $reified$Element, @Ignore copy_ $name$, HashSet<Element> hashSet$param$, Stability stability$param$) {
        Hashtable $ceylontmp$hashtable$124 = HashSet.HashSet$copy$hashtable($reified$Element, hashSet$param$, stability$param$);
        this($reified$Element, $name$, hashSet$param$, stability$param$, $ceylontmp$hashtable$124);
    }

    @Ignore
    public HashSet($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Set$this$ = new Set.impl($reified$Element, (Set)this);
        this.$ceylon$collection$SetMutator$this$ = new SetMutator$impl($reified$Element, this);
        this.stability = null;
        this.hashtable = null;
        this.store = null;
        this.length = 0L;
        this.head = null;
        this.tip = null;
    }

    @Ignore
    public Set.impl<? extends Element> $ceylon$language$Set$impl() {
        return this.$ceylon$language$Set$this$;
    }

    @Override
    @Ignore
    public final <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Set$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public final Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Set$this$.getDistinct();
    }

    @Ignore
    public boolean subset(Set<? extends java.lang.Object> set) {
        return this.$ceylon$language$Set$this$.subset(set);
    }

    @Ignore
    public boolean superset(Set<? extends java.lang.Object> set) {
        return this.$ceylon$language$Set$this$.superset(set);
    }

    @Ignore
    public Collection.impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Iterable.impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Ignore
    public boolean any(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.any(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Ignore
    public <Result> Sequential collect(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.collect($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Ignore
    public boolean every(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.every(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Override
    @Ignore
    public Element find(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.find(selecting);
    }

    @Override
    @Ignore
    public Element findLast(Callable<? extends Boolean> selecting) {
        return (Element)this.$ceylon$language$Iterable$this$.findLast(selecting);
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public Element getFromFirst(long index) {
        return (Element)this.$ceylon$language$Iterable$this$.getFromFirst(index);
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$0 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$0);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$Iterable$this$.longerThan(length);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public <Result> java.lang.Object reduce(TypeDescriptor $reified$Result, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.reduce($reified$Result, accumulating);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> repeat(long times) {
        return this.$ceylon$language$Iterable$this$.repeat(times);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getRest() {
        return this.$ceylon$language$Iterable$this$.getRest();
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Sequential sequence() {
        return this.$ceylon$language$Iterable$this$.sequence();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$Iterable$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public Sequential sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Override
    @Ignore
    public SetMutator$impl<? super Element> $ceylon$collection$SetMutator$impl() {
        return this.$ceylon$collection$SetMutator$this$;
    }

    @Override
    @Ignore
    public boolean removeAll(Iterable<? extends Element, ? extends java.lang.Object> elements) {
        return this.$ceylon$collection$SetMutator$this$.removeAll(elements);
    }

    @DocAnnotation$annotation$(description="Determines whether this is a linked hash set with a\nstable iteration order.")
    @TypeInfo(value="ceylon.collection::Stability")
    @NonNull
    private final Stability getStability$priv$() {
        return this.stability;
    }

    @DocAnnotation$annotation$(description="Performance-related settings for the backing array.")
    @TypeInfo(value="ceylon.collection::Hashtable")
    @NonNull
    private final Hashtable getHashtable$priv$() {
        return this.hashtable;
    }

    @DocAnnotation$annotation$(description="Array of linked lists where we store the elements.\n\nEach element is stored in a linked list from this array\nat the index of the hash code of the element, modulo \nthe array size.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Element>?>")
    @NonNull
    private final Array<CachingCell<Element>> getStore$priv$() {
        return this.store;
    }

    private final void setStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Element>?>") @NonNull Array<CachingCell<Element>> store) {
        this.store = store;
    }

    @DocAnnotation$annotation$(description="Number of elements in this set.")
    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    @DocAnnotation$annotation$(description="Head of the traversal linked list if in `linked` mode. \nStorage is done in [[store]], but traversal is done\nusing an alternative linked list maintained to have a \nstable iteration order. Note that the cells used are \nthe same as in the [[store]], except for storage we use \n[[CachingCell.rest]] for traversal, while for the stable \niteration we use the \n[[LinkedCell.next]]/[[LinkedCell.previous]] attributes \nof the same cell.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::LinkedCell<Element>?")
    @Nullable
    private final LinkedCell<Element> getHead$priv$() {
        return this.head;
    }

    private final void setHead$priv$(@Name(value="head") @TypeInfo(value="ceylon.collection::LinkedCell<Element>?") @Nullable LinkedCell<Element> head) {
        this.head = head;
    }

    @DocAnnotation$annotation$(description="Tip of the traversal linked list if in `linked` mode.")
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::LinkedCell<Element>?")
    @Nullable
    private final LinkedCell<Element> getTip$priv$() {
        return this.tip;
    }

    private final void setTip$priv$(@Name(value="tip") @TypeInfo(value="ceylon.collection::LinkedCell<Element>?") @Nullable LinkedCell<Element> tip) {
        this.tip = tip;
    }

    private final long hashCode$priv$(@Name(value="key") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object key) {
        long h = key.hashCode();
        return h ^ h >>> 16;
    }

    private final long storeIndex$priv$(@Name(value="elemHash") long elemHash, @Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Element>?>") @NonNull Array<CachingCell<Element>> store) {
        return elemHash & store.getSize() - 1L;
    }

    @TypeInfo(value="ceylon.collection::CachingCell<Element>")
    @NonNull
    private final CachingCell<Element> createCell$priv$(@Name(value="elem") @TypeInfo(value="Element") Element elem, @Name(value="elemHash") long elemHash, @Name(value="rest") @TypeInfo(value="ceylon.collection::CachingCell<Element>?") @Nullable CachingCell<Element> rest) {
        if (this.getStability$priv$().equals(linked_.get_())) {
            LinkedCell<Element> cell = new LinkedCell<Element>(this.$reified$Element, elem, elemHash, rest, this.getTip$priv$());
            LinkedCell<Element> last$3 = this.getTip$priv$();
            if (last$3 != null) {
                LinkedCell<Element> last$4 = last$3;
                last$4.setNext(cell);
            }
            this.setTip$priv$(cell);
            if (this.getHead$priv$() == null) {
                this.setHead$priv$(cell);
            }
            return cell;
        }
        return new CachingCell<Element>(this.$reified$Element, elem, elemHash, rest);
    }

    private final void deleteCell$priv$(@Name(value="cell") @TypeInfo(value="ceylon.collection::CachingCell<Element>") @NonNull CachingCell<Element> cell) {
        if (this.getStability$priv$().equals(linked_.get_())) {
            CachingCell<Element> cell$7 = null;
            cell$7 = cell;
            if (!(cell$7 instanceof LinkedCell) || !Util.isReified(cell$7, (TypeDescriptor)TypeDescriptor.klass(LinkedCell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}))) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is LinkedCell<Element> cell" + Util.assertIsFailed((boolean)false, (TypeDescriptor)TypeDescriptor.klass(LinkedCell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}), cell$7));
            }
            LinkedCell cell$8 = (LinkedCell)cell$7;
            LinkedCell last$10 = cell$8.getPrevious();
            if (last$10 != null) {
                LinkedCell last$11 = last$10;
                last$11.setNext(cell$8.getNext());
            } else {
                this.setHead$priv$(cell$8.getNext());
            }
            LinkedCell next$13 = cell$8.getNext();
            if (next$13 != null) {
                LinkedCell next$14 = next$13;
                next$14.setPrevious(cell$8.getPrevious());
            } else {
                this.setTip$priv$(cell$8.getPrevious());
            }
        }
    }

    private final boolean addToStore$priv$(@Name(value="store") @TypeInfo(value="ceylon.language::Array<ceylon.collection::CachingCell<Element>?>") @NonNull Array<CachingCell<Element>> store, @Name(value="element") @TypeInfo(value="Element") Element element) {
        CachingCell<Element> cell$15;
        CachingCell<Element> headBucket;
        long elementHash = this.hashCode$priv$(element);
        long index = this.storeIndex$priv$(elementHash, store);
        CachingCell<Element> bucket = headBucket = (CachingCell<Element>)store.getFromFirst(index);
        while ((cell$15 = bucket) != null) {
            CachingCell<Element> cell$16 = cell$15;
            if (cell$16.getKeyHash() == elementHash && cell$16.getElement().equals(element)) {
                cell$16.setElement(element);
                return false;
            }
            bucket = cell$16.getRest();
        }
        store.set(index, this.createCell$priv$(element, elementHash, headBucket));
        return true;
    }

    private final void checkRehash$priv$() {
        if (this.getHashtable$priv$().rehash(this.getLength$priv$(), this.getStore$priv$().getSize())) {
            Array newStore = cachingElementStore_.cachingElementStore(this.$reified$Element, this.getHashtable$priv$().capacity(this.getLength$priv$()));
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                CachingCell cell$19;
                CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
                while ((cell$19 = bucket) != null) {
                    CachingCell cell$20 = cell$19;
                    bucket = cell$20.getRest();
                    long newIndex = this.storeIndex$priv$(cell$20.getKeyHash(), newStore);
                    CachingCell newBucket = (CachingCell)newStore.getFromFirst(newIndex);
                    cell$20.setRest(newBucket);
                    newStore.set(newIndex, cell$20);
                }
            }
            this.setStore$priv$(newStore);
        }
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean add(@Name(value="element") @TypeInfo(value="Element") Element element) {
        if (this.addToStore$priv$(this.getStore$priv$(), element)) {
            long $ceylontmp$op$33 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$33 + 1L);
            this.checkRehash$priv$();
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean addAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterator elem$iterator$$41;
        boolean ret = false;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$36 = elements;
        boolean isArray$37 = iterable$36 instanceof Array;
        boolean isTuple$38 = iterable$36 instanceof Tuple && ((Tuple)iterable$36).$getArray$() != null;
        java.lang.Object elem$35 = null;
        int i$39 = 0;
        int length$40 = isArray$37 || isTuple$38 ? (int)iterable$36.getSize() : 0;
        Iterator iterator = elem$iterator$$41 = isTuple$38 || isArray$37 ? null : iterable$36.iterator();
        while (isTuple$38 || isArray$37 ? i$39 < length$40 : !((elem$35 = elem$iterator$$41.next()) instanceof Finished)) {
            if (isArray$37 || isTuple$38) {
                elem$35 = iterable$36.getFromFirst((long)i$39++);
            }
            java.lang.Object elem = elem$35;
            if (!this.addToStore$priv$(this.getStore$priv$(), elem)) continue;
            long $ceylontmp$op$43 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$43 + 1L);
            ret = true;
        }
        if (ret) {
            this.checkRehash$priv$();
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean remove(@Name(value="element") @TypeInfo(value="Element") Element element) {
        CachingCell cell$49;
        CachingCell head$47;
        long elementHash = this.hashCode$priv$(element);
        long index = this.storeIndex$priv$(elementHash, this.getStore$priv$());
        CachingCell head$46 = (CachingCell)this.getStore$priv$().getFromFirst(index);
        if (head$46 != null && (head$47 = head$46).getElement().equals(element)) {
            this.getStore$priv$().set(index, head$47.getRest());
            this.deleteCell$priv$(head$47);
            long $ceylontmp$op$48 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$48 - 1L);
            return true;
        }
        CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
        while ((cell$49 = bucket) != null) {
            CachingCell rest$53;
            CachingCell cell$50 = cell$49;
            CachingCell rest = cell$50.getRest();
            boolean $ceylontmp$if$51 = false;
            CachingCell rest$52 = rest;
            if (rest$52 != null) {
                rest$53 = rest$52;
                if (rest$53.getKeyHash() == elementHash && rest$53.getElement().equals(element)) {
                    $ceylontmp$if$51 = true;
                }
            } else {
                rest$53 = null;
            }
            if ($ceylontmp$if$51) {
                cell$50.setRest(rest$53.getRest());
                this.deleteCell$priv$(rest$53);
                long $ceylontmp$op$54 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$54 - 1L);
                return true;
            }
            bucket = rest;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object clear() {
        long index = 0L;
        while (index < this.getStore$priv$().getSize()) {
            this.getStore$priv$().set(index++, null);
        }
        this.setLength$priv$(0L);
        this.setHead$priv$(null);
        this.setTip$priv$(null);
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    @NonNull
    public final Iterator<? extends Element> iterator() {
        return (Iterator)(this.getStability$priv$().equals(linked_.get_()) ? new LinkedCellIterator<Element>(this.$reified$Element, this.getHead$priv$()) : new CachingStoreIterator<Element>(this.$reified$Element, this.getStore$priv$()));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        long count = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            CachingCell cell$55;
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$55 = bucket) != null) {
                CachingCell cell$56 = cell$55;
                if (((Boolean)selecting.$call$(cell$56.getElement())).booleanValue()) {
                    ++count;
                }
                bucket = cell$56.getRest();
            }
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(final @Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") @NonNull Callable<? extends java.lang.Object> step) {
        this.getStore$priv$().each((Callable)new AbstractCallable<java.lang.Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(CachingCell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})})}), "Anything(CachingCell<Element>?)", -1){

            @Ignore
            public java.lang.Object $call$(java.lang.Object $param$0) {
                CachingCell cell$58;
                CachingCell bucket;
                CachingCell iter = bucket = (CachingCell)$param$0;
                while ((cell$58 = iter) != null) {
                    CachingCell cell$59 = cell$58;
                    step.$call$(cell$59.getElement());
                    iter = cell$59.getRest();
                }
                return null;
            }
        });
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long hash = 0L;
        for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
            CachingCell cell$61;
            CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
            while ((cell$61 = bucket) != null) {
                CachingCell cell$62 = cell$61;
                hash += (long)cell$62.getElement().hashCode();
                bucket = cell$62.getRest();
            }
        }
        long $ceylontmp$hash$63 = hash;
        return (int)($ceylontmp$hash$63 ^ $ceylontmp$hash$63 >>> 32);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        Set that$69;
        HashSet that$66;
        boolean $ceylontmp$if$64 = false;
        java.lang.Object that$65 = that;
        if (that$65 instanceof HashSet && Util.isReified((java.lang.Object)that$65, (TypeDescriptor)TypeDescriptor.klass(HashSet.class, (TypeDescriptor[])new TypeDescriptor[]{Anything.$TypeDescriptor$}))) {
            that$66 = (HashSet)that$65;
            if (this == that$66) {
                $ceylontmp$if$64 = true;
            }
        } else {
            that$66 = null;
        }
        if ($ceylontmp$if$64) {
            return true;
        }
        boolean $ceylontmp$if$67 = false;
        java.lang.Object that$68 = that;
        if (that$68 instanceof Set) {
            that$69 = (Set)that$68;
            if (that$69.getSize() == this.getLength$priv$()) {
                $ceylontmp$if$67 = true;
            }
        } else {
            that$69 = null;
        }
        if ($ceylontmp$if$67) {
            for (long index = 0L; index < this.getStore$priv$().getSize(); ++index) {
                CachingCell cell$70;
                CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
                while ((cell$70 = bucket) != null) {
                    CachingCell cell$71 = cell$70;
                    java.lang.Object $ceylontmp$73 = cell$71.getElement();
                    if (!that$69.contains($ceylontmp$73)) {
                        return false;
                    }
                    bucket = cell$71.getRest();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashSet<Element>")
    @NonNull
    public final HashSet<Element> $clone() {
        return new HashSet<Element>(this.$reified$Element, copy_, this);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        CachingCell cell$75;
        if (this.getEmpty()) {
            return false;
        }
        long elementHash = this.hashCode$priv$(element);
        long index = this.storeIndex$priv$(elementHash, this.getStore$priv$());
        CachingCell bucket = (CachingCell)this.getStore$priv$().getFromFirst(index);
        while ((cell$75 = bucket) != null) {
            CachingCell cell$76 = cell$75;
            if (cell$76.getKeyHash() == elementHash && cell$76.getElement().equals(element)) {
                return true;
            }
            bucket = cell$76.getRest();
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashSet<Element>")
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public final <Other> HashSet<Element> complement(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") @NonNull Set<? extends Other> set) {
        java.lang.Object elem$79;
        HashSet<java.lang.Object> ret = new HashSet<java.lang.Object>(this.$reified$Element);
        Iterator elem$iterator$$80 = this.iterator();
        while (!((elem$79 = elem$iterator$$80.next()) instanceof Finished)) {
            java.lang.Object elem = elem$79;
            java.lang.Object $ceylontmp$82 = elem;
            if (set.contains($ceylontmp$82)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashSet<Element|Other>", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public final <Other> HashSet exclusiveUnion(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") @NonNull Set<? extends Other> set) {
        java.lang.Object elem$89;
        java.lang.Object elem$84;
        HashSet<java.lang.Object> ret = new HashSet<java.lang.Object>(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        Iterator elem$iterator$$85 = this.iterator();
        while (!((elem$84 = elem$iterator$$85.next()) instanceof Finished)) {
            java.lang.Object elem = elem$84;
            java.lang.Object $ceylontmp$87 = elem;
            if (set.contains($ceylontmp$87)) continue;
            ret.add(elem);
        }
        Iterator elem$iterator$$90 = set.iterator();
        while (!((elem$89 = elem$iterator$$90.next()) instanceof Finished)) {
            java.lang.Object elem = elem$89;
            java.lang.Object $ceylontmp$92 = elem;
            if (this.contains($ceylontmp$92)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashSet<Element&Other>", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public final <Other> HashSet intersection(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") @NonNull Set<? extends Other> set) {
        java.lang.Object elem$94;
        HashSet<java.lang.Object> ret = new HashSet<java.lang.Object>(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        Iterator elem$iterator$$95 = this.iterator();
        while (!((elem$94 = elem$iterator$$95.next()) instanceof Finished)) {
            java.lang.Object elem = elem$94;
            java.lang.Object $ceylontmp$97 = elem;
            if (!set.contains($ceylontmp$97) || !Util.isReified((java.lang.Object)elem, (TypeDescriptor)$reified$Other)) continue;
            ret.add(elem);
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::HashSet<Element|Other>", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
    @NonNull
    public final <Other> HashSet union(@Ignore TypeDescriptor $reified$Other, @Name(value="set") @TypeInfo(value="ceylon.language::Set<Other>") @NonNull Set<? extends Other> set) {
        HashSet<Element> ret = new HashSet<Element>(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, $reified$Other}));
        ret.addAll((Iterable<Element, java.lang.Object>)this);
        ret.addAll((Iterable<Element, java.lang.Object>)set);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getFirst() {
        void var1_3;
        CachingCell safe$101;
        LinkedCell<Element> safe$102;
        java.lang.Object $ceylontmp$ifResult$99 = this.getStability$priv$().equals(linked_.get_()) ? ((safe$102 = this.getHead$priv$()) != null ? safe$102.getElement() : null) : ((safe$101 = (CachingCell)this.getStore$priv$().getCoalesced().getFirst()) != null ? safe$101.getElement() : null);
        return var1_3;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getLast() {
        CachingCell safe$105;
        CachingCell cell$104;
        if (this.getStability$priv$().equals(linked_.get_())) {
            LinkedCell<Element> safe$108 = this.getTip$priv$();
            return safe$108 != null ? (Element)safe$108.getElement() : null;
        }
        CachingCell bucket = (CachingCell)this.getStore$priv$().getReversed().getCoalesced().getFirst();
        while ((cell$104 = (safe$105 = bucket) != null ? safe$105.getRest() : null) != null) {
            CachingCell cell$106;
            bucket = cell$106 = cell$104;
        }
        CachingCell safe$107 = bucket;
        return safe$107 != null ? (Element)safe$107.getElement() : null;
    }

    @Ignore
    public static final <Element> Stability HashSet$stability(TypeDescriptor $reified$Element) {
        return linked_.get_();
    }

    @Ignore
    public static final <Element> Hashtable HashSet$hashtable(TypeDescriptor $reified$Element, Stability stability$param$) {
        return new Hashtable();
    }

    @Ignore
    public static final <Element> Iterable<? extends Element, ? extends java.lang.Object> HashSet$elements(TypeDescriptor $reified$Element, Stability stability$param$, Hashtable hashtable$param$) {
        return empty_.get_();
    }

    @DocAnnotation$annotation$(description="Create a new `HashSet` with the given initial elements.")
    @SharedAnnotation$annotation$
    public HashSet(@Ignore TypeDescriptor $reified$Element, @Name(value="stability") @Defaulted @TypeInfo(value="ceylon.collection::Stability") @DocAnnotation$annotation$(description="Determines whether this is a linked hash set with a\nstable iteration order, defaulting to [[linked]]\n(stable).") @NonNull Stability stability$param$, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable$param$, @Name(value="elements") @Defaulted @TypeInfo(value="{Element*}") @DocAnnotation$annotation$(description="The initial elements of the set, defaulting to no\ninitial elements.") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements$param$) {
        Iterator val$iterator$$28;
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Set$this$ = new Set.impl($reified$Element, (Set)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$collection$SetMutator$this$ = new SetMutator$impl($reified$Element, this);
        this.head = null;
        this.tip = null;
        this.stability = stability$param$;
        this.hashtable = hashtable$param$;
        Iterable<? extends Element, ? extends java.lang.Object> elements = elements$param$;
        this.setLength$priv$(0L);
        Iterable<? extends Element, ? extends java.lang.Object> $ceylontmp$110 = elements$param$;
        boolean accurateInitialCapacity = $ceylontmp$110 instanceof ceylon.language.Collection;
        long initialCapacity = accurateInitialCapacity ? hashtable$param$.initialCapacityForSize(elements$param$.getSize()) : hashtable$param$.initialCapacityForUnknownSize();
        this.setStore$priv$(cachingElementStore_.cachingElementStore($reified$Element, initialCapacity));
        Iterable<? extends Element, ? extends java.lang.Object> iterable$23 = elements;
        boolean isArray$24 = iterable$23 instanceof Array;
        boolean isTuple$25 = iterable$23 instanceof Tuple && ((Tuple)iterable$23).$getArray$() != null;
        java.lang.Object elem$22 = null;
        int i$26 = 0;
        int length$27 = isArray$24 || isTuple$25 ? (int)iterable$23.getSize() : 0;
        Iterator iterator = val$iterator$$28 = isTuple$25 || isArray$24 ? null : iterable$23.iterator();
        while (isTuple$25 || isArray$24 ? i$26 < length$27 : !((elem$22 = val$iterator$$28.next()) instanceof Finished)) {
            if (isArray$24 || isTuple$25) {
                elem$22 = iterable$23.getFromFirst((long)i$26++);
            }
            java.lang.Object val = elem$22;
            if (!this.addToStore$priv$(this.getStore$priv$(), val)) continue;
            long $ceylontmp$op$30 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$30 + 1L);
        }
        if (!accurateInitialCapacity) {
            this.checkRehash$priv$();
        }
    }

    @Ignore
    public static final <Element> Stability HashSet$copy$stability(TypeDescriptor $reified$Element, HashSet<Element> hashSet$param$) {
        return super.getStability$priv$();
    }

    @Ignore
    public static final <Element> Hashtable HashSet$copy$hashtable(TypeDescriptor $reified$Element, HashSet<Element> hashSet$param$, Stability stability$param$) {
        return new Hashtable();
    }

    @DocAnnotation$annotation$(description="Create a new `HashSet` with the same initial elements\nas the given [[hashSet]].")
    @SharedAnnotation$annotation$
    @Name(value="copy")
    public HashSet(@Ignore TypeDescriptor $reified$Element, @Ignore copy_ $name$, @Name(value="hashSet") @TypeInfo(value="ceylon.collection::HashSet<Element>") @DocAnnotation$annotation$(description="The `HashSet` to copy.") @NonNull HashSet<Element> hashSet$param$, @Name(value="stability") @Defaulted @TypeInfo(value="ceylon.collection::Stability") @DocAnnotation$annotation$(description="Determines whether this is a linked hash set with a\nstable iteration order, defaulting to the stability\nof the copied `HashSet`.") @NonNull Stability stability$param$, @Name(value="hashtable") @Defaulted @TypeInfo(value="ceylon.collection::Hashtable") @DocAnnotation$annotation$(description="Performance-related settings for the backing array.") @NonNull Hashtable hashtable$param$) {
        Iterator val$iterator$$28;
        java.lang.Object elements;
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Set$this$ = new Set.impl($reified$Element, (Set)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$collection$SetMutator$this$ = new SetMutator$impl($reified$Element, this);
        this.head = null;
        this.tip = null;
        this.stability = stability$param$;
        this.hashtable = hashtable$param$;
        boolean accurateInitialCapacity = true;
        this.setStore$priv$(cachingElementStore_.cachingElementStore($reified$Element, super.getStore$priv$().getSize()));
        if (stability$param$.equals(unlinked_.get_())) {
            elements = empty_.get_();
            this.setLength$priv$(super.getLength$priv$());
            for (long index = 0L; index < super.getStore$priv$().getSize(); ++index) {
                CachingCell bucket$120 = (CachingCell)super.getStore$priv$().getFromFirst(index);
                if (bucket$120 == null) continue;
                CachingCell bucket$121 = bucket$120;
                this.getStore$priv$().set(index, bucket$121.$clone());
            }
        } else {
            this.setLength$priv$(0L);
            elements = hashSet$param$;
        }
        java.lang.Object iterable$23 = elements;
        boolean isArray$24 = iterable$23 instanceof Array;
        boolean isTuple$25 = iterable$23 instanceof Tuple && ((Tuple)iterable$23).$getArray$() != null;
        java.lang.Object elem$22 = null;
        int i$26 = 0;
        int length$27 = isArray$24 || isTuple$25 ? (int)iterable$23.getSize() : 0;
        Iterator iterator = val$iterator$$28 = isTuple$25 || isArray$24 ? null : iterable$23.iterator();
        while (isTuple$25 || isArray$24 ? i$26 < length$27 : !((elem$22 = val$iterator$$28.next()) instanceof Finished)) {
            if (isArray$24 || isTuple$25) {
                elem$22 = iterable$23.getFromFirst((long)i$26++);
            }
            java.lang.Object val = elem$22;
            if (!this.addToStore$priv$(this.getStore$priv$(), val)) continue;
            long $ceylontmp$op$30 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$30 + 1L);
        }
        if (!accurateInitialCapacity) {
            this.checkRehash$priv$();
        }
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new HashSet(TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(HashSet.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "stability")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "hashtable")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "store")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "head")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(HashSet.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "tip")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::HashSet.stability": {
                return this.stability;
            }
            case "ceylon.collection::HashSet.hashtable": {
                return this.hashtable;
            }
            case "ceylon.collection::HashSet.store": {
                return this.store;
            }
            case "ceylon.collection::HashSet.length": {
                return Integer.instance((long)this.length);
            }
            case "ceylon.collection::HashSet.head": {
                return this.head;
            }
            case "ceylon.collection::HashSet.tip": {
                return this.tip;
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::HashSet.stability": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"stability").invokeExact(this, (Stability)instance);
                    break;
                }
                case "ceylon.collection::HashSet.hashtable": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"hashtable").invokeExact(this, (Hashtable)instance);
                    break;
                }
                case "ceylon.collection::HashSet.store": {
                    this.store = (Array)instance;
                    break;
                }
                case "ceylon.collection::HashSet.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                case "ceylon.collection::HashSet.head": {
                    this.head = (LinkedCell)instance;
                    break;
                }
                case "ceylon.collection::HashSet.tip": {
                    this.tip = (LinkedCell)instance;
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="copy")
    public static final class copy_ {
        copy_() {
        }
    }
}

