/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.largest_;
import ceylon.collection.maximumCapacity_;
import ceylon.language.AssertionError;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.runtime_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Performance-related settings for a hashtable based \ncollection like [[HashMap]] or [[HashSet]].\n\nThe size of the backing [[Array]] is called the _capacity_\nof the hashtable.\n\n- The capacity of a new instance is specified by the given \n  [[initialCapacity]].\n- The capacity is increased, and the elements _rehashed_, \n  when the ratio of collection size to capacity exceeds the \n  given [[loadFactor]].\n- The new capacity is the product of the current capacity \n  and the given [[growthFactor]].")
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
public class Hashtable
implements ReifiedType,
java.io.Serializable,
Serializable {
    @Ignore
    private final long initialCapacity;
    @Ignore
    private final double loadFactor;
    @Ignore
    private final double growthFactor;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Hashtable.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @Ignore
    public Hashtable() {
        long $ceylontmp$initialCapacity$0 = Hashtable.$default$initialCapacity();
        double $ceylontmp$loadFactor$1 = Hashtable.$default$loadFactor($ceylontmp$initialCapacity$0);
        double $ceylontmp$growthFactor$2 = Hashtable.$default$growthFactor($ceylontmp$initialCapacity$0, $ceylontmp$loadFactor$1);
        this($ceylontmp$initialCapacity$0, $ceylontmp$loadFactor$1, $ceylontmp$growthFactor$2);
    }

    @Ignore
    public Hashtable(long initialCapacity) {
        double $ceylontmp$loadFactor$3 = Hashtable.$default$loadFactor(initialCapacity);
        double $ceylontmp$growthFactor$4 = Hashtable.$default$growthFactor(initialCapacity, $ceylontmp$loadFactor$3);
        this(initialCapacity, $ceylontmp$loadFactor$3, $ceylontmp$growthFactor$4);
    }

    @Ignore
    public Hashtable(long initialCapacity, double loadFactor) {
        double $ceylontmp$growthFactor$5 = Hashtable.$default$growthFactor(initialCapacity, loadFactor);
        this(initialCapacity, loadFactor, $ceylontmp$growthFactor$5);
    }

    @Ignore
    public Hashtable($Serialization$ ignored) {
        this.initialCapacity = 0L;
        this.loadFactor = 0.0;
        this.growthFactor = 0.0;
    }

    public Hashtable(@Name(value="initialCapacity") @Defaulted @DocAnnotation$annotation$(description="The initial capacity of the backing array.") @SharedAnnotation$annotation$ long initialCapacity, @Name(value="loadFactor") @Defaulted @DocAnnotation$annotation$(description="The ratio between the number of elements and the \ncapacity which triggers a rebuild of the hash set.") @SharedAnnotation$annotation$ double loadFactor, @Name(value="growthFactor") @Defaulted @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.") @SharedAnnotation$annotation$ double growthFactor) {
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.growthFactor = growthFactor;
        long lhs$6 = this.getInitialCapacity();
        long rhs$7 = 0L;
        if (lhs$6 < rhs$7) {
            throw new AssertionError("Assertion failed: initial capacity cannot be negative" + System.lineSeparator() + "\tviolated " + "initialCapacity>=0" + Util.assertBinOpFailed((Object)Integer.instance((long)lhs$6), (Object)Integer.instance((long)rhs$7)));
        }
        long lhs$8 = this.getInitialCapacity();
        long rhs$9 = runtime_.get_().getMaxArraySize();
        if (lhs$8 > rhs$9) {
            throw new AssertionError("Assertion failed: initial capacity too large" + System.lineSeparator() + "\tviolated " + "initialCapacity<=runtime.maxArraySize" + Util.assertBinOpFailed((Object)Integer.instance((long)lhs$8), (Object)Integer.instance((long)rhs$9)));
        }
        double lhs$10 = this.getLoadFactor();
        double rhs$11 = 0.0;
        if (!(lhs$10 > rhs$11)) {
            throw new AssertionError("Assertion failed: load factor must be positive" + System.lineSeparator() + "\tviolated " + "loadFactor>0.0" + Util.assertBinOpFailed((Object)Float.instance((double)lhs$10), (Object)Float.instance((double)rhs$11)));
        }
        double lhs$12 = this.getGrowthFactor();
        double rhs$13 = 1.0;
        if (!(lhs$12 >= rhs$13)) {
            throw new AssertionError("Assertion failed: growth factor must be at least 1.0" + System.lineSeparator() + "\tviolated " + "growthFactor>=1.0" + Util.assertBinOpFailed((Object)Float.instance((double)lhs$12), (Object)Float.instance((double)rhs$13)));
        }
    }

    @Ignore
    public static long $default$initialCapacity() {
        return 16L;
    }

    @Ignore
    public static double $default$loadFactor(long initialCapacity) {
        return 0.75;
    }

    @Ignore
    public static double $default$growthFactor(long initialCapacity, double loadFactor) {
        return 2.0;
    }

    @DocAnnotation$annotation$(description="The initial capacity of the backing array.")
    @SharedAnnotation$annotation$
    public final long getInitialCapacity() {
        return this.initialCapacity;
    }

    @DocAnnotation$annotation$(description="The ratio between the number of elements and the \ncapacity which triggers a rebuild of the hash set.")
    @SharedAnnotation$annotation$
    public final double getLoadFactor() {
        return this.loadFactor;
    }

    @DocAnnotation$annotation$(description="The factor used to determine the new size of the\nbacking array when a new backing array is allocated.")
    @SharedAnnotation$annotation$
    public final double getGrowthFactor() {
        return this.growthFactor;
    }

    @SharedAnnotation$annotation$
    public final boolean rehash(@Name(value="length") long length, @Name(value="capacity") long capacity) {
        return length > Float.getInteger((double)((double)capacity * this.getLoadFactor())) && this.capacity(length) > capacity;
    }

    @SharedAnnotation$annotation$
    public final long capacity(@Name(value="length") long length) {
        return this.powerOf2$priv$(Float.getInteger((double)((double)length * this.getGrowthFactor())));
    }

    @SharedAnnotation$annotation$
    public final long initialCapacityForSize(@Name(value="size") long size) {
        return this.powerOf2$priv$(largest_.largest(this.getInitialCapacity(), Float.getInteger((double)((double)size / this.getLoadFactor() + 1.0))));
    }

    @SharedAnnotation$annotation$
    public final long initialCapacityForUnknownSize() {
        return this.powerOf2$priv$(this.getInitialCapacity());
    }

    private final long powerOf2$priv$(@Name(value="capacity") long capacity) {
        long n = capacity - 1L;
        n = n >>> 1 | n;
        n = n >>> 2 | n;
        n = n >>> 4 | n;
        n = n >>> 8 | n;
        if ((n = n >>> 16 | n) < 0L) {
            return 1L;
        }
        if (n >= maximumCapacity_.get_()) {
            return maximumCapacity_.get_();
        }
        return n + 1L;
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new Hashtable();
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Hashtable.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "initialCapacity")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Hashtable.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "loadFactor")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(Hashtable.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "growthFactor")));
        return reference;
    }

    @Ignore
    public Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::Hashtable.initialCapacity": {
                return Integer.instance((long)this.initialCapacity);
            }
            case "ceylon.collection::Hashtable.loadFactor": {
                return Float.instance((double)this.loadFactor);
            }
            case "ceylon.collection::Hashtable.growthFactor": {
                return Float.instance((double)this.growthFactor);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, Object instance) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::Hashtable.initialCapacity": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"initialCapacity").invokeExact(this, ((Integer)instance).longValue());
                    break;
                }
                case "ceylon.collection::Hashtable.loadFactor": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"loadFactor").invokeExact(this, ((Float)instance).doubleValue());
                    break;
                }
                case "ceylon.collection::Hashtable.growthFactor": {
                    Util.setter((MethodHandles.Lookup)lookup, (String)"growthFactor").invokeExact(this, ((Float)instance).doubleValue());
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }
}

