/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.Cell;
import ceylon.collection.CellIterator;
import ceylon.collection.HashSet;
import ceylon.collection.Hashtable;
import ceylon.collection.ListMutator$impl;
import ceylon.collection.MutableList;
import ceylon.collection.MutableList$impl;
import ceylon.collection.Queue;
import ceylon.collection.Stability;
import ceylon.collection.Stack;
import ceylon.collection.measureToSpan_;
import ceylon.collection.spanToMeasure_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.Collection;
import ceylon.language.Comparison;
import ceylon.language.Correspondence;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.Map;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SerializableAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.language.empty_;
import ceylon.language.finished_;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ClassOrInterfaceDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.process_;
import ceylon.language.serialization.Member;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.language.AbstractIterable;
import com.redhat.ceylon.compiler.java.language.AbstractIterator;
import com.redhat.ceylon.compiler.java.language.ConstantIterable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.ConstructorName;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.metamodel.Metamodel;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import com.redhat.ceylon.compiler.java.runtime.serialization.$Serialization$;
import com.redhat.ceylon.compiler.java.runtime.serialization.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[MutableList]] implemented as a singly linked list.\nAlso:\n\n- a [[Stack]], where the top of the stack is the _first_\n  element of the list, and\n- a [[Queue]], where the front of the queue is the first\n  element of the list and the back of the queue is the\n  last element of the list.")
@AuthorsAnnotation$annotation$(authors={"St\u00e9phane \u00c9pardaud"})
@SharedAnnotation$annotation$
@SerializableAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.collection::MutableList<Element>", "ceylon.collection::Stack<Element>", "ceylon.collection::Queue<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={}, caseTypes={})})
@Class(constructors=true)
public class LinkedList<Element>
implements ReifiedType,
MutableList<Element>,
Stack<Element>,
Queue<Element>,
java.io.Serializable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final MutableList$impl<Element> $ceylon$collection$MutableList$this$;
    @Ignore
    protected final List.impl<Element> $ceylon$language$List$this$;
    @Ignore
    protected final Collection.impl<Element> $ceylon$language$Collection$this$;
    @Ignore
    protected final Iterable.impl<Element, java.lang.Object> $ceylon$language$Iterable$this$;
    @Ignore
    protected final Category.impl<java.lang.Object> $ceylon$language$Category$this$;
    @Ignore
    protected final Correspondence.impl<Integer, Element> $ceylon$language$Correspondence$this$;
    @Ignore
    protected final ListMutator$impl<Element> $ceylon$collection$ListMutator$this$;
    @Ignore
    private Cell<Element> head;
    @Ignore
    private Cell<Element> tail;
    @Ignore
    private long length;
    @Ignore
    public static final copy_ copy_ = null;

    @Ignore
    public LinkedList(TypeDescriptor $reified$Element) {
        Iterable<Element, java.lang.Object> $ceylontmp$elements$300 = LinkedList.LinkedList$elements($reified$Element);
        this($reified$Element, $ceylontmp$elements$300);
    }

    @Ignore
    public LinkedList($Serialization$ ignored, TypeDescriptor $reified$Element) {
        this.$reified$Element = $reified$Element;
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.head = null;
        this.tail = null;
        this.length = 0L;
    }

    @Override
    @Ignore
    public MutableList$impl<Element> $ceylon$collection$MutableList$impl() {
        return this.$ceylon$collection$MutableList$this$;
    }

    @Override
    @Ignore
    public Element deleteFirst() {
        return this.$ceylon$collection$MutableList$this$.deleteFirst();
    }

    @Override
    @Ignore
    public Element deleteLast() {
        return this.$ceylon$collection$MutableList$this$.deleteLast();
    }

    @Override
    @Ignore
    public java.lang.Object move(long i, long j) {
        return this.$ceylon$collection$MutableList$this$.move(i, j);
    }

    @Override
    @Ignore
    public long remove(Element element) {
        return this.$ceylon$collection$MutableList$this$.remove(element);
    }

    @Override
    @Ignore
    public boolean removeFirst(Element element) {
        return this.$ceylon$collection$MutableList$this$.removeFirst(element);
    }

    @Override
    @Ignore
    public boolean removeLast(Element element) {
        return this.$ceylon$collection$MutableList$this$.removeLast(element);
    }

    @Override
    @Ignore
    public long replace(Element element, Element replacement) {
        return this.$ceylon$collection$MutableList$this$.replace(element, replacement);
    }

    @Override
    @Ignore
    public boolean replaceFirst(Element element, Element replacement) {
        return this.$ceylon$collection$MutableList$this$.replaceFirst(element, replacement);
    }

    @Override
    @Ignore
    public boolean replaceLast(Element element, Element replacement) {
        return this.$ceylon$collection$MutableList$this$.replaceLast(element, replacement);
    }

    @Override
    @Ignore
    public java.lang.Object swap(long i, long j) {
        return this.$ceylon$collection$MutableList$this$.swap(i, j);
    }

    @Ignore
    public List.impl<? extends Element> $ceylon$language$List$impl() {
        return this.$ceylon$language$List$this$;
    }

    @Ignore
    public boolean endsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.endsWith(sublist);
    }

    @Override
    @Ignore
    public final Element get(Integer index) {
        return (Element)this.$ceylon$language$List$this$.get(index);
    }

    @Override
    @Ignore
    public Element getFromLast(long index) {
        return (Element)this.$ceylon$language$List$this$.getFromLast(index);
    }

    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> indexesWhere(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$List$this$.indexesWhere(selecting);
    }

    @Override
    @Ignore
    public List<? extends Element> initial(long length) {
        return this.$ceylon$language$List$this$.initial(length);
    }

    @Ignore
    public List<? extends Integer> getKeys() {
        return this.$ceylon$language$List$this$.getKeys();
    }

    @Ignore
    public boolean longerThan(long length) {
        return this.$ceylon$language$List$this$.longerThan(length);
    }

    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor $reified$Result, Callable<? extends Result> mapping) {
        return this.$ceylon$language$List$this$.mapElements($reified$Result, mapping);
    }

    @Ignore
    public final <Other> long patch$from(TypeDescriptor $reified$Other, List<? extends Other> list) {
        return this.$ceylon$language$List$this$.patch$from($reified$Other, list);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list) {
        long $ceylontmp$from$0 = this.patch$from($reified$Other, list);
        long $ceylontmp$length$1 = this.patch$length($reified$Other, list, $ceylontmp$from$0);
        return this.patch$canonical$($reified$Other, list, $ceylontmp$from$0, $ceylontmp$length$1);
    }

    @Ignore
    public final <Other> long patch$length(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        return this.$ceylon$language$List$this$.patch$length($reified$Other, list, from);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from) {
        long $ceylontmp$length$2 = this.patch$length($reified$Other, list, from);
        return this.patch$canonical$($reified$Other, list, from, $ceylontmp$length$2);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Ignore
    private <Other> List patch$canonical$(TypeDescriptor $reified$Other, List<? extends Other> list, long from, long length) {
        return this.$ceylon$language$List$this$.patch($reified$Other, list, from, length);
    }

    @Override
    @Ignore
    public List<? extends Element> repeat(long times) {
        return this.$ceylon$language$List$this$.repeat(times);
    }

    @Override
    @Ignore
    public List<? extends Element> getRest() {
        return this.$ceylon$language$List$this$.getRest();
    }

    @Override
    @Ignore
    public List<? extends Element> getReversed() {
        return this.$ceylon$language$List$this$.getReversed();
    }

    @Ignore
    public boolean shorterThan(long length) {
        return this.$ceylon$language$List$this$.shorterThan(length);
    }

    @Override
    @Ignore
    public Sequence slice(long index) {
        return this.$ceylon$language$List$this$.slice(index);
    }

    @Ignore
    public boolean startsWith(List<? extends java.lang.Object> sublist) {
        return this.$ceylon$language$List$this$.startsWith(sublist);
    }

    @Override
    @Ignore
    public List<? extends Element> sublist(long from, long to) {
        return this.$ceylon$language$List$this$.sublist(from, to);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistFrom(long from) {
        return this.$ceylon$language$List$this$.sublistFrom(from);
    }

    @Override
    @Ignore
    public List<? extends Element> sublistTo(long to) {
        return this.$ceylon$language$List$this$.sublistTo(to);
    }

    @Override
    @Ignore
    public List<? extends Element> terminal(long length) {
        return this.$ceylon$language$List$this$.terminal(length);
    }

    @Override
    @Ignore
    public List<? extends Element> trim(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trim(trimming);
    }

    @Override
    @Ignore
    public List<? extends Element> trimLeading(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trimLeading(trimming);
    }

    @Override
    @Ignore
    public List<? extends Element> trimTrailing(Callable<? extends Boolean> trimming) {
        return this.$ceylon$language$List$this$.trimTrailing(trimming);
    }

    @Ignore
    public Collection.impl<? extends Element> $ceylon$language$Collection$impl() {
        return this.$ceylon$language$Collection$this$;
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$this$.combinations(length);
    }

    @Ignore
    public boolean getEmpty() {
        return this.$ceylon$language$Collection$this$.getEmpty();
    }

    @Override
    @Ignore
    public final Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$this$.getPermutations();
    }

    @Ignore
    public String toString() {
        return this.$ceylon$language$Collection$this$.toString();
    }

    @Ignore
    public Iterable.impl<? extends Element, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return this.$ceylon$language$Iterable$this$;
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$this$.by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.chain($reified$Other, $reified$OtherAbsent, other);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCoalesced() {
        return this.$ceylon$language$Iterable$this$.getCoalesced();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$this$.getCycled();
    }

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor $reified$Default, Default defaultValue) {
        return this.$ceylon$language$Iterable$this$.defaultNullElements($reified$Default, defaultValue);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$this$.getDistinct();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$this$.getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> filter(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.filter(selecting);
    }

    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor $reified$Result, TypeDescriptor $reified$OtherAbsent, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return this.$ceylon$language$Iterable$this$.flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.fold($reified$Result, initial);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor $reified$Other, Other head) {
        return this.$ceylon$language$Iterable$this$.follow($reified$Other, head);
    }

    @Override
    @Ignore
    public final Map<? extends Element, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$this$.frequencies();
    }

    @Override
    @Ignore
    public final <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor $reified$Group, Callable<? extends Group> grouping) {
        return this.$ceylon$language$Iterable$this$.group($reified$Group, grouping);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$this$.getIndexed();
    }

    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$this$.indexes();
    }

    @Ignore
    public final <Other> long interpose$step(TypeDescriptor $reified$Other, Other element) {
        return this.$ceylon$language$Iterable$this$.interpose$step($reified$Other, element);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element) {
        long $ceylontmp$step$3 = this.interpose$step($reified$Other, element);
        return this.interpose$canonical$($reified$Other, element, $ceylontmp$step$3);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Ignore
    private <Other> Iterable interpose$canonical$(TypeDescriptor $reified$Other, Other element, long step) {
        return this.$ceylon$language$Iterable$this$.interpose($reified$Other, element, step);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locate(selecting);
    }

    @Override
    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locateLast(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends java.lang.Object> locations(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.locations(selecting);
    }

    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.map($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Element max(Callable<? extends Comparison> comparing) {
        return (Element)this.$ceylon$language$Iterable$this$.max(comparing);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor $reified$Type) {
        return this.$ceylon$language$Iterable$this$.narrow($reified$Type);
    }

    @Override
    @Ignore
    public Iterable getPaired() {
        return this.$ceylon$language$Iterable$this$.getPaired();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends java.lang.Object> partition(long length) {
        return this.$ceylon$language$Iterable$this$.partition(length);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor $reified$Other, TypeDescriptor $reified$OtherAbsent, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return this.$ceylon$language$Iterable$this$.product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor $reified$Result, Result initial) {
        return this.$ceylon$language$Iterable$this$.scan($reified$Result, initial);
    }

    @Override
    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> selecting) {
        return this.$ceylon$language$Iterable$this$.select(selecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skip(long skipping) {
        return this.$ceylon$language$Iterable$this$.skip(skipping);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> skipping) {
        return this.$ceylon$language$Iterable$this$.skipWhile(skipping);
    }

    @Override
    @Ignore
    public Sequential sort(Callable<? extends Comparison> comparing) {
        return this.$ceylon$language$Iterable$this$.sort(comparing);
    }

    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor $reified$Result, TypeDescriptor $reified$Args, Callable<? extends Callable<? extends Result>> method) {
        return this.$ceylon$language$Iterable$this$.spread($reified$Result, $reified$Args, method);
    }

    @Ignore
    public final <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor $reified$Group, TypeDescriptor $reified$Result, Callable<? extends Group> grouping, Callable<? extends Result> accumulating) {
        return this.$ceylon$language$Iterable$this$.summarize($reified$Group, $reified$Result, grouping, accumulating);
    }

    @Override
    @Ignore
    public final <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor $reified$Result, Callable<? extends Result> collecting) {
        return this.$ceylon$language$Iterable$this$.tabulate($reified$Result, collecting);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> take(long taking) {
        return this.$ceylon$language$Iterable$this$.take(taking);
    }

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> taking) {
        return this.$ceylon$language$Iterable$this$.takeWhile(taking);
    }

    @Ignore
    public Category.impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return this.$ceylon$language$Category$this$;
    }

    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsAny(elements);
    }

    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> elements) {
        return this.$ceylon$language$Category$this$.containsEvery(elements);
    }

    @Ignore
    public Correspondence.impl<? super Integer, ? extends Element> $ceylon$language$Correspondence$impl() {
        return this.$ceylon$language$Correspondence$this$;
    }

    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesAny(keys);
    }

    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends java.lang.Object> keys) {
        return this.$ceylon$language$Correspondence$this$.definesEvery(keys);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor $reified$Absent, Iterable<? extends Integer, ? extends Absent> keys) {
        return this.$ceylon$language$Correspondence$this$.getAll($reified$Absent, keys);
    }

    @Override
    @Ignore
    public ListMutator$impl<? super Element> $ceylon$collection$ListMutator$impl() {
        return this.$ceylon$collection$ListMutator$this$;
    }

    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::Cell<Element>?")
    @Nullable
    private final Cell<Element> getHead$priv$() {
        return this.head;
    }

    private final void setHead$priv$(@Name(value="head") @TypeInfo(value="ceylon.collection::Cell<Element>?") @Nullable Cell<Element> head) {
        this.head = head;
    }

    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::Cell<Element>?")
    @Nullable
    private final Cell<Element> getTail$priv$() {
        return this.tail;
    }

    private final void setTail$priv$(@Name(value="tail") @TypeInfo(value="ceylon.collection::Cell<Element>?") @Nullable Cell<Element> tail) {
        this.tail = tail;
    }

    @VariableAnnotation$annotation$
    private final long getLength$priv$() {
        return this.length;
    }

    private final void setLength$priv$(@Name(value="length") long length) {
        this.length = length;
    }

    private final void addToTail$priv$(@Name(value="element") @TypeInfo(value="Element") Element element) {
        Cell<Element> newTail = new Cell<Element>(this.$reified$Element, element, null);
        Cell<Element> tail$5 = this.getTail$priv$();
        if (tail$5 != null) {
            Cell<Element> tail$7 = tail$5;
            tail$7.setRest(newTail);
            this.setTail$priv$(newTail);
        } else {
            Cell<Element> $ceylontmp$op$6 = newTail;
            this.setHead$priv$($ceylontmp$op$6);
            this.setTail$priv$($ceylontmp$op$6);
        }
        long $ceylontmp$op$8 = this.getLength$priv$();
        this.setLength$priv$($ceylontmp$op$8 + 1L);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object set(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        Cell<Element> cell$12;
        long lhs$9 = 0L;
        long middle$10 = index;
        long rhs$11 = this.getLength$priv$();
        if (lhs$9 > middle$10 || middle$10 >= rhs$11) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlast index in the list" + System.lineSeparator() + "\tviolated " + "0<=index<length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$9), (java.lang.Object)Integer.instance((long)middle$10), (java.lang.Object)Integer.instance((long)rhs$11)));
        }
        Cell<Element> iter = this.getHead$priv$();
        long i = 0L;
        while ((cell$12 = iter) != null) {
            Cell<Element> cell$13 = cell$12;
            if (i++ == index) {
                cell$13.setElement(element);
                return null;
            }
            iter = cell$13.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object insert(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        long lhs$15 = 0L;
        long middle$16 = index;
        long rhs$17 = this.getLength$priv$();
        if (lhs$15 > middle$16 || middle$16 > rhs$17) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlength of the list" + System.lineSeparator() + "\tviolated " + "0<=index<=length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$15), (java.lang.Object)Integer.instance((long)middle$16), (java.lang.Object)Integer.instance((long)rhs$17)));
        }
        if (index == this.getLength$priv$()) {
            this.add(element);
        } else if (index == 0L) {
            this.setHead$priv$(new Cell<Element>(this.$reified$Element, element, this.getHead$priv$()));
            long $ceylontmp$op$24 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$24 + 1L);
        } else {
            Cell<Element> cell$20;
            Cell<Element> iter = this.getHead$priv$();
            long i = 0L;
            while ((cell$20 = iter) != null) {
                Cell<Element> cell$21 = cell$20;
                Cell<Element> rest = cell$21.getRest();
                if (++i == index) {
                    cell$21.setRest(new Cell<Element>(this.$reified$Element, element, rest));
                    long $ceylontmp$op$23 = this.getLength$priv$();
                    this.setLength$priv$($ceylontmp$op$23 + 1L);
                    return null;
                }
                iter = rest;
            }
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object insertAll(@Name(value="index") long index, @Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        long lhs$25 = 0L;
        long middle$26 = index;
        long rhs$27 = this.getLength$priv$();
        if (lhs$25 > middle$26 || middle$26 > rhs$27) {
            throw new AssertionError("Assertion failed: index may not be negative or greater than the\nlength of the list" + System.lineSeparator() + "\tviolated " + "0<=index<=length" + Util.assertWithinOpFailed((java.lang.Object)Integer.instance((long)lhs$25), (java.lang.Object)Integer.instance((long)middle$26), (java.lang.Object)Integer.instance((long)rhs$27)));
        }
        if (index == this.getLength$priv$()) {
            this.addAll(elements);
        } else {
            Array reversed = new Array(this.$reified$Element, elements);
            reversed.reverseInPlace();
            if (index == 0L) {
                this.setHead$priv$((Cell)reversed.fold(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})}), this.getHead$priv$()).$call$((java.lang.Object)new AbstractCallable<Cell<Element>>(TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}), TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})}), this.$reified$Element}), "Cell<Element>(Cell<Element>?, Element)", -1){

                    @Ignore
                    public Cell<Element> $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                        Cell rest = (Cell)$param$0;
                        java.lang.Object element = $param$1;
                        return new Cell<java.lang.Object>(LinkedList.this.$reified$Element, element, rest);
                    }
                }));
                long $ceylontmp$op$34 = this.getLength$priv$() + reversed.getSize();
                this.setLength$priv$($ceylontmp$op$34);
            } else {
                Cell<Element> cell$30;
                Cell<Element> iter = this.getHead$priv$();
                long i = 0L;
                while ((cell$30 = iter) != null) {
                    Cell<Element> cell$31 = cell$30;
                    Cell<Element> rest = cell$31.getRest();
                    if (++i == index) {
                        cell$31.setRest((Cell)reversed.fold(TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})}), rest).$call$((java.lang.Object)new AbstractCallable<Cell<Element>>(TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element}), TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{TypeDescriptor.union((TypeDescriptor[])new TypeDescriptor[]{Null.$TypeDescriptor$, TypeDescriptor.klass(Cell.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element})}), this.$reified$Element}), "Cell<Element>(Cell<Element>?, Element)", -1){

                            @Ignore
                            public Cell<Element> $call$(java.lang.Object $param$0, java.lang.Object $param$1) {
                                Cell rest = (Cell)$param$0;
                                java.lang.Object element = $param$1;
                                return new Cell<java.lang.Object>(LinkedList.this.$reified$Element, element, rest);
                            }
                        }));
                        long $ceylontmp$op$33 = this.getLength$priv$() + reversed.getSize();
                        this.setLength$priv$($ceylontmp$op$33);
                        return null;
                    }
                    iter = rest;
                }
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
            }
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object add(@Name(value="element") @TypeInfo(value="Element") Element element) {
        this.addToTail$priv$(element);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object addAll(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Iterator element$iterator$$42;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$37 = elements;
        boolean isArray$38 = iterable$37 instanceof Array;
        boolean isTuple$39 = iterable$37 instanceof Tuple && ((Tuple)iterable$37).$getArray$() != null;
        java.lang.Object elem$36 = null;
        int i$40 = 0;
        int length$41 = isArray$38 || isTuple$39 ? (int)iterable$37.getSize() : 0;
        Iterator iterator = element$iterator$$42 = isTuple$39 || isArray$38 ? null : iterable$37.iterator();
        while (isTuple$39 || isArray$38 ? i$40 < length$41 : !((elem$36 = element$iterator$$42.next()) instanceof Finished)) {
            if (isArray$38 || isTuple$39) {
                elem$36 = iterable$37.getFromFirst((long)i$40++);
            }
            java.lang.Object element = elem$36;
            this.add(element);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element delete(@Name(value="index") long index) {
        if (index == 0L) {
            Cell<Element> cell$56 = this.getHead$priv$();
            if (cell$56 != null) {
                Cell<Element> cell$57 = cell$56;
                Cell<Element> rest$59 = cell$57.getRest();
                if (rest$59 != null) {
                    Cell<Element> rest$61 = rest$59;
                    this.setHead$priv$(rest$61);
                } else {
                    Cell<Element> $ceylontmp$op$60 = null;
                    this.setTail$priv$($ceylontmp$op$60);
                    this.setHead$priv$($ceylontmp$op$60);
                }
                long $ceylontmp$op$62 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$62 - 1L);
                return cell$57.getElement();
            }
            return null;
        }
        long middle$45 = index;
        if (0L < middle$45 && middle$45 < this.getLength$priv$()) {
            Cell cell$46;
            Cell iter = this.getHead$priv$();
            long i = 0L;
            while ((cell$46 = iter) != null) {
                Cell cell$47 = cell$46;
                Cell<Element> rest = cell$47.getRest();
                if (++i == index) {
                    Cell<Element> safe$51 = rest;
                    Cell<Element> more$50 = safe$51 != null ? safe$51.getRest() : null;
                    if (more$50 != null) {
                        Cell<Element> more$52 = more$50;
                        cell$47.setRest(more$52);
                    } else {
                        this.setTail$priv$(cell$47);
                        cell$47.setRest(null);
                    }
                    long $ceylontmp$op$53 = this.getLength$priv$();
                    this.setLength$priv$($ceylontmp$op$53 - 1L);
                    Cell<Element> safe$54 = rest;
                    return safe$54 != null ? (Element)safe$54.getElement() : null;
                }
                iter = rest;
            }
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long removeAll(@Name(value="elements") @TypeInfo(value="{Element&ceylon.language::Object*}") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements) {
        Cell<Element> cell$74;
        Element elem$67;
        Element $ceylontmp$68;
        Cell<Element> cell$65;
        Element elem$66;
        Cell<Element> cell$64;
        TypeDescriptor arg$63$reified$0 = TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, Object.$TypeDescriptor$});
        ConstantIterable arg$63$2 = new ConstantIterable(TypeDescriptor.intersection((TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element, Object.$TypeDescriptor$}), Null.$TypeDescriptor$, elements, new java.lang.Object[0]);
        Stability arg$63$0 = HashSet.HashSet$stability(arg$63$reified$0);
        Hashtable arg$63$1 = HashSet.HashSet$hashtable(arg$63$reified$0, arg$63$0);
        HashSet set = new HashSet(arg$63$reified$0, arg$63$0, arg$63$1, arg$63$2);
        long result = 0L;
        while ((cell$64 = this.getHead$priv$()) != null && (elem$66 = (cell$65 = cell$64).getElement()) != null && set.contains($ceylontmp$68 = (elem$67 = elem$66))) {
            Cell<Element> rest$70 = cell$65.getRest();
            if (rest$70 != null) {
                Cell<Element> rest$72 = rest$70;
                this.setHead$priv$(rest$72);
            } else {
                Cell<Element> $ceylontmp$op$71 = null;
                this.setTail$priv$($ceylontmp$op$71);
                this.setHead$priv$($ceylontmp$op$71);
            }
            long $ceylontmp$op$73 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$73 - 1L);
            ++result;
        }
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$74 = iter) != null) {
            java.lang.Object elem$80;
            Cell<Element> rest$78;
            Cell<Element> cell$75 = cell$74;
            Cell<Element> rest = cell$75.getRest();
            boolean $ceylontmp$if$76 = false;
            Cell<Element> rest$77 = rest;
            if (rest$77 != null) {
                rest$78 = rest$77;
                Element elem$79 = rest$78.getElement();
                if (elem$79 != null) {
                    elem$80 = elem$79;
                    java.lang.Object $ceylontmp$81 = elem$80;
                    if (set.contains($ceylontmp$81)) {
                        $ceylontmp$if$76 = true;
                    }
                } else {
                    elem$80 = null;
                }
            } else {
                rest$78 = null;
                elem$80 = null;
            }
            if ($ceylontmp$if$76) {
                Cell<Element> more$83 = rest$78.getRest();
                if (more$83 != null) {
                    Cell<Element> more$85 = more$83;
                    cell$75.setRest(more$85);
                } else {
                    Cell<Element> $ceylontmp$op$84 = null;
                    this.setTail$priv$($ceylontmp$op$84);
                    cell$75.setRest($ceylontmp$op$84);
                }
                long $ceylontmp$op$86 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$86 - 1L);
                ++result;
                continue;
            }
            iter = rest;
        }
        return result;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$97;
        Element elem$91;
        Cell<Element> cell$89;
        Element elem$90;
        Cell<Element> cell$88 = this.getHead$priv$();
        if (cell$88 != null && (elem$90 = (cell$89 = cell$88).getElement()) != null && ((Boolean)selecting.$call$(elem$91 = elem$90)).booleanValue()) {
            Cell<Element> rest$93 = cell$89.getRest();
            if (rest$93 != null) {
                Cell<Element> rest$95 = rest$93;
                this.setHead$priv$(rest$95);
            } else {
                Cell<Element> $ceylontmp$op$94 = null;
                this.setTail$priv$($ceylontmp$op$94);
                this.setHead$priv$($ceylontmp$op$94);
            }
            long $ceylontmp$op$96 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$96 - 1L);
            return elem$91;
        }
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$97 = iter) != null) {
            Element elem$103;
            Cell<Element> rest$101;
            Element elem$102;
            Cell<Element> cell$98 = cell$97;
            Cell<Element> rest = cell$98.getRest();
            Cell<Element> rest$100 = rest;
            if (rest$100 != null && (elem$102 = (rest$101 = rest$100).getElement()) != null && ((Boolean)selecting.$call$(elem$103 = elem$102)).booleanValue()) {
                Cell<Element> more$105 = rest$101.getRest();
                if (more$105 != null) {
                    Cell<Element> more$107 = more$105;
                    cell$98.setRest(more$107);
                } else {
                    Cell<Element> $ceylontmp$op$106 = null;
                    this.setTail$priv$($ceylontmp$op$106);
                    cell$98.setRest($ceylontmp$op$106);
                }
                long $ceylontmp$op$108 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$108 - 1L);
                return elem$103;
            }
            iter = rest;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Integer index$110 = this.lastIndexWhere(selecting);
        if (index$110 != null) {
            long index$111 = index$110.longValue();
            return this.delete(index$111);
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long removeWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$121;
        Element elem$115;
        Cell<Element> cell$113;
        Element elem$114;
        Cell<Element> cell$112;
        long result = 0L;
        while ((cell$112 = this.getHead$priv$()) != null && (elem$114 = (cell$113 = cell$112).getElement()) != null && ((Boolean)selecting.$call$(elem$115 = elem$114)).booleanValue()) {
            Cell<Element> rest$117 = cell$113.getRest();
            if (rest$117 != null) {
                Cell<Element> rest$119 = rest$117;
                this.setHead$priv$(rest$119);
            } else {
                Cell<Element> $ceylontmp$op$118 = null;
                this.setTail$priv$($ceylontmp$op$118);
                this.setHead$priv$($ceylontmp$op$118);
            }
            long $ceylontmp$op$120 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$120 - 1L);
            ++result;
        }
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$121 = iter) != null) {
            java.lang.Object elem$127;
            Cell<Element> rest$125;
            Cell<Element> cell$122 = cell$121;
            Cell<Element> rest = cell$122.getRest();
            boolean $ceylontmp$if$123 = false;
            Cell<Element> rest$124 = rest;
            if (rest$124 != null) {
                rest$125 = rest$124;
                Element elem$126 = rest$125.getElement();
                if (elem$126 != null) {
                    elem$127 = elem$126;
                    if (((Boolean)selecting.$call$(elem$127)).booleanValue()) {
                        $ceylontmp$if$123 = true;
                    }
                } else {
                    elem$127 = null;
                }
            } else {
                rest$125 = null;
                elem$127 = null;
            }
            if ($ceylontmp$if$123) {
                Cell<Element> more$129 = rest$125.getRest();
                if (more$129 != null) {
                    Cell<Element> more$131 = more$129;
                    cell$122.setRest(more$131);
                } else {
                    Cell<Element> $ceylontmp$op$130 = null;
                    this.setTail$priv$($ceylontmp$op$130);
                    cell$122.setRest($ceylontmp$op$130);
                }
                long $ceylontmp$op$132 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$132 - 1L);
                ++result;
                continue;
            }
            iter = rest;
        }
        return result;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long prune() {
        Cell<Element> cell$140;
        Cell<Element> cell$134;
        Cell<Element> cell$133;
        long originalLength = this.getLength$priv$();
        while ((cell$133 = this.getHead$priv$()) != null && (cell$134 = cell$133).getElement() == null) {
            Cell<Element> rest$136 = cell$134.getRest();
            if (rest$136 != null) {
                Cell<Element> rest$138 = rest$136;
                this.setHead$priv$(rest$138);
            } else {
                Cell<Element> $ceylontmp$op$137 = null;
                this.setTail$priv$($ceylontmp$op$137);
                this.setHead$priv$($ceylontmp$op$137);
            }
            long $ceylontmp$op$139 = this.getLength$priv$();
            this.setLength$priv$($ceylontmp$op$139 - 1L);
        }
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$140 = iter) != null) {
            Cell<Element> rest$144;
            Cell<Element> cell$141 = cell$140;
            Cell<Element> rest = cell$141.getRest();
            boolean $ceylontmp$if$142 = false;
            Cell<Element> rest$143 = rest;
            if (rest$143 != null) {
                rest$144 = rest$143;
                if (rest$144.getElement() == null) {
                    $ceylontmp$if$142 = true;
                }
            } else {
                rest$144 = null;
            }
            if ($ceylontmp$if$142) {
                Cell<Element> more$146 = rest$144.getRest();
                if (more$146 != null) {
                    Cell<Element> more$148 = more$146;
                    cell$141.setRest(more$148);
                } else {
                    Cell<Element> $ceylontmp$op$147 = null;
                    this.setTail$priv$($ceylontmp$op$147);
                    cell$141.setRest($ceylontmp$op$147);
                }
                long $ceylontmp$op$149 = this.getLength$priv$();
                this.setLength$priv$($ceylontmp$op$149 - 1L);
                continue;
            }
            iter = rest;
        }
        return originalLength - this.getLength$priv$();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Cell<Element> cell$150;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$150 = iter) != null) {
            Element elem$154;
            Cell<Element> cell$151 = cell$150;
            Element elem$153 = cell$151.getElement();
            if (elem$153 != null && ((Boolean)selecting.$call$(elem$154 = elem$153)).booleanValue()) {
                cell$151.setElement(replacement);
                return elem$154;
            }
            iter = cell$151.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Cell<Element> cell$155;
        Cell<Element> last = null;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$155 = iter) != null) {
            Element elem$159;
            Cell<Element> cell$156 = cell$155;
            Element elem$158 = cell$156.getElement();
            if (elem$158 != null && ((Boolean)selecting.$call$(elem$159 = elem$158)).booleanValue()) {
                last = cell$156;
            }
            iter = cell$156.getRest();
        }
        Cell<Element> cell$161 = last;
        if (cell$161 != null) {
            Cell<Element> cell$162 = cell$161;
            java.lang.Object result = cell$162.getElement();
            cell$162.setElement(replacement);
            return result;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long replaceWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Cell<Element> cell$163;
        long count = 0L;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$163 = iter) != null) {
            Element elem$167;
            Cell<Element> cell$164 = cell$163;
            Element elem$166 = cell$164.getElement();
            if (elem$166 != null && ((Boolean)selecting.$call$(elem$167 = elem$166)).booleanValue()) {
                cell$164.setElement(replacement);
                ++count;
            }
            iter = cell$164.getRest();
        }
        return count;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object infill(@Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        Cell<Element> cell$168;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$168 = iter) != null) {
            Cell<Element> cell$169 = cell$168;
            if (cell$169.getElement() == null) {
                cell$169.setElement(replacement);
            }
            iter = cell$169.getRest();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object clear() {
        void var1_1;
        this.setLength$priv$(0L);
        Cell<Element> $ceylontmp$op$171 = null;
        this.setTail$priv$($ceylontmp$op$171);
        this.setHead$priv$((Cell<Element>)var1_1);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element getFromFirst(@Name(value="index") long index) {
        Cell<Element> cell$172;
        Cell<Element> iter = this.getHead$priv$();
        long i = 0L;
        while ((cell$172 = iter) != null) {
            Cell<Element> cell$173 = cell$172;
            if (i++ == index) {
                return cell$173.getElement();
            }
            iter = cell$173.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List spanFrom(@Name(value="from") @NonNull Integer from) {
        Cell<Element> cell$175;
        LinkedList<Element> ret = new LinkedList<Element>(this.$reified$Element);
        Cell<Element> iter = this.getHead$priv$();
        long i = 0L;
        while ((cell$175 = iter) != null) {
            Cell<Element> cell$176 = cell$175;
            if (i >= from.longValue()) {
                ret.add(cell$176.getElement());
            }
            ++i;
            iter = cell$176.getRest();
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List spanTo(@Name(value="to") @NonNull Integer to) {
        Cell<Element> cell$178;
        LinkedList<Element> ret = new LinkedList<Element>(this.$reified$Element);
        Cell<Element> iter = this.getHead$priv$();
        long i = 0L;
        while ((cell$178 = iter) != null) {
            Cell<Element> cell$179 = cell$178;
            if (i > to.longValue()) break;
            ret.add(cell$179.getElement());
            ++i;
            iter = cell$179.getRest();
        }
        return ret;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List span(@Name(value="from") @NonNull Integer from, @Name(value="to") @NonNull Integer to) {
        Sequence $pattern$tuple$181 = spanToMeasure_.spanToMeasure(from.longValue(), to.longValue(), this.getLength$priv$());
        long start = ((Integer)$pattern$tuple$181.getFromFirst(0L)).longValue();
        long len = ((Integer)$pattern$tuple$181.getFromFirst(1L)).longValue();
        boolean reversed = ((Boolean)$pattern$tuple$181.getFromFirst(2L)).booleanValue();
        List result = new LinkedList(this.$reified$Element, this.skip(start).take(len));
        return reversed ? result.getReversed() : result;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object deleteSpan(@Name(value="from") long from, @Name(value="to") long to) {
        Sequence $pattern$tuple$182 = spanToMeasure_.spanToMeasure(from, to, this.getLength$priv$());
        long start = ((Integer)$pattern$tuple$182.getFromFirst(0L)).longValue();
        long len = ((Integer)$pattern$tuple$182.getFromFirst(1L)).longValue();
        boolean _ = ((Boolean)$pattern$tuple$182.getFromFirst(2L)).booleanValue();
        if (start < this.getLength$priv$() && len > 0L) {
            Cell<Element> preCell$188;
            boolean keepHead = start > 0L;
            Cell<Element> lastPreMeasureCell = this.advanceBy$priv$(start - 1L, this.getHead$priv$());
            long skipCells = len + (keepHead ? 1L : 0L);
            Cell<Element> $ceylontmp$184 = lastPreMeasureCell;
            Cell<Element> firstPostMeasureCell = this.advanceBy$priv$(skipCells, $ceylontmp$184 != null ? $ceylontmp$184 : this.getHead$priv$());
            if (!keepHead) {
                Cell<Element> $ceylontmp$186 = lastPreMeasureCell;
                this.setHead$priv$($ceylontmp$186 != null ? $ceylontmp$186 : firstPostMeasureCell);
            }
            if ((preCell$188 = lastPreMeasureCell) != null) {
                Cell<Element> preCell$189 = preCell$188;
                preCell$189.setRest(firstPostMeasureCell);
            }
            if (len >= this.getLength$priv$()) {
                this.setTail$priv$(null);
            }
            long $ceylontmp$op$191 = this.getLength$priv$() - len;
            this.setLength$priv$($ceylontmp$op$191);
        }
        return null;
    }

    @TypeInfo(value="ceylon.collection::Cell<Element>?")
    @Nullable
    private final Cell<Element> advanceBy$priv$(@Name(value="cells") long cells, @Name(value="start") @TypeInfo(value="ceylon.collection::Cell<Element>?") @Nullable Cell<Element> start) {
        Cell<Element> result;
        block4: {
            if (cells < 0L) {
                return null;
            }
            result = start;
            Cell<Element> start$194 = start;
            if (start$194 == null) break block4;
            Cell<Element> start$195 = start$194;
            if (cells > 0L) {
                long $ceylontmp$first$198 = 1L;
                long $ceylontmp$last$199 = cells;
                boolean $ceylontmp$increasing$200 = Integer.offset((long)$ceylontmp$last$199, (long)1L) >= 0L;
                long $ceylontmp$incr$201 = $ceylontmp$increasing$200 ? 1L : -1L;
                long i$204 = 1L;
                long $ceylontmp$element$203 = 1L;
                boolean $ceylontmp$f$202 = false;
                do {
                    if ($ceylontmp$f$202) {
                        $ceylontmp$element$203 += $ceylontmp$incr$201;
                    }
                    $ceylontmp$f$202 = true;
                    long i = i$204 = $ceylontmp$element$203;
                    Cell<Element> safe$205 = result;
                    Cell<Element> cell = result = safe$205 != null ? safe$205.getRest() : null;
                } while (!$ceylontmp$increasing$200 ? i$204 - $ceylontmp$last$199 != 0L : i$204 - $ceylontmp$last$199 != 0L);
            }
        }
        return result;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::List<Element>", erased=true, untrusted=true)
    @NonNull
    public final List measure(@Name(value="from") @NonNull Integer from, @Name(value="length") long length) {
        Sequence<? extends Integer> tuple$206 = measureToSpan_.measureToSpan(from.longValue(), length);
        return this.span((Integer)tuple$206.get(Integer.instance((long)0L)), (Integer)tuple$206.get(Integer.instance((long)1L)));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object deleteMeasure(@Name(value="from") long from, @Name(value="length") long length) {
        Sequence<? extends Integer> tuple$208 = measureToSpan_.measureToSpan(from, length);
        this.deleteSpan(((Integer)tuple$208.get(Integer.instance((long)0L))).longValue(), ((Integer)tuple$208.get(Integer.instance((long)1L))).longValue());
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean defines(@Name(value="index") @NonNull Integer index) {
        return index.longValue() >= 0L && index.longValue() < this.getLength$priv$();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object element) {
        Cell<Element> cell$210;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$210 = iter) != null) {
            Element elem$214;
            Cell<Element> cell$211 = cell$210;
            Element elem$213 = cell$211.getElement();
            if (elem$213 != null && (elem$214 = elem$213).equals(element)) {
                return true;
            }
            iter = cell$211.getRest();
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSize() {
        return this.getLength$priv$();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$216;
        Cell<Element> iter = this.getHead$priv$();
        long count = 0L;
        while ((cell$216 = iter) != null) {
            Cell<Element> cell$217 = cell$216;
            if (((Boolean)selecting.$call$(cell$217.getElement())).booleanValue()) {
                ++count;
            }
            iter = cell$217.getRest();
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Transient
    @Nullable
    public final Integer getLastIndex() {
        return !this.getEmpty() ? Integer.instance((long)(this.getLength$priv$() - 1L)) : null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Iterator<Element>")
    @NonNull
    public final Iterator<? extends Element> iterator() {
        return new CellIterator<Element>(this.$reified$Element, this.getHead$priv$());
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::LinkedList<Element>")
    @NonNull
    public final LinkedList<Element> $clone() {
        return new LinkedList<Element>(this.$reified$Element, copy_, this);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object each(@Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Anything(Element)") @NonNull Callable<? extends java.lang.Object> step) {
        Cell<Element> cell$219;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$219 = iter) != null) {
            Cell<Element> cell$220 = cell$219;
            step.$call$(cell$220.getElement());
            iter = cell$220.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element find(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$221;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$221 = iter) != null) {
            Element element$225;
            Cell<Element> cell$222 = cell$221;
            Element element = cell$222.getElement();
            Element element$224 = element;
            if (element$224 != null && ((Boolean)selecting.$call$(element$225 = element$224)).booleanValue()) {
                return element$225;
            }
            iter = cell$222.getRest();
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findLast(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$226;
        Element result = null;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$226 = iter) != null) {
            Element element$230;
            Cell<Element> cell$227 = cell$226;
            Element element = cell$227.getElement();
            Element element$229 = element;
            if (element$229 != null && ((Boolean)selecting.$call$(element$230 = element$229)).booleanValue()) {
                result = element$230;
            }
            iter = cell$227.getRest();
        }
        return result;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean every(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$231;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$231 = iter) != null) {
            Cell<Element> cell$232 = cell$231;
            if (!((Boolean)selecting.$call$(cell$232.getElement())).booleanValue()) {
                return false;
            }
            iter = cell$232.getRest();
        }
        return true;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean any(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        Cell<Element> cell$234;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$234 = iter) != null) {
            Cell<Element> cell$235 = cell$234;
            if (((Boolean)selecting.$call$(cell$235.getElement())).booleanValue()) {
                return true;
            }
            iter = cell$235.getRest();
        }
        return false;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Result|Element|ceylon.language::Null", erased=true)
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @Nullable
    public final <Result> java.lang.Object reduce(@Ignore TypeDescriptor $reified$Result, @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="Result(Result|Element, Element)") @NonNull Callable<? extends Result> accumulating) {
        Cell<Element> first$238 = this.getHead$priv$();
        if (first$238 != null) {
            Cell<Element> cell$240;
            Cell<Element> first$239 = first$238;
            java.lang.Object partial = first$239.getElement();
            Cell<Element> iter = first$239.getRest();
            while ((cell$240 = iter) != null) {
                Cell<Element> cell$241 = cell$240;
                partial = accumulating.$call$(partial, cell$241.getElement());
                iter = cell$241.getRest();
            }
            return partial;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        Cell<Element> cell$243;
        long hash = 1L;
        Cell<Element> iter = this.getHead$priv$();
        while ((cell$243 = iter) != null) {
            Cell<Element> cell$244 = cell$243;
            hash *= 31L;
            Element car$246 = cell$244.getElement();
            if (car$246 != null) {
                Element car$247 = car$246;
                hash += (long)car$247.hashCode();
            }
            iter = cell$244.getRest();
        }
        long $ceylontmp$hash$248 = hash;
        return (int)($ceylontmp$hash$248 ^ $ceylontmp$hash$248 >>> 32);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull java.lang.Object that) {
        java.lang.Object that$250 = that;
        if (that$250 instanceof LinkedList && Util.isReified((java.lang.Object)that$250, (TypeDescriptor)TypeDescriptor.klass(LinkedList.class, (TypeDescriptor[])new TypeDescriptor[]{Anything.$TypeDescriptor$}))) {
            Cell<Element> thisCell$254;
            LinkedList that$251 = (LinkedList)that$250;
            if (this == that$251) {
                return true;
            }
            if (this.getLength$priv$() != that$251.getLength$priv$()) {
                return false;
            }
            Cell<Element> thisIter = this.getHead$priv$();
            Cell<Element> thatIter = that$251.getHead$priv$();
            while ((thisCell$254 = thisIter) != null) {
                Cell<Element> thisCell$255 = thisCell$254;
                Cell<Element> thatCell$256 = thatIter;
                if (thatCell$256 == null) break;
                Cell<Element> thatCell$257 = thatCell$256;
                Element thisElement = thisCell$255.getElement();
                Element thatElement = thatCell$257.getElement();
                Element thisElement$259 = thisElement;
                if (thisElement$259 != null) {
                    Element thisElement$262 = thisElement$259;
                    Element thatElement$264 = thatElement;
                    if (thatElement$264 == null) {
                        Element thatElement$267 = thatElement$264;
                        return false;
                    }
                    Element thatElement$265 = thatElement$264;
                    if (!thisElement$262.equals(thatElement$265)) {
                        return false;
                    }
                } else {
                    Element thisElement$260 = thisElement$259;
                    if (thatElement != null) {
                        return false;
                    }
                }
                thisIter = thisCell$255.getRest();
                thatIter = thatCell$257.getRest();
            }
            return true;
        }
        return this.$ceylon$language$List$this$.equals(that);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object truncate(@Name(value="size") long size) {
        long lhs$268 = size;
        long rhs$269 = 0L;
        if (lhs$268 < rhs$269) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "size>=0" + Util.assertBinOpFailed((java.lang.Object)Integer.instance((long)lhs$268), (java.lang.Object)Integer.instance((long)rhs$269)));
        }
        if (size == 0L) {
            Cell<Element> $ceylontmp$op$276 = null;
            this.setTail$priv$($ceylontmp$op$276);
            this.setHead$priv$($ceylontmp$op$276);
            this.setLength$priv$(0L);
        } else {
            Cell cell$271;
            long i = 0L;
            Cell iter = this.getHead$priv$();
            while (++i < size && (cell$271 = iter) != null) {
                Cell cell$272 = cell$271;
                iter = cell$272.getRest();
            }
            Cell cell$274 = iter;
            if (cell$274 != null) {
                Cell cell$275 = cell$274;
                cell$275.setRest(null);
                this.setTail$priv$(cell$275);
                this.setLength$priv$(size);
            }
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public final Integer firstIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        java.lang.Object elem$278;
        long index = 0L;
        Iterator element$iterator$$279 = this.iterator();
        while (!((elem$278 = element$iterator$$279.next()) instanceof Finished)) {
            java.lang.Object element$282;
            java.lang.Object element = elem$278;
            java.lang.Object element$281 = element;
            if (element$281 != null && ((Boolean)selecting.$call$(element$282 = element$281)).booleanValue()) {
                return Integer.instance((long)index);
            }
            ++index;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public final Integer lastIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> selecting) {
        java.lang.Object elem$284;
        long index = 0L;
        Integer result = null;
        Iterator element$iterator$$285 = this.iterator();
        while (!((elem$284 = element$iterator$$285.next()) instanceof Finished)) {
            java.lang.Object element$288;
            java.lang.Object element = elem$284;
            java.lang.Object element$287 = element;
            if (element$287 != null && ((Boolean)selecting.$call$(element$288 = element$287)).booleanValue()) {
                result = Integer.instance((long)index);
            }
            ++index;
        }
        return result;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="[Result+]|[]", erased=true)
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public final <Result> Sequential collect(final @Ignore TypeDescriptor $reified$Result, final @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(Element)") @NonNull Callable<? extends Result> collecting) {
        return new AbstractIterable<Result, java.lang.Object>($reified$Result, Null.$TypeDescriptor$){

            public final Iterator<Result> iterator() {
                return new AbstractIterator<Result>($reified$Result){
                    private final Iterator<? extends Element> $iterator$0;
                    private Element element;
                    private boolean element$exhausted$;
                    {
                        this.$iterator$0 = LinkedList.this.iterator();
                    }

                    private final boolean element() {
                        java.lang.Object $ceylontmp$item$289 = this.$iterator$0.next();
                        boolean bl = this.element$exhausted$ = $ceylontmp$item$289 == finished_.get_();
                        if (this.element$exhausted$) {
                            return false;
                        }
                        this.element = $ceylontmp$item$289;
                        return true;
                    }

                    public final java.lang.Object next() {
                        if (this.element()) {
                            java.lang.Object element = this.element;
                            return collecting.$call$(element);
                        }
                        return finished_.get_();
                    }
                };
            }
        }.sequence();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getFirst() {
        Cell<Element> safe$290 = this.getHead$priv$();
        return safe$290 != null ? (Element)safe$290.getElement() : null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?", erased=true, untrusted=true)
    @Transient
    @Nullable
    public final Element getLast() {
        Cell<Element> safe$291 = this.getTail$priv$();
        return safe$291 != null ? (Element)safe$291.getElement() : null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object push(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return this.insert(0L, element);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element pop() {
        return this.deleteFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getTop() {
        return this.getFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final java.lang.Object offer(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return this.add(element);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element accept() {
        return this.deleteFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getBack() {
        return this.getLast();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Transient
    @Nullable
    public final Element getFront() {
        return this.getFirst();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="[Element+]|[]", erased=true)
    @NonNull
    public final Sequential sequence() {
        return new Array(this.$reified$Element, (Iterable)this).sequence();
    }

    @Ignore
    public static final <Element> Iterable<? extends Element, ? extends java.lang.Object> LinkedList$elements(TypeDescriptor $reified$Element) {
        return empty_.get_();
    }

    @DocAnnotation$annotation$(description="Create a new `LinkedList` with the given initial \n[[elements]].")
    @SharedAnnotation$annotation$
    public LinkedList(@Ignore TypeDescriptor $reified$Element, @Name(value="elements") @Defaulted @TypeInfo(value="{Element*}") @DocAnnotation$annotation$(description="The initial elements of the list.") @NonNull Iterable<? extends Element, ? extends java.lang.Object> elements$param$) {
        Iterator element$iterator$$299;
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.head = null;
        this.tail = null;
        this.length = 0L;
        Iterable<? extends Element, ? extends java.lang.Object> iterable$294 = elements$param$;
        boolean isArray$295 = iterable$294 instanceof Array;
        boolean isTuple$296 = iterable$294 instanceof Tuple && ((Tuple)iterable$294).$getArray$() != null;
        java.lang.Object elem$293 = null;
        int i$297 = 0;
        int length$298 = isArray$295 || isTuple$296 ? (int)iterable$294.getSize() : 0;
        Iterator iterator = element$iterator$$299 = isTuple$296 || isArray$295 ? null : iterable$294.iterator();
        while (isTuple$296 || isArray$295 ? i$297 < length$298 : !((elem$293 = element$iterator$$299.next()) instanceof Finished)) {
            if (isArray$295 || isTuple$296) {
                elem$293 = iterable$294.getFromFirst((long)i$297++);
            }
            java.lang.Object element = elem$293;
            this.addToTail$priv$(element);
        }
    }

    @DocAnnotation$annotation$(description="Create a new `LinkedList` with the same initial \nelements as the given [[linkedList]].")
    @SharedAnnotation$annotation$
    @Name(value="copy")
    public LinkedList(@Ignore TypeDescriptor $reified$Element, @Ignore copy_ $name$, @Name(value="linkedList") @TypeInfo(value="ceylon.collection::LinkedList<Element>") @DocAnnotation$annotation$(description="The `LinkedList` to copy.") @NonNull LinkedList<Element> linkedList$param$) {
        Cell<Element> cell$301;
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$MutableList$this$ = new MutableList$impl($reified$Element, this);
        this.$ceylon$language$List$this$ = new List.impl($reified$Element, (List)this);
        this.$ceylon$language$Collection$this$ = new Collection.impl($reified$Element, (ceylon.language.Collection)this);
        this.$ceylon$language$Iterable$this$ = new Iterable.impl($reified$Element, Null.$TypeDescriptor$, (Iterable)this);
        this.$ceylon$language$Category$this$ = new Category.impl(Object.$TypeDescriptor$, (Category)this);
        this.$ceylon$language$Correspondence$this$ = new Correspondence.impl(Integer.$TypeDescriptor$, $reified$Element, (Correspondence)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator$impl($reified$Element, this);
        this.head = null;
        this.tail = null;
        this.length = 0L;
        Cell<Element> iter = super.getHead$priv$();
        while ((cell$301 = iter) != null) {
            Cell<Element> cell$302 = cell$301;
            this.addToTail$priv$(cell$302.getElement());
            iter = cell$302.getRest();
        }
    }

    @Ignore
    public static void main(String[] args) {
        process_.get_().setupArguments(args);
        new LinkedList(TypeDescriptor.NothingType);
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(LinkedList.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }

    @Ignore
    public Collection<ReachableReference> $references$() {
        ArrayList<ReachableReference> reference = new ArrayList<ReachableReference>();
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(LinkedList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "head")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(LinkedList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "tail")));
        reference.add((ReachableReference)new MemberImpl((FunctionOrValueDeclaration)((ClassOrInterfaceDeclaration)Metamodel.getOrCreateMetamodel(LinkedList.class)).getDeclaredMemberDeclaration(ValueDeclaration.$TypeDescriptor$, "length")));
        return reference;
    }

    @Ignore
    public java.lang.Object $get$(ReachableReference reference) {
        switch (((Member)reference).getAttribute().getQualifiedName()) {
            case "ceylon.collection::LinkedList.head": {
                return this.head;
            }
            case "ceylon.collection::LinkedList.tail": {
                return this.tail;
            }
            case "ceylon.collection::LinkedList.length": {
                return Integer.instance((long)this.length);
            }
        }
        throw new RuntimeException("unknown attribute");
    }

    @Ignore
    public void $set$(ReachableReference reference, java.lang.Object instance) {
        if (reference instanceof Member) {
            switch (((Member)reference).getAttribute().getQualifiedName()) {
                case "ceylon.collection::LinkedList.head": {
                    this.head = (Cell)instance;
                    break;
                }
                case "ceylon.collection::LinkedList.tail": {
                    this.tail = (Cell)instance;
                    break;
                }
                case "ceylon.collection::LinkedList.length": {
                    this.length = ((Integer)instance).longValue();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown attribute");
                }
            }
        } else {
            throw new AssertionError("unexpected reachable reference " + reference);
        }
    }

    @Ceylon(major=8, minor=1)
    @Ignore
    @ConstructorName(value="copy")
    public static final class copy_ {
        copy_() {
        }
    }
}

