/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.collection.ListMutator;
import ceylon.collection.MutableList$impl;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Comparison;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.Map;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A [[List]] supporting addition, insertion, removal, and\nreplacement of its elements.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.collection::CLinkedList", "::1.3.3:ceylon.collection::CArrayList"})})
@AuthorsAnnotation$annotation$(authors={"St\u00e9phane \u00c9pardaud"})
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::List<Element>", "ceylon.collection::ListMutator<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface MutableList<Element>
extends List<Element>,
ListMutator<Element> {
    @Ignore
    public MutableList$impl<Element> $ceylon$collection$MutableList$impl();

    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> getPermutations();

    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> combinations(long var1);

    @Ignore
    public List span(Integer var1, Integer var2);

    @Ignore
    public List spanFrom(Integer var1);

    @Ignore
    public List spanTo(Integer var1);

    @Ignore
    public List measure(Integer var1, long var2);

    @Ignore
    public Iterable getPaired();

    @Ignore
    public Iterable<? extends Element, ? extends Object> getCycled();

    @Ignore
    public Element getLast();

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> getIndexed();

    @Ignore
    public Iterable<? extends Element, ? extends Object> getCoalesced();

    @Ignore
    public Iterable<? extends Element, ? extends Object> getExceptLast();

    @Ignore
    public List<? extends Element> getRest();

    @Ignore
    public Element getFirst();

    @Ignore
    public Iterable<? extends Element, ? extends Object> getDistinct();

    @Ignore
    public Iterator<? extends Element> iterator();

    @Ignore
    public Element getFromFirst(long var1);

    @Ignore
    public Sequential sequence();

    @Ignore
    public Iterable<? extends Element, ? extends Object> filter(Callable<? extends Boolean> var1);

    @Ignore
    public <Type> Iterable narrow(TypeDescriptor var1);

    @Ignore
    public <Result> Object reduce(TypeDescriptor var1, Callable<? extends Result> var2);

    @Ignore
    public Element find(Callable<? extends Boolean> var1);

    @Ignore
    public Element findLast(Callable<? extends Boolean> var1);

    @Ignore
    public Entry<? extends Integer, ? extends Element> locate(Callable<? extends Boolean> var1);

    @Ignore
    public Entry<? extends Integer, ? extends Element> locateLast(Callable<? extends Boolean> var1);

    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> locations(Callable<? extends Boolean> var1);

    @Ignore
    public Element max(Callable<? extends Comparison> var1);

    @Ignore
    public Sequential sort(Callable<? extends Comparison> var1);

    @Ignore
    public Sequential<? extends Element> select(Callable<? extends Boolean> var1);

    @Ignore
    public Iterable<? extends Element, ? extends Object> skip(long var1);

    @Ignore
    public Iterable<? extends Element, ? extends Object> take(long var1);

    @Ignore
    public Iterable<? extends Element, ? extends Object> skipWhile(Callable<? extends Boolean> var1);

    @Ignore
    public Iterable<? extends Element, ? extends Object> takeWhile(Callable<? extends Boolean> var1);

    @Ignore
    public List<? extends Element> repeat(long var1);

    @Ignore
    public Iterable<? extends Element, ? extends Object> by(long var1);

    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor var1, Default var2);

    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> partition(long var1);

    @Ignore
    public <Other> Iterable follow(TypeDescriptor var1, Other var2);

    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor var1, TypeDescriptor var2, Iterable<? extends Other, ? extends OtherAbsent> var3);

    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor var1, TypeDescriptor var2, Iterable<? extends Other, ? extends OtherAbsent> var3);

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor var1, Other var2);

    @Ignore
    public <Other> Iterable interpose(TypeDescriptor var1, Other var2, long var3);

    @Ignore
    public Map<? extends Element, ? extends Integer> frequencies();

    @Ignore
    public <Result> Map<? extends Element, ? extends Result> tabulate(TypeDescriptor var1, Callable<? extends Result> var2);

    @Ignore
    public <Group> Map<? extends Group, ? extends Sequence<? extends Element>> group(TypeDescriptor var1, Callable<? extends Group> var2);

    @Ignore
    public List<? extends Element> getReversed();

    @Ignore
    public Element get(Integer var1);

    @Ignore
    public Element getFromLast(long var1);

    @Ignore
    public List<? extends Element> sublistFrom(long var1);

    @Ignore
    public List<? extends Element> sublistTo(long var1);

    @Ignore
    public List<? extends Element> sublist(long var1, long var3);

    @Ignore
    public <Other> List patch(TypeDescriptor var1, List<? extends Other> var2);

    @Ignore
    public <Other> List patch(TypeDescriptor var1, List<? extends Other> var2, long var3);

    @Ignore
    public <Other> List patch(TypeDescriptor var1, List<? extends Other> var2, long var3, long var5);

    @Ignore
    public List<? extends Element> trim(Callable<? extends Boolean> var1);

    @Ignore
    public List<? extends Element> trimLeading(Callable<? extends Boolean> var1);

    @Ignore
    public List<? extends Element> trimTrailing(Callable<? extends Boolean> var1);

    @Ignore
    public Sequence slice(long var1);

    @Ignore
    public List<? extends Element> initial(long var1);

    @Ignore
    public List<? extends Element> terminal(long var1);

    @Ignore
    public <Absent> Iterable<? extends Element, ? extends Absent> getAll(TypeDescriptor var1, Iterable<? extends Integer, ? extends Absent> var2);

    @Override
    @DocAnnotation$annotation$(description="Remove the element at the specified [[index]],\nreturning the removed element, if any, or `null` if\nthere was no such element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element delete(@Name(value="index") long var1);

    @Override
    @DocAnnotation$annotation$(description="Remove the element with index `0` from this list,\nreturning the removed element, or `null` if there was\nno such element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element deleteFirst();

    @Override
    @DocAnnotation$annotation$(description="Remove the element with index `size-1` from this list,\nreturning the removed element, or `null` if there was\nno such element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element deleteLast();

    @Override
    @DocAnnotation$annotation$(description="A new list with the same elements as this list.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::MutableList<Element>")
    @NonNull
    public MutableList<Element> $clone();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object swap(@Name(value="i") long var1, @Name(value="j") long var3);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object move(@Name(value="i") long var1, @Name(value="j") long var3);

    @DocAnnotation$annotation$(description="Remove every element that satisfies the given \n[[predicate function|selecting]] from this list, \nreturning the number of elements that were removed.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long removeWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long prune();

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long remove(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Remove the first element that satisfies the given \n[[predicate function|selecting]] from this list, \nreturning the removed element, or `null` if no such \nelement was found in this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element findAndRemoveFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public boolean removeFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Remove the last element that satisfies the given \n[[predicate function|selecting]] from this list, \nreturning the removed element, or `null` if no such \nelement was found in this list.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element findAndRemoveLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public boolean removeLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1);

    @DocAnnotation$annotation$(description="Replace every element in this list that satisfies the \ngiven [[predicate function|selecting]] with the given \n[[replacement]].")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long replaceWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object infill(@Name(value="replacement") @TypeInfo(value="Element") Element var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public long replace(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") Element var2);

    @DocAnnotation$annotation$(description="Replace the first element of this list that satisfies \nthe given [[predicate function|selecting]] with\nthe given [[replacement]], returning the replaced \nelement, or `null` if no such element was found in this \nlist.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element findAndReplaceFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public boolean replaceFirst(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") Element var2);

    @DocAnnotation$annotation$(description="Replace the last element of this list that satisfies \nthe given [[predicate function|selecting]] with\nthe given [[replacement]], returning the replaced \nelement, or `null` if no such element was found in this \nlist.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element findAndReplaceLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1, @Name(value="replacement") @TypeInfo(value="Element") @DocAnnotation$annotation$(description="The replacement value") Element var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    public boolean replaceLast(@Name(value="element") @TypeInfo(value="Element&ceylon.language::Object") @NonNull Element var1, @Name(value="replacement") @TypeInfo(value="Element") Element var2);
}

