/*
 * Decompiled with CFR 0.152.
 */
package ceylon.collection;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstract supertype of datastructures that can\nbe used as FIFO queues.\n\nA `Queue` has a well-defined [[front]] and\n[[back]]. Elements may be added to the back\nof the queue by [[offer]], and removed from\nthe front of the queue by [[accept]].\n\nNote that many `Queue`s are also [[List]]s, but \nthere is no defined relationship between the \norder of elements in the list and the direction \nof the queue. In particular, the front of the \nqueue may be first element of the list, or it \nmay be the last element of the list.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.collection::CLinkedList", "::1.3.3:ceylon.collection::CArrayList", "::1.3.3:ceylon.collection::IStack"})})
@SharedAnnotation$annotation$
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={}, caseTypes={})})
public interface Queue<Element> {
    @DocAnnotation$annotation$(description="Add a new element to the back of the queue.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object offer(@Name(value="element") @TypeInfo(value="Element") Element var1);

    @DocAnnotation$annotation$(description="Remove and return the element at the front \nof the queue.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element accept();

    @DocAnnotation$annotation$(description="The element currently at the front of the \nqueue, or `null` if the queue is empty.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element getFront();

    @DocAnnotation$annotation$(description="The element currently at the back of the \nqueue, or `null` if the queue is empty.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public Element getBack();
}

