/*
 * Decompiled with CFR 0.152.
 */
package ceylon.decimal;

import ceylon.decimal.Decimal;
import ceylon.decimal.Decimal$impl;
import ceylon.decimal.DividedWithRemainder;
import ceylon.decimal.Rounding;
import ceylon.decimal.RoundingImpl;
import ceylon.decimal.defaultRounding_;
import ceylon.decimal.toWhole_;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Comparable;
import ceylon.language.Comparison;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Invertible;
import ceylon.language.Number;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.equal_;
import ceylon.language.larger_;
import ceylon.language.smaller_;
import ceylon.whole.Whole;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.ObjectArray;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

@Ceylon(major=8, minor=1)
@FinalAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.decimal::Decimal"})
final class DecimalImpl
implements ReifiedType,
Decimal,
Serializable {
    @Ignore
    protected final Decimal$impl $ceylon$decimal$Decimal$this$;
    @Ignore
    protected final Number.impl<Decimal> $ceylon$language$Number$this$;
    @Ignore
    protected final Invertible.impl<Decimal> $ceylon$language$Invertible$this$;
    @Ignore
    protected final Comparable.impl<Decimal> $ceylon$language$Comparable$this$;
    @Ignore
    private final BigDecimal implementation;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(DecimalImpl.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @Jpa
    @Ignore
    protected DecimalImpl() {
        this.$ceylon$language$Invertible$this$ = new Invertible.impl(Decimal.$TypeDescriptor$, (Invertible)this);
        this.$ceylon$language$Comparable$this$ = new Comparable.impl(Decimal.$TypeDescriptor$, (Comparable)this);
        this.$ceylon$language$Number$this$ = new Number.impl(Decimal.$TypeDescriptor$, (Number)this);
        this.$ceylon$decimal$Decimal$this$ = new Decimal$impl(this);
        this.implementation = null;
    }

    DecimalImpl(@Name(value="num") @TypeInfo(value="java.math::BigDecimal") @NonNull BigDecimal num) {
        this.$ceylon$decimal$Decimal$this$ = new Decimal$impl(this);
        this.$ceylon$language$Number$this$ = new Number.impl(Decimal.$TypeDescriptor$, (Number)this);
        this.$ceylon$language$Invertible$this$ = new Invertible.impl(Decimal.$TypeDescriptor$, (Invertible)this);
        this.$ceylon$language$Comparable$this$ = new Comparable.impl(Decimal.$TypeDescriptor$, (Comparable)this);
        this.implementation = num;
    }

    @Override
    @Ignore
    public Decimal$impl $ceylon$decimal$Decimal$impl() {
        return this.$ceylon$decimal$Decimal$this$;
    }

    @Override
    @Ignore
    public final Rounding dividedAndRemainder$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.dividedAndRemainder$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding dividedRounded$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.dividedRounded$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding dividedTruncated$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.dividedTruncated$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding minusRounded$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.minusRounded$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding plusRounded$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.plusRounded$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding powerRounded$rounding(long other) {
        return this.$ceylon$decimal$Decimal$this$.powerRounded$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding remainderRounded$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.remainderRounded$rounding(other);
    }

    @Override
    @Ignore
    public final Rounding timesRounded$rounding(Decimal other) {
        return this.$ceylon$decimal$Decimal$this$.timesRounded$rounding(other);
    }

    @Ignore
    public Number.impl<Decimal> $ceylon$language$Number$impl() {
        return this.$ceylon$language$Number$this$;
    }

    @Ignore
    public Decimal getMagnitude() {
        return (Decimal)this.$ceylon$language$Number$this$.getMagnitude();
    }

    @Ignore
    public Invertible.impl<Decimal> $ceylon$language$Invertible$impl() {
        return this.$ceylon$language$Invertible$this$;
    }

    @Ignore
    public Comparable.impl<? super Decimal> $ceylon$language$Comparable$impl() {
        return this.$ceylon$language$Comparable$this$;
    }

    @Ignore
    public boolean largerThan(Decimal other) {
        return this.$ceylon$language$Comparable$this$.largerThan((Comparable)other);
    }

    @Ignore
    public boolean notLargerThan(Decimal other) {
        return this.$ceylon$language$Comparable$this$.notLargerThan((Comparable)other);
    }

    @Ignore
    public boolean notSmallerThan(Decimal other) {
        return this.$ceylon$language$Comparable$this$.notSmallerThan((Comparable)other);
    }

    @Ignore
    public boolean smallerThan(Decimal other) {
        return this.$ceylon$language$Comparable$this$.smallerThan((Comparable)other);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="java.math::BigDecimal")
    @NonNull
    public final BigDecimal getImplementation() {
        return this.implementation;
    }

    @Override
    @Ignore
    public final Decimal dividedTruncated(Decimal other) {
        Rounding $ceylontmp$rounding$5 = this.dividedTruncated$rounding(other);
        return this.dividedTruncated$canonical$(other, $ceylontmp$rounding$5);
    }

    @Ignore
    private Decimal dividedTruncated$canonical$(Decimal other, Rounding rounding) {
        Decimal other$0 = null;
        other$0 = other;
        if (!(other$0 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$0));
        }
        DecimalImpl other$1 = (DecimalImpl)other$0;
        Rounding sel$2 = rounding;
        if (sel$2 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().divideToIntegralValue(other$1.getImplementation())));
        }
        if (sel$2 instanceof RoundingImpl) {
            RoundingImpl rounding$4 = (RoundingImpl)sel$2;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().divideToIntegralValue(other$1.getImplementation(), rounding$4.getImplementation())));
        }
        Rounding rounding$3 = sel$2;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal dividedTruncated(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.dividedTruncated$canonical$(other, rounding);
    }

    @Override
    @Ignore
    public final Decimal remainderRounded(Decimal other) {
        Rounding $ceylontmp$rounding$11 = this.remainderRounded$rounding(other);
        return this.remainderRounded$canonical$(other, $ceylontmp$rounding$11);
    }

    @Ignore
    private Decimal remainderRounded$canonical$(Decimal other, Rounding rounding) {
        Decimal other$6 = null;
        other$6 = other;
        if (!(other$6 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$6));
        }
        DecimalImpl other$7 = (DecimalImpl)other$6;
        Rounding sel$8 = rounding;
        if (sel$8 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().remainder(other$7.getImplementation())));
        }
        if (sel$8 instanceof RoundingImpl) {
            RoundingImpl rounding$10 = (RoundingImpl)sel$8;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().remainder(other$7.getImplementation(), rounding$10.getImplementation())));
        }
        Rounding rounding$9 = sel$8;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal remainderRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.remainderRounded$canonical$(other, rounding);
    }

    @Override
    @Ignore
    public final DividedWithRemainder dividedAndRemainder(Decimal other) {
        Rounding $ceylontmp$rounding$19 = this.dividedAndRemainder$rounding(other);
        return this.dividedAndRemainder$canonical$(other, $ceylontmp$rounding$19);
    }

    @Ignore
    private DividedWithRemainder dividedAndRemainder$canonical$(Decimal other, Rounding rounding) {
        Array array;
        Decimal other$12 = null;
        other$12 = other;
        if (!(other$12 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$12));
        }
        DecimalImpl other$13 = (DecimalImpl)other$12;
        Rounding sel$14 = rounding;
        if (sel$14 == null) {
            array = ObjectArray.getArray((Object[])((Object[])Util.checkNull((Object)this.getImplementation().divideAndRemainder(other$13.getImplementation()))));
        } else if (sel$14 instanceof RoundingImpl) {
            RoundingImpl rounding$16 = (RoundingImpl)sel$14;
            array = ObjectArray.getArray((Object[])((Object[])Util.checkNull((Object)this.getImplementation().divideAndRemainder(other$13.getImplementation(), rounding$16.getImplementation()))));
        } else {
            Rounding rounding$15 = sel$14;
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
        }
        BigDecimal $ceylontmp$17 = (BigDecimal)array.getFromFirst(0L);
        BigDecimal $ceylontmp$18 = (BigDecimal)array.getFromFirst(1L);
        return new DividedWithRemainder(new DecimalImpl((BigDecimal)Util.checkNull((Object)($ceylontmp$17 != null ? $ceylontmp$17 : BigDecimal.ZERO))), new DecimalImpl((BigDecimal)Util.checkNull((Object)($ceylontmp$18 != null ? $ceylontmp$18 : BigDecimal.ZERO))));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::DividedWithRemainder")
    @NonNull
    public final DividedWithRemainder dividedAndRemainder(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.dividedAndRemainder$canonical$(other, rounding);
    }

    @Override
    @DocAnnotation$annotation$(description="The precision of this decimal.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getPrecision() {
        return this.getImplementation().precision();
    }

    @Override
    @DocAnnotation$annotation$(description="The scale of this decimal.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getScale() {
        return this.getImplementation().scale();
    }

    @Override
    @DocAnnotation$annotation$(description="The unscaled value.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.whole::Whole")
    @Transient
    @NonNull
    public final Whole getUnscaled() {
        return toWhole_.toWhole((BigInteger)Util.checkNull((Object)this.getImplementation().unscaledValue()));
    }

    @Override
    @DocAnnotation$annotation$(description="This value rounded according to the given context.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal round(@Name(value="rounding") @TypeInfo(value="ceylon.decimal::Rounding") @NonNull Rounding rounding) {
        Rounding rounding$20 = null;
        rounding$20 = rounding;
        if (!(rounding$20 instanceof RoundingImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is RoundingImpl rounding" + Util.assertIsFailed((boolean)false, (TypeDescriptor)RoundingImpl.$TypeDescriptor$, (Object)rounding$20));
        }
        RoundingImpl rounding$21 = (RoundingImpl)rounding$20;
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().round(rounding$21.getImplementation())));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Comparison")
    @NonNull
    public final Comparison compare(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other) {
        long cmp;
        Decimal other$22 = null;
        other$22 = other;
        if (!(other$22 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$22));
        }
        DecimalImpl other$23 = (DecimalImpl)other$22;
        long sel$24 = cmp = Integer.getSign((long)this.getImplementation().compareTo(other$23.getImplementation()));
        if (sel$24 == -1L) {
            return smaller_.get_();
        }
        if (sel$24 == 1L) {
            return larger_.get_();
        }
        return equal_.get_();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal divided(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other) {
        Decimal other$25 = null;
        other$25 = other;
        if (!(other$25 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$25));
        }
        DecimalImpl other$26 = (DecimalImpl)other$25;
        Rounding rounding$28 = defaultRounding_.get_().get();
        if (rounding$28 != null) {
            Rounding rounding$29 = rounding$28;
            return this.dividedRounded(other$26, rounding$29);
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().divide(other$26.getImplementation())));
    }

    @Override
    @Ignore
    public final Decimal dividedRounded(Decimal other) {
        Rounding $ceylontmp$rounding$35 = this.dividedRounded$rounding(other);
        return this.dividedRounded$canonical$(other, $ceylontmp$rounding$35);
    }

    @Ignore
    private Decimal dividedRounded$canonical$(Decimal other, Rounding rounding) {
        Decimal other$30 = null;
        other$30 = other;
        if (!(other$30 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$30));
        }
        DecimalImpl other$31 = (DecimalImpl)other$30;
        Rounding sel$32 = rounding;
        if (sel$32 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().divide(other$31.getImplementation())));
        }
        if (sel$32 instanceof RoundingImpl) {
            RoundingImpl rounding$34 = (RoundingImpl)sel$32;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().divide(other$31.getImplementation(), rounding$34.getImplementation())));
        }
        Rounding rounding$33 = sel$32;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal dividedRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.dividedRounded$canonical$(other, rounding);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean equals(@Name(value="that") @TypeInfo(value="ceylon.language::Object") @NonNull Object that) {
        Object that$36 = null;
        that$36 = that;
        if (!(that$36 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl that" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)that$36));
        }
        DecimalImpl that$37 = (DecimalImpl)that$36;
        return this.getImplementation() == that$37.getImplementation() || (long)this.getImplementation().compareTo(that$37.getImplementation()) == 0L;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean strictlyEquals(@Name(value="that") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal that) {
        Decimal that$38 = null;
        that$38 = that;
        if (!(that$38 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl that" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)that$38));
        }
        DecimalImpl that$39 = (DecimalImpl)that$38;
        return this.getImplementation() == that$39.getImplementation() || this.getImplementation().equals(that$39.getImplementation());
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final double getFloat() {
        return this.getImplementation().doubleValue();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final int hashCode() {
        long $ceylontmp$hash$41 = ((BigDecimal)Util.checkNull((Object)this.getImplementation().stripTrailingZeros())).hashCode();
        return (int)($ceylontmp$hash$41 ^ $ceylontmp$hash$41 >>> 32);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getInteger() {
        return this.getImplementation().longValue();
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.whole::Whole")
    @Transient
    @NonNull
    public final Whole getWhole() {
        return toWhole_.toWhole((BigInteger)Util.checkNull((Object)this.getImplementation().toBigInteger()));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal minus(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other) {
        Decimal other$42 = null;
        other$42 = other;
        if (!(other$42 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$42));
        }
        DecimalImpl other$43 = (DecimalImpl)other$42;
        Rounding rounding$45 = defaultRounding_.get_().get();
        if (rounding$45 != null) {
            Rounding rounding$46 = rounding$45;
            return this.minusRounded(other$43, rounding$46);
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().subtract(other$43.getImplementation())));
    }

    @Override
    @Ignore
    public final Decimal minusRounded(Decimal other) {
        Rounding $ceylontmp$rounding$52 = this.minusRounded$rounding(other);
        return this.minusRounded$canonical$(other, $ceylontmp$rounding$52);
    }

    @Ignore
    private Decimal minusRounded$canonical$(Decimal other, Rounding rounding) {
        Decimal other$47 = null;
        other$47 = other;
        if (!(other$47 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$47));
        }
        DecimalImpl other$48 = (DecimalImpl)other$47;
        Rounding sel$49 = rounding;
        if (sel$49 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().subtract(other$48.getImplementation())));
        }
        if (sel$49 instanceof RoundingImpl) {
            RoundingImpl rounding$51 = (RoundingImpl)sel$49;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().subtract(other$48.getImplementation(), rounding$51.getImplementation())));
        }
        Rounding rounding$50 = sel$49;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal minusRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.minusRounded$canonical$(other, rounding);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @Transient
    @NonNull
    public final Decimal getFractionalPart() {
        return this.minus(this.getWholePart());
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final boolean getNegative() {
        return (long)this.getImplementation().signum() < 0L;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @Transient
    @NonNull
    public final Decimal getNegated() {
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().negate()));
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal plus(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other) {
        Decimal other$53 = null;
        other$53 = other;
        if (!(other$53 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$53));
        }
        DecimalImpl other$54 = (DecimalImpl)other$53;
        Rounding rounding$56 = defaultRounding_.get_().get();
        if (rounding$56 != null) {
            Rounding rounding$57 = rounding$56;
            return this.plusRounded(other$54, rounding$57);
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().add(other$54.getImplementation())));
    }

    @Override
    @Ignore
    public final Decimal plusRounded(Decimal other) {
        Rounding $ceylontmp$rounding$63 = this.plusRounded$rounding(other);
        return this.plusRounded$canonical$(other, $ceylontmp$rounding$63);
    }

    @Ignore
    private Decimal plusRounded$canonical$(Decimal other, Rounding rounding) {
        Decimal other$58 = null;
        other$58 = other;
        if (!(other$58 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$58));
        }
        DecimalImpl other$59 = (DecimalImpl)other$58;
        Rounding sel$60 = rounding;
        if (sel$60 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().add(other$59.getImplementation())));
        }
        if (sel$60 instanceof RoundingImpl) {
            RoundingImpl rounding$62 = (RoundingImpl)sel$60;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().add(other$59.getImplementation(), rounding$62.getImplementation())));
        }
        Rounding rounding$61 = sel$60;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal plusRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.plusRounded$canonical$(other, rounding);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final boolean getPositive() {
        return (long)this.getImplementation().signum() > 0L;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal power(@Name(value="other") @NonNull Integer other) {
        long rhs$67;
        Rounding rounding$65 = defaultRounding_.get_().get();
        if (rounding$65 != null) {
            Rounding rounding$68 = rounding$65;
            return this.powerRounded(other.longValue(), rounding$68);
        }
        long lhs$66 = other.longValue();
        if (lhs$66 < (rhs$67 = 0L)) {
            throw new AssertionError("Assertion failed: exponent must be non-negative" + System.lineSeparator() + "\tviolated " + "other>=0" + Util.assertBinOpFailed((Object)Integer.instance((long)lhs$66), (Object)Integer.instance((long)rhs$67)));
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().pow((int)other.longValue())));
    }

    @Override
    @Ignore
    public final Decimal powerRounded(long other) {
        Rounding $ceylontmp$rounding$72 = this.powerRounded$rounding(other);
        return this.powerRounded$canonical$(other, $ceylontmp$rounding$72);
    }

    @Ignore
    private Decimal powerRounded$canonical$(long other, Rounding rounding) {
        Rounding sel$69 = rounding;
        if (sel$69 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().pow((int)other)));
        }
        if (sel$69 instanceof RoundingImpl) {
            RoundingImpl rounding$71 = (RoundingImpl)sel$69;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().pow((int)other, rounding$71.getImplementation())));
        }
        Rounding rounding$70 = sel$69;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal powerRounded(@Name(value="other") long other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.powerRounded$canonical$(other, rounding);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    public final long getSign() {
        return this.getImplementation().signum();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    @NonNull
    public final String toString() {
        return (String)Util.checkNull((Object)this.getImplementation().toString());
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal times(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other) {
        Decimal other$73 = null;
        other$73 = other;
        if (!(other$73 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$73));
        }
        DecimalImpl other$74 = (DecimalImpl)other$73;
        Rounding rounding$76 = defaultRounding_.get_().get();
        if (rounding$76 != null) {
            Rounding rounding$77 = rounding$76;
            return this.timesRounded(other$74, rounding$77);
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().multiply(other$74.getImplementation())));
    }

    @Override
    @Ignore
    public final Decimal timesRounded(Decimal other) {
        Rounding $ceylontmp$rounding$83 = this.timesRounded$rounding(other);
        return this.timesRounded$canonical$(other, $ceylontmp$rounding$83);
    }

    @Ignore
    private Decimal timesRounded$canonical$(Decimal other, Rounding rounding) {
        Decimal other$78 = null;
        other$78 = other;
        if (!(other$78 instanceof DecimalImpl)) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is DecimalImpl other" + Util.assertIsFailed((boolean)false, (TypeDescriptor)$TypeDescriptor$, (Object)other$78));
        }
        DecimalImpl other$79 = (DecimalImpl)other$78;
        Rounding sel$80 = rounding;
        if (sel$80 == null) {
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().multiply(other$79.getImplementation())));
        }
        if (sel$80 instanceof RoundingImpl) {
            RoundingImpl rounding$82 = (RoundingImpl)sel$80;
            return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().multiply(other$79.getImplementation(), rounding$82.getImplementation())));
        }
        Rounding rounding$81 = sel$80;
        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal")
    @NonNull
    public final Decimal timesRounded(@Name(value="other") @TypeInfo(value="ceylon.decimal::Decimal") @NonNull Decimal other, @Name(value="rounding") @Defaulted @TypeInfo(value="ceylon.decimal::Rounding?") @Nullable Rounding rounding) {
        return this.timesRounded$canonical$(other, rounding);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @Transient
    @NonNull
    public final Decimal getWholePart() {
        return new DecimalImpl(new BigDecimal(this.getImplementation().toBigInteger()));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal plusInteger(@Name(value="integer") long integer) {
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().add(BigDecimal.valueOf(integer))));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal timesInteger(@Name(value="integer") long integer) {
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().multiply(BigDecimal.valueOf(integer))));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Decimal", erased=true, untrusted=true)
    @NonNull
    public final Decimal powerOfInteger(@Name(value="integer") long integer) {
        long lhs$84 = integer;
        long rhs$85 = 0L;
        if (lhs$84 < rhs$85) {
            throw new AssertionError("Assertion failed: exponent must be non-negative" + System.lineSeparator() + "\tviolated " + "integer>=0" + Util.assertBinOpFailed((Object)Integer.instance((long)lhs$84), (Object)Integer.instance((long)rhs$85)));
        }
        return new DecimalImpl((BigDecimal)Util.checkNull((Object)this.getImplementation().pow((int)integer)));
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

