/*
 * Decompiled with CFR 0.152.
 */
package ceylon.decimal;

import ceylon.decimal.Mode;
import ceylon.language.AbstractAnnotation$annotation$;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AssertionError;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.CaseTypes;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Holds precision and rounding information for use in \ndecimal arithmetic. A precision of `0` means unlimited \nprecision.")
@ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.3:ceylon.language::CAssertionError", when="if the given [[precision]] is negative.")})
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::IDecimal"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::Fround"}), @SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.decimal::VunlimitedPrecision"})})
@SharedAnnotation$annotation$
@AbstractAnnotation$annotation$
@CaseTypes(value={"ceylon.decimal::RoundingImpl"})
public abstract class Rounding
implements ReifiedType,
Serializable {
    @Ignore
    private final long precision;
    @Ignore
    private final Mode mode;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Rounding.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @Jpa
    @Ignore
    protected Rounding() {
        this.precision = 0L;
        this.mode = null;
    }

    public Rounding(@Name(value="precision") @DocAnnotation$annotation$(description="The precision to apply when rounding.") @SharedAnnotation$annotation$ long precision, @Name(value="mode") @TypeInfo(value="ceylon.decimal::Mode") @DocAnnotation$annotation$(description="The kind of rounding to apply.") @SharedAnnotation$annotation$ @NonNull Mode mode) {
        this.precision = precision;
        this.mode = mode;
        long lhs$0 = this.getPrecision();
        long rhs$1 = 0L;
        if (lhs$0 < rhs$1) {
            throw new AssertionError("Assertion failed: Precision cannot be negative" + System.lineSeparator() + "\tviolated " + "precision >= 0" + Util.assertBinOpFailed((Object)Integer.instance((long)lhs$0), (Object)Integer.instance((long)rhs$1)));
        }
    }

    @DocAnnotation$annotation$(description="The precision to apply when rounding.")
    @SharedAnnotation$annotation$
    public final long getPrecision() {
        return this.precision;
    }

    @DocAnnotation$annotation$(description="The kind of rounding to apply.")
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.decimal::Mode")
    @NonNull
    public final Mode getMode() {
        return this.mode;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Transient
    @NonNull
    public final String toString() {
        if (this.getPrecision() == 0L) {
            return "unlimited";
        }
        return this.getPrecision() + " " + this.getMode().toString();
    }

    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Object?")
    @Nullable
    public abstract Object getImplementation();

    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }
}

