/*
 * Decompiled with CFR 0.152.
 */
package ceylon.logging;

import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.VariableAnnotation$annotation$;
import ceylon.logging.Logger;
import ceylon.logging.Priority;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Member;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="An object that sends log messages relating to a particular\n[[topic|category]]. A `Logger` instance for a [[Category]] \nmay be obtained by invoking [[logger]].\n\n    Logger log = logger(`module org.hibernate`);\n\nEach `Logger` has a [[priority]]. Log messages with a \npriority lower than the current priority of the `Logger` \nwill not be sent.\n\n    log.priority = warn;\n    log.info(\"hello\"); //not sent\n    log.error(\"sos\"); //sent")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.logging::Vlogger"})})
@SharedAnnotation$annotation$
@Members(value={@Member(klass=impl.Message.class)})
public interface Logger {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Logger.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @Ignore
    public impl $ceylon$logging$Logger$impl();

    @DocAnnotation$annotation$(description="The [[topic|Category]] to which log messages sent by \nthis `Logger` relate.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language.meta.declaration::Module|ceylon.language.meta.declaration::Package", erased=true)
    @NonNull
    public Object getCategory();

    @DocAnnotation$annotation$(description="The current priority of this `Logger`. If not \nexplicitly set, the [[default|defaultPriority]] \npriority is used.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.logging::VdefaultPriority", "::1.3.2:ceylon.logging::ILogger.Fenabled"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @VariableAnnotation$annotation$
    @TypeInfo(value="ceylon.logging::Priority")
    @NonNull
    public Priority getPriority();

    public void setPriority(@Name(value="priority") @TypeInfo(value="ceylon.logging::Priority") @NonNull Priority var1);

    @DocAnnotation$annotation$(description="Evaluate the given message, producing a [[String]].")
    @SharedAnnotation$annotation$
    @NonNull
    public String render(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1);

    @DocAnnotation$annotation$(description="Determines if log messages with the given priority will\nbe sent by this `Logger`. That is, if the given \npriority is at least as high as this `Logger`s\n[[current priority|Logger.priority]].")
    @SharedAnnotation$annotation$
    public boolean enabled(@Name(value="priority") @TypeInfo(value="ceylon.logging::Priority") @NonNull Priority var1);

    @Ignore
    public Object log(Priority var1, Object var2);

    @Ignore
    public Throwable log$throwable(Priority var1, Object var2);

    @DocAnnotation$annotation$(description="Send a log [[message]] with the given [[priority]].\nOptionally, a [[throwable]] may be given.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object log(@Name(value="priority") @TypeInfo(value="ceylon.logging::Priority") @NonNull Priority var1, @Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var2, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var3);

    @Ignore
    public void fatal(Object var1);

    @Ignore
    public Throwable fatal$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send a [[ceylon.logging::fatal]] log message.")
    @SharedAnnotation$annotation$
    public void fatal(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);

    @Ignore
    public void error(Object var1);

    @Ignore
    public Throwable error$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send an [[ceylon.logging::error]] log message.")
    @SharedAnnotation$annotation$
    public void error(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);

    @Ignore
    public void warn(Object var1);

    @Ignore
    public Throwable warn$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send a [[ceylon.logging::warn]] log message.")
    @SharedAnnotation$annotation$
    public void warn(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);

    @Ignore
    public void info(Object var1);

    @Ignore
    public Throwable info$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send an [[ceylon.logging::info]] log message.")
    @SharedAnnotation$annotation$
    public void info(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);

    @Ignore
    public void debug(Object var1);

    @Ignore
    public Throwable debug$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send a [[ceylon.logging::debug]] log message.")
    @SharedAnnotation$annotation$
    public void debug(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);

    @Ignore
    public void trace(Object var1);

    @Ignore
    public Throwable trace$throwable(Object var1);

    @DocAnnotation$annotation$(description="Send a [[ceylon.logging::trace]] log message.")
    @SharedAnnotation$annotation$
    public void trace(@Name(value="message") @TypeInfo(value="ceylon.language::String|ceylon.language::String()", erased=true) @NonNull Object var1, @Name(value="throwable") @Defaulted @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable var2);
}

