/*
 * Decompiled with CFR 0.152.
 */
package ceylon.logging;

import ceylon.language.DocAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Import;
import com.redhat.ceylon.compiler.java.metadata.Module;

@Ceylon(major=8, minor=1)
@Module(name="ceylon.logging", doc="Defines a platform-neutral API for writing log messages.\n\n_Important! By default, no log writer function is registered,\nand so nothing is logged. Read on to learn how to properly\nconfigure logging for your application_\n\n## Adding logging to your module\n\nLog messages are written to a [[Logger]]. A canonical \n`Logger` instance for a package or module may be obtained \nby calling [[logger]].\n\n    Logger log = logger(`module hello`);\n\nThe methods [[Logger.fatal]], [[Logger.error]], \n[[Logger.warn]], [[Logger.info]], [[Logger.debug]], and \n[[Logger.trace]] write log messages with various\n[[priorities|Priority]].\n\n    log.debug(\"trying to do something\");\n    try {\n        doSomething();\n    }\n    catch (e) {\n        log.error(\"something bad happened\", e);\n    }\n\nFor log messages with interpolated expressions, these\nmethods accept an anonymous function.\n  \n    log.debug(()=>\"trying to do ``something``\");\n    try {\n        do(something);\n    }\n    catch (e) {\n        log.error(()=>\"badness happened doing ``something``\", e);\n    }\n\n## Configuring logging for your application\n\nIf your module is going to be part of a larger application\nthen the above is the only thing you need to know to add\nlogging. But given the fact that this logging module does\n_not_ actually define any infrastructure for log message\noutput, your application must at some point during startup\nregister a [[LogWriter]] function by calling [[addLogWriter]]\nand passing it a log writer function. For example:\n\n    addLogWriter(writeSimpleLog);\n\n[[writeSimpleLog]] is a trivial log writer function that\nlogs information to standard out and warnings and errors \nto standard error. Your program will almost certainly \nneed to define its own log writer function that appends\nto a file, or whatever. \n\nIt's easy to customize the output by writing your own\n[[log writer function|LogWriter]]. For example, we can\nuse `ceylon.time` and `ceylon.locale` to obtain a nicely\nformatter time and date:\n\n    import ceylon.logging { ... }\n    import ceylon.time { now }\n    import ceylon.locale { systemLocale }\n    \n    ...\n    \n    addLogWriter {\n        void log(Priority p, Category c, String m, Throwable? t) {\n            value print \n                    = p <= info \n                    then process.write\n                    else process.writeError;\n            value instant = now();\n            value formats = systemLocale.formats;\n            value date = \n                    formats.shortFormatDate(instant.date());\n            value time = \n                    formats.mediumFormatTime(instant.time());\n            print(\"[``date`` at ``time``] ``p.string``: ``m``\");\n            print(operatingSystem.newline);\n            if (exists t) {\n                printStackTrace(t, print);\n            }\n        }\n    };\n\nOr, to log to a file, using `ceylon.file`:\n\n    import ceylon.logging { ... }\n    import ceylon.file { ... }\n\n    File file;\n    switch (resource = parsePath(\"log.txt\").resource)\n    case (is ExistingResource) {\n        assert (is File resource);\n        file = resource;\n    }\n    case (is Nil) {\n        file = resource.createFile();\n    }\n    \n    addLogWriter {\n        void log(Priority p, Category c, String m, Throwable? t) {\n            try (appender = file.Appender()) {\n                appender.writeLine(\"[``system.milliseconds``] ``p.string``: ``m``\");\n                if (exists t) {\n                    printStackTrace(t, appender.write);\n                }\n            }\n        }\n    };\n \nBy default, only log messages with priority at least \n[[info]] are sent to the `LogWriter` functions. To change\nthe minimum priority, assign to [[defaultPriority]].\n\n    defaultPriority = debug;\n\nAlternatively, we can assign an explicit priority to a\nspecific `Logger` by assigning to [[Logger.priority]].\n\n    logger(`module hello`).priority = debug;\n\nFor integration with other logging libraries, it is\npossible to completely replace the [[logger]] function\nwith a custom function for producing `Logger`s.\n\n    logger = (Category category)\n        => JDKLoggerImpl(JDKLogger.getLogger(category.qualifiedName));", version="1.3.3", dependencies={@Import(name="ceylon.collection", version="1.3.3"), @Import(name="ceylon.language", version="1.3.3")}, group="org.ceylon-lang")
@DocAnnotation$annotation$(description="Defines a platform-neutral API for writing log messages.\n\n_Important! By default, no log writer function is registered,\nand so nothing is logged. Read on to learn how to properly\nconfigure logging for your application_\n\n## Adding logging to your module\n\nLog messages are written to a [[Logger]]. A canonical \n`Logger` instance for a package or module may be obtained \nby calling [[logger]].\n\n    Logger log = logger(`module hello`);\n\nThe methods [[Logger.fatal]], [[Logger.error]], \n[[Logger.warn]], [[Logger.info]], [[Logger.debug]], and \n[[Logger.trace]] write log messages with various\n[[priorities|Priority]].\n\n    log.debug(\"trying to do something\");\n    try {\n        doSomething();\n    }\n    catch (e) {\n        log.error(\"something bad happened\", e);\n    }\n\nFor log messages with interpolated expressions, these\nmethods accept an anonymous function.\n  \n    log.debug(()=>\"trying to do ``something``\");\n    try {\n        do(something);\n    }\n    catch (e) {\n        log.error(()=>\"badness happened doing ``something``\", e);\n    }\n\n## Configuring logging for your application\n\nIf your module is going to be part of a larger application\nthen the above is the only thing you need to know to add\nlogging. But given the fact that this logging module does\n_not_ actually define any infrastructure for log message\noutput, your application must at some point during startup\nregister a [[LogWriter]] function by calling [[addLogWriter]]\nand passing it a log writer function. For example:\n\n    addLogWriter(writeSimpleLog);\n\n[[writeSimpleLog]] is a trivial log writer function that\nlogs information to standard out and warnings and errors \nto standard error. Your program will almost certainly \nneed to define its own log writer function that appends\nto a file, or whatever. \n\nIt's easy to customize the output by writing your own\n[[log writer function|LogWriter]]. For example, we can\nuse `ceylon.time` and `ceylon.locale` to obtain a nicely\nformatter time and date:\n\n    import ceylon.logging { ... }\n    import ceylon.time { now }\n    import ceylon.locale { systemLocale }\n    \n    ...\n    \n    addLogWriter {\n        void log(Priority p, Category c, String m, Throwable? t) {\n            value print \n                    = p <= info \n                    then process.write\n                    else process.writeError;\n            value instant = now();\n            value formats = systemLocale.formats;\n            value date = \n                    formats.shortFormatDate(instant.date());\n            value time = \n                    formats.mediumFormatTime(instant.time());\n            print(\"[``date`` at ``time``] ``p.string``: ``m``\");\n            print(operatingSystem.newline);\n            if (exists t) {\n                printStackTrace(t, print);\n            }\n        }\n    };\n\nOr, to log to a file, using `ceylon.file`:\n\n    import ceylon.logging { ... }\n    import ceylon.file { ... }\n\n    File file;\n    switch (resource = parsePath(\"log.txt\").resource)\n    case (is ExistingResource) {\n        assert (is File resource);\n        file = resource;\n    }\n    case (is Nil) {\n        file = resource.createFile();\n    }\n    \n    addLogWriter {\n        void log(Priority p, Category c, String m, Throwable? t) {\n            try (appender = file.Appender()) {\n                appender.writeLine(\"[``system.milliseconds``] ``p.string``: ``m``\");\n                if (exists t) {\n                    printStackTrace(t, appender.write);\n                }\n            }\n        }\n    };\n \nBy default, only log messages with priority at least \n[[info]] are sent to the `LogWriter` functions. To change\nthe minimum priority, assign to [[defaultPriority]].\n\n    defaultPriority = debug;\n\nAlternatively, we can assign an explicit priority to a\nspecific `Logger` by assigning to [[Logger.priority]].\n\n    logger(`module hello`).priority = debug;\n\nFor integration with other logging libraries, it is\npossible to completely replace the [[logger]] function\nwith a custom function for producing `Logger`s.\n\n    logger = (Category category)\n        => JDKLoggerImpl(JDKLogger.getLogger(category.qualifiedName));")
final class $module_ {
    public static final String ceylon$collection = null;

    private $module_() {
    }
}

