/*
 * Decompiled with CFR 0.152.
 */
package ceylon.logging;

import ceylon.language.Anything;
import ceylon.language.Callable;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.operatingSystem_;
import ceylon.language.printStackTrace_;
import ceylon.language.process_;
import ceylon.language.system_;
import ceylon.logging.Priority;
import ceylon.logging.info_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@Method
public final class writeSimpleLog_ {
    private writeSimpleLog_() {
    }

    @DocAnnotation$annotation$(description="A trivial [[log writer function|LogWriter]] that prints\nmessages with priority:\n\n- [[info]] or lower to [[standard out|process.write]], and \n- [[warn]] or higher to [[standard error|process.writeError]].\n\nThe format of the message is:\n\n`[milliseconds] PRIORITY message`\n\nThis log writer function must be registered explicitly by\ncalling:\n\n    addLogWriter(writeSimpleLog);")
    @SharedAnnotation$annotation$
    public static void writeSimpleLog(@Name(value="priority") @TypeInfo(value="ceylon.logging::Priority") @NonNull Priority priority, @Name(value="category") @TypeInfo(value="ceylon.language.meta.declaration::Module|ceylon.language.meta.declaration::Package", erased=true) @NonNull Object category, @Name(value="message") @NonNull String message, @Name(value="throwable") @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable throwable) {
        AbstractCallable abstractCallable;
        process_ $instance$;
        if (priority.notLargerThan(info_.get_())) {
            $instance$ = process_.get_();
            abstractCallable = new AbstractCallable<Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{ceylon.language.String.$TypeDescriptor$}), "Anything(String)", -1){

                @Ignore
                public Object $call$(Object $param$0) {
                    String $ceylontmp$string = ((ceylon.language.String)$param$0).toString();
                    $instance$.write($ceylontmp$string);
                    return null;
                }
            };
        } else {
            $instance$ = process_.get_();
            abstractCallable = new AbstractCallable<Object>(Anything.$TypeDescriptor$, TypeDescriptor.tuple((boolean)false, (boolean)false, (int)-1, (TypeDescriptor[])new TypeDescriptor[]{ceylon.language.String.$TypeDescriptor$}), "Anything(String)", -1){

                @Ignore
                public Object $call$(Object $param$0) {
                    String $ceylontmp$string = ((ceylon.language.String)$param$0).toString();
                    $instance$.writeError($ceylontmp$string);
                    return null;
                }
            };
        }
        AbstractCallable print = abstractCallable;
        print.$call$((Object)ceylon.language.String.instance((String)("[" + system_.get_().getMilliseconds() + "] " + priority.toString() + " " + message)));
        print.$call$((Object)ceylon.language.String.instance((String)operatingSystem_.get_().getNewline()));
        Throwable throwable$1 = throwable;
        if (throwable$1 != null) {
            Throwable throwable$2 = throwable$1;
            printStackTrace_.printStackTrace((Throwable)throwable$2, (Callable)print);
        }
    }
}

