/*
 * Decompiled with CFR 0.152.
 */
package ceylon.process;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.NativeAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Import;
import com.redhat.ceylon.compiler.java.metadata.Module;

@Ceylon(major=8, minor=1)
@Module(name="ceylon.process", doc="API for running native commands in a child process.\nClients simply create `Process`es using the\n`createProcess()` method. The new process starts\nexecuting immediately.\n  \n    Process process = createProcess { \n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n    };\n  \nBy default, the standard input, output, and error \nstreams of the new child process are piped to and\nfrom the current process by exposing a `Writer` and\n`Reader`s.\n  \n    if (is Reader reader = process.output) {\n        while (exists line = reader.readLine()) {\n            print(line);\n        }\n    }\n  \nThe standard input, output, and error streams may be\nredirected by specifying an `Input` or `Output` to\n`createProcess()`.\n  \n    Process process = createProcess {\n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n        output = OverwriteFileOutput {\n            path = home.childPath(\"out.txt\");\n        };\n        error = AppendFileOutput {\n            path = home.childPath(\"err.txt\");\n        };\n    };\n  \nThe objects `currentInput`, `currentOutput`, and \n`currentError` allow the standard input, output, and \nerror streams to be redirected to the standard input, \noutput, and error streams of the current virtual\nmachine process.\n  \n    Process process = createProcess {\n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n        output = currentOutput;\n        error = currentError;\n    };\n  \nTo wait for the child process to terminate, call\nthe `waitForExit()` method of `Process`.", by={"Gavin King"}, version="1.3.3", dependencies={@Import(name="ceylon.file", version="1.3.3", export=true), @Import(name="java.base", version="7"), @Import(name="ceylon.language", version="1.3.3")}, nativeBackends={"jvm"}, group="org.ceylon-lang")
@DocAnnotation$annotation$(description="API for running native commands in a child process.\nClients simply create `Process`es using the\n`createProcess()` method. The new process starts\nexecuting immediately.\n  \n    Process process = createProcess { \n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n    };\n  \nBy default, the standard input, output, and error \nstreams of the new child process are piped to and\nfrom the current process by exposing a `Writer` and\n`Reader`s.\n  \n    if (is Reader reader = process.output) {\n        while (exists line = reader.readLine()) {\n            print(line);\n        }\n    }\n  \nThe standard input, output, and error streams may be\nredirected by specifying an `Input` or `Output` to\n`createProcess()`.\n  \n    Process process = createProcess {\n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n        output = OverwriteFileOutput {\n            path = home.childPath(\"out.txt\");\n        };\n        error = AppendFileOutput {\n            path = home.childPath(\"err.txt\");\n        };\n    };\n  \nThe objects `currentInput`, `currentOutput`, and \n`currentError` allow the standard input, output, and \nerror streams to be redirected to the standard input, \noutput, and error streams of the current virtual\nmachine process.\n  \n    Process process = createProcess {\n        command = \"ls\";\n        arguments = [\"-l\"];\n        path = home;\n        output = currentOutput;\n        error = currentError;\n    };\n  \nTo wait for the child process to terminate, call\nthe `waitForExit()` method of `Process`.")
@AuthorsAnnotation$annotation$(authors={"Gavin King"})
@NativeAnnotation$annotation$(backends={"jvm"})
final class $module_ {
    @SharedAnnotation$annotation$
    public static final String ceylon$file = null;
    public static final String java$base = null;

    private $module_() {
    }
}

