/*
 * Decompiled with CFR 0.152.
 */
package ceylon.process;

import ceylon.file.Path;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Represents a separate native process.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.3:ceylon.process::FcreateProcess"})})
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
public interface Process {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(Process.class, (TypeDescriptor[])new TypeDescriptor[0]);

    @DocAnnotation$annotation$(description="A _command_, usually the name or path of \na program to execute.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @NonNull
    public String getCommand();

    @DocAnnotation$annotation$(description="The arguments to the [[command]].")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="{ceylon.language::String*}")
    @NonNull
    public Iterable<? extends ceylon.language.String, ? extends Object> getArguments();

    @DocAnnotation$annotation$(description="The directory in which the process runs.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.file::Path")
    @NonNull
    public Path getPath();

    @DocAnnotation$annotation$(description="The standard input stream of the process.\nThis is a `Writer` in the case that the\nstandard input is being piped from the\ncurrent process.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.process::Input|ceylon.file::Writer", erased=true)
    @NonNull
    public Object getInput();

    @DocAnnotation$annotation$(description="The standard output stream of the process.\nThis is a `Reader` in the case that the\nstandard output is being piped back to the\ncurrent process.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.process::Output|ceylon.file::Reader", erased=true)
    @NonNull
    public Object getOutput();

    @DocAnnotation$annotation$(description="The standard error stream of the process.\nThis is a `Reader` in the case that the\nstandard error is being piped back to the\ncurrent process.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.process::Error|ceylon.file::Reader", erased=true)
    @NonNull
    public Object getError();

    @DocAnnotation$annotation$(description="The environment variables of the process.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="{<ceylon.language::String->ceylon.language::String>*}")
    @NonNull
    public Iterable<? extends Entry<? extends ceylon.language.String, ? extends ceylon.language.String>, ? extends Object> getEnvironment();

    @DocAnnotation$annotation$(description="The exit code of the terminated process,\nor `null` if the process has not yet \nterminated. Normal termination is \nconventionally indicated by the exit\ncode `0`.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Integer?")
    @Nullable
    public Integer getExitCode();

    @DocAnnotation$annotation$(description="Determine if the process has terminated.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    public boolean getTerminated();

    @DocAnnotation$annotation$(description="Wait for the process to terminate, \nreturning the exit code. Normal \ntermination is conventionally indicated \nby the exit code `0`.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    public long waitForExit();

    @DocAnnotation$annotation$(description="Force the process to terminate.")
    @FormalAnnotation$annotation$
    @SharedAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object kill();
}

