/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.bootstrap.CeylonMessages;
import ceylon.modules.bootstrap.NoGreetingJDKModuleLogger;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Rest;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.compiler.java.runtime.tools.Backend;
import com.redhat.ceylon.compiler.java.runtime.tools.CeylonToolProvider;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.Runner;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.modules.Main;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogger;

@Summary(value="Executes a Ceylon program")
@Description(value="Executes the Ceylon program specified as the `<module>` argument. The `<module>` may optionally include a version.")
@RemainingSections(value="## Configuration file\n\nThe run tool accepts the following option from the Ceylon configuration file: `runtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute the `com.example.foobar` module:\n\n    ceylon run com.example.foobar/1.0.0\n\nThe following would execute the `bob` function in the `com.example.foobar.gee` package of the same previous module:\n\n    ceylon run --run com.example.foobar.gee::bob com.example.foobar/1.0.0")
public class CeylonRunTool
extends RepoUsingTool {
    private static final String CEYLON_RUNTIME = "ceylon.runtime";
    private static volatile Module runtimeModule;
    private String moduleNameOptVersion;
    private String run;
    private String compileFlags;
    private boolean flatClasspath;
    private List<String> args = Collections.emptyList();
    private boolean autoExportMavenDependencies;

    public CeylonRunTool() {
        super(CeylonMessages.RESOURCE_BUNDLE);
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Argument(argumentName="module", multiplicity="1", order=1)
    public void setModule(String moduleNameOptVersion) {
        this.moduleNameOptVersion = moduleNameOptVersion;
    }

    @Rest
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    @OptionArgument(longName="run", argumentName="toplevel")
    @Description(value="Specifies the fully qualified name of a toplevel method or class with no parameters. The format is: `qualified.package.name::classOrMethodName` with `::` acting as separator between the package name and the toplevel class or method name.")
    public void setRun(String run) {
        this.run = run;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setCompile(String compile) {
        this.compileFlags = compile;
    }

    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `cmr`.")
    public void setVerbose(String verbose) {
        super.setVerbose(verbose);
    }

    public void initialize(CeylonTool mainTool) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException {
        if (this.compileFlags == null) {
            this.compileFlags = DefaultToolOptions.getRunToolCompileFlags();
            if (this.compileFlags.isEmpty()) {
                this.compileFlags = "never";
            }
        } else if (this.compileFlags.isEmpty()) {
            this.compileFlags = "once";
        }
        String module = ModuleUtil.moduleName((String)this.moduleNameOptVersion);
        String version = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), module, ModuleUtil.moduleVersion((String)this.moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 0, this.compileFlags);
        if (version == null) {
            return;
        }
        if (!version.isEmpty()) {
            this.moduleNameOptVersion = ModuleUtil.makeModuleName((String)module, (String)version);
        }
        if (this.flatClasspath) {
            this.startInFlatClasspath(module, version);
            return;
        }
        ArrayList<String> argList = new ArrayList<String>();
        String ceylonVersion = System.getProperty("ceylon.system.version");
        if (ceylonVersion == null) {
            ceylonVersion = "1.2.0";
        }
        String sysRep = this.systemRepo != null ? this.systemRepo : System.getProperty("ceylon.system.repo");
        if (this.run != null) {
            argList.add("-run");
            argList.add(this.run);
        }
        if (this.offline) {
            argList.add("-offline");
        }
        if (this.verbose != null) {
            argList.add("-verbose");
            if (this.verbose.isEmpty()) {
                argList.add("all");
            } else {
                argList.add(this.verbose);
            }
        }
        argList.add("-sysrep");
        argList.add(sysRep);
        if (this.cacheRepo != null) {
            argList.add("-cacherep");
            argList.add(this.cacheRepo);
        }
        if (this.overrides != null) {
            argList.add("-overrides");
            argList.add(this.overrides);
        }
        if (this.noDefRepos) {
            argList.add("-nodefreps");
        }
        if (this.autoExportMavenDependencies) {
            argList.add("-auto-export-maven-dependencies");
        }
        if (this.repo != null) {
            for (URI repo : this.repo) {
                argList.add("-rep");
                argList.add(repo.toString());
            }
        }
        argList.add(this.moduleNameOptVersion);
        argList.addAll(this.args);
        try {
            if (runtimeModule == null) {
                Class<ModuleLoader> i$ = ModuleLoader.class;
                synchronized (ModuleLoader.class) {
                    if (runtimeModule == null) {
                        Module.setModuleLogger((ModuleLogger)new NoGreetingJDKModuleLogger());
                        Main.main((String[])this.setupArguments(argList, sysRep, ceylonVersion));
                        ModuleLoader ml = Module.getBootModuleLoader();
                        runtimeModule = ml.loadModule(ModuleIdentifier.create((String)CEYLON_RUNTIME, (String)ceylonVersion));
                    } else {
                        runtimeModule.run(this.moduleArguments(argList));
                    }
                    // ** MonitorExit[i$] (shouldn't be in output)
                    return;
                }
            }
            runtimeModule.run(this.moduleArguments(argList));
            return;
        }
        catch (Error err) {
            throw err;
        }
        catch (RuntimeException e) {
            if (e instanceof CeylonRuntimeException || !e.getClass().getName().equals("ceylon.modules.CeylonRuntimeException")) throw e;
            throw new CeylonRuntimeException(e.getMessage());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void startInFlatClasspath(String module, String version) {
        JavaRunnerOptions options = new JavaRunnerOptions();
        if (this.repo != null) {
            for (URI userRepository : this.repo) {
                options.addUserRepository(userRepository.toASCIIString());
            }
        }
        options.setOffline(this.offline);
        options.setSystemRepository(this.systemRepo);
        options.setVerboseCategory(this.verbose);
        options.setRun(this.run);
        options.setOverrides(this.overrides);
        Runner runner = CeylonToolProvider.getRunner((Backend)Backend.Java, (RunnerOptions)options, (String)module, (String)version);
        runner.run(this.args.toArray(new String[this.args.size()]));
    }

    private String[] setupArguments(List<String> argList, String sysRep, String ceylonVersion) {
        ArrayList<String> setupArgs = new ArrayList<String>();
        setupArgs.addAll(Arrays.asList("-mp", sysRep, "ceylon.runtime:" + ceylonVersion, "+executable", "ceylon.modules.jboss.runtime.JBossRuntime"));
        setupArgs.addAll(argList);
        String[] args = setupArgs.toArray(new String[setupArgs.size()]);
        return args;
    }

    private String[] moduleArguments(List<String> argList) {
        ArrayList<String> moduleArgs = new ArrayList<String>();
        moduleArgs.addAll(Arrays.asList("+executable", "ceylon.modules.jboss.runtime.JBossRuntime"));
        moduleArgs.addAll(argList);
        String[] args = moduleArgs.toArray(new String[moduleArgs.size()]);
        return args;
    }
}

