/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap;

import ceylon.modules.bootstrap.CeylonMessages;
import ceylon.modules.bootstrap.CeylonRunTool;
import ceylon.modules.bootstrap.CeylonTestFailureError;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Rest;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Summary(value="Executes tests")
@Description(value="Executes tests in specified `<modules>`. The `<modules>` arguments are the names of the modules to test with an optional version.")
@RemainingSections(value="## Configuration file\n\nThe test tool accepts the following option from the Ceylon configuration file: `testtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute tests in the `com.example.foobar` module:\n\n    ceylon test com.example.foobar/1.0.0")
public class CeylonTestTool
extends RepoUsingTool {
    private static final String TEST_MODULE_NAME = "com.redhat.ceylon.testjvm";
    private static final String TEST_RUN_FUNCTION = "com.redhat.ceylon.testjvm.run";
    private List<String> moduleNameOptVersionList;
    private List<String> testList;
    private List<String> argumentList;
    private String compileFlags;
    private String version;
    private boolean tap;
    private boolean report;

    public CeylonTestTool() {
        super(CeylonMessages.RESOURCE_BUNDLE);
    }

    public void initialize(CeylonTool mainTool) throws Exception {
    }

    @Argument(argumentName="modules", multiplicity="+")
    public void setModules(List<String> moduleNameOptVersionList) {
        this.moduleNameOptVersionList = moduleNameOptVersionList;
    }

    @OptionArgument(longName="test", argumentName="test")
    @Description(value="Specifies which tests will be run.")
    public void setTests(List<String> testList) {
        this.testList = testList;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setCompile(String compile) {
        this.compileFlags = compile;
    }

    @OptionArgument(argumentName="version")
    @Description(value="Specifies version of test module, which will be used, if no value is set, then the latest available version will be used.")
    public void setVersion(String version) {
        this.version = version;
    }

    @Option(longName="tap")
    @Description(value="Enables the Test Anything Protocol v13.")
    public void setTap(boolean tap) {
        this.tap = tap;
    }

    @Option(longName="report")
    @Description(value="Generates the test results report into HTML format, output directory is `reports/test` (experimental).")
    public void setReport(boolean report) {
        this.report = report;
    }

    @Rest
    public void setArgs(List<String> argumentList) {
        this.argumentList = argumentList;
    }

    public void run() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (this.version == null) {
            Collection versions = this.getModuleVersions(this.getRepositoryManager(), TEST_MODULE_NAME, null, ModuleQuery.Type.JVM, 8, 0);
            if (versions == null || versions.isEmpty()) {
                this.version = "1.2.0";
            } else {
                ModuleVersionDetails mdv = versions.toArray(new ModuleVersionDetails[0])[versions.size() - 1];
                this.version = mdv.getVersion();
            }
        }
        if (this.moduleNameOptVersionList != null) {
            for (String moduleNameOptVersion : this.moduleNameOptVersionList) {
                String moduleAndVersion = this.resolveModuleAndVersion(moduleNameOptVersion);
                if (moduleAndVersion == null) {
                    return;
                }
                args.add("--module");
                args.add(moduleAndVersion);
            }
        }
        if (this.testList != null) {
            for (String test : this.testList) {
                args.add("--test");
                args.add(test);
            }
        }
        if (this.argumentList != null) {
            args.addAll(this.argumentList);
        }
        if (this.compileFlags == null) {
            this.compileFlags = DefaultToolOptions.getTestToolCompileFlags();
            if (this.compileFlags.isEmpty()) {
                this.compileFlags = "never";
            }
        } else if (this.compileFlags.isEmpty()) {
            this.compileFlags = "once";
        }
        if (this.tap) {
            args.add("--tap");
        }
        if (this.report) {
            args.add("--report");
        }
        CeylonRunTool ceylonRunTool = new CeylonRunTool();
        ceylonRunTool.setModule("com.redhat.ceylon.testjvm/" + this.version);
        ceylonRunTool.setRun(TEST_RUN_FUNCTION);
        ceylonRunTool.setArgs(args);
        ceylonRunTool.setRepository(this.repo);
        ceylonRunTool.setSystemRepository(this.systemRepo);
        ceylonRunTool.setCacheRepository(this.cacheRepo);
        ceylonRunTool.setOverrides(this.overrides);
        ceylonRunTool.setNoDefRepos(this.noDefRepos);
        ceylonRunTool.setOffline(this.offline);
        ceylonRunTool.setVerbose(this.verbose);
        ceylonRunTool.setCompile(this.compileFlags);
        ceylonRunTool.setCwd(this.cwd);
        try {
            ceylonRunTool.run();
        }
        catch (Throwable x) {
            if (x.getClass().getCanonicalName().equals("com.redhat.ceylon.testjvm.TestFailureException")) {
                throw new CeylonTestFailureError();
            }
            throw x;
        }
    }

    private String resolveModuleAndVersion(String moduleNameOptVersion) throws IOException {
        String moduleName = ModuleUtil.moduleName((String)moduleNameOptVersion);
        String moduleVersion = ModuleUtil.moduleVersion((String)moduleNameOptVersion);
        moduleVersion = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), moduleName, moduleVersion, ModuleQuery.Type.JVM, 8, 0, this.compileFlags);
        return moduleVersion != null ? moduleName + "/" + moduleVersion : null;
    }
}

