/*
 * Copyright 2011 Red Hat inc. and third party contributors as noted 
 * by the author tags.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ceylon.modules.bootstrap.loader;

import org.jboss.modules.ModuleLoader;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;

/**
 * Abstract bootstrap module loader.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
abstract class BootstrapModuleLoader extends ModuleLoader {

    /**
     * Get Ceylon repository.
     *
     * @return the ceylon repository
     */
    protected static String getCeylonRepository() {
        return AccessController.doPrivileged(new PrivilegedAction<String>() {
            public String run() {
                final String defaultCeylonRepository = System.getProperty("user.home") + File.separator + ".ceylon" + File.separator + "repo";
                return System.getProperty("ceylon.repo", defaultCeylonRepository);
            }
        });
    }

}
