/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.compiler;

import ceylon.modules.api.compiler.CompilerAdapter;
import ceylon.modules.api.compiler.CopyCompilerAdapter;
import ceylon.modules.api.compiler.JavaCompilerAdapter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CompilerAdapterFactory {
    private static CompilerAdapterFactory instance = new CompilerAdapterFactory();
    private List<CompilerAdapter> adapters = new CopyOnWriteArrayList<CompilerAdapter>();

    private CompilerAdapterFactory() {
        this.addCompilerAdapter(new CopyCompilerAdapter());
        this.addCompilerAdapter(JavaCompilerAdapter.INSTANCE);
    }

    public static CompilerAdapterFactory getInstance() {
        return instance;
    }

    public File findAndCompile(File sourceRoot, String name, File classesRoot) throws IOException {
        File source = null;
        CompilerAdapter adapter = null;
        for (CompilerAdapter ca : this.adapters) {
            source = ca.findSource(sourceRoot, name);
            if (source == null) continue;
            adapter = ca;
            break;
        }
        if (adapter == null) {
            return null;
        }
        return adapter.compile(source, name, classesRoot);
    }

    public File compile(File source, String name, File classesRoot) throws IOException {
        for (CompilerAdapter ca : this.adapters) {
            File output = ca.compile(source, name, classesRoot);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public void addCompilerAdapter(CompilerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null adapter");
        }
        this.adapters.add(0, adapter);
    }

    public void removeCompilerAdapter(CompilerAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("Null adapter");
        }
        this.adapters.remove(adapter);
    }
}

