/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap;

import ceylon.modules.bootstrap.CeylonMessages;
import ceylon.modules.bootstrap.CeylonRunTool;
import ceylon.modules.bootstrap.CeylonTestFailureError;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.AbstractTestTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import java.util.ArrayList;

@Summary(value="Executes tests")
@Description(value="Executes tests in specified `<modules>`. The `<modules>` arguments are the names of the modules to test with an optional version.")
@RemainingSections(value="## Configuration file\n\nThe test tool accepts the following option from the Ceylon configuration file: `testtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute tests in the `com.example.foobar` module:\n\n    ceylon test com.example.foobar/1.0.0")
public class CeylonTestTool
extends AbstractTestTool {
    private boolean flatClasspath;
    private boolean autoExportMavenDependencies;
    private boolean linkWithCurrentDistribution;

    public CeylonTestTool() {
        super(CeylonMessages.RESOURCE_BUNDLE, ModuleQuery.Type.JVM, Integer.valueOf(8), Integer.valueOf(0), null, null);
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Option
    @Description(value="Link modules which were compiled with a more recent version of the distribution to the version of that module present in this distribution (1.2.2). This might fail with a linker error at runtime. For example if the module depended on an API present in the more recent version, but absent from 1.2.2. Allowed arguments are upgrade, downgrade or abort. Default: upgrade")
    public void setLinkWithCurrentDistribution(boolean linkWithCurrentDistribution) {
        this.linkWithCurrentDistribution = linkWithCurrentDistribution;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    public void run() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList moduleAndVersionList = new ArrayList();
        this.processModuleNameOptVersionList(args, moduleAndVersionList);
        this.processTestList(args);
        this.processTagList(args);
        this.processArgumentList(args);
        this.processCompileFlags();
        this.processTapOption(args);
        this.processReportOption(args);
        this.resolveVersion(moduleAndVersionList);
        CeylonRunTool ceylonRunTool = new CeylonRunTool();
        ceylonRunTool.setModule("ceylon.test/" + this.version);
        ceylonRunTool.setRun("ceylon.test::runTestTool");
        ceylonRunTool.setArgs(args);
        ceylonRunTool.setRepository(this.repo);
        ceylonRunTool.setFlatClasspath(this.flatClasspath);
        ceylonRunTool.setLinkWithCurrentDistribution(this.linkWithCurrentDistribution);
        ceylonRunTool.setAutoExportMavenDependencies(this.autoExportMavenDependencies);
        ceylonRunTool.setSystemRepository(this.systemRepo);
        ceylonRunTool.setCacheRepository(this.cacheRepo);
        ceylonRunTool.setOverrides(this.overrides);
        ceylonRunTool.setNoDefRepos(this.noDefRepos);
        ceylonRunTool.setOffline(this.offline);
        ceylonRunTool.setVerbose(this.verbose);
        ceylonRunTool.setCompile(this.compileFlags);
        ceylonRunTool.setCwd(this.cwd);
        try {
            ceylonRunTool.run();
        }
        catch (Throwable x) {
            if (x.getClass().getCanonicalName().equals("ceylon.test.engine.internal.TestFailureException")) {
                throw new CeylonTestFailureError();
            }
            throw x;
        }
    }
}

