/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.Configuration;
import ceylon.modules.SecurityActions;
import ceylon.modules.spi.ArgumentType;
import ceylon.modules.spi.Constants;
import ceylon.modules.spi.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class Main {
    public static void main(String[] args) throws Throwable {
        try {
            Main.execute(args);
        }
        catch (CeylonRuntimeException cre) {
            throw cre;
        }
        catch (Throwable t) {
            Throwable t2;
            Throwable throwable = t2 = t.getCause() != null ? t.getCause() : t;
            if (t2 instanceof InvocationTargetException) {
                t2 = t.getCause() != null ? t2.getCause() : t2;
            }
            throw t2;
        }
    }

    public static void execute(String[] args) throws Exception {
        Configuration conf = Main.parseArgs(args);
        String exe = conf.executable;
        if (exe == null) {
            throw new CeylonRuntimeException("Missing -executable argument");
        }
        Executable executable = Main.createInstance(Executable.class, exe);
        executable.execute(conf);
    }

    private static Configuration parseArgs(String[] args) {
        Configuration conf = new Configuration();
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            String arg = args[i];
            boolean implArg = arg.startsWith(Constants.IMPL_ARGUMENT_PREFIX.toString());
            boolean ceylonArg = arg.startsWith(Constants.CEYLON_ARGUMENT_PREFIX.toString());
            if (!implArg && !ceylonArg) {
                conf.module = arg;
                conf.arguments = Arrays.copyOfRange(args, i + 1, args.length);
                break;
            }
            ArgumentType type = implArg ? ArgumentType.IMPL : ArgumentType.CEYLON;
            i = conf.setArgument(arg.substring(1), type, args, i);
        }
        conf.check();
        return conf;
    }

    public static <T> T createInstance(Class<T> expectedType, String defaultImpl) throws Exception {
        if (expectedType == null) {
            throw new CeylonRuntimeException("Null expected type");
        }
        if (defaultImpl == null) {
            throw new CeylonRuntimeException("Null default impl");
        }
        return SecurityActions.instantiate(expectedType, defaultImpl);
    }
}

