/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.compiler;

import ceylon.modules.api.compiler.AbstractCompilerAdapter;
import ceylon.modules.api.compiler.CompilerAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Collections;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavaCompilerAdapter
extends AbstractCompilerAdapter {
    public static CompilerAdapter INSTANCE = new JavaCompilerAdapter();

    private JavaCompilerAdapter() {
        super(".java");
    }

    @Override
    public File findSource(File root, String name) {
        return super.findSource(root, this.toPath(name));
    }

    @Override
    public File compile(File source, String name, File classesRoot) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesRoot));
        FileJavaFileObject sourceJFO = new FileJavaFileObject(source);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, null, null, Collections.singleton(sourceJFO));
        if (!task.call().booleanValue()) {
            throw new IllegalArgumentException("Cannot compile: " + source);
        }
        return new File(classesRoot, JavaCompilerAdapter.toPath(name, ".class"));
    }

    private static class FileJavaFileObject
    extends SimpleJavaFileObject {
        private File source;

        private FileJavaFileObject(File source) {
            super(source.toURI(), JavaFileObject.Kind.SOURCE);
            if (source == null) {
                throw new IllegalArgumentException("Null source");
            }
            this.source = source;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return new FileInputStream(this.source);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return new FileOutputStream(this.source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            StringWriter writer = new StringWriter();
            InputStream is = this.openInputStream();
            try {
                int b;
                while ((b = is.read()) >= 0) {
                    writer.write(b);
                }
                writer.flush();
            }
            finally {
                AbstractCompilerAdapter.safeClose(is);
                AbstractCompilerAdapter.safeClose(writer);
            }
            return writer.getBuffer();
        }

        @Override
        public long getLastModified() {
            return this.source.lastModified();
        }

        @Override
        public boolean delete() {
            return this.source.delete();
        }
    }
}

