/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap;

import ceylon.modules.bootstrap.CeylonMessages;
import ceylon.modules.bootstrap.CeylonRunTool;
import ceylon.modules.bootstrap.CeylonTestFailureError;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.AbstractTestTool;
import java.util.ArrayList;
import java.util.List;

@Summary(value="Executes tests on the JVM")
@Description(value="Executes tests in specified `<modules>`. The `<modules>` arguments are the names of the modules to test with an optional version.")
@RemainingSections(value="## Configuration file\n\nThe test tool accepts the following option from the Ceylon configuration file: `testtool.compile` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute tests in the `com.example.foobar` module:\n\n    ceylon test com.example.foobar/1.0.0")
public class CeylonTestTool
extends AbstractTestTool {
    private static final String COLOR_RESET = "com.redhat.ceylon.common.tool.terminal.color.reset";
    private static final String COLOR_GREEN = "com.redhat.ceylon.common.tool.terminal.color.green";
    private static final String COLOR_RED = "com.redhat.ceylon.common.tool.terminal.color.red";
    private boolean flatClasspath = DefaultToolOptions.getDefaultFlatClasspath();
    private boolean autoExportMavenDependencies = DefaultToolOptions.getDefaultAutoExportMavenDependencies();
    private boolean linkWithCurrentDistribution;

    public CeylonTestTool() {
        super(CeylonMessages.RESOURCE_BUNDLE, ModuleQuery.Type.JVM, Integer.valueOf(8), Integer.valueOf(1), null, null);
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Option
    @Description(value="Link modules which were compiled with a more recent version of the distribution to the version of that module present in this distribution (1.3.0). This might fail with a linker error at runtime. For example if the module depended on an API present in the more recent version, but absent from 1.3.0. Allowed arguments are upgrade, downgrade or abort. Default: upgrade")
    public void setLinkWithCurrentDistribution(boolean linkWithCurrentDistribution) {
        this.linkWithCurrentDistribution = linkWithCurrentDistribution;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    public void run() throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        ArrayList moduleAndVersionList = new ArrayList();
        this.processModuleNameOptVersionList(args, moduleAndVersionList);
        this.processTestList(args);
        this.processTagList(args);
        this.processArgumentList(args);
        this.processCompileFlags();
        this.processTapOption(args);
        this.processReportOption(args);
        this.processColors(args);
        this.resolveVersion(moduleAndVersionList);
        CeylonRunTool ceylonRunTool = new CeylonRunTool();
        ceylonRunTool.setModule("ceylon.test/" + this.version);
        ceylonRunTool.setRun("ceylon.test::runTestTool");
        ceylonRunTool.setArgs(args);
        ceylonRunTool.setRepository(this.repos);
        ceylonRunTool.setFlatClasspath(this.flatClasspath);
        ceylonRunTool.setLinkWithCurrentDistribution(this.linkWithCurrentDistribution);
        ceylonRunTool.setAutoExportMavenDependencies(this.autoExportMavenDependencies);
        ceylonRunTool.setSystemRepository(this.systemRepo);
        ceylonRunTool.setCacheRepository(this.cacheRepo);
        ceylonRunTool.setOverrides(this.overrides);
        ceylonRunTool.setNoDefRepos(this.noDefRepos);
        ceylonRunTool.setOffline(this.offline);
        ceylonRunTool.setVerbose(this.verbose);
        ceylonRunTool.setCompile(this.compileFlags);
        ceylonRunTool.setCwd(this.cwd);
        if (this.flatClasspath) {
            for (String moduleAndVersion : moduleAndVersionList) {
                String moduleName = ModuleUtil.moduleName((String)moduleAndVersion);
                String moduleVersion = ModuleUtil.moduleVersion((String)moduleAndVersion);
                ceylonRunTool.addExtraModule(moduleName, moduleVersion);
            }
        }
        try {
            ceylonRunTool.run();
        }
        catch (Throwable x) {
            if (x.getClass().getCanonicalName().equals("ceylon.test.engine.internal.TestFailureException")) {
                throw new CeylonTestFailureError();
            }
            throw x;
        }
    }

    private void processColors(List<String> args) {
        String reset = OSUtil.Color.reset.escape();
        String green = OSUtil.Color.green.escape();
        String red = OSUtil.Color.red.escape();
        if (reset != null && green != null && red != null) {
            System.setProperty(COLOR_RESET, reset);
            System.setProperty(COLOR_GREEN, green);
            System.setProperty(COLOR_RED, red);
        }
    }
}

