/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap.loader;

import com.redhat.ceylon.model.cmr.JDKUtils;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public class InitialModuleLoader
extends ModuleLoader {
    public InitialModuleLoader() {
        super(new ModuleFinder[]{new LocalModuleFinder()});
    }

    protected ModuleSpec findModule(ModuleIdentifier module) throws ModuleLoadException {
        if (JDKUtils.isJDKModule((String)module.getName())) {
            ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)module);
            Set jdkPaths = JDKUtils.getJDKPathsByModule((String)module.getName());
            builder.addDependency(DependencySpec.createSystemDependencySpec((Set)jdkPaths, (boolean)true));
            return builder.create();
        }
        if (JDKUtils.isOracleJDKModule((String)module.getName())) {
            ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)module);
            Set jdkPaths = JDKUtils.getOracleJDKPathsByModule((String)module.getName());
            builder.addDependency(DependencySpec.createSystemDependencySpec((Set)jdkPaths, (boolean)true));
            return builder.create();
        }
        return super.findModule(module);
    }
}

