/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.bootstrap.CeylonMessages;
import ceylon.modules.bootstrap.NoGreetingJDKModuleLogger;
import ceylon.modules.bootstrap.loader.InitialModuleLoader;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Rest;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.RepoUsingTool;
import com.redhat.ceylon.compiler.java.runtime.tools.Backend;
import com.redhat.ceylon.compiler.java.runtime.tools.CeylonToolProvider;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.ModuleNotFoundException;
import com.redhat.ceylon.compiler.java.runtime.tools.Runner;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.modules.Main;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogger;

@Summary(value="Executes a Ceylon program on the JVM")
@Description(value="Executes the Ceylon program specified as the `module` argument. The `module` may optionally include a version.")
@RemainingSections(value="## Compile flags\n\nThe `--compile` option can take the following flags: \n\n - **never** - Never perform any compilation\n - **once** - Only compile when the compiled module is not available\n - **check** - Compile when the sources are newer than the compiled module\n - **force** - Always compile\n\nIf the flag is given without an argument it's the same as specifying `check`. If no flag is given at all it's the same as specifying `never`.\n\n\n## Configuration file\n\nThe run tool accepts the following option from the Ceylon configuration file: `runtool.compile`, `runtool.run`, `runtool.module` and multiple `runtool.arg` (the equivalent option on the command line always has precedence).\n\n## EXAMPLE\n\nThe following would execute the `com.example.foobar` module:\n\n    ceylon run com.example.foobar/1.0.0\n\nThe following would execute the `bob` function in the `com.example.foobar.gee` package of the same previous module:\n\n    ceylon run --run com.example.foobar.gee::bob com.example.foobar/1.0.0")
public class CeylonRunTool
extends RepoUsingTool {
    private static final String CEYLON_RUNTIME = "ceylon.runtime";
    private static volatile Module runtimeModule;
    private String moduleNameOptVersion;
    private String run;
    private String compileFlags;
    private List<String> args;
    private boolean flatClasspath = DefaultToolOptions.getDefaultFlatClasspath();
    private boolean autoExportMavenDependencies = DefaultToolOptions.getDefaultAutoExportMavenDependencies();
    private boolean upgradeDist = DefaultToolOptions.getLinkWithCurrentDistribution();
    private Map<String, String> extraModules = new HashMap<String, String>();

    public CeylonRunTool() {
        super(CeylonMessages.RESOURCE_BUNDLE);
    }

    @Option(longName="flat-classpath")
    @Description(value="Launches the Ceylon module using a flat classpath.")
    public void setFlatClasspath(boolean flatClasspath) {
        this.flatClasspath = flatClasspath;
    }

    @Argument(argumentName="module", multiplicity="?", order=1)
    public void setModule(String moduleNameOptVersion) {
        this.moduleNameOptVersion = moduleNameOptVersion;
    }

    @Rest
    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Option(longName="auto-export-maven-dependencies")
    @Description(value="When using JBoss Modules (the default), treats all module dependencies between Maven modules as shared.")
    public void setAutoExportMavenDependencies(boolean autoExportMavenDependencies) {
        this.autoExportMavenDependencies = autoExportMavenDependencies;
    }

    @OptionArgument(longName="run", argumentName="toplevel")
    @Description(value="Specifies the fully qualified name of a toplevel method or class to run. The indicated declaration must be shared by the `module` and have no parameters. The format is: `qualified.package.name::classOrMethodName` with `::` acting as separator between the package name and the toplevel class or method name. (default: `module.name::run`)")
    public void setRun(String run) {
        this.run = run;
    }

    @Option
    @OptionArgument(argumentName="flags")
    @Description(value="Determines if and how compilation should be handled. Allowed flags include: `never`, `once`, `force`, `check`.")
    public void setCompile(String compile) {
        this.compileFlags = compile;
    }

    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `cmr`.")
    public void setVerbose(String verbose) {
        super.setVerbose(verbose);
    }

    protected Set<String> getVerboseCategories(String ... morecats) {
        return super.getVerboseCategories(new String[]{"cmr"});
    }

    @Option
    @Description(value="Link modules which were compiled with a more recent version of the distribution to the version of that module present in this distribution (1.3.1). This might fail with a linker error at runtime. For example if the module depended on an API present in the more recent version, but absent from 1.3.1. Allowed arguments are upgrade, downgrade or abort. Default: upgrade")
    public void setLinkWithCurrentDistribution(boolean downgradeDist) {
        this.upgradeDist = !downgradeDist;
    }

    public void addExtraModule(String module, String version) {
        this.extraModules.put(module, version);
    }

    protected boolean shouldUpgradeDist() {
        return this.upgradeDist;
    }

    public void initialize(CeylonTool mainTool) throws Exception {
        super.initialize(mainTool);
        if (this.moduleNameOptVersion == null) {
            this.moduleNameOptVersion = DefaultToolOptions.getRunToolModule((com.redhat.ceylon.common.Backend)com.redhat.ceylon.common.Backend.Java);
            if (this.moduleNameOptVersion != null) {
                if (this.run == null) {
                    this.run = DefaultToolOptions.getRunToolRun((com.redhat.ceylon.common.Backend)com.redhat.ceylon.common.Backend.Java);
                }
                if (this.args == null || this.args.isEmpty()) {
                    this.args = DefaultToolOptions.getRunToolArgs((com.redhat.ceylon.common.Backend)com.redhat.ceylon.common.Backend.Java);
                }
            } else {
                throw new IllegalArgumentException("Missing required argument 'module' to command 'run'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException {
        this.compileFlags = this.processCompileFlags(this.compileFlags, DefaultToolOptions.getRunToolCompileFlags());
        String module = ModuleUtil.moduleName((String)this.moduleNameOptVersion);
        String version = this.checkModuleVersionsOrShowSuggestions(module, ModuleUtil.moduleVersion((String)this.moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 1, null, null, this.compileFlags);
        if (version == null) {
            return;
        }
        if (!version.isEmpty()) {
            this.moduleNameOptVersion = ModuleUtil.makeModuleName((String)module, (String)version);
        }
        if (this.flatClasspath) {
            this.startInFlatClasspath(module, version);
            return;
        }
        ArrayList<String> argList = new ArrayList<String>();
        String ceylonVersion = System.getProperty("ceylon.system.version");
        if (ceylonVersion == null) {
            ceylonVersion = "1.3.1";
        }
        String sysRep = this.systemRepo != null ? this.systemRepo : System.getProperty("ceylon.system.repo");
        if (this.run != null) {
            argList.add("-run");
            argList.add(this.run);
        }
        if (this.offline) {
            argList.add("-offline");
        }
        if (this.verbose != null) {
            argList.add("-verbose");
            if (this.verbose.isEmpty()) {
                argList.add("all");
            } else {
                argList.add(this.verbose);
            }
        }
        argList.add("-sysrep");
        argList.add(sysRep);
        if (!this.upgradeDist) {
            argList.add("-downgrade-dist");
        }
        if (this.cacheRepo != null) {
            argList.add("-cacherep");
            argList.add(this.cacheRepo);
        }
        if (this.overrides != null) {
            argList.add("-overrides");
            argList.add(this.overrides);
        }
        if (this.noDefRepos) {
            argList.add("-nodefreps");
        }
        if (this.autoExportMavenDependencies) {
            argList.add("-auto-export-maven-dependencies");
        }
        if (this.repos != null) {
            for (URI repo : this.repos) {
                argList.add("-rep");
                argList.add(repo.toString());
            }
        }
        argList.add(this.moduleNameOptVersion);
        argList.addAll(this.args);
        try {
            if (runtimeModule == null) {
                Class<ModuleLoader> i$ = ModuleLoader.class;
                synchronized (ModuleLoader.class) {
                    if (runtimeModule == null) {
                        Module.setModuleLogger((ModuleLogger)new NoGreetingJDKModuleLogger());
                        System.setProperty("boot.module.loader", InitialModuleLoader.class.getName());
                        Main.main((String[])this.moduleArguments(argList, sysRep, ceylonVersion));
                        ModuleLoader ml = Module.getBootModuleLoader();
                        runtimeModule = ml.loadModule(ModuleIdentifier.create((String)CEYLON_RUNTIME, (String)ceylonVersion));
                    } else {
                        runtimeModule.run(this.moduleArguments(argList, null, null));
                    }
                    // ** MonitorExit[i$] (shouldn't be in output)
                    return;
                }
            }
            runtimeModule.run(this.moduleArguments(argList, null, null));
            return;
        }
        catch (Error err) {
            throw err;
        }
        catch (RuntimeException e) {
            if (e instanceof CeylonRuntimeException || !e.getClass().getName().equals("ceylon.modules.CeylonRuntimeException")) throw e;
            throw new CeylonRuntimeException(e.getMessage());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void startInFlatClasspath(String module, String version) {
        JavaRunnerOptions options = new JavaRunnerOptions();
        if (this.repos != null) {
            for (URI userRepository : this.repos) {
                options.addUserRepository(userRepository.toASCIIString());
            }
        }
        if (this.getCwd() != null) {
            options.setWorkingDirectory(this.getCwd().getAbsolutePath());
        }
        options.setOffline(this.offline);
        options.setSystemRepository(this.systemRepo);
        options.setVerboseCategory(this.verbose);
        options.setRun(this.run);
        options.setOverrides(this.overrides);
        options.setDowngradeDist(!this.upgradeDist);
        options.setExtraModules(this.extraModules);
        try {
            Runner runner = CeylonToolProvider.getRunner((Backend)Backend.Java, (RunnerOptions)options, (String)module, (String)version);
            runner.run(this.args.toArray(new String[this.args.size()]));
        }
        catch (ModuleNotFoundException e) {
            throw new CeylonRuntimeException(e.getMessage());
        }
    }

    private String[] moduleArguments(List<String> argList, String sysRep, String ceylonVersion) {
        ArrayList<String> moduleArgs = new ArrayList<String>();
        if (sysRep != null) {
            moduleArgs.add("-mp");
            moduleArgs.add(sysRep);
        }
        if (ceylonVersion != null) {
            moduleArgs.add("ceylon.runtime:" + ceylonVersion);
        }
        moduleArgs.add("+executable");
        moduleArgs.add("ceylon.modules.jboss.runtime.JBossRuntime");
        if (this.cwd != null) {
            moduleArgs.add("-cwd");
            moduleArgs.add(this.cwd.getAbsolutePath());
        }
        moduleArgs.addAll(argList);
        String[] args = moduleArgs.toArray(new String[moduleArgs.size()]);
        return args;
    }
}

