/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.repository;

import ceylon.modules.api.compiler.CompilerAdapterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.modules.Resource;

class SourceEntryResource
implements Resource {
    private String name;
    private File sourceFile;
    private File classFile;
    private URL url;
    private File classesRoot;

    public SourceEntryResource(String name, File sourceFile, URL url, File classesRoot) {
        this.name = name;
        this.sourceFile = sourceFile;
        this.url = url;
        this.classesRoot = classesRoot;
    }

    protected synchronized File getClassFile() throws IOException {
        if (this.classFile == null) {
            CompilerAdapterFactory factory = CompilerAdapterFactory.getInstance();
            this.classFile = factory.compile(this.sourceFile, this.name, this.classesRoot);
        }
        return this.classFile;
    }

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.url;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.getClassFile());
    }

    public long getSize() {
        try {
            return this.getClassFile().length();
        }
        catch (IOException ignored) {
            return 0L;
        }
    }
}

