/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.jboss.modules.Module;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getClassLoader(final Module module) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return module.getClassLoader();
                }
            });
        }
        return module.getClassLoader();
    }

    public static ClassLoader setContextClassLoader(final ClassLoader cl) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    return oldClassLoader;
                }
            });
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        return oldClassLoader;
    }
}

