/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap.loader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

final class ModuleXmlParser {
    private static final String NAMESPACE = "urn:jboss:module:1.0";
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();

    private ModuleXmlParser() {
    }

    private static void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> parseResourcePaths(InputStream source, ModuleIdentifier mi) throws ModuleLoadException {
        try {
            ArrayList<String> arrayList;
            XMLInputFactory inputFactory = INPUT_FACTORY;
            ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
            ModuleXmlParser.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
            XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
            try {
                ArrayList<String> resourcePaths = new ArrayList<String>();
                ModuleXmlParser.parseResourcePaths(streamReader, resourcePaths);
                arrayList = resourcePaths;
            }
            catch (Throwable throwable) {
                try {
                    ModuleXmlParser.safeClose(streamReader);
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new ModuleLoadException("Error reading resource paths: " + mi, (Throwable)e);
                }
            }
            ModuleXmlParser.safeClose(streamReader);
            return arrayList;
        }
        finally {
            ModuleXmlParser.safeClose(source);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }

    private static XMLStreamException unexpectedContent(XMLStreamReader reader) {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XMLStreamException(b.toString(), reader.getLocation());
    }

    private static XMLStreamException endOfDocument(Location location) {
        return new XMLStreamException("Unexpected end of document", location);
    }

    private static XMLStreamException missingAttributes(Location location, Set<Attribute> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        return new XMLStreamException(b.toString(), location);
    }

    private static void parseResourcePaths(XMLStreamReader reader, List<String> resourcePaths) throws XMLStreamException {
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    if (Element.of(reader.getName()) != Element.MODULE) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    ModuleXmlParser.parseModuleContents(reader, resourcePaths);
                    ModuleXmlParser.parseEndDocument(reader);
                    return;
                }
                case 2: {
                    continue block4;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseModuleContents(XMLStreamReader reader, List<String> resourcePaths) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EXPORTS: {
                            ModuleXmlParser.skipElement(reader);
                            continue block10;
                        }
                        case DEPENDENCIES: {
                            ModuleXmlParser.skipElement(reader);
                            continue block10;
                        }
                        case MAIN_CLASS: {
                            ModuleXmlParser.skipElement(reader);
                            continue block10;
                        }
                        case RESOURCES: {
                            ModuleXmlParser.parseResources(reader, resourcePaths);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void skipElement(XMLStreamReader reader) throws XMLStreamException {
        String name = reader.getLocalName();
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (name == null || !name.equals(reader.getLocalName())) continue block4;
                    return;
                }
                case 1: {
                    continue block4;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseResources(XMLStreamReader reader, List<String> resourcePaths) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (Element.of(reader.getName())) {
                        case RESOURCE_ROOT: {
                            ModuleXmlParser.parseResourceRoot(reader, resourcePaths);
                            continue block7;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader.getLocation());
    }

    private static void parseResourceRoot(XMLStreamReader reader, List<String> resourcePaths) throws XMLStreamException {
        String path = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    continue block11;
                }
                case PATH: {
                    path = reader.getAttributeValue(i);
                    continue block11;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader.getLocation(), required);
        }
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    resourcePaths.add(path);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case FILTER: {
                            ModuleXmlParser.skipElement(reader);
                            continue block12;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    private static void parseEndDocument(XMLStreamReader reader) throws XMLStreamException {
        block5: while (reader.hasNext()) {
            switch (reader.next()) {
                case 8: {
                    return;
                }
                case 4: {
                    if (reader.isWhiteSpace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 5: 
                case 6: {
                    continue block5;
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
    }

    static enum Disposition {
        NONE("none"),
        IMPORT("import"),
        EXPORT("export");

        private static final Map<String, Disposition> values;
        private final String value;

        private Disposition(String value) {
            this.value = value;
        }

        static Disposition of(String value) {
            Disposition disposition = values.get(value);
            return disposition == null ? NONE : disposition;
        }

        static {
            HashMap<String, Disposition> map = new HashMap<String, Disposition>();
            for (Disposition d : Disposition.values()) {
                map.put(d.value, d);
            }
            values = map;
        }
    }

    static enum Attribute {
        NAME,
        SLOT,
        EXPORT,
        SERVICES,
        PATH,
        OPTIONAL,
        DEFAULT_LOADER,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("name"), NAME);
            attributesMap.put(new QName("slot"), SLOT);
            attributesMap.put(new QName("export"), EXPORT);
            attributesMap.put(new QName("services"), SERVICES);
            attributesMap.put(new QName("path"), PATH);
            attributesMap.put(new QName("optional"), OPTIONAL);
            attributesMap.put(new QName("default-loader"), DEFAULT_LOADER);
            attributes = attributesMap;
        }
    }

    static enum Element {
        MODULE,
        DEPENDENCIES,
        EXPORTS,
        IMPORTS,
        INCLUDE,
        INCLUDE_SET,
        EXCLUDE,
        EXCLUDE_SET,
        RESOURCES,
        MAIN_CLASS,
        RESOURCE_ROOT,
        PATH,
        FILTER,
        CONFIGURATION,
        LOADER,
        MODULE_PATH,
        IMPORT,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            Element element = elements.get(qName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "module"), MODULE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "dependencies"), DEPENDENCIES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resources"), RESOURCES);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "main-class"), MAIN_CLASS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "resource-root"), RESOURCE_ROOT);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "path"), PATH);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exports"), EXPORTS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "imports"), IMPORTS);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "include"), INCLUDE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exclude"), EXCLUDE);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "include-set"), INCLUDE_SET);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "exclude-set"), EXCLUDE_SET);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "filter"), FILTER);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "configuration"), CONFIGURATION);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "loader"), LOADER);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "module-path"), MODULE_PATH);
            elementsMap.put(new QName(ModuleXmlParser.NAMESPACE, "import"), IMPORT);
            elements = elementsMap;
        }
    }
}

