/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.Configuration;
import ceylon.modules.Main;
import ceylon.modules.api.runtime.AbstractRuntime;
import ceylon.modules.jboss.runtime.ClassLoaderHolderImpl;
import ceylon.modules.spi.runtime.ClassLoaderHolder;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.RepositoryManagerBuilder;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.spi.ContentTransformer;
import com.redhat.ceylon.cmr.spi.MergeStrategy;
import com.redhat.ceylon.common.log.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;

public abstract class AbstractJBossRuntime
extends AbstractRuntime {
    @Override
    public ClassLoaderHolder createClassLoader(String name, String version, Configuration conf) throws Exception {
        ModuleIdentifier moduleIdentifier;
        if ("default".equals(name)) {
            if (version != null) {
                throw new CeylonRuntimeException("Invalid module identifier: default module should not have any version");
            }
        } else if (version == null) {
            StringBuilder sb = new StringBuilder("Invalid module identifier: missing required version");
            sb.append(" (should be of the form ");
            sb.append(name);
            sb.append("/version)");
            throw new CeylonRuntimeException(sb.toString());
        }
        try {
            moduleIdentifier = ModuleIdentifier.fromString((String)(name + ":" + version));
        }
        catch (IllegalArgumentException x) {
            CeylonRuntimeException cre = new CeylonRuntimeException("Invalid module name or version: contains invalid characters");
            cre.initCause(x);
            throw cre;
        }
        try {
            ModuleLoader moduleLoader = this.createModuleLoader(conf);
            Module module = moduleLoader.loadModule(moduleIdentifier);
            return new ClassLoaderHolderImpl(module);
        }
        catch (ModuleNotFoundException e) {
            String spec = e.getMessage();
            int p = spec.lastIndexOf(58);
            if (p >= 0) {
                spec = spec.substring(0, p) + "/" + spec.substring(p + 1);
            }
            String msg = "Could not find module: " + spec + " (invalid version?";
            if (name.equals("ceylon.language")) {
                msg = msg + " try running with '--link-with-current-distribution'";
            }
            msg = msg + ")";
            CeylonRuntimeException cre = new CeylonRuntimeException(msg);
            cre.initCause(e);
            throw cre;
        }
    }

    private RepositoryManager createRepository(Configuration conf, boolean offline) {
        ContentTransformer ct;
        CMRJULLogger log = new CMRJULLogger();
        RepositoryManagerBuilder builder = CeylonUtils.repoManager().cwd(conf.cwd).systemRepo(conf.systemRepository).cacheRepo(conf.cacheRepository).overrides(conf.overrides).upgradeDist(conf.upgradeDist).noDefaultRepos(conf.noDefaultRepositories).noOutRepo(true).userRepos(conf.repositories).offline(offline || conf.offline).logger((Logger)log).buildManagerBuilder();
        MergeStrategy ms = this.getService(MergeStrategy.class, conf);
        if (ms != null) {
            builder.mergeStrategy(ms);
        }
        if (conf.cacheContent) {
            builder.cacheContent();
        }
        if ((ct = this.getService(ContentTransformer.class, conf)) != null) {
            builder.contentTransformer(ct);
        }
        return builder.buildRepository();
    }

    protected RepositoryManager createRepository(Configuration conf) {
        return this.createRepository(conf, false);
    }

    protected <T> T getService(Class<T> serviceType, Configuration conf) {
        try {
            String impl = conf.impl.get(serviceType.getName());
            return impl != null ? (T)Main.createInstance(serviceType, impl) : null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate service: " + serviceType.getName(), e);
        }
    }

    protected abstract ModuleLoader createModuleLoader(Configuration var1) throws Exception;
}

