/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class Graph<K, V, E> {
    private ConcurrentMap<K, Vertex<V, E>> vertices = new ConcurrentHashMap<K, Vertex<V, E>>();

    Graph() {
    }

    public Vertex<V, E> createVertex(K key, V value) {
        Vertex v = new Vertex(value);
        Vertex previous = this.vertices.putIfAbsent(key, v);
        return previous != null ? previous : v;
    }

    public Vertex<V, E> getVertex(K key) {
        return (Vertex)this.vertices.get(key);
    }

    public Collection<Vertex<V, E>> getVertices() {
        return this.vertices != null ? Collections.unmodifiableCollection(this.vertices.values()) : Collections.emptySet();
    }

    public static class Edge<V, E> {
        private E cost;
        private Vertex<V, E> from;
        private Vertex<V, E> to;

        public static <V, E> void create(E cost, Vertex<V, E> from, Vertex<V, E> to) {
            new Edge<V, E>(cost, from, to);
        }

        private Edge(E cost, Vertex<V, E> from, Vertex<V, E> to) {
            if (from == null) {
                throw new IllegalArgumentException("Null from");
            }
            if (to == null) {
                throw new IllegalArgumentException("Null to");
            }
            this.cost = cost;
            this.from = from;
            this.to = to;
            ((Vertex)from).addOut(this);
            ((Vertex)to).addIn(this);
        }

        public E getCost() {
            return this.cost;
        }

        public Vertex<V, E> getFrom() {
            return this.from;
        }

        public Vertex<V, E> getTo() {
            return this.to;
        }
    }

    public static class Vertex<V, E> {
        private V value;
        private Set<Edge<V, E>> in;
        private Set<Edge<V, E>> out;

        Vertex(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        private void addIn(Edge<V, E> edge) {
            if (this.in == null) {
                this.in = new HashSet<Edge<V, E>>();
            }
            this.in.add(edge);
        }

        private void addOut(Edge<V, E> edge) {
            if (this.out == null) {
                this.out = new HashSet<Edge<V, E>>();
            }
            this.out.add(edge);
        }

        public Set<Edge<V, E>> getIn() {
            return this.in != null ? Collections.unmodifiableSet(this.in) : Collections.emptySet();
        }

        public Set<Edge<V, E>> getOut() {
            return this.out != null ? Collections.unmodifiableSet(this.out) : Collections.emptySet();
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return this.value.equals(other.value);
        }
    }
}

