/*
 * Decompiled with CFR 0.152.
 */
package daevil.menu;

import daevil.OSType;
import daevil.menu.BatchFileBuilder;
import daevil.menu.Menu;
import daevil.menu.MenuOption;
import java.util.HashSet;
import java.util.List;

public class BatchFileMenu
extends Menu {
    HashSet<String> functionBucket;
    private final BatchFileBuilder batchFileBuilder = new BatchFileBuilder();

    public BatchFileMenu(String title) {
        super(title);
        this.functionBucket = new HashSet();
    }

    public BatchFileMenu(String title, List<MenuOption> options) {
        super(title, options);
        this.functionBucket = new HashSet();
    }

    public HashSet<String> functionBucket() {
        return this.functionBucket;
    }

    @Override
    public BatchFileBuilder batchFileBuilder() {
        return this.batchFileBuilder;
    }

    @Override
    public String generate() {
        String usage = this.usageString("usage: %~n0%~x0 ^[", "^|");
        this.batchFileBuilder.append(this.generateResolverText(OSType.WINDOWS) + "REM get all args after first for passing extra args\nset FIRSTARG=%1\nset RESTVAR=\nshift\n:loop1\nif \"%1\"==\"\" goto after_loop\nset RESTVAR=%RESTVAR% %1\nshift\ngoto loop1\n:after_loop\nif NOT \"%FIRSTARG%\" == \"\" goto RUNCOMMAND\ngoto MENU\n\nREM FUNCTIONS FOR COMMANDS\n");
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                this.batchFileBuilder.append("REM *** " + option.name.get() + " *** \n:" + option.name.get() + "\ncls\necho " + option.name.get() + "\n" + option.commandLines(OSType.WINDOWS) + "\ngoto %GOTONEXT%\n::\n\n");
            }
        });
        this.batchFileBuilder.append(":MENU\nSET GOTONEXT=PAUSEMENU\ncls\nSET SCRIPT_DIR=%BASE_SCRIPT_DIR%\nCD %SCRIPT_DIR%\necho.\necho  " + (String)this.title.get() + "\necho    " + usage + "\necho.\necho    0 EXIT\n");
        this._options.forEach(option -> {
            if (option.name.get().equals("separator")) {
                this.batchFileBuilder.append("echo    ************************************************************\n");
            } else {
                this.batchFileBuilder.append("echo    " + option.number.get() + " " + option.name.get() + " (" + option.description.get() + ")\n");
            }
        });
        this.batchFileBuilder.append("echo.\necho.\nset choice=\nset /p choice=  Enter option number :\necho.\nREM trim whitespace\nfor /f \"tokens=* delims= \" %%a in (\"%choice%\") do set choice=%%a\nfor /l %%a in (1,1,100) do if \"!choice:~-1!\"==\" \" set choice=!choice:~0,-1!\nif '%choice%'=='0' goto BYE\n");
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                this.batchFileBuilder.append("if '%choice%'=='" + option.number.get() + "' goto " + option.name.get() + "\n");
            }
        });
        this.batchFileBuilder.append("::\necho.\necho.\necho \"%choice%\" is not a valid option - try again\necho.\npause\ngoto MENU\n::\n");
        this.batchFileBuilder.append(":RUNCOMMAND\nSET GOTONEXT=BYE\n");
        this._options.forEach(option -> {
            if (!option.name.get().equals("separator")) {
                this.batchFileBuilder.append("if \"%FIRSTARG%\" == \"" + option.name.get() + "\" goto " + option.name.get() + "\n");
            }
        });
        this.batchFileBuilder.append("echo Unknown option %FIRSTARG%\ngoto BYE\n::\n:PAUSEMENU\nset choice=\npause\ngoto MENU\n::\n:BYE\n::\n");
        this.batchFileBuilder.append("exit /B 0");
        if (this.resolvers().size() > 0) {
            String functions = String.join((CharSequence)"\n", this.functionBucket());
            this.batchFileBuilder.append("\n::Functions\n").append(functions);
        }
        return this.batchFileBuilder.toString().replace("\n", "\r\n");
    }
}

